/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.bridge.http.WriterOutputStream;

public abstract class CGIServlet
extends HttpServlet {
    public static final int BUF_SIZE = 8192;
    private static final long serialVersionUID = 3258132448955937337L;
    public ServletContext context = null;
    private int debug = 0;
    protected int iClientInputTimeout = 100;
    public String cgiPathPrefix = "/WEB-INF/cgi";
    private static final String UTF = "UTF-8";
    public HashMap processEnvironment = null;
    private static final File winnt = new File("c:/winnt");
    private static final File windows = new File("c:/windows");
    private static final Class[] EMPTY_PARAM = new Class[0];
    private static final Object[] EMPTY_ARG = new Object[0];
    private static HashMap defaultEnv;
    protected CGIRunnerFactory cgiRunnerFactory;

    static synchronized HashMap getProcessEnvironment() {
        Object object;
        if (defaultEnv != null) {
            return defaultEnv;
        }
        defaultEnv = new HashMap();
        String string = null;
        if (winnt.isDirectory()) {
            string = "c:\\winnt";
        } else if (windows.isDirectory()) {
            string = "c:\\windows";
        }
        try {
            object = System.getenv("SystemRoot");
            if (object != null) {
                string = object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = System.getProperty("Windows.SystemRoot");
            if (object != null) {
                string = object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string != null) {
            defaultEnv.put("SystemRoot", string);
        }
        try {
            object = System.class.getMethod("getenv", EMPTY_PARAM);
            Map map = (Map)((Method)object).invoke((Object)System.class, EMPTY_ARG);
            defaultEnv.putAll(map);
        }
        catch (Exception exception) {
            defaultEnv.putAll(Util.COMMON_ENVIRONMENT);
        }
        return defaultEnv;
    }

    protected static String encode(String string, HttpServlet httpServlet) {
        try {
            return URLEncoder.encode(string, UTF);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            httpServlet.log("Error: " + unsupportedEncodingException);
            return string;
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.processEnvironment = CGIServlet.getProcessEnvironment();
        String string = this.getServletConfig().getServletName();
        if (string == null) {
            string = "";
        }
        if (string.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException("Cannot invoke CGIServlet through the invoker");
        }
        String string2 = null;
        try {
            string2 = this.getServletConfig().getInitParameter("debug");
            if (string2 != null) {
                this.debug = Integer.parseInt(string2);
            }
            if ((string2 = this.getServletConfig().getInitParameter("cgiPathPrefix")) != null) {
                this.cgiPathPrefix = string2;
            }
            if ((string2 = this.getServletConfig().getInitParameter("iClientInputTimeout")) != null) {
                this.iClientInputTimeout = Integer.parseInt(string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.context = servletConfig.getServletContext();
    }

    protected void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException, IOException {
        CGIEnvironment cGIEnvironment = this.createCGIEnvironment(httpServletRequest, httpServletResponse, this.getServletContext());
        CGIRunner cGIRunner = this.cgiRunnerFactory.createCGIRunner(cGIEnvironment);
        if (bl) {
            cGIRunner.setInput((InputStream)httpServletRequest.getInputStream());
        }
        cGIRunner.setResponse(httpServletResponse);
        try {
            cGIRunner.execute();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.handle(httpServletRequest, httpServletResponse, true);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.handle(httpServletRequest, httpServletResponse, true);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handle(httpServletRequest, httpServletResponse, false);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (Util.logLevel > 4) {
            if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                this.log("doGet (included):" + httpServletRequest.getAttribute("javax.servlet.include.request_uri"));
            }
            this.log("doGet:" + httpServletRequest.getRequestURI());
        }
        this.handle(httpServletRequest, httpServletResponse, false);
    }

    public static int getLocalPort(ServletRequest servletRequest) {
        int n = -1;
        try {
            n = servletRequest.getLocalPort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n <= 0) {
            n = servletRequest.getServerPort();
        }
        return n;
    }

    protected CGIEnvironment createCGIEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        CGIEnvironment cGIEnvironment = new CGIEnvironment(httpServletRequest, httpServletResponse, servletContext);
        cGIEnvironment.init(httpServletRequest, httpServletResponse);
        return cGIEnvironment;
    }

    protected static String[] hashToStringArray(Map map) throws NullPointerException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            objectArray = iterator.next().toString();
            vector.add((String)objectArray + "=" + map.get(objectArray));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getRealPath(ServletContext servletContext, String string) {
        String string2 = servletContext.getRealPath(string);
        if (string2 != null) {
            return string2;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        URL uRL = null;
        try {
            uRL = servletContext.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            Util.printStackTrace((Throwable)malformedURLException);
        }
        if (uRL != null && !"file".equals(uRL.getProtocol())) {
            uRL = null;
        }
        if (uRL == null) {
            throw new IllegalArgumentException("Cannot access " + string + " within the current web directory. Explode your application .war file and try again.");
        }
        string2 = uRL.getPath();
        return string2.replace('/', File.separatorChar);
    }

    protected abstract class CGIRunner {
        protected HashMap env = null;
        protected File wd = null;
        protected InputStream stdin = null;
        protected HttpServletResponse response = null;

        protected CGIRunner(CGIEnvironment cGIEnvironment) {
            this.env = cGIEnvironment.environment;
            this.wd = cGIEnvironment.workingDirectory;
        }

        protected abstract void execute() throws IOException, ServletException, InterruptedException;

        protected void setResponse(HttpServletResponse httpServletResponse) {
            this.response = httpServletResponse;
        }

        protected void setInput(InputStream inputStream) {
            this.stdin = inputStream;
        }

        protected void addHeader(String string) {
            try {
                if (CGIServlet.this.debug >= 2) {
                    CGIServlet.this.log("runCGI: addHeader(\"" + string + "\")");
                }
                if (string.startsWith("Status")) {
                    int n = (string = string.substring(string.indexOf(":") + 1).trim()).indexOf(32);
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    this.response.setStatus(Integer.parseInt(string));
                } else {
                    this.response.addHeader(string.substring(0, string.indexOf(":")).trim(), string.substring(string.indexOf(":") + 1).trim());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        protected void addHeader(String string, String string2) {
            try {
                if (string.startsWith("Status")) {
                    int n = string2.indexOf(32);
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    }
                    this.response.setStatus(Integer.parseInt(string2));
                } else {
                    this.response.addHeader(string, string2);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        protected OutputStream getServletOutputStream(HttpServletResponse httpServletResponse) throws IOException {
            try {
                return httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                WriterOutputStream writerOutputStream = new WriterOutputStream((Writer)httpServletResponse.getWriter());
                writerOutputStream.setEncoding(httpServletResponse.getCharacterEncoding());
                return writerOutputStream;
            }
        }
    }

    protected class CGIEnvironment {
        protected ServletContext context = null;
        protected String contextPath = null;
        protected String servletPath = null;
        protected String queryString = null;
        protected String requestUri = null;
        protected String pathInfo = null;
        protected String webAppRootDir = null;
        protected HashMap environment = null;
        protected String command = null;
        protected File workingDirectory = null;

        protected CGIEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
            this.setupFromContext(servletContext);
            this.setupFromRequest(httpServletRequest);
        }

        public void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            this.setCGIEnvironment(httpServletRequest, httpServletResponse);
            int n = this.command.lastIndexOf(File.separator);
            if (n == -1) {
                n = this.command.lastIndexOf("/");
            }
            if (n == -1) {
                throw new IllegalArgumentException("command is not a file path");
            }
            this.workingDirectory = new File(this.command.substring(0, n));
        }

        protected void setupFromContext(ServletContext servletContext) {
            this.context = servletContext;
            this.webAppRootDir = CGIServlet.getRealPath(servletContext, "/");
        }

        protected void setupFromRequest(HttpServletRequest httpServletRequest) {
            this.contextPath = (String)httpServletRequest.getAttribute("javax.servlet.include.context_path");
            if (this.contextPath == null) {
                this.contextPath = httpServletRequest.getContextPath();
            }
            this.pathInfo = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (this.pathInfo == null) {
                this.pathInfo = httpServletRequest.getPathInfo();
            }
            this.servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            if (this.servletPath == null) {
                this.servletPath = httpServletRequest.getServletPath();
            }
            this.queryString = (String)httpServletRequest.getAttribute("javax.servlet.include.query_string");
            if (this.queryString == null) {
                this.queryString = httpServletRequest.getQueryString();
            }
            this.requestUri = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            if (this.requestUri == null) {
                this.requestUri = httpServletRequest.getRequestURI();
            }
        }

        protected String[] findCGI(String string, String string2, String string3, String string4, String string5) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (string2 != null && string2.lastIndexOf(File.separator) == string2.length() - 1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string5 != null) {
                string2 = string2 + File.separator + string5;
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: path=" + string + ", " + string2);
            }
            File file = new File(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            if (CGIServlet.this.debug >= 3) {
                CGIServlet.this.log("findCGI: currentLoc=" + file);
            }
            while (!file.isFile() && stringTokenizer.hasMoreElements()) {
                if (CGIServlet.this.debug >= 3) {
                    CGIServlet.this.log("findCGI: currentLoc=" + file);
                }
                file = new File(file, (String)stringTokenizer.nextElement());
            }
            if (!file.isFile()) {
                return new String[]{null, null, null, null};
            }
            if (CGIServlet.this.debug >= 2) {
                CGIServlet.this.log("findCGI: FOUND cgi at " + file);
            }
            string6 = file.getAbsolutePath();
            string7 = file.getName();
            string9 = file.getParent().substring(string2.length()) + File.separator + string7;
            string8 = ".".equals(string3) ? string4 + string9 : string3 + string4 + string9;
            if (CGIServlet.this.debug >= 1) {
                CGIServlet.this.log("findCGI calc: name=" + string7 + ", path=" + string6 + ", scriptname=" + string8 + ", cginame=" + string9);
            }
            return new String[]{string6, string8, string9, string7};
        }

        private String getHeaders(StringBuffer stringBuffer, Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append("; ");
            }
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            return string;
        }

        protected boolean setCGIEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            HashMap hashMap = (HashMap)CGIServlet.this.processEnvironment.clone();
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            String string2 = null;
            String string3 = null;
            string = this.pathInfo;
            string = string == null ? "" : string;
            string2 = httpServletRequest.getPathTranslated();
            string2 = string2 == null ? "" : string2;
            String[] stringArray = this.findCGI(string, this.webAppRootDir, this.contextPath, this.servletPath, CGIServlet.this.cgiPathPrefix);
            string3 = stringArray[0];
            hashMap.put("SERVER_SOFTWARE", "TOMCAT");
            hashMap.put("SERVER_NAME", this.nullsToBlanks(httpServletRequest.getServerName()));
            hashMap.put("GATEWAY_INTERFACE", "CGI/1.1");
            hashMap.put("SERVER_PROTOCOL", this.nullsToBlanks(httpServletRequest.getProtocol()));
            int n = CGIServlet.getLocalPort((ServletRequest)httpServletRequest);
            Integer n2 = n == 0 ? new Integer(-1) : new Integer(n);
            hashMap.put("SERVER_PORT", n2.toString());
            hashMap.put("REQUEST_METHOD", this.nullsToBlanks(httpServletRequest.getMethod()));
            hashMap.put("SCRIPT_NAME", this.nullsToBlanks(stringArray[1]));
            hashMap.put("QUERY_STRING", this.nullsToBlanks(this.queryString));
            hashMap.put("REMOTE_HOST", this.nullsToBlanks(httpServletRequest.getRemoteHost()));
            hashMap.put("REMOTE_ADDR", this.nullsToBlanks(httpServletRequest.getRemoteAddr()));
            hashMap.put("AUTH_TYPE", this.nullsToBlanks(httpServletRequest.getAuthType()));
            hashMap.put("REMOTE_USER", this.nullsToBlanks(httpServletRequest.getRemoteUser()));
            hashMap.put("REMOTE_IDENT", "");
            hashMap.put("CONTENT_TYPE", this.nullsToBlanks(httpServletRequest.getContentType()));
            this.setPathInfo(httpServletRequest, hashMap, stringArray[2]);
            int n3 = httpServletRequest.getContentLength();
            String string4 = n3 <= 0 ? "" : new Integer(n3).toString();
            hashMap.put("CONTENT_LENGTH", string4);
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            String string5 = null;
            while (enumeration.hasMoreElements()) {
                string5 = ((String)enumeration.nextElement()).toUpperCase();
                if ("AUTHORIZATION".equalsIgnoreCase(string5) || "PROXY_AUTHORIZATION".equalsIgnoreCase(string5)) continue;
                if ("HOST".equalsIgnoreCase(string5)) {
                    String string6 = httpServletRequest.getHeader(string5);
                    int n4 = string6.indexOf(":");
                    if (n4 < 0) {
                        n4 = string6.length();
                    }
                    hashMap.put("HTTP_" + string5.replace('-', '_'), string6.substring(0, n4));
                    continue;
                }
                if (string5.startsWith("X_")) {
                    hashMap.put(string5, httpServletRequest.getHeader(string5));
                    continue;
                }
                hashMap.put("HTTP_" + string5.replace('-', '_'), this.getHeaders(stringBuffer, httpServletRequest.getHeaders(string5)));
            }
            this.command = string3;
            this.environment = hashMap;
            return true;
        }

        protected void setPathInfo(HttpServletRequest httpServletRequest, HashMap hashMap, String string) {
            String string2 = null;
            String string3 = null;
            string2 = this.pathInfo == null || this.pathInfo.substring(string.length()).length() <= 0 ? "" : this.pathInfo.substring(string.length());
            hashMap.put("PATH_INFO", string2);
            string3 = string2 != null && !"".equals(string2) ? CGIServlet.getRealPath(this.context, string2) : null;
            if (string3 != null && !"".equals(string3)) {
                hashMap.put("PATH_TRANSLATED", this.nullsToBlanks(string3));
            }
        }

        protected String nullsToBlanks(String string) {
            return this.nullsToString(string, "");
        }

        protected String nullsToString(String string, String string2) {
            return string == null ? string2 : string;
        }

        protected String blanksToString(String string, String string2) {
            return "".equals(string) || string == null ? string2 : string;
        }
    }

    protected abstract class CGIRunnerFactory {
        protected CGIRunnerFactory() {
        }

        protected abstract CGIRunner createCGIRunner(CGIEnvironment var1);
    }
}

