/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import php.java.bridge.Util;
import php.java.script.servlet.EngineFactory;

public class ContextLoaderListener
implements ServletContextListener {
    public static final String CLOSEABLES = ContextLoaderListener.class.getName() + ".CLOSEABLES";
    public static final String ENGINES = ContextLoaderListener.class.getName() + ".ENGINES";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyCloseables(ServletContext servletContext) {
        List list = (List)servletContext.getAttribute(CLOSEABLES);
        if (list == null) {
            return;
        }
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                try {
                    Method method = e.getClass().getMethod("close", Util.ZERO_PARAM);
                    method.invoke(e, Util.ZERO_ARG);
                }
                catch (Exception exception) {
                    Util.printStackTrace((Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Util.printStackTrace((Throwable)throwable);
        }
        finally {
            servletContext.removeAttribute(CLOSEABLES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyScriptEngines(ServletContext servletContext) {
        try {
            EngineFactory engineFactory = null;
            try {
                engineFactory = (EngineFactory)servletContext.getAttribute(EngineFactory.ROOT_ENGINE_FACTORY_ATTRIBUTE);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (engineFactory == null) {
                return;
            }
            List list = (List)servletContext.getAttribute(ENGINES);
            if (list == null) {
                return;
            }
            engineFactory.releaseScriptEngines(list);
        }
        finally {
            servletContext.removeAttribute(ENGINES);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            ContextLoaderListener.destroyCloseables(servletContext);
            ContextLoaderListener.destroyScriptEngines(servletContext);
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        servletContext.removeAttribute(EngineFactory.ROOT_ENGINE_FACTORY_ATTRIBUTE);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Class<?> clazz = Class.forName("php.java.script.servlet.EngineFactory", true, Thread.currentThread().getContextClassLoader());
            ServletContext servletContext = servletContextEvent.getServletContext();
            servletContext.setAttribute(EngineFactory.ROOT_ENGINE_FACTORY_ATTRIBUTE, clazz.newInstance());
            servletContext.setAttribute(ENGINES, Collections.synchronizedList(new ArrayList()));
            servletContext.setAttribute(CLOSEABLES, new LinkedList());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
        }
    }
}

