/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.IContextFactory;

final class HttpContextRunner
implements Serializable {
    private static final long serialVersionUID = 6280393106090501730L;
    private Request request;
    private InputStream in;
    private OutputStream out;
    private AbstractChannel channel;
    private IContextFactory ctx;
    private byte shortPathHeader;

    public HttpContextRunner(AbstractChannel abstractChannel, IContextFactory iContextFactory) {
        this.channel = abstractChannel;
        this.ctx = iContextFactory;
    }

    private int readLength() throws IOException {
        byte[] byArray = new byte[1];
        this.in.read(byArray);
        this.shortPathHeader = (byte)(0xFF & byArray[0]);
        byArray = new byte[2];
        this.in.read(byArray);
        return 0xFF & byArray[0] | 0xFF00 & byArray[1] << 8;
    }

    private String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.in.read(byArray);
        return new String(byArray, "ASCII");
    }

    private String readName() throws IOException {
        return this.readString(this.readLength());
    }

    private void setIO(JavaBridge javaBridge, InputStream inputStream, OutputStream outputStream) {
        javaBridge.request.reset();
        javaBridge.in = inputStream;
        javaBridge.out = outputStream;
    }

    private boolean init() throws IOException {
        if (Util.logLevel > 4) {
            Util.logDebug((String)("starting a new ContextRunner " + this));
        }
        this.out = this.channel.getOuptutStream();
        this.in = this.channel.getInputStream();
        int n = this.in.read();
        if (n != 127) {
            if (n == -1) {
                return false;
            }
            try {
                this.out.write(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Protocol violation");
        }
        this.out.write(0);
        this.out.flush();
        this.readName();
        JavaBridge javaBridge = this.ctx.getBridge();
        if (this.shortPathHeader != -1) {
            javaBridge.request = new Request(javaBridge);
            javaBridge.request.init(this.shortPathHeader);
        }
        this.setIO(javaBridge, this.in, this.out);
        this.request = javaBridge.request;
        this.ctx.initialize();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.init()) {
                this.request.handleRequests();
            } else {
                Util.warn((String)"context runner init failed");
            }
        }
        catch (IOException iOException) {
            if (Util.logLevel > 4) {
                Util.printStackTrace((Throwable)iOException);
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        finally {
            if (this.ctx != null) {
                this.ctx.destroy();
            }
            this.channel.shutdown();
        }
    }
}

