/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import php.java.bridge.ISession;
import php.java.bridge.http.IContextFactory;
import php.java.servlet.Context;

class HttpSessionFacade
implements ISession {
    private HttpSession session;
    private int timeout;
    private HttpSession sessionCache = null;
    private boolean isNew;
    private IContextFactory ctxFactory;

    HttpSession getCachedSession() {
        if (this.sessionCache != null) {
            return this.sessionCache;
        }
        this.sessionCache = this.session;
        this.sessionCache.setMaxInactiveInterval(this.timeout);
        return this.sessionCache;
    }

    protected HttpSessionFacade(IContextFactory iContextFactory, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, int n) {
        this.ctxFactory = iContextFactory;
        this.session = bl ? httpServletRequest.getSession(true) : httpServletRequest.getSession();
        this.timeout = n;
        this.isNew = this.session.isNew();
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)((Context)this.ctxFactory.getContext()).getHttpServletRequest();
    }

    public ServletContext getServletContext() {
        return (ServletContext)((Context)this.ctxFactory.getContext()).getServletContext();
    }

    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)((Context)this.ctxFactory.getContext()).getHttpServletResponse();
    }

    public Object get(Object object) {
        return this.getCachedSession().getAttribute(String.valueOf(object));
    }

    public void put(Object object, Object object2) {
        this.getCachedSession().setAttribute(String.valueOf(object), object2);
    }

    public Object remove(Object object) {
        String string = String.valueOf(object);
        Object object2 = this.getCachedSession().getAttribute(string);
        if (object2 != null) {
            this.getCachedSession().removeAttribute(string);
        }
        return object2;
    }

    public void setTimeout(int n) {
        this.getCachedSession().setMaxInactiveInterval(n);
    }

    public int getTimeout() {
        return this.getCachedSession().getMaxInactiveInterval();
    }

    public int getSessionCount() {
        return -1;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void destroy() {
        this.getCachedSession().invalidate();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            this.put(k, v);
        }
    }

    public Map getAll() {
        HttpSession httpSession = this.getCachedSession();
        HashMap hashMap = new HashMap();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = this.get(e);
            hashMap.put(e, object);
        }
        return hashMap;
    }

    public long getCreationTime() {
        return this.getCachedSession().getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getCachedSession().getLastAccessedTime();
    }
}

