/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.IContextFactory;
import php.java.servlet.CGIServlet;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.Logger;
import php.java.servlet.RemoteHttpServletContextFactory;
import php.java.servlet.RemoteServletContextFactory;
import php.java.servlet.SimpleServletContextFactory;

public class PhpJavaServlet
extends HttpServlet {
    private static final long serialVersionUID = 3257854259629144372L;
    private ContextServer contextServer;
    protected int logLevel = -1;
    private Util.Logger logger;
    protected boolean promiscuous = false;
    private boolean isWebLogic = false;
    private boolean isJBoss = false;
    private static final String LOCAL_ADDR = "127.0.0.1";
    private static final String ROOT_CONTEXT_SERVER_ATTRIBUTE = ContextServer.class.getName() + ".ROOT";

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext;
        String string;
        String string2 = CGIServlet.getRealPath(servletConfig.getServletContext(), "");
        if (string2 == null) {
            string2 = "";
        }
        if ((string = (servletContext = servletConfig.getServletContext()).getInitParameter("promiscuous")) == null) {
            string = "";
        }
        string = string.trim();
        if ((string = string.toLowerCase()).equals("on") || string.equals("true")) {
            this.promiscuous = true;
        }
        try {
            this.contextServer = PhpJavaServlet.getContextServer(servletContext, this.promiscuous);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.init(servletConfig);
        String string3 = servletContext.getServerInfo();
        if (string3 != null && string3.startsWith("WebLogic")) {
            this.isWebLogic = true;
        }
        if (string3 != null && string3.startsWith("JBoss")) {
            this.isJBoss = true;
        }
        this.logger = new Util.Logger(!this.isJBoss, (ILogger)new Logger(servletContext));
        if (Util.VERSION != null) {
            this.log("PHP/Java Bridge servlet " + string2 + " version " + Util.VERSION + " ready.");
        } else {
            this.log("PHP/Java Bridge servlet " + string2 + " ready.");
        }
    }

    public void destroy() {
        ServletContext servletContext = this.getServletContext();
        try {
            ContextLoaderListener.destroyCloseables(servletContext);
            ContextLoaderListener.destroyScriptEngines(servletContext);
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        if (this.contextServer != null) {
            this.contextServer.destroy();
        }
        super.destroy();
    }

    protected SimpleServletContextFactory getContextFactory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ContextFactory.ICredentials iCredentials) {
        JavaBridge javaBridge;
        SimpleServletContextFactory simpleServletContextFactory = null;
        String string = httpServletRequest.getHeader("X_JAVABRIDGE_CONTEXT");
        if (string != null) {
            simpleServletContextFactory = (SimpleServletContextFactory)ContextFactory.get((String)string, (ContextFactory.ICredentials)iCredentials);
        }
        if (simpleServletContextFactory == null) {
            simpleServletContextFactory = (SimpleServletContextFactory)RemoteServletContextFactory.addNew((Servlet)this, this.getServletContext(), null, httpServletRequest, httpServletResponse);
            javaBridge = simpleServletContextFactory.getBridge();
            javaBridge.logDebug("HTTP request");
        } else {
            javaBridge = simpleServletContextFactory.getBridge();
            javaBridge.logDebug("redirect");
        }
        this.updateRequestLogLevel(javaBridge);
        httpServletResponse.setHeader("X_JAVABRIDGE_CONTEXT", simpleServletContextFactory.getId());
        return simpleServletContextFactory;
    }

    protected void updateRequestLogLevel(JavaBridge javaBridge) {
        if (this.logLevel > -1) {
            javaBridge.logLevel = this.logLevel;
        }
    }

    protected void waitForContext(SimpleServletContextFactory simpleServletContextFactory) {
        try {
            simpleServletContextFactory.waitFor(Util.MAX_WAIT);
        }
        catch (InterruptedException interruptedException) {
            Util.printStackTrace((Throwable)interruptedException);
        }
    }

    protected void handleChunkedLocalConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        ServletInputStream servletInputStream = null;
        ServletOutputStream servletOutputStream = null;
        SimpleServletContextFactory simpleServletContextFactory = this.getContextFactory(httpServletRequest, httpServletResponse, null);
        JavaBridge javaBridge = simpleServletContextFactory.getBridge();
        simpleServletContextFactory.setSessionFactory(httpServletRequest);
        servletInputStream = httpServletRequest.getInputStream();
        javaBridge.in = servletInputStream;
        servletOutputStream = httpServletResponse.getOutputStream();
        javaBridge.out = servletOutputStream;
        Request request = javaBridge.request = new Request(javaBridge);
        if (request.init((InputStream)servletInputStream, (OutputStream)servletOutputStream)) {
            AbstractChannelName abstractChannelName = this.contextServer.getFallbackChannelName(string, (IContextFactory)simpleServletContextFactory);
            httpServletResponse.setHeader("X_JAVABRIDGE_REDIRECT", abstractChannelName.getName());
            this.contextServer.start(abstractChannelName, (ILogger)this.logger);
            request.handleRequests();
            if (javaBridge.logLevel > 3) {
                javaBridge.logDebug("redirecting to port# " + abstractChannelName);
            }
            servletInputStream.close();
            try {
                httpServletResponse.flushBuffer();
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
            try {
                servletOutputStream.close();
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
            this.waitForContext(simpleServletContextFactory);
        } else {
            Util.warn((String)"handleChunkedLocalConnection init failed");
            simpleServletContextFactory.destroy();
        }
    }

    protected void handlePersistentLocalConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        ServletInputStream servletInputStream = null;
        ServletOutputStream servletOutputStream = null;
        SimpleServletContextFactory simpleServletContextFactory = this.getContextFactory(httpServletRequest, httpServletResponse, null);
        JavaBridge javaBridge = simpleServletContextFactory.getBridge();
        simpleServletContextFactory.setSessionFactory(httpServletRequest);
        servletInputStream = httpServletRequest.getInputStream();
        javaBridge.in = servletInputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        javaBridge.out = byteArrayOutputStream;
        Request request = javaBridge.request = new Request(javaBridge);
        if (request.init((InputStream)servletInputStream, (OutputStream)byteArrayOutputStream)) {
            AbstractChannelName abstractChannelName = this.contextServer.getFallbackChannelName(string, (IContextFactory)simpleServletContextFactory);
            httpServletResponse.setHeader("X_JAVABRIDGE_REDIRECT", abstractChannelName.getName());
            this.contextServer.start(abstractChannelName, (ILogger)this.logger);
            request.handleRequests();
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            servletOutputStream = httpServletResponse.getOutputStream();
            byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
            if (javaBridge.logLevel > 3) {
                javaBridge.logDebug("redirecting to port# " + abstractChannelName);
            }
            servletInputStream.close();
            try {
                httpServletResponse.flushBuffer();
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
            try {
                servletOutputStream.close();
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
            this.waitForContext(simpleServletContextFactory);
        } else {
            Util.warn((String)"handlePersistentLocalConnection init failed");
            simpleServletContextFactory.destroy();
        }
    }

    protected void handleLocalConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        if (PhpJavaServlet.getHeader("Content-Length", httpServletRequest) == null) {
            this.handleChunkedLocalConnection(httpServletRequest, httpServletResponse, string);
        } else {
            this.handlePersistentLocalConnection(httpServletRequest, httpServletResponse, string);
        }
    }

    public static String getHeader(String string, HttpServletRequest httpServletRequest) {
        String string2 = httpServletRequest.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private InputStream getInputStream(HttpServletRequest httpServletRequest) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        if (!this.isWebLogic) {
            return servletInputStream;
        }
        return new FilterInputStream((InputStream)servletInputStream){

            public int read(byte[] byArray, int n, int n2) throws IOException {
                return this.in.read(byArray, n, 1);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHttpConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        RemoteHttpServletContextFactory remoteHttpServletContextFactory;
        String string;
        boolean bl = false;
        if (PhpJavaServlet.getHeader("Content-Length", httpServletRequest) != null) {
            this.log("WARNING: Pipe- and SocketContextServer switched off in the back end. Either enable them or define(\"JAVA_PERSISTENT_SERVLET_CONNECTION\", false) in \"java/Java.inc\" and try again.");
        }
        if ((string = httpServletRequest.getHeader("X_JAVABRIDGE_CONTEXT")) != null) {
            remoteHttpServletContextFactory = (RemoteHttpServletContextFactory)RemoteHttpServletContextFactory.get(string);
            if (remoteHttpServletContextFactory == null) {
                throw new IllegalStateException("Cannot find RemoteHttpServletContextFactory in session");
            }
        } else {
            remoteHttpServletContextFactory = new RemoteHttpServletContextFactory((Servlet)this, this.getServletContext(), httpServletRequest, httpServletRequest, httpServletResponse);
            bl = true;
        }
        httpServletResponse.setHeader("X_JAVABRIDGE_CONTEXT", remoteHttpServletContextFactory.getId());
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        InputStream inputStream = null;
        ServletOutputStream servletOutputStream = null;
        JavaBridge javaBridge = remoteHttpServletContextFactory.getBridge();
        javaBridge.in = inputStream = this.getInputStream(httpServletRequest);
        servletOutputStream = httpServletResponse.getOutputStream();
        javaBridge.out = servletOutputStream;
        remoteHttpServletContextFactory.setResponse(httpServletResponse);
        Request request = javaBridge.request = new Request(javaBridge);
        try {
            if (request.init(inputStream, (OutputStream)servletOutputStream)) {
                request.handleRequests();
            } else {
                Util.warn((String)"handleHttpConnection init failed");
            }
        }
        finally {
            if (bl) {
                remoteHttpServletContextFactory.destroy();
            }
        }
    }

    protected void handlePut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Util.setLogger((ILogger)this.logger);
        String string = PhpJavaServlet.getHeader("X_JAVABRIDGE_CHANNEL", httpServletRequest);
        if (Util.logLevel > 3) {
            Util.logDebug((String)("doPut:" + httpServletRequest.getRequestURL()));
        }
        if (LOCAL_ADDR.equals(httpServletRequest.getRemoteAddr()) && this.contextServer != null && this.contextServer.isAvailable(string)) {
            this.handleLocalConnection(httpServletRequest, httpServletResponse, string);
        } else {
            this.handleHttpConnection(httpServletRequest, httpServletResponse);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.handlePut(httpServletRequest, httpServletResponse);
        }
        catch (RuntimeException runtimeException) {
            Util.printStackTrace((Throwable)runtimeException);
            throw new ServletException((Throwable)runtimeException);
        }
        catch (IOException iOException) {
            Util.printStackTrace((Throwable)iOException);
            throw iOException;
        }
        catch (ServletException servletException) {
            Util.printStackTrace((Throwable)servletException);
            throw servletException;
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getRequestURI();
        httpServletRequest.getRequestDispatcher(string.substring(0, string.length() - 10)).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public static synchronized ContextServer getContextServer(ServletContext servletContext, boolean bl) {
        ContextServer contextServer = (ContextServer)servletContext.getAttribute(ROOT_CONTEXT_SERVER_ATTRIBUTE);
        if (contextServer == null) {
            String string = CGIServlet.getRealPath(servletContext, "");
            if (string == null) {
                string = "";
            }
            contextServer = new ContextServer(string, bl);
            servletContext.setAttribute(ROOT_CONTEXT_SERVER_ATTRIBUTE, (Object)contextServer);
        }
        return contextServer;
    }
}

