/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridgeFactory;
import php.java.bridge.Request;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.servlet.CGIServlet;
import php.java.servlet.Context;
import php.java.servlet.HttpSessionFacade;
import php.java.servlet.RemoteHttpServletResponse;

public class RemoteHttpServletContextFactory
extends JavaBridgeFactory
implements IContextFactory,
Serializable {
    private static final HashMap contexts = new HashMap();
    public static final String CONTEXT_FACTORY_ATTRIBUTE = RemoteHttpServletContextFactory.class.getName() + ".ROOT";
    private static final long serialVersionUID = -7009009517347609467L;
    protected Servlet servlet;
    protected ServletContext kontext;
    protected HttpServletRequest proxy;
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected HttpServletResponse out;
    private IContext context;
    private ISession session;
    private IContextFactoryVisitor impl;
    private String id;
    private static long counter = 0L;

    private static synchronized String addNext(RemoteHttpServletContextFactory remoteHttpServletContextFactory, String string) {
        String string2 = Long.toHexString(++counter) + "@" + string;
        contexts.put(string2, remoteHttpServletContextFactory);
        return string2;
    }

    protected RemoteHttpServletContextFactory(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletRequest httpServletRequest2, HttpServletResponse httpServletResponse) {
        this.kontext = servletContext;
        this.proxy = httpServletRequest;
        this.req = httpServletRequest2;
        this.res = httpServletResponse;
        this.servlet = servlet;
        this.javaBridgeClassLoader = new SimpleJavaBridgeClassLoader(this.getClassLoader());
        this.id = RemoteHttpServletContextFactory.addNext(this, CGIServlet.getRealPath(servletContext, ""));
    }

    protected void accept(IContextFactoryVisitor iContextFactoryVisitor) {
        this.impl = iContextFactoryVisitor;
        iContextFactoryVisitor.visit((IContextFactory)this);
    }

    public static synchronized IContextFactory get(String string) {
        return (IContextFactory)contexts.get(string);
    }

    private static synchronized IContextFactory remove(String string) {
        return (IContextFactory)contexts.remove(string);
    }

    public static IContextFactory addNew(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletRequest httpServletRequest2, HttpServletResponse httpServletResponse, IContextFactoryVisitor iContextFactoryVisitor) {
        RemoteHttpServletContextFactory remoteHttpServletContextFactory = new RemoteHttpServletContextFactory(servlet, servletContext, httpServletRequest, httpServletRequest2, httpServletResponse);
        remoteHttpServletContextFactory.accept(iContextFactoryVisitor);
        return remoteHttpServletContextFactory;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String getId() {
        return this.id;
    }

    public String getRedirectString() {
        if (this.impl != null) {
            return this.impl.getRedirectString();
        }
        throw new IllegalStateException("getRedirectString");
    }

    public String getRedirectString(String string) {
        if (this.impl != null) {
            return this.impl.getRedirectString(string);
        }
        throw new IllegalStateException("getRedirectString");
    }

    public String getSocketName() {
        if (this.impl != null) {
            return this.impl.getSocketName();
        }
        throw new IllegalStateException("getSocketName");
    }

    public ISession getSimpleSession(String string, boolean bl, int n) {
        throw new IllegalStateException("Named sessions not supported by HTTP tunnel. Enable the Pipe- or SocketContextServer and try again.");
    }

    public ISession getSession(String string, boolean bl, int n) {
        if (string != null) {
            return this.getSimpleSession(string, bl, n);
        }
        if (this.session != null) {
            return this.session;
        }
        if (this.proxy == null) {
            throw new NullPointerException("This context " + this.getId() + " doesn't have a session proxy.");
        }
        this.session = new HttpSessionFacade(this, this.kontext, this.proxy, this.res, bl, n);
        return this.session;
    }

    HttpSession getCurrentSession() {
        if (this.session != null) {
            return ((HttpSessionFacade)this.session).getCachedSession();
        }
        return null;
    }

    public void initialize() {
        throw new IllegalStateException("initialize");
    }

    public void invalidate() {
        throw new IllegalStateException("invalidate");
    }

    public void recycle(String string) {
        throw new IllegalStateException("recycle");
    }

    public void release() {
        if (this.impl == null) {
            throw new IllegalStateException("release");
        }
        this.impl.release();
    }

    public void releaseManaged() throws InterruptedException {
        if (this.impl == null) {
            throw new IllegalStateException("releaseManaged");
        }
        this.impl.releaseManaged();
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public void waitFor(long l) throws InterruptedException {
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return this.javaBridgeClassLoader;
    }

    public void parseHeader(Request request, InputStream inputStream) throws IOException {
        throw new IllegalStateException("parseHeader");
    }

    public void setContext(IContext iContext) {
        if (this.impl != null) {
            this.impl.setContext(iContext);
        }
        this.context = iContext;
    }

    public IContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.impl != null) {
            this.context = this.impl.getContext();
        } else {
            this.setContext(this.createContext());
        }
        this.context.setAttribute("php.java.bridge.JavaBridge", (Object)this.getBridge(), 100);
        return this.context;
    }

    public void destroy() {
        super.destroy();
        RemoteHttpServletContextFactory.remove(this.getId());
    }

    private IContext createContext() {
        Context context = new Context(this.kontext, this.req, this.res);
        context.setAttribute("php.java.servlet.ServletContext", this.kontext, 100);
        context.setAttribute("php.java.servlet.ServletConfig", this.servlet.getServletConfig(), 100);
        context.setAttribute("php.java.servlet.Servlet", this.servlet, 100);
        context.setAttribute("php.java.servlet.HttpServletRequest", new HttpServletRequestWrapper(this.req){

            public HttpSession getSession() {
                return RemoteHttpServletContextFactory.this.getCurrentSession();
            }

            public HttpSession getSession(boolean bl) {
                HttpSession httpSession = this.getSession();
                if (bl && !httpSession.isNew()) {
                    throw new IllegalStateException("To obtain a new session call java_session() or \"java_session(null, -1, TRUE)\" at the beginning of your PHP script.");
                }
                return httpSession;
            }
        }, 100);
        context.setAttribute("php.java.servlet.HttpServletResponse", new RemoteHttpServletResponse(), 100);
        return context;
    }

    public void flushBuffer() throws IOException {
        this.out.flushBuffer();
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        this.out = httpServletResponse;
    }
}

