/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletRequest;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.servlet.CGIServlet;
import php.java.servlet.PhpCGIServlet;
import php.java.servlet.fastcgi.Channel;
import php.java.servlet.fastcgi.ConnectException;
import php.java.servlet.fastcgi.FCGIProcess;
import php.java.servlet.fastcgi.FastCGIServlet;
import php.java.servlet.fastcgi.NPChannelFactory;
import php.java.servlet.fastcgi.SocketChannelFactory;

public abstract class ChannelFactory {
    protected PhpCGIServlet servlet;
    protected PhpCGIServlet.CGIEnvironment env;
    protected String contextPath;
    protected boolean promiscuous;
    protected static FCGIProcess proc = null;
    private static boolean fcgiStarted = false;
    private static final Object fcgiStartLock = new Object();
    private static boolean fcgiActivatorRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean startServer(ILogger iLogger) {
        Object object = fcgiStartLock;
        synchronized (object) {
            if (!fcgiStarted) {
                if (this.servlet.delegateToJavaBridgeContext) {
                    boolean bl = FastCGIServlet.isJavaBridgeWc(this.contextPath);
                    this.delegateOrStartFCGI(bl, iLogger);
                } else if (this.canStartFCGI()) {
                    try {
                        this.bind(iLogger);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fcgiStarted = true;
            }
        }
        return fcgiStarted;
    }

    public abstract void test() throws ConnectException;

    protected abstract void waitForDaemon() throws UnknownHostException, InterruptedException;

    protected final void runFcgi(Map map, String string, boolean bl) {
        byte[] byArray = new byte[8192];
        try {
            int n;
            Util.Process process = this.doBind(map, string, bl);
            if (process == null) {
                return;
            }
            process.getInputStream().close();
            InputStream inputStream = process.getErrorStream();
            while ((n = inputStream.read(byArray)) != -1) {
                System.err.write(byArray, 0, n);
            }
            if (process != null) {
                try {
                    process.destroy();
                    process = null;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Util.logDebug((String)("Could not start FCGI server: " + exception));
        }
    }

    protected abstract Util.Process doBind(Map var1, String var2, boolean var3) throws IOException;

    protected void bind(final ILogger iLogger) throws InterruptedException, IOException {
        Util.Thread thread = new Util.Thread("JavaBridgeFastCGIRunner"){

            public void run() {
                Util.setLogger((ILogger)iLogger);
                Map map = (Map)ChannelFactory.this.servlet.processEnvironment.clone();
                map.put("PHP_FCGI_CHILDREN", ChannelFactory.this.servlet.php_fcgi_children);
                map.put("PHP_FCGI_MAX_REQUESTS", ChannelFactory.this.servlet.php_fcgi_max_requests);
                ChannelFactory.this.runFcgi(map, ChannelFactory.this.servlet.php, ChannelFactory.this.servlet.php_include_java);
            }
        };
        thread.start();
        this.waitForDaemon();
    }

    private void delegateOrStartFCGI(boolean bl, ILogger iLogger) {
        try {
            if (bl) {
                if (this.canStartFCGI()) {
                    this.bind(iLogger);
                }
            } else if (this.canStartFCGI()) {
                if (!fcgiActivatorRunning) {
                    this.activateFCGI();
                }
                fcgiActivatorRunning = true;
                try {
                    fcgiStartLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
    }

    private boolean canStartFCGI() {
        return this.servlet.canStartFCGI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = fcgiStartLock;
        synchronized (object) {
            fcgiStarted = false;
            fcgiActivatorRunning = false;
            if (proc == null) {
                return;
            }
            try {
                proc.getOutputStream().close();
            }
            catch (IOException iOException) {
                Util.printStackTrace((Throwable)iOException);
            }
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Util.printStackTrace((Throwable)interruptedException);
            }
            proc.destroy();
            proc = null;
        }
    }

    public abstract Channel connect() throws ConnectException;

    private void activateFCGI() throws IOException, InterruptedException {
        URL uRL = new URL("http", "127.0.0.1", CGIServlet.getLocalPort((ServletRequest)this.env.req), "/JavaBridge/.php");
        URLConnection uRLConnection = uRL.openConnection();
        new Util.Thread("JavaBridgeFCGIActivator"){
            URLConnection conn;

            public Thread init(URLConnection uRLConnection) {
                this.conn = uRLConnection;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Object object2222;
                InputStream inputStream;
                block20: {
                    inputStream = null;
                    try {
                        this.conn.connect();
                        inputStream = this.conn.getInputStream();
                        byte[] byArray = new byte[8192];
                        while (-1 != inputStream.read(byArray)) {
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    Object var4_5 = null;
                    if (inputStream == null) break block20;
                    try {
                        inputStream.close();
                    }
                    catch (Exception object2222) {
                        // empty catch block
                    }
                }
                object2222 = fcgiStartLock;
                synchronized (object2222) {
                    fcgiStartLock.notify();
                }
                {
                    catch (Exception exception) {
                        Object object32222;
                        Util.printStackTrace((Throwable)exception);
                        Object var4_6 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception object32222) {
                                // empty catch block
                            }
                        }
                        object32222 = fcgiStartLock;
                        synchronized (object32222) {
                            fcgiStartLock.notify();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object42222;
                    Object var4_7 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception object42222) {
                            // empty catch block
                        }
                    }
                    object42222 = fcgiStartLock;
                    synchronized (object42222) {
                        fcgiStartLock.notify();
                    }
                    throw throwable;
                }
            }
        }.init(uRLConnection).start();
    }

    public void initialize(PhpCGIServlet phpCGIServlet, PhpCGIServlet.CGIEnvironment cGIEnvironment, String string) {
        this.servlet = phpCGIServlet;
        this.env = cGIEnvironment;
        this.contextPath = string;
        if (FastCGIServlet.isJavaBridgeWc(string)) {
            this.setDefaultPort();
        } else {
            this.setDynamicPort();
        }
    }

    protected abstract void setDynamicPort();

    protected abstract void setDefaultPort();

    public abstract String getFcgiStartCommand(String var1, String var2);

    public abstract void findFreePort(boolean var1);

    public static ChannelFactory createChannelFactory(boolean bl) {
        if (PhpCGIServlet.USE_SH_WRAPPER) {
            return new SocketChannelFactory(bl);
        }
        return new NPChannelFactory();
    }

    public String toString() {
        return "ChannelName@" + this.contextPath == null ? "<not initialized>" : this.contextPath;
    }
}

