/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import php.java.bridge.Util;
import php.java.servlet.fastcgi.Channel;
import php.java.servlet.fastcgi.ChannelFactory;
import php.java.servlet.fastcgi.ConnectException;
import php.java.servlet.fastcgi.ConnectionException;
import php.java.servlet.fastcgi.DefaultInputStream;
import php.java.servlet.fastcgi.DefaultOutputStream;
import php.java.servlet.fastcgi.IOFactory;

public class ConnectionPool {
    private int limit;
    private int connections = 0;
    private List freeList = new LinkedList();
    private List connectionList = new LinkedList();
    private IOFactory factory;
    private int maxRequests;
    private ChannelFactory channelName;

    public ConnectionPool(ChannelFactory channelFactory, int n, int n2, IOFactory iOFactory) throws ConnectException {
        if (Util.logLevel > 3) {
            Util.logDebug((String)("Creating new connection pool for: " + channelFactory));
        }
        this.channelName = channelFactory;
        this.limit = n;
        this.factory = iOFactory;
        this.maxRequests = n2;
        channelFactory.test();
    }

    private Connection createNewConnection() throws ConnectException, SocketException {
        Connection connection = new Connection(this.channelName, this.maxRequests, this.factory);
        this.connectionList.add(connection);
        ++this.connections;
        return connection;
    }

    public synchronized Connection openConnection() throws InterruptedException, ConnectException, SocketException {
        Connection connection;
        if (this.freeList.isEmpty() && this.connections < this.limit) {
            connection = this.createNewConnection();
        } else {
            while (this.freeList.isEmpty()) {
                this.wait();
            }
            connection = (Connection)this.freeList.remove(0);
            connection.reset();
        }
        return connection.reopen();
    }

    private synchronized void closeConnection(Connection connection) {
        this.freeList.add(connection);
        this.notify();
    }

    public synchronized void destroy() {
        Iterator iterator = this.connectionList.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            connection.destroy();
        }
        if (this.channelName != null) {
            this.channelName.destroy();
        }
    }

    public final class Connection {
        protected int ostate;
        protected int state;
        protected ChannelFactory channelName;
        protected Channel channel;
        private DefaultOutputStream outputStream;
        private DefaultInputStream inputStream;
        private boolean isClosed;
        private IOFactory factory;
        private int maxRequests;
        private int counter;

        protected void reset() {
            this.ostate = 0;
            this.state = 0;
        }

        protected void init() {
            this.inputStream = null;
            this.outputStream = null;
            this.counter = this.maxRequests;
            this.reset();
        }

        protected Connection reopen() throws ConnectException, SocketException {
            if (this.isClosed) {
                this.channel = this.factory.connect(this.channelName);
            }
            this.isClosed = false;
            return this;
        }

        protected Connection(ChannelFactory channelFactory, int n, IOFactory iOFactory) throws ConnectException, SocketException {
            this.channelName = channelFactory;
            this.factory = iOFactory;
            this.isClosed = true;
            this.maxRequests = n;
            this.init();
        }

        public void setIsClosed() {
            this.isClosed = true;
        }

        protected void close() throws ConnectException, SocketException {
            if (this.maxRequests > 0 && --this.counter == 0) {
                this.isClosed = true;
            }
            if (this.isClosed) {
                this.destroy();
                this.init();
            }
            ConnectionPool.this.closeConnection(this);
        }

        private void destroy() {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public OutputStream getOutputStream() throws ConnectionException {
            if (this.outputStream != null) {
                return this.outputStream;
            }
            DefaultOutputStream defaultOutputStream = (DefaultOutputStream)this.factory.createOutputStream();
            defaultOutputStream.setConnection(this);
            this.ostate |= 2;
            return defaultOutputStream;
        }

        public InputStream getInputStream() throws ConnectionException {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            DefaultInputStream defaultInputStream = (DefaultInputStream)this.factory.createInputStream();
            defaultInputStream.setConnection(this);
            this.ostate |= 1;
            return defaultInputStream;
        }
    }
}

