/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.IOException;
import php.java.bridge.Util;
import php.java.servlet.fastcgi.ConnectionException;
import php.java.servlet.fastcgi.DefaultInputStream;
import php.java.servlet.fastcgi.FastCGIServlet;

class FastCGIInputStream
extends DefaultInputStream {
    private final FastCGIServlet servlet;
    private StringBuffer error;
    private byte[] header = new byte[8];

    FastCGIInputStream(FastCGIServlet fastCGIServlet) {
        this.servlet = fastCGIServlet;
    }

    public StringBuffer getError() {
        return this.error;
    }

    public String checkError() {
        return this.error == null ? null : Util.checkError((String)this.error.toString());
    }

    public int read(byte[] byArray) throws ConnectionException {
        try {
            return this.doRead(byArray);
        }
        catch (ConnectionException connectionException) {
            throw connectionException;
        }
        catch (IOException iOException) {
            throw new ConnectionException(this.connection, iOException);
        }
    }

    public int doRead(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.read(this.header, n2, 8 - n2)) > 0) {
            n2 += n;
        }
        if (8 != n2) {
            throw new IOException("Protocol error");
        }
        int n3 = this.header[1] & 0xFF;
        int n4 = (this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF;
        int n5 = this.header[6] & 0xFF;
        switch (n3) {
            case 6: 
            case 7: {
                Object object;
                n2 = 0;
                while ((n = this.read(byArray, n2, n4 - n2)) > 0) {
                    n2 += n;
                }
                if (n2 != n4) {
                    throw new IOException("Protocol error while reading FCGI data");
                }
                if (n3 == 7) {
                    object = new String(byArray, 0, n2, "ASCII");
                    this.servlet.log((String)object);
                    n4 = 0;
                    if (this.error == null) {
                        this.error = new StringBuffer((String)object);
                    } else {
                        this.error.append((String)object);
                    }
                }
                if (n5 > 0) {
                    object = new byte[n5];
                    n2 = 0;
                    while ((n = this.read((byte[])object, n2, ((byte[])object).length - n2)) > 0) {
                        n2 += n;
                    }
                    if (n2 != n5) {
                        throw new IOException("Protocol error while reading FCGI padding");
                    }
                }
                return n4;
            }
            case 3: {
                n2 = 0;
                while ((n = this.read(byArray, n2, n4 - n2)) > 0) {
                    n2 += n;
                }
                if (n2 != n4) {
                    throw new IOException("Protocol error while reading EOF data");
                }
                if (n5 > 0 && (n2 = super.read(byArray, 0, n5)) != n5) {
                    throw new IOException("Protocol error while reading EOF padding");
                }
                return -1;
            }
        }
        throw new IOException("Received unknown type");
    }
}

