/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.bridge.http.IContextFactory;
import php.java.servlet.CGIServlet;
import php.java.servlet.Logger;
import php.java.servlet.PhpCGIServlet;
import php.java.servlet.fastcgi.Channel;
import php.java.servlet.fastcgi.ChannelFactory;
import php.java.servlet.fastcgi.ConnectException;
import php.java.servlet.fastcgi.ConnectionException;
import php.java.servlet.fastcgi.ConnectionPool;
import php.java.servlet.fastcgi.FastCGIInputStream;
import php.java.servlet.fastcgi.FastCGIOutputStream;
import php.java.servlet.fastcgi.IOFactory;

public abstract class FastCGIServlet
extends CGIServlet {
    private static final long serialVersionUID = 3545800996174312757L;
    static final int FCGI_BUF_SIZE = 65535;
    static final int FCGI_HEADER_LEN = 8;
    protected static final int FCGI_BEGIN_REQUEST = 1;
    protected static final int FCGI_ABORT_REQUEST = 2;
    protected static final int FCGI_END_REQUEST = 3;
    protected static final int FCGI_PARAMS = 4;
    protected static final int FCGI_STDIN = 5;
    protected static final int FCGI_STDOUT = 6;
    protected static final int FCGI_STDERR = 7;
    protected static final int FCGI_DATA = 8;
    protected static final int FCGI_GET_VALUES = 9;
    protected static final int FCGI_GET_VALUES_RESULT = 10;
    protected static final int FCGI_UNKNOWN_TYPE = 11;
    protected static final byte[] FCGI_EMPTY_RECORD = new byte[0];
    protected static final int FCGI_KEEP_CONN = 1;
    protected static final int FCGI_RESPONDER = 1;
    protected static final int FCGI_AUTHORIZER = 2;
    protected static final int FCGI_FILTER = 3;
    public static final int FCGI_PORT = 9667;
    public static final String PHP_FCGI_CHILDREN = "5";
    public static final String PHP_FCGI_MAX_REQUESTS = "5000";
    public static final String FCGI_PIPE = "\\\\.\\pipe\\JavaBridge@9667";
    protected String php = null;
    protected boolean phpTryOtherLocations = false;
    protected boolean preferSystemPhp = false;
    protected boolean fcgiIsConfigured;
    protected boolean fcgiIsAvailable;
    protected boolean canStartFCGI = false;
    protected boolean override_hosts = true;
    protected boolean delegateToJavaBridgeContext = false;
    protected String php_fcgi_children = "5";
    protected boolean php_include_java;
    protected int php_fcgi_children_number = Integer.parseInt("5");
    protected String php_fcgi_max_requests = "5000";
    protected int php_fcgi_max_requests_number = Integer.parseInt("5000");
    protected ILogger logger;
    protected boolean promiscuous = false;
    private static final Object globalCtxLock = new Object();
    private static final Object javaBridgeCtxLock = new Object();
    private static ConnectionPool fcgiConnectionPool = null;
    private final IOFactory defaultPoolFactory = new IOFactory(){

        public InputStream createInputStream() {
            return new FastCGIInputStream(FastCGIServlet.this);
        }

        public OutputStream createOutputStream() {
            return new FastCGIOutputStream();
        }

        public Channel connect(ChannelFactory channelFactory) throws ConnectException {
            return channelFactory.connect();
        }
    };
    private final CGIRunnerFactory defaultCGIRunnerFactory = new CGIRunnerFactory();
    protected ChannelFactory channelName;
    private boolean isJBoss;

    protected void checkCgiBinary(ServletConfig servletConfig) {
        String string;
        if (this.php == null) {
            try {
                File file;
                string = servletConfig.getInitParameter("php_exec");
                if (string == null || string.trim().length() == 0) {
                    string = "php-cgi";
                    this.phpTryOtherLocations = true;
                }
                if (!(file = new File(string)).isAbsolute()) {
                    string = FastCGIServlet.getRealPath(servletConfig.getServletContext(), this.cgiPathPrefix) + File.separator + string;
                }
                this.php = string;
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
        }
        if (this.fcgiIsAvailable) {
            try {
                string = servletConfig.getServletContext().getInitParameter("use_fast_cgi");
                if (string == null) {
                    try {
                        string = System.getProperty("php.java.bridge.use_fast_cgi");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ("false".equalsIgnoreCase(string) || "off".equalsIgnoreCase(string)) {
                    this.fcgiIsAvailable = false;
                    this.fcgiIsConfigured = false;
                } else {
                    boolean bl;
                    string = servletConfig.getInitParameter("use_fast_cgi");
                    if (string == null) {
                        string = "auto";
                    }
                    string = string.trim();
                    string = string.toLowerCase();
                    boolean bl2 = string.startsWith("auto");
                    boolean bl3 = bl = string.equals("false") || string.equals("off");
                    if (bl) {
                        this.fcgiIsAvailable = false;
                        this.fcgiIsConfigured = false;
                    }
                    if (bl2) {
                        this.canStartFCGI = true;
                    }
                }
            }
            catch (Throwable throwable) {
                Util.printStackTrace((Throwable)throwable);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        super.init(servletConfig);
        String string2 = this.context.getServerInfo();
        if (string2 != null && string2.startsWith("JBoss")) {
            this.isJBoss = true;
        }
        this.logger = new Util.Logger(!this.isJBoss, (ILogger)new Logger(this.context));
        try {
            string = this.context.getInitParameter("promiscuous");
            if (string == null) {
                string = "";
            }
            string = string.trim();
            if ((string = string.toLowerCase()).equals("on") || string.equals("true")) {
                this.promiscuous = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            string = this.context.getInitParameter("override_hosts");
            if (string == null) {
                string = "";
            }
            string = string.trim();
            if ((string = string.toLowerCase()).equals("off") || string.equals("false")) {
                this.override_hosts = false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            string = servletConfig.getInitParameter("prefer_system_php_exec");
            if (string == null) {
                string = "";
            }
            string = string.trim();
            if ((string = string.toLowerCase()).equals("on") || string.equals("true")) {
                this.preferSystemPhp = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        String string3 = null;
        try {
            string3 = servletConfig.getInitParameter("php_fcgi_children");
            if (string3 == null) {
                string3 = this.getServletConfig().getInitParameter("PHP_FCGI_CHILDREN");
            }
            if (string3 == null) {
                string3 = System.getProperty("php.java.bridge.php_fcgi_children");
            }
            if (string3 != null) {
                this.php_fcgi_children_number = Integer.parseInt(string3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string3 != null) {
            this.php_fcgi_children = string3;
        }
        string3 = null;
        this.php_include_java = false;
        try {
            string3 = servletConfig.getInitParameter("php_include_java");
            if (string3 == null) {
                string3 = servletConfig.getInitParameter("PHP_INCLUDE_JAVA");
            }
            if (string3 == null) {
                string3 = System.getProperty("php.java.bridge.php_include_java");
            }
            if (string3 != null && (string3.equalsIgnoreCase("on") || string3.equalsIgnoreCase("true"))) {
                this.php_include_java = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string3 = null;
        try {
            string3 = servletConfig.getInitParameter("php_fcgi_max_requests");
            if (string3 == null) {
                string3 = this.getServletConfig().getInitParameter("PHP_FCGI_MAX_REQUESTS");
            }
            if (string3 == null) {
                string3 = System.getProperty("php.java.bridge.php_fcgi_max_requests");
            }
            if (string3 != null) {
                this.php_fcgi_max_requests_number = Integer.parseInt(string3);
                this.php_fcgi_max_requests = string3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fcgiIsConfigured = true;
        this.fcgiIsAvailable = true;
        this.checkCgiBinary(servletConfig);
        try {
            string = servletConfig.getInitParameter("shared_fast_cgi_pool");
            if (string == null) {
                string = "";
            }
            string = string.trim();
            if ((string = string.toLowerCase()).equals("on") || string.equals("true")) {
                this.delegateToJavaBridgeContext = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.channelName = ChannelFactory.createChannelFactory(this.promiscuous);
        this.channelName.findFreePort(this.canStartFCGI && !this.delegateToJavaBridgeContext);
    }

    public void destroy() {
        if (fcgiConnectionPool != null) {
            fcgiConnectionPool.destroy();
        }
        this.channelName.destroy();
        super.destroy();
        fcgiConnectionPool = null;
    }

    protected StringBuffer getCgiDir() {
        String string = FastCGIServlet.getRealPath(this.getServletContext(), "/");
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.cgiPathPrefix);
        return stringBuffer;
    }

    protected CGIServlet.CGIEnvironment createCGIEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        CGIEnvironment cGIEnvironment = new CGIEnvironment(httpServletRequest, httpServletResponse, servletContext);
        cGIEnvironment.init(httpServletRequest, httpServletResponse);
        return cGIEnvironment;
    }

    static boolean isJavaBridgeWc(String string) {
        return string != null && string.endsWith("JavaBridge");
    }

    protected class CGIRunner
    extends CGIServlet.CGIRunner {
        private ConnectionPool connectionPool;
        protected IContextFactory ctx;

        protected CGIRunner(CGIServlet.CGIEnvironment cGIEnvironment) {
            super(cGIEnvironment);
            this.connectionPool = ((CGIEnvironment)cGIEnvironment).connectionPool;
            this.ctx = ((CGIEnvironment)cGIEnvironment).ctx;
        }

        protected void doExecute() throws IOException, ServletException {
            try {
                this.parseBody();
            }
            catch (ConnectionException connectionException) {
                Util.logError((String)("PHP application terminated unexpectedly, have you started php-cgi with the environment setting PHP_FCGI_MAX_REQUESTS=" + FastCGIServlet.this.php_fcgi_max_requests + "?  Error: " + connectionException));
                throw connectionException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute() throws IOException, ServletException, InterruptedException {
            block8: {
                try {
                    try {
                        this.doExecute();
                    }
                    catch (ConnectException connectException) {
                        FastCGIServlet.this.fcgiIsAvailable = false;
                        if (Util.logLevel <= 1) throw new ServletException("PHP FastCGI server failed, switching off FastCGI SAPI.", (Throwable)connectException);
                        Util.logDebug((String)("PHP FastCGI server failed, switching off FastCGI SAPI: " + connectException));
                        Util.printStackTrace((Throwable)connectException);
                        throw new ServletException("PHP FastCGI server failed, switching off FastCGI SAPI.", (Throwable)connectException);
                    }
                    catch (ConnectionException connectionException) {
                        if (Util.logLevel <= 1) throw new ServletException("PHP FastCGI instance failed.", (Throwable)connectionException);
                        Util.logDebug((String)("PHP FastCGI instance failed: " + connectionException));
                        Util.printStackTrace((Throwable)connectionException);
                        throw new ServletException("PHP FastCGI instance failed.", (Throwable)connectionException);
                    }
                    catch (IOException iOException) {
                        Util.printStackTrace((Throwable)iOException);
                        throw iOException;
                    }
                    Object var3_1 = null;
                    if (this.ctx == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    if (this.ctx != null) {
                        this.ctx.releaseManaged();
                    }
                    this.ctx = null;
                    throw throwable;
                }
                this.ctx.releaseManaged();
            }
            this.ctx = null;
        }

        /*
         * Loose catch block
         */
        protected void parseBody() throws IOException, ServletException {
            block34: {
                IOException iOException2222;
                ConnectionPool.Connection connection;
                FastCGIOutputStream fastCGIOutputStream;
                FastCGIInputStream fastCGIInputStream;
                InputStream inputStream;
                block32: {
                    int n;
                    inputStream = null;
                    fastCGIInputStream = null;
                    fastCGIOutputStream = null;
                    connection = null;
                    connection = this.connectionPool.openConnection();
                    fastCGIOutputStream = (FastCGIOutputStream)connection.getOutputStream();
                    fastCGIInputStream = (FastCGIInputStream)connection.getInputStream();
                    inputStream = this.stdin;
                    fastCGIOutputStream.writeBegin();
                    fastCGIOutputStream.writeParams(this.env);
                    String string = null;
                    byte[] byArray = new byte[65535];
                    int n2 = 0;
                    int n3 = 0;
                    boolean bl = false;
                    if (inputStream != null) {
                        while ((n = inputStream.read(byArray)) != -1) {
                            fastCGIOutputStream.write(byArray, n);
                        }
                        inputStream.close();
                        inputStream = null;
                    } else {
                        fastCGIOutputStream.write(FCGI_EMPTY_RECORD);
                    }
                    fastCGIOutputStream.close();
                    fastCGIOutputStream = null;
                    while ((n = fastCGIInputStream.read(byArray)) != -1) {
                        int n4 = n2 + n;
                        while (!bl && n2 < n4) {
                            switch (byArray[n2++]) {
                                case 10: {
                                    if (n3 + 2 == n2 && byArray[n3] == 13) {
                                        bl = true;
                                        break;
                                    }
                                    string = new String(byArray, n3, n2 - n3 - 2, "ASCII");
                                    this.addHeader(string);
                                    n3 = n2;
                                }
                            }
                        }
                        if (!bl) continue;
                        if (n2 < n4) {
                            this.getServletOutputStream(this.response).write(byArray, n2, n4 - n2);
                        }
                        n2 = 0;
                    }
                    fastCGIInputStream.close();
                    String string2 = fastCGIInputStream.checkError();
                    StringBuffer stringBuffer = fastCGIInputStream.getError();
                    if (stringBuffer != null && Util.logLevel > 4) {
                        Util.logDebug((String)stringBuffer.toString());
                    }
                    fastCGIInputStream = null;
                    connection = null;
                    if (string2 != null) {
                        throw new RuntimeException(string2);
                    }
                    Object var14_15 = null;
                    if (connection != null) {
                        connection.setIsClosed();
                    }
                    if (inputStream == null) break block32;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (fastCGIInputStream != null) {
                    try {
                        fastCGIInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (fastCGIOutputStream != null) {
                    try {
                        fastCGIOutputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block34;
                {
                    catch (InterruptedException interruptedException) {
                        throw new ServletException((Throwable)interruptedException);
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException32222;
                    Object var14_16 = null;
                    if (connection != null) {
                        connection.setIsClosed();
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (fastCGIInputStream != null) {
                        try {
                            fastCGIInputStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (fastCGIOutputStream != null) {
                        try {
                            fastCGIOutputStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    protected class CGIRunnerFactory
    extends CGIServlet.CGIRunnerFactory {
        protected CGIRunnerFactory() {
        }

        protected CGIServlet.CGIRunner createCGIRunner(CGIServlet.CGIEnvironment cGIEnvironment) {
            return new CGIRunner(cGIEnvironment);
        }
    }

    protected class CGIEnvironment
    extends CGIServlet.CGIEnvironment {
        private ConnectionPool connectionPool;
        public IContextFactory ctx;
        protected static final String empty_string = "";
        private static final int JAVABRIDGE_RESERVE = 1;

        protected CGIEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
            super(httpServletRequest, httpServletResponse, servletContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String[] findCGI(String string, String string2, String string3, String string4, String string5) {
            Object object;
            boolean bl = FastCGIServlet.isJavaBridgeWc(string3);
            Object object2 = object = bl ? javaBridgeCtxLock : globalCtxLock;
            synchronized (object2) {
                if (!FastCGIServlet.this.fcgiIsAvailable) {
                    return null;
                }
                this.connectionPool = fcgiConnectionPool;
                if (null == this.connectionPool) {
                    try {
                        int n = FastCGIServlet.this.php_fcgi_children_number;
                        if (FastCGIServlet.this.delegateToJavaBridgeContext) {
                            n = bl ? 1 : FastCGIServlet.this.php_fcgi_children_number - 1;
                        }
                        this.connectionPool = this.createConnectionPool(n);
                        fcgiConnectionPool = this.connectionPool;
                    }
                    catch (Exception exception) {
                        String string6 = CGIServlet.getRealPath(this.context, string5);
                        Util.logDebug((String)(exception + ": FastCGI channel not available, switching off fast cgi. " + FastCGIServlet.this.channelName.getFcgiStartCommand(string6, FastCGIServlet.this.php_fcgi_max_requests)));
                        FastCGIServlet.this.fcgiIsAvailable = false;
                        return null;
                    }
                }
            }
            FastCGIServlet.this.cgiRunnerFactory = FastCGIServlet.this.defaultCGIRunnerFactory;
            return new String[]{FastCGIServlet.this.php, string3 + string4, empty_string, empty_string};
        }

        private ConnectionPool createConnectionPool(int n) throws ConnectException {
            FastCGIServlet.this.channelName.initialize((PhpCGIServlet)FastCGIServlet.this, (PhpCGIServlet.CGIEnvironment)this, this.contextPath);
            FastCGIServlet.this.fcgiIsAvailable = FastCGIServlet.this.channelName.startServer(FastCGIServlet.this.logger);
            return new ConnectionPool(FastCGIServlet.this.channelName, n, FastCGIServlet.this.php_fcgi_max_requests_number, FastCGIServlet.this.defaultPoolFactory);
        }
    }
}

