/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.Util;
import php.java.servlet.CGIServlet;
import php.java.servlet.fastcgi.Channel;
import php.java.servlet.fastcgi.ChannelFactory;
import php.java.servlet.fastcgi.ConnectException;
import php.java.servlet.fastcgi.FCGIProcess;
import php.java.servlet.fastcgi.NPChannel;

class NPChannelFactory
extends ChannelFactory {
    public static final String PREFIX = "\\\\.\\pipe\\";
    private String raPath;
    private String testRaPath;

    NPChannelFactory() {
    }

    public void test() throws ConnectException {
        if (!new File(this.raPath).canWrite()) {
            throw new ConnectException(new IOException("File " + this.raPath + " not writable"));
        }
    }

    private NPChannel doConnect() throws ConnectException {
        try {
            return new NPChannel(new RandomAccessFile(this.raPath, "rw"));
        }
        catch (IOException iOException) {
            throw new ConnectException(iOException);
        }
    }

    public Channel connect() throws ConnectException {
        return this.doConnect();
    }

    protected Util.Process doBind(Map map, String string, boolean bl) throws IOException {
        if (proc != null) {
            return null;
        }
        if (this.raPath == null) {
            throw new IOException("No pipe name available.");
        }
        map.put("X_JAVABRIDGE_OVERRIDE_HOSTS", this.servlet.override_hosts ? "/" : "");
        map.put("REDIRECT_STATUS", "200");
        String[] stringArray = Util.getPhpArgs((String[])new String[]{string, this.raPath}, (boolean)bl);
        File file = null;
        if (string != null) {
            try {
                file = new File(string).getParentFile();
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
            }
        }
        proc = new FCGIProcess(stringArray, file, map, CGIServlet.getRealPath(this.servlet.context, this.servlet.cgiPathPrefix), this.servlet.phpTryOtherLocations, this.servlet.preferSystemPhp);
        proc.start();
        return proc;
    }

    protected void waitForDaemon() throws UnknownHostException, InterruptedException {
        Thread.sleep(5000L);
    }

    public String getFcgiStartCommand(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(".");
        stringBuffer.append(File.separator);
        stringBuffer.append("php-cgi-");
        stringBuffer.append(Util.osArch);
        stringBuffer.append("-");
        stringBuffer.append(Util.osName);
        String string3 = stringBuffer.toString();
        String string4 = "Please start Apache or IIS or start a standalone PHP server.\nFor example with the commands: \n\ncd " + string + "\n" + "set %REDIRECT_STATUS%=200\n" + "set %X_JAVABRIDGE_OVERRIDE_HOSTS%=/\n" + "set %PHP_FCGI_CHILDREN%=5\n" + "set %PHP_FCGI_MAX_REQUESTS%=php_fcgi_max_requests\n" + "php-cgi -d allow_url_include=On -n\n\n" + "Or copy your php-cgi.exe to " + string3 + "\n\n.";
        return string4;
    }

    public void findFreePort(boolean bl) {
        try {
            if (bl) {
                File file = File.createTempFile("JavaBridge", ".socket");
                this.testRaPath = PREFIX + file.getPath();
                file.delete();
            } else {
                this.testRaPath = "\\\\.\\pipe\\JavaBridge@9667";
            }
        }
        catch (IOException iOException) {
            Util.printStackTrace((Throwable)iOException);
        }
    }

    public void setDefaultPort() {
        this.raPath = "\\\\.\\pipe\\JavaBridge@9667";
    }

    protected void setDynamicPort() {
        this.raPath = this.testRaPath;
    }
}

