/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.servlet.CGIServlet;
import php.java.servlet.fastcgi.Channel;
import php.java.servlet.fastcgi.ChannelFactory;
import php.java.servlet.fastcgi.ConnectException;
import php.java.servlet.fastcgi.FCGIProcess;
import php.java.servlet.fastcgi.SocketChannel;

class SocketChannelFactory
extends ChannelFactory {
    public static final String LOCAL_HOST = "127.0.0.1";
    private int port;
    private ServerSocket fcgiTestSocket = null;
    private int fcgiTestPort;

    public SocketChannelFactory(boolean bl) {
        this.promiscuous = bl;
    }

    public void test() throws ConnectException {
        try {
            Socket socket = new Socket(InetAddress.getByName(this.getName()), this.port);
            socket.close();
        }
        catch (IOException iOException) {
            throw new ConnectException(iOException);
        }
    }

    private Socket doConnect(String string, int n) throws ConnectException {
        Socket socket = null;
        try {
            socket = new Socket(InetAddress.getByName(string), n);
        }
        catch (IOException iOException) {
            throw new ConnectException(iOException);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            Util.printStackTrace((Throwable)socketException);
        }
        return socket;
    }

    public Channel connect() throws ConnectException {
        Socket socket = this.doConnect(this.getName(), this.getPort());
        return new SocketChannel(socket);
    }

    protected void waitForDaemon() throws UnknownHostException, InterruptedException {
        long l = System.currentTimeMillis();
        int n = 15;
        InetAddress inetAddress = InetAddress.getByName(LOCAL_HOST);
        if (Util.logLevel > 3) {
            Util.logDebug((String)"Waiting for PHP FastCGI daemon");
        }
        while (n-- > 0) {
            try {
                Socket socket = new Socket(inetAddress, this.getPort());
                socket.close();
                break;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() - 16000L > l) break;
                Thread.sleep(1000L);
            }
        }
        if (n == -1) {
            Util.logError((String)"Timeout waiting for PHP FastCGI daemon");
        }
        if (Util.logLevel > 3) {
            Util.logDebug((String)"done waiting for PHP FastCGI daemon");
        }
    }

    protected Util.Process doBind(Map map, String string, boolean bl) throws IOException {
        if (proc != null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(Util.JAVABRIDGE_PROMISCUOUS || this.promiscuous ? "" : LOCAL_HOST);
        stringBuffer.append(':');
        stringBuffer.append(String.valueOf(this.getPort()));
        String string2 = stringBuffer.toString();
        map.put("X_JAVABRIDGE_OVERRIDE_HOSTS", this.servlet.override_hosts ? "/" : "");
        map.put("REDIRECT_STATUS", "200");
        String[] stringArray = Util.getPhpArgs((String[])new String[]{string, "-b", string2}, (boolean)bl);
        File file = null;
        if (string != null) {
            try {
                file = new File(string).getParentFile();
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
            }
        }
        proc = new FCGIProcess(stringArray, file, map, CGIServlet.getRealPath(this.servlet.context, this.servlet.cgiPathPrefix), this.servlet.phpTryOtherLocations, this.servlet.preferSystemPhp);
        proc.start();
        return proc;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return LOCAL_HOST;
    }

    public String getFcgiStartCommand(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(".");
        stringBuffer.append(File.separator);
        stringBuffer.append("php-cgi-");
        stringBuffer.append(Util.osArch);
        stringBuffer.append("-");
        stringBuffer.append(Util.osName);
        String string3 = stringBuffer.toString();
        String string4 = null;
        string4 = "Please start Apache or IIS or start a standalone PHP server.\nFor example with the commands: \n\ncd " + string + "\n" + "chmod +x " + string3 + "\n" + "REDIRECT_STATUS=200 " + "X_JAVABRIDGE_OVERRIDE_HOSTS=\"/\" " + "PHP_FCGI_CHILDREN=\"5\" " + "PHP_FCGI_MAX_REQUESTS=\"" + string2 + "\" " + string3 + " -d allow_url_include=On -c " + string3 + ".ini -b 127.0.0.1:" + this.getPort() + "\n\n";
        return string4;
    }

    protected void bind(ILogger iLogger) throws InterruptedException, IOException {
        if (this.fcgiTestSocket != null) {
            this.fcgiTestSocket.close();
            this.fcgiTestSocket = null;
        }
        super.bind(iLogger);
    }

    public void findFreePort(boolean bl) {
        this.fcgiTestPort = 9667;
        this.fcgiTestSocket = null;
        for (int i = 9668; bl && i < 9767; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(i, 20, InetAddress.getByName(LOCAL_HOST));
                this.fcgiTestPort = i;
                this.fcgiTestSocket = serverSocket;
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    public void setDefaultPort() {
        this.port = 9667;
    }

    protected void setDynamicPort() {
        this.port = this.fcgiTestPort;
    }

    public void destroy() {
        super.destroy();
        if (this.fcgiTestSocket != null) {
            try {
                this.fcgiTestSocket.close();
                this.fcgiTestSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

