/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import php.java.bridge.ThreadPool;
import php.java.bridge.Util;

public final class AppThreadPool
extends ThreadPool {
    protected ThreadPool.Delegate createDelegate(String name) {
        return new Delegate(name);
    }

    public AppThreadPool(String name, int poolMaxSize) {
        super(name, poolMaxSize);
    }

    final class Delegate
    extends ThreadPool.Delegate {
        protected ThreadGroup appGroup;

        protected Delegate(String name) {
            super(AppThreadPool.this, new Group(name), name);
            this.appGroup = null;
            ((Group)this.getThreadGroup()).lock();
        }

        public ThreadGroup getAppGroup() {
            if (this.appGroup != null) {
                return this.appGroup;
            }
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            this.appGroup = new AppGroup("JavaBridgeThreadPoolAppGroup");
            group.lock();
            return this.appGroup;
        }

        public void setPersistent() {
            if (!AppThreadPool.this.checkReserve() && !this.terminate) {
                this.terminate = true;
                String name = this.getName();
                this.setName(name + ",isDaemon=true");
                if (Util.logLevel > 5) {
                    name = name + "+";
                }
                this.createThread(name);
            }
            this.end();
        }

        protected void createThread(String name) {
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            super.createThread(name);
            group.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void terminate() {
            ThreadGroup group;
            if (Util.logLevel > 4) {
                Util.logDebug("term (thread removed from pool): " + this);
            }
            if ((group = this.appGroup) != null) {
                try {
                    group.interrupt();
                }
                catch (SecurityException e) {
                    return;
                }
                try {
                    group.destroy();
                }
                catch (SecurityException e) {
                }
                catch (IllegalThreadStateException e1) {
                    Util.printStackTrace(e1);
                }
                catch (Exception e2) {
                    Util.printStackTrace(e2);
                }
                finally {
                    this.appGroup = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void end() {
            ThreadGroup group;
            super.end();
            if (Util.logLevel > 4) {
                Util.logDebug("end (thread returned to pool): " + this);
            }
            if ((group = this.appGroup) != null) {
                try {
                    group.interrupt();
                }
                catch (SecurityException e) {
                }
                catch (Exception e2) {
                    Util.printStackTrace(e2);
                }
                finally {
                    this.appGroup = null;
                }
            }
        }
    }

    static final class AppGroup
    extends ThreadGroup {
        private void init() {
            this.setDaemon(true);
        }

        public AppGroup(String name) {
            super(name);
            this.init();
        }

        public AppGroup(ThreadGroup group, String name) {
            super(group, name);
            this.init();
        }
    }

    static final class Group
    extends ThreadGroup {
        boolean isLocked = false;

        void lock() {
            this.isLocked = true;
        }

        void unlock() {
            this.isLocked = false;
        }

        private void init() {
            this.setDaemon(true);
        }

        public Group(String name) {
            super(name);
            this.init();
        }

        public Group(ThreadGroup group, String name) {
            super(group, name);
            this.init();
        }
    }
}

