/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import php.java.bridge.JavaBridge;
import php.java.bridge.SimplePhpString;

abstract class PhpMap {
    JavaBridge _bridge;
    Object value;
    Class componentType;
    boolean keyType;

    protected PhpMap(JavaBridge bridge, Object value, boolean keyType) {
        this._bridge = bridge;
        this.value = value;
        this.keyType = keyType;
        this.componentType = value.getClass().getComponentType();
        this.init();
    }

    protected Object coerce(Object val) {
        return this._bridge.coerce(this.componentType, val, this._bridge.request.response);
    }

    protected abstract void init();

    public abstract Object currentData();

    public abstract Object currentKey();

    public abstract boolean moveForward();

    public abstract boolean hasMore();

    public boolean getType() {
        return this.keyType;
    }

    public static PhpMap getPhpMap(Object value, JavaBridge bridge) {
        if (bridge.logLevel > 3) {
            bridge.logDebug("returning map for " + value.getClass());
        }
        if (value.getClass().isArray()) {
            return new PhpMap(bridge, value, false){
                boolean valid;
                int i;
                int length;

                protected void init() {
                    this.i = 0;
                    this.length = Array.getLength(this.value);
                    this.valid = this.length > 0;
                }

                public Object currentData() {
                    if (!this.valid) {
                        return null;
                    }
                    return Array.get(this.value, this.i);
                }

                public Object currentKey() {
                    if (!this.valid) {
                        return null;
                    }
                    return this._bridge.castToExact(new Integer(this.i));
                }

                public boolean moveForward() {
                    this.valid = ++this.i < this.length;
                    return this.valid;
                }

                public boolean hasMore() {
                    return this.valid;
                }
            };
        }
        if (value instanceof Collection) {
            return new PhpMap(bridge, value, false){
                int i;
                boolean valid;
                Iterator iter;

                protected void init() {
                    this.iter = ((Collection)this.value).iterator();
                    this.i = 0;
                    this.valid = false;
                    if (this.iter.hasNext()) {
                        this.valid = true;
                        this.value = this.iter.next();
                    }
                }

                public Object currentData() {
                    return this.value;
                }

                public Object currentKey() {
                    return this._bridge.castToExact(new Integer(this.i));
                }

                public boolean moveForward() {
                    if (this.iter.hasNext()) {
                        ++this.i;
                        this.value = this.iter.next();
                        this.valid = true;
                        return true;
                    }
                    this.valid = false;
                    return false;
                }

                public boolean hasMore() {
                    return this.valid;
                }
            };
        }
        if (value instanceof Map) {
            return new PhpMap(bridge, value, true){
                Object currentKey;
                Iterator iter;

                protected void init() {
                    this.iter = ((Map)this.value).keySet().iterator();
                    this.currentKey = null;
                    if (this.iter.hasNext()) {
                        this.currentKey = this.iter.next();
                    }
                }

                public Object currentData() {
                    if (this.currentKey == null) {
                        return null;
                    }
                    return ((Map)this.value).get(this.currentKey);
                }

                public Object currentKey() {
                    return new SimplePhpString(this._bridge, String.valueOf(this.currentKey));
                }

                public boolean moveForward() {
                    this.currentKey = this.iter.hasNext() ? this.iter.next() : null;
                    return this.currentKey != null;
                }

                public boolean hasMore() {
                    return this.currentKey != null;
                }
            };
        }
        return null;
    }
}

