/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import php.java.bridge.ISocketFactory;

class TCPServerSocket
implements ISocketFactory {
    static int TCP_PORT_BASE = 9267;
    private ServerSocket sock;
    private int port;
    boolean local;

    public static ISocketFactory create(String name, int backlog) throws IOException {
        boolean local = false;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.startsWith("INET:")) {
            name = name.substring(5);
        } else if (name.startsWith("INET_LOCAL:")) {
            local = true;
            name = name.substring(11);
        }
        int p = Integer.parseInt(name);
        TCPServerSocket s = new TCPServerSocket(p, backlog, local);
        return s;
    }

    private ServerSocket newServerSocket(int port, int backlog) throws IOException {
        try {
            if (this.local) {
                return new ServerSocket(port, backlog, InetAddress.getByName("127.0.0.1"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new ServerSocket(port, backlog);
    }

    private void findFreePort(int start, int backlog) {
        for (int port = start; port < start + 100; ++port) {
            try {
                this.sock = this.newServerSocket(port, backlog);
                this.port = port;
                return;
            }
            catch (IOException e) {
                continue;
            }
        }
    }

    private TCPServerSocket(int port, int backlog, boolean local) throws IOException {
        this.local = local;
        if (port == 0) {
            this.findFreePort(TCP_PORT_BASE, backlog);
        } else {
            this.sock = this.newServerSocket(port, backlog);
            this.port = port;
        }
    }

    public void close() throws IOException {
        this.sock.close();
    }

    public Socket accept() throws IOException {
        Socket s = this.sock.accept();
        s.setTcpNoDelay(true);
        return s;
    }

    public String getSocketName() {
        return String.valueOf(this.port);
    }

    public String toString() {
        return (this.local ? "INET_LOCAL:" : "INET:") + this.getSocketName();
    }
}

