/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ISocketFactory;
import php.java.bridge.Util;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;

public abstract class HttpServer
implements Runnable {
    public static final String PUT = "PUT";
    public static final String GET = "GET";
    public static final String POST = "POST";
    protected ISocketFactory socket;
    protected Thread httpServer;
    private AppThreadPool pool;
    protected boolean isSecure;
    protected static final byte[] ERROR_UNAVAIL = Util.toBytes("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>503 Service Unavailable</title></head><body><h1>Out of system resources</h1><p>Try again shortly or use the Apache or IIS front end instead.</p><hr></body></html>");
    protected static final byte[] ERROR = Util.toBytes("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL was not found on this server.</p><hr></body></html>");

    public abstract ISocketFactory bind(String var1) throws IOException;

    public abstract ISocketFactory bindSecure(String var1) throws IOException;

    protected HttpServer() throws IOException {
        this(null);
    }

    protected HttpServer(String serverPort, boolean isSecure) throws IOException {
        this.isSecure = isSecure;
        if (serverPort == null) {
            serverPort = "0";
        }
        if (!serverPort.startsWith("INET")) {
            serverPort = (Util.JAVABRIDGE_PROMISCUOUS ? "INET:" : "INET_LOCAL:") + serverPort;
        }
        this.socket = isSecure ? this.bindSecure(serverPort) : this.bind(serverPort);
        try {
            this.pool = this.createThreadPool("JavaBridgeHttpServerThreadPool");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.httpServer = new Util.Thread(this, "JavaBridgeHttpServer");
        this.httpServer.start();
    }

    protected HttpServer(String serverPort) throws IOException {
        this(serverPort, false);
    }

    private AppThreadPool createThreadPool(String name) {
        AppThreadPool pool = null;
        int maxSize = 20;
        try {
            maxSize = Integer.parseInt(Util.THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (maxSize > 0) {
            pool = new AppThreadPool(name, maxSize);
        }
        return pool;
    }

    protected boolean parseHeader(HttpRequest req) throws UnsupportedEncodingException, IOException {
        int n;
        byte[] buf = new byte[8192];
        InputStream natIn = req.getInputStream();
        int i = 0;
        int s = 0;
        boolean eoh = false;
        boolean rn = false;
        String remain = null;
        while ((n = natIn.read(buf, i, buf.length - i)) != -1) {
            int N = i + n;
            block5: while (!eoh && i < N) {
                switch (buf[i++]) {
                    case 10: {
                        if (rn) {
                            eoh = true;
                        } else {
                            String line;
                            if (remain != null) {
                                line = remain + new String(buf, s, i - s, "ASCII");
                                line = line.substring(0, line.length() - 2);
                                remain = null;
                            } else {
                                line = new String(buf, s, i - s - 2, "ASCII");
                            }
                            req.addHeader(line);
                            s = i;
                        }
                        rn = true;
                        continue block5;
                    }
                    case 13: {
                        continue block5;
                    }
                }
                rn = false;
            }
            if (eoh) {
                req.pushBack(buf, i, N - i);
                return true;
            }
            remain = remain != null ? remain + new String(buf, s, i - s, "ASCII") : new String(buf, s, i - s, "ASCII");
            i = 0;
            s = 0;
        }
        return false;
    }

    protected void doRun() throws IOException {
        while (true) {
            Socket sock;
            try {
                sock = this.socket.accept();
            }
            catch (SocketException e) {
                return;
            }
            catch (IOException e) {
                Util.printStackTrace(e);
                return;
            }
            Util.logDebug("Socket connection accepted");
            if (this.pool == null) {
                Util.logDebug("Starting new HTTP server thread");
                new Util.Thread(new Runner(sock), Util.EXTENSION_NAME + "HttpServerRunner").start();
                continue;
            }
            Util.logDebug("Starting HTTP server thread from thread pool");
            this.pool.start(new Runner(sock));
        }
    }

    protected void writeServiceUnavailable(HttpRequest req, HttpResponse res) throws IOException {
        res.setContentLength(ERROR_UNAVAIL.length);
        OutputStream out = res.getOutputStream();
        out.write(ERROR_UNAVAIL);
    }

    protected void writeError(HttpRequest req, HttpResponse res) throws IOException {
        res.setContentLength(ERROR.length);
        OutputStream out = res.getOutputStream();
        out.write(ERROR);
    }

    protected void doPost(HttpRequest req, HttpResponse res) throws IOException {
        this.writeError(req, res);
    }

    protected void doGet(HttpRequest req, HttpResponse res) throws IOException {
        this.writeError(req, res);
    }

    protected void doPut(HttpRequest req, HttpResponse res) throws IOException {
        this.writeError(req, res);
    }

    protected void service(HttpRequest req, HttpResponse res) throws IOException {
        String contentLength = req.getHeader("Content-Length");
        if (contentLength == null) {
            req.setContentLength(-1);
        } else {
            req.setContentLength(Integer.parseInt(contentLength));
        }
        String method = req.getMethod();
        if (method == PUT) {
            this.doPut(req, res);
        } else if (method == GET) {
            this.doGet(req, res);
        } else if (method == POST) {
            this.doPost(req, res);
        }
    }

    public void run() {
        try {
            this.doRun();
        }
        catch (IOException e) {
            Util.printStackTrace(e);
        }
    }

    public void destroy() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
        try {
            if (this.pool != null) {
                this.pool.destroy();
            }
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
    }

    public ISocketFactory getSocket() {
        return this.socket;
    }

    private class Runner
    implements Runnable {
        private Socket sock;
        private HttpRequest req;
        private HttpResponse res;

        public Runner(Socket sock) throws IOException {
            this.sock = sock;
            this.req = new HttpRequest(sock.getInputStream());
            this.res = new HttpResponse(sock.getOutputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (HttpServer.this.parseHeader(this.req)) {
                    HttpServer.this.service(this.req, this.res);
                }
            }
            catch (IOException e) {
                Util.printStackTrace(e);
            }
            finally {
                try {
                    this.req.close();
                }
                catch (IOException e) {}
                try {
                    this.res.close();
                }
                catch (IOException e) {}
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

