/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import php.java.bridge.ILogger;
import php.java.bridge.ThreadPool;
import php.java.bridge.Util;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.FCGIConnectionFactory;
import php.java.bridge.http.FCGIConnectionPool;
import php.java.bridge.http.FCGIIOFactory;
import php.java.bridge.http.FCGIInputStream;
import php.java.bridge.http.FCGIOutputStream;
import php.java.bridge.http.IFCGIProcess;
import php.java.bridge.http.IFCGIProcessFactory;
import php.java.servlet.Logger;
import php.java.servlet.ServletUtil;
import php.java.servlet.fastcgi.FCGIProcess;

public class ContextLoaderListener
implements ServletContextListener,
IFCGIProcessFactory {
    private LinkedList closeables = new LinkedList();
    public static final String PEAR_DIR = "/WEB-INF/pear";
    public static final String CGI_DIR = "/WEB-INF/cgi";
    public static final String WEB_INF_DIR = "/WEB-INF";
    protected ServletContext context;
    protected FCGIConnectionFactory channelName;
    protected String php = null;
    protected boolean fcgiIsConfigured;
    protected boolean canStartFCGI = false;
    protected boolean override_hosts = true;
    protected String php_fcgi_connection_pool_size = "5";
    protected String php_fcgi_connection_pool_timeout = "-1";
    protected boolean php_include_java;
    protected int php_fcgi_connection_pool_size_number = Integer.parseInt("5");
    protected long php_fcgi_connection_pool_timeout_number = Long.parseLong("-1");
    protected String php_fcgi_max_requests = "5000";
    protected int php_fcgi_max_requests_number = Integer.parseInt("5000");
    protected ILogger logger;
    protected boolean promiscuous = true;
    protected ContextLoaderListener listener;
    private FCGIConnectionPool fcgiConnectionPool = null;
    private boolean isJBoss;
    private ContextServer contextServer;
    private ThreadPool fcgiThreadPool;
    public static final String CONTEXT_LOADER_LISTENER = ContextLoaderListener.class.getName() + ".ROOT";
    static final HashMap PROCESS_ENVIRONMENT = ContextLoaderListener.getProcessEnvironment();
    private final FCGIIOFactory defaultPoolFactory = new FCGIIOFactory(){

        public InputStream createInputStream() {
            return new FCGIInputStream((IFCGIProcessFactory)ContextLoaderListener.this);
        }

        public OutputStream createOutputStream() {
            return new FCGIOutputStream();
        }

        public FCGIConnection connect(FCGIConnectionFactory name) throws FCGIConnectException {
            return name.connect();
        }
    };
    protected boolean preferSystemPhp = false;
    protected boolean phpTryOtherLocations = false;
    private String cgiDir;
    private String pearDir;
    private String webInfDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCloseables(ServletContext ctx) {
        LinkedList list = this.closeables;
        if (list == null) {
            return;
        }
        try {
            Iterator ii = list.iterator();
            while (ii.hasNext()) {
                Object c = ii.next();
                try {
                    Method close = c.getClass().getMethod("close", Util.ZERO_PARAM);
                    close.setAccessible(true);
                    close.invoke(c, Util.ZERO_ARG);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.closeables.clear();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        try {
            this.destroyCloseables(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fcgiConnectionPool != null) {
            this.fcgiConnectionPool.destroy();
        }
        if (this.fcgiThreadPool != null) {
            this.fcgiThreadPool.destroy();
        }
        if (this.channelName != null) {
            this.channelName.destroy();
        }
        this.fcgiConnectionPool = null;
        if (this.contextServer != null) {
            this.contextServer.destroy();
        }
        Util.destroy();
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        ctx.setAttribute(CONTEXT_LOADER_LISTENER, (Object)this);
        this.context = ctx;
        this.init();
        boolean promiscuous = true;
        try {
            String value = ctx.getInitParameter("promiscuous");
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if ((value = value.toLowerCase()).equals("off") || value.equals("false")) {
                promiscuous = false;
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        String name = this.context.getServerInfo();
        if (name != null && name.startsWith("JBoss")) {
            this.isJBoss = true;
        }
        this.logger = new Util.Logger(!this.isJBoss, (ILogger)new Logger());
        Util.setDefaultLogger((ILogger)this.logger);
        String servletContextName = ServletUtil.getRealPath(this.context, "");
        if (servletContextName == null) {
            servletContextName = "";
        }
        this.contextServer = new ContextServer(servletContextName, promiscuous);
        this.channelName = FCGIConnectionFactory.createChannelFactory((IFCGIProcessFactory)this, (boolean)promiscuous);
        this.channelName.findFreePort(this.canStartFCGI);
        try {
            this.fcgiConnectionPool = this.createConnectionPool(this.php_fcgi_connection_pool_size_number);
        }
        catch (FCGIConnectException e) {
            Util.printStackTrace((Throwable)e);
        }
        this.fcgiThreadPool = this.createThreadPool(this.php_fcgi_connection_pool_size_number);
    }

    private void init() {
        try {
            String value = this.context.getInitParameter("prefer_system_php_exec");
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if ((value = value.toLowerCase()).equals("on") || value.equals("true")) {
                this.preferSystemPhp = true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String val = null;
        try {
            val = this.context.getInitParameter("php_fcgi_children");
            if (val == null) {
                val = this.context.getInitParameter("PHP_FCGI_CHILDREN");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_children");
            }
            if (val == null) {
                val = this.context.getInitParameter("php_fcgi_connection_pool_size");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_connection_pool_size");
            }
            if (val != null) {
                this.php_fcgi_connection_pool_size_number = Integer.parseInt(val);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (val != null) {
            this.php_fcgi_connection_pool_size = val;
        }
        val = null;
        try {
            val = this.context.getInitParameter("php_fcgi_connection_pool_timeout");
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_connection_pool_timeout");
            }
            if (val != null) {
                this.php_fcgi_connection_pool_timeout_number = Integer.parseInt(val);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (val != null) {
            this.php_fcgi_connection_pool_timeout = val;
        }
        val = null;
        this.php_include_java = false;
        try {
            val = this.context.getInitParameter("php_include_java");
            if (val == null) {
                val = this.context.getInitParameter("PHP_INCLUDE_JAVA");
            }
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_include_java");
            }
            if (val != null && (val.equalsIgnoreCase("on") || val.equalsIgnoreCase("true"))) {
                this.php_include_java = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        val = null;
        try {
            val = this.context.getInitParameter("php_fcgi_max_requests");
            if (val == null) {
                val = System.getProperty("php.java.bridge.php_fcgi_max_requests");
            }
            if (val != null) {
                this.php_fcgi_max_requests_number = Integer.parseInt(val);
                this.php_fcgi_max_requests = val;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.checkCgiBinary();
        this.createPhpFiles();
    }

    private void checkCgiBinary() {
        String value;
        if (this.php == null) {
            try {
                File f;
                value = this.context.getInitParameter("php_exec");
                if (value == null || value.trim().length() == 0) {
                    value = "php-cgi";
                    this.phpTryOtherLocations = true;
                }
                if (!(f = new File(value)).isAbsolute()) {
                    value = ServletUtil.getRealPath(this.context, CGI_DIR) + File.separator + value;
                }
                this.php = value;
            }
            catch (Throwable t) {
                Util.printStackTrace((Throwable)t);
            }
        }
        this.fcgiIsConfigured = true;
        try {
            value = this.context.getInitParameter("use_fast_cgi");
            if (value == null) {
                try {
                    value = System.getProperty("php.java.bridge.use_fast_cgi");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ("false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value)) {
                this.fcgiIsConfigured = false;
            } else {
                boolean notAvailable;
                value = this.context.getInitParameter("use_fast_cgi");
                if (value == null) {
                    value = "auto";
                }
                value = value.trim();
                value = value.toLowerCase();
                boolean autostart = value.startsWith("auto");
                boolean bl = notAvailable = value.equals("false") || value.equals("off");
                if (notAvailable) {
                    this.fcgiIsConfigured = false;
                }
                if (autostart) {
                    this.canStartFCGI = true;
                }
            }
        }
        catch (Throwable t) {
            Util.printStackTrace((Throwable)t);
        }
    }

    private boolean useSystemPhp(File f) {
        if (!this.phpTryOtherLocations) {
            return true;
        }
        if (!f.exists()) {
            return true;
        }
        if (!this.preferSystemPhp) {
            return false;
        }
        for (int i = 0; i < Util.DEFAULT_CGI_LOCATIONS.length; ++i) {
            File location = new File(Util.DEFAULT_CGI_LOCATIONS[i]);
            if (!location.exists()) continue;
            return true;
        }
        return false;
    }

    private static void updateProcessEnvironment(File conf) {
        try {
            PROCESS_ENVIRONMENT.put("PHP_INI_SCAN_DIR", conf.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            PROCESS_ENVIRONMENT.put("PHP_INI_SCAN_DIR", conf.getAbsolutePath());
        }
    }

    private static HashMap getProcessEnvironment() {
        HashMap map = new HashMap(Util.COMMON_ENVIRONMENT);
        return map;
    }

    private void createPhpFiles() {
        File readme;
        FileOutputStream out;
        byte[] data;
        File phpCgi;
        String pearDir;
        String javaDir = ServletUtil.getRealPath(this.context, "java");
        if (javaDir != null) {
            File javaDirFile = new File(javaDir);
            try {
                if (!javaDirFile.exists()) {
                    javaDirFile.mkdir();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            File javaIncFile = new File(javaDir, "Java.inc");
            try {
                if (!javaIncFile.exists()) {
                    Field f = Util.JAVA_INC.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.JAVA_INC);
                    FileOutputStream out2 = new FileOutputStream(javaIncFile);
                    ((OutputStream)out2).write(buf);
                    ((OutputStream)out2).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File javaProxyFile = new File(javaDir, "JavaProxy.php");
            try {
                if (!javaProxyFile.exists()) {
                    Field f = Util.JAVA_PROXY.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.JAVA_PROXY);
                    FileOutputStream out3 = new FileOutputStream(javaProxyFile);
                    ((OutputStream)out3).write(buf);
                    ((OutputStream)out3).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((pearDir = ServletUtil.getRealPath(this.context, PEAR_DIR)) != null) {
            File pearDirFile = new File(pearDir);
            try {
                if (!pearDirFile.exists()) {
                    pearDirFile.mkdir();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String cgiDir = ServletUtil.getRealPath(this.context, CGI_DIR);
        File cgiOsDir = new File(cgiDir, Util.osArch + "-" + Util.osName);
        File conf = new File(cgiOsDir, "conf.d");
        File ext = new File(cgiOsDir, "ext");
        File cgiDirFile = new File(cgiDir);
        try {
            if (!cgiDirFile.exists()) {
                cgiDirFile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!conf.exists()) {
                conf.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!ext.exists()) {
                ext.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File javaIncFile = new File(cgiOsDir, "launcher.sh");
        if (Util.USE_SH_WRAPPER) {
            try {
                if (!javaIncFile.exists()) {
                    Field f = Util.LAUNCHER_UNIX.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.LAUNCHER_UNIX);
                    FileOutputStream out4 = new FileOutputStream(javaIncFile);
                    ((OutputStream)out4).write(buf);
                    ((OutputStream)out4).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File javaProxyFile = new File(cgiOsDir, "launcher.exe");
        if (!Util.USE_SH_WRAPPER) {
            try {
                if (!javaProxyFile.exists()) {
                    Field f = Util.LAUNCHER_WINDOWS.getField("bytes");
                    Field f2 = Util.LAUNCHER_WINDOWS2.getField("bytes");
                    Field f3 = Util.LAUNCHER_WINDOWS3.getField("bytes");
                    Field f4 = Util.LAUNCHER_WINDOWS4.getField("bytes");
                    byte[] buf = (byte[])f.get(Util.LAUNCHER_WINDOWS);
                    byte[] buf2 = (byte[])f2.get(Util.LAUNCHER_WINDOWS2);
                    byte[] buf3 = (byte[])f3.get(Util.LAUNCHER_WINDOWS3);
                    byte[] buf4 = (byte[])f4.get(Util.LAUNCHER_WINDOWS4);
                    FileOutputStream out5 = new FileOutputStream(javaProxyFile);
                    ((OutputStream)out5).write(buf);
                    ((OutputStream)out5).write(buf2);
                    ((OutputStream)out5).write(buf3);
                    ((OutputStream)out5).write(buf4);
                    ((OutputStream)out5).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean exeExists = true;
        if (Util.USE_SH_WRAPPER) {
            try {
                phpCgi = new File(cgiOsDir, "php-cgi");
                if (!this.useSystemPhp(phpCgi)) {
                    File ini;
                    ContextLoaderListener.updateProcessEnvironment(conf);
                    File wrapper = new File(cgiOsDir, "php-cgi.sh");
                    if (!wrapper.exists()) {
                        data = ("#!/bin/sh\nchmod +x ./" + Util.osArch + "-" + Util.osName + "/php-cgi\n" + "exec ./" + Util.osArch + "-" + Util.osName + "/php-cgi -c ./" + Util.osArch + "-" + Util.osName + "/php-cgi.ini \"$@\"").getBytes();
                        out = new FileOutputStream(wrapper);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                    if (!(ini = new File(cgiOsDir, "php-cgi.ini")).exists()) {
                        byte[] data2 = (";; -*- mode: Scheme; tab-width:4 -*-\n;; A simple php.ini\n;; DO NOT EDIT THIS FILE!\n;; Add your configuration files to the " + conf + " instead.\n" + ";; PHP extensions go to " + ext + ". Please see phpinfo() for ABI version details.\n" + "extension_dir=\"" + ext + "\"\n" + "include_path=\"" + pearDir + ":/usr/share/pear:.\"\n").getBytes();
                        FileOutputStream out6 = new FileOutputStream(ini);
                        ((OutputStream)out6).write(data2);
                        ((OutputStream)out6).close();
                    }
                } else {
                    exeExists = false;
                    readme = new File(cgiOsDir, "php-cgi.MISSING.README.txt");
                    if (!readme.exists()) {
                        data = "You can add \"php-cgi\" to this directory and re-deploy your web application.\n".getBytes();
                        out = new FileOutputStream(readme);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                phpCgi = new File(cgiOsDir, "php-cgi.exe");
                if (!this.useSystemPhp(phpCgi)) {
                    ContextLoaderListener.updateProcessEnvironment(conf);
                    File ini = new File(cgiOsDir, "php.ini");
                    if (!ini.exists()) {
                        data = (";; -*- mode: Scheme; tab-width:4 -*-\r\n;; A simple php.ini\r\n;; DO NOT EDIT THIS FILE!\r\n;; Add your configuration files to the " + conf + " instead.\r\n" + ";; PHP extensions go to " + ext + ". Please see phpinfo() for ABI version details.\r\n" + "extension_dir=\"" + ext + "\"\r\n" + "include_path=\"" + pearDir + ";.\"\r\n").getBytes();
                        out = new FileOutputStream(ini);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                } else {
                    exeExists = false;
                    readme = new File(cgiOsDir, "php-cgi.exe.MISSING.README.txt");
                    if (!readme.exists()) {
                        data = "You can add \"php-cgi.exe\" to this directory and re-deploy your web application.\r\n".getBytes();
                        out = new FileOutputStream(readme);
                        ((OutputStream)out).write(data);
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File tmpl = new File(conf, "mysql.ini");
        if (exeExists && !tmpl.exists()) {
            String str = Util.USE_SH_WRAPPER ? ";; -*- mode: Scheme; tab-width:4 -*-\n;; Example extension.ini file: mysql.ini.\n;; Copy the correct version (see phpinfo()) of the PHP extension \"mysql.so\" to the ./../ext directory and uncomment the following line\n; extension = mysql.so\n" : ";; -*- mode: Scheme; tab-width:4 -*-\r\n;; Example extension.ini file: mysql.ini.\r\n;; Copy the correct version (see phpinfo()) of the PHP extension \"php_mysql.dll\" to the .\\..\\ext directory and uncomment the following line\r\n; extension = php_mysql.dll\r\n";
            data = str.getBytes();
            try {
                out = new FileOutputStream(tmpl);
                ((OutputStream)out).write(data);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private FCGIConnectionPool createConnectionPool(int children) throws FCGIConnectException {
        this.channelName.initialize();
        this.channelName.startServer(this.logger);
        return new FCGIConnectionPool(this.channelName, children, this.php_fcgi_max_requests_number, this.defaultPoolFactory, this.php_fcgi_connection_pool_timeout_number);
    }

    private ThreadPool createThreadPool(int children) {
        return new ThreadPool("JavaBridgeServletScriptEngineProxy", children);
    }

    public ThreadPool getThreadPool() {
        return this.fcgiThreadPool;
    }

    public ContextServer getContextServer() {
        return this.contextServer;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public FCGIConnectionFactory getChannelName() {
        return this.channelName;
    }

    public List getCloseables() {
        return this.closeables;
    }

    public FCGIConnectionPool getConnectionPool() {
        return this.fcgiConnectionPool;
    }

    public static ContextLoaderListener getContextLoaderListener(ServletContext ctx) {
        return (ContextLoaderListener)ctx.getAttribute(CONTEXT_LOADER_LISTENER);
    }

    public IFCGIProcess createFCGIProcess(String[] args, boolean includeJava, File home, Map env) throws IOException {
        return new FCGIProcess(args, includeJava, this.getCgiDir(), this.getPearDir(), this.getWebInfDir(), home, env, this.getCgiDir(), this.phpTryOtherLocations, this.preferSystemPhp);
    }

    public String getPhpConnectionPoolSize() {
        return this.php_fcgi_connection_pool_size;
    }

    public String getPhpMaxRequests() {
        return this.php_fcgi_max_requests;
    }

    public String getPhp() {
        return this.php;
    }

    public boolean getPhpIncludeJava() {
        return this.php_include_java;
    }

    public HashMap getEnvironment() {
        return ContextLoaderListener.getProcessEnvironment();
    }

    public boolean canStartFCGI() {
        return this.canStartFCGI;
    }

    public String getCgiDir() {
        if (this.cgiDir != null) {
            return this.cgiDir;
        }
        this.cgiDir = ServletUtil.getRealPath(this.context, CGI_DIR);
        return this.cgiDir;
    }

    public String getPearDir() {
        if (this.pearDir != null) {
            return this.pearDir;
        }
        this.pearDir = ServletUtil.getRealPath(this.context, PEAR_DIR);
        return this.pearDir;
    }

    public String getWebInfDir() {
        if (this.webInfDir != null) {
            return this.webInfDir;
        }
        this.webInfDir = ServletUtil.getRealPath(this.context, WEB_INF_DIR);
        return this.webInfDir;
    }

    public void log(String msg) {
        this.logger.log(3, msg);
    }
}

