/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.IContextFactory;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.Logger;
import php.java.servlet.RemoteHttpServletContextFactory;
import php.java.servlet.RemoteServletContextFactory;
import php.java.servlet.ServletUtil;
import php.java.servlet.SimpleServletContextFactory;

public class PhpJavaServlet
extends HttpServlet {
    private static final long serialVersionUID = 3257854259629144372L;
    private ContextServer contextServer;
    protected int logLevel = -1;
    private Util.Logger logger;
    protected boolean promiscuous = false;
    private boolean isJBoss = false;
    protected int maxKeepAliveRequests;
    protected int keepAliveTimeout;
    private String keepAliveParam;
    private static final String LOCAL_ADDR = "127.0.0.1";

    public void init(ServletConfig config) throws ServletException {
        ServletContext ctx;
        String value;
        this.maxKeepAliveRequests = ServletUtil.getMBeanProperty("*:type=Connector,port=8080", "maxKeepAliveRequests");
        this.keepAliveTimeout = ServletUtil.getMBeanProperty("*:type=Connector,port=8080", "keepAliveTimeout");
        StringBuffer buf = new StringBuffer("timeout=");
        buf.append(this.keepAliveTimeout);
        buf.append(", max=");
        buf.append(this.maxKeepAliveRequests);
        this.promiscuous = true;
        this.keepAliveParam = buf.toString();
        String servletContextName = ServletUtil.getRealPath(config.getServletContext(), "");
        if (servletContextName == null) {
            servletContextName = "";
        }
        if ((value = (ctx = config.getServletContext()).getInitParameter("promiscuous")) == null) {
            value = "";
        }
        value = value.trim();
        if ((value = value.toLowerCase()).equals("off") || value.equals("false")) {
            this.promiscuous = false;
        }
        if (value.equals("on") || value.equals("true")) {
            this.promiscuous = true;
        }
        this.contextServer = ContextLoaderListener.getContextLoaderListener(ctx).getContextServer();
        super.init(config);
        String name = ctx.getServerInfo();
        if (name != null && name.startsWith("JBoss")) {
            this.isJBoss = true;
        }
        this.logger = new Util.Logger(!this.isJBoss, (ILogger)new Logger());
        Util.setDefaultLogger((ILogger)this.logger);
        if (Util.VERSION != null) {
            this.log("PHP/Java Bridge servlet " + servletContextName + " version " + Util.VERSION + " ready.");
        } else {
            this.log("PHP/Java Bridge servlet " + servletContextName + " ready.");
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected SimpleServletContextFactory getContextFactory(HttpServletRequest req, HttpServletResponse res) {
        JavaBridge bridge;
        SimpleServletContextFactory ctx = null;
        String id = req.getHeader("X_JAVABRIDGE_CONTEXT");
        if (id != null) {
            ctx = (SimpleServletContextFactory)ContextFactory.get((String)id);
        }
        if (ctx == null) {
            ctx = (SimpleServletContextFactory)RemoteServletContextFactory.addNew((Servlet)this, this.getServletContext(), null, req, res);
            bridge = ctx.getBridge();
            bridge.logDebug("HTTP request");
        } else {
            bridge = ctx.getBridge();
            bridge.logDebug("redirect");
        }
        this.updateRequestLogLevel(bridge);
        res.setHeader("X_JAVABRIDGE_CONTEXT", ctx.getId());
        return ctx;
    }

    protected void updateRequestLogLevel(JavaBridge bridge) {
        if (this.logLevel > -1) {
            bridge.logLevel = this.logLevel;
        }
    }

    protected void waitForContext(SimpleServletContextFactory ctx) {
        try {
            ctx.waitFor(Util.MAX_WAIT);
        }
        catch (InterruptedException e) {
            Util.printStackTrace((Throwable)e);
        }
    }

    protected void handleLocalConnection(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletInputStream sin = null;
        ServletOutputStream resOut = null;
        SimpleServletContextFactory ctx = this.getContextFactory(req, res);
        JavaBridge bridge = ctx.getBridge();
        ctx.setSessionFactory(req);
        sin = req.getInputStream();
        bridge.in = sin;
        ByteArrayOutputStream sout = new ByteArrayOutputStream();
        bridge.out = sout;
        Request r = bridge.request = new Request(bridge);
        if (r.init((InputStream)sin, (OutputStream)sout)) {
            AbstractChannelName channelName = this.contextServer.getChannelName((IContextFactory)ctx);
            res.setHeader("X_JAVABRIDGE_REDIRECT", channelName.getName());
            this.contextServer.start(channelName, (ILogger)this.logger);
            if (!r.handleOneRequest()) {
                throw new IOException("parse error");
            }
            res.setContentLength(sout.size());
            resOut = res.getOutputStream();
            sout.writeTo((OutputStream)resOut);
            if (bridge.logLevel > 3) {
                bridge.logDebug("redirecting to port# " + channelName);
            }
            sin.close();
            try {
                res.flushBuffer();
            }
            catch (Throwable t) {
                Util.printStackTrace((Throwable)t);
            }
            try {
                resOut.close();
            }
            catch (Throwable t) {
                Util.printStackTrace((Throwable)t);
            }
            this.waitForContext(ctx);
        } else {
            Util.warn((String)"handleLocalConnection init failed");
            ctx.destroy();
        }
    }

    public static String getHeader(String key, HttpServletRequest req) {
        String val = req.getHeader(key);
        if (val == null) {
            return null;
        }
        if (val.length() == 0) {
            val = null;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHttpConnection(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RemoteHttpServletContextFactory ctx = new RemoteHttpServletContextFactory((Servlet)this, this.getServletContext(), req, req, res);
        res.setHeader("X_JAVABRIDGE_CONTEXT", ctx.getId());
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Keep-Alive", this.keepAliveParam);
        try {
            ctx.getBridge().handleRequests((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream());
        }
        finally {
            ctx.destroy();
        }
    }

    protected void handlePut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Util.logLevel > 3) {
            Util.logDebug((String)("doPut:" + req.getRequestURL()));
        }
        boolean isLocal = LOCAL_ADDR.equals(req.getRemoteAddr());
        boolean isHttps = req.isSecure();
        if (this.contextServer != null && this.contextServer.isAvailable(null) && (isLocal || !isLocal && this.promiscuous) && !isHttps) {
            this.handleLocalConnection(req, res);
        } else {
            this.handleHttpConnection(req, res);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.handlePut(req, res);
        }
        catch (RuntimeException e) {
            Util.printStackTrace((Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            Util.printStackTrace((Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            Util.printStackTrace((Throwable)e);
            throw e;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String uri = req.getRequestURI();
        req.getRequestDispatcher(uri.substring(0, uri.length() - 10)).forward((ServletRequest)req, (ServletResponse)res);
    }
}

