/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    protected HashSet engineSpis = new HashSet();
    protected HashMap nameAssociations = new HashMap();
    protected HashMap extensionAssocitions = new HashMap();
    protected HashMap mimeTypeAssociations = new HashMap();
    protected Bindings globalscope = new SimpleBindings();

    private Iterator getServiceProviders() {
        Method m;
        Class<?> c;
        Iterator i = null;
        try {
            c = Class.forName("gnu.classpath.ServiceFactory");
            m = c.getMethod("lookupProviders", Class.class);
            try {
                m.setAccessible(true);
            }
            catch (Throwable tt) {
                // empty catch block
            }
            i = (Iterator)m.invoke(c, ScriptEngineFactory.class);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (i != null) {
            return i;
        }
        try {
            c = Class.forName("sun.misc.Service");
            m = c.getMethod("providers", Class.class);
            try {
                m.setAccessible(true);
            }
            catch (Throwable tt) {
                // empty catch block
            }
            i = (Iterator)m.invoke(c, ScriptEngineFactory.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return i;
    }

    public ScriptEngineManager() {
        Iterator iterator = this.getServiceProviders();
        while (iterator.hasNext()) {
            int i;
            ScriptEngineFactory factory = (ScriptEngineFactory)iterator.next();
            this.engineSpis.add(factory);
            String[] data = factory.getNames().toArray(new String[0]);
            for (i = 0; i < data.length; ++i) {
                this.nameAssociations.put(data[i], factory);
            }
            data = factory.getExtensions().toArray(new String[0]);
            for (i = 0; i < data.length; ++i) {
                this.extensionAssocitions.put(data[i], factory);
            }
            data = factory.getMimeTypes().toArray(new String[0]);
            for (i = 0; i < data.length; ++i) {
                this.mimeTypeAssociations.put(data[i], factory);
            }
        }
    }

    public Object get(String key) {
        return this.globalscope.get(key);
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.extensionAssocitions.get(extension);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.mimeTypeAssociations.get(mimeType);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByName(String name) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.nameAssociations.get(name);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public List getEngineFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.engineSpis.toArray()));
    }

    public Bindings getBindings() {
        return this.globalscope;
    }

    public void put(String key, Object value) {
        this.globalscope.put(key, value);
    }

    public void registerEngineExtension(String extension, Class factory) {
        this.extensionAssocitions.put(extension, factory);
    }

    public void registerEngineName(String name, Class factory) {
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String mimeType, Class factory) {
        this.mimeTypeAssociations.put(mimeType, factory);
    }

    public void setBindings(Bindings namespace) {
        this.globalscope = namespace;
    }
}

