/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import php.java.bridge.ILogger;
import php.java.bridge.SimpleLog4jLogger;
import php.java.bridge.Util;

public class ChainsawLogger
extends SimpleLog4jLogger
implements ILogger {
    public static final int DEFAULT_PORT = 4445;
    public static final String DEFAULT_PORT_NAME = String.valueOf(4445);
    public static final String DEFAULT_HOST = "127.0.0.1";
    private int configuredPort;

    public void configure(String defaultHost, int configuredPort) throws Exception {
        this.configuredPort = configuredPort;
        Socket s = new Socket(defaultHost, configuredPort);
        s.close();
        Class<?> clazz = Class.forName("org.apache.log4j.net.SocketAppender");
        Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
        Object socketAppender = constructor.newInstance(defaultHost, new Integer(configuredPort));
        clazz = Class.forName("org.apache.log4j.BasicConfigurator");
        Method method = clazz.getMethod("resetConfiguration", Util.ZERO_PARAM);
        method.invoke(clazz, Util.ZERO_ARG);
        Class<?> appender = Class.forName("org.apache.log4j.Appender");
        method = clazz.getMethod("configure", appender);
        method.invoke(clazz, socketAppender);
    }

    protected void init() throws Exception {
        this.configure(DEFAULT_HOST, Integer.parseInt(System.getProperty("chainsaw.port", DEFAULT_PORT_NAME)));
        this.logger = new SimpleLog4jLogger.LoggerProxy(this);
    }

    protected ChainsawLogger() {
    }

    public static ChainsawLogger createChainsawLogger() throws Exception {
        ChainsawLogger logger = new ChainsawLogger();
        logger.init();
        return logger;
    }

    public String toString() {
        return "Chainsaw logger, host: 127.0.0.1, port: " + this.configuredPort;
    }
}

