/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import php.java.bridge.ILogger;
import php.java.bridge.Util;

class FileLogger
implements ILogger {
    static boolean haveDateFormat = true;
    private static Object _form;
    private boolean isInit = false;

    FileLogger() {
    }

    private void init() {
        if (Util.logStream == null) {
            if (Util.DEFAULT_LOG_FILE == null || Util.DEFAULT_LOG_FILE.trim().length() == 0) {
                Util.logStream = System.err;
            } else {
                try {
                    Util.logStream = new PrintStream(new FileOutputStream(Util.DEFAULT_LOG_FILE));
                }
                catch (FileNotFoundException e1) {
                    Util.logStream = System.err;
                }
            }
        }
        this.isInit = true;
    }

    public String now() {
        if (!haveDateFormat) {
            return String.valueOf(System.currentTimeMillis());
        }
        try {
            if (_form == null) {
                _form = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
            }
            return ((SimpleDateFormat)_form).format(new Date());
        }
        catch (Throwable t) {
            haveDateFormat = false;
            return this.now();
        }
    }

    public void log(String s) {
        if (!this.isInit) {
            this.init();
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.printStackTrace(e);
            bytes = s.getBytes();
        }
        Util.logStream.write(bytes, 0, bytes.length);
        Util.logStream.println("");
        Util.logStream.flush();
    }

    public void printStackTrace(Throwable t) {
        if (!this.isInit) {
            this.init();
        }
        if (Util.logLevel > 0) {
            if (t instanceof Error) {
                Util.println(1, "An error occured: " + t);
            } else if (Util.logLevel > 1) {
                Util.println(2, "An exception occured: " + t);
            }
            t.printStackTrace(Util.logStream);
        }
    }

    public void log(int level, String msg) {
        StringBuffer b = new StringBuffer(this.now());
        b.append(" ");
        b.append(Util.EXTENSION_NAME);
        b.append(" ");
        switch (level) {
            case 1: {
                b.append("FATAL");
                break;
            }
            case 2: {
                b.append("ERROR");
                break;
            }
            case 3: {
                b.append("INFO ");
                break;
            }
            case 4: {
                b.append("DEBUG");
                break;
            }
            default: {
                b.append(level);
            }
        }
        b.append(": ");
        b.append(msg);
        this.log(b.toString());
    }

    public void warn(String msg) {
        StringBuffer b = new StringBuffer(this.now());
        b.append(" ");
        b.append(Util.EXTENSION_NAME);
        b.append(" ");
        b.append("WARNING");
        b.append(": ");
        b.append(msg);
        this.log(b.toString());
    }

    public String toString() {
        return "DefaultLogger";
    }
}

