/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.UnsupportedEncodingException;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

final class ParserString {
    protected byte[] string;
    protected int off;
    protected int length;
    private JavaBridge bridge;
    static final byte[] digits = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 127, 127, 127, 127, 127, 127, 127, 10, 11, 12, 13, 14, 15, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 10, 11, 12, 13, 14, 15};

    protected ParserString(JavaBridge bridge) {
        this.bridge = bridge;
    }

    public String getUTF8StringValue() {
        try {
            return new String(this.string, this.off, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.printStackTrace(e);
            return new String(this.string, this.off, this.length);
        }
    }

    public String getStringValue() {
        return this.bridge.getString(this.string, this.off, this.length);
    }

    public String getCachedStringValue() {
        return this.bridge.getCachedString(this.string, this.off, this.length);
    }

    public String getASCIIStringValue() {
        return this.bridge.stringCache.getString(this.string, this.off, this.length, "ASCII");
    }

    public int getClassicIntValue() {
        int sign;
        if (this.length == 0) {
            return 0;
        }
        int off = this.off;
        int length = this.length;
        int val = 0;
        if (this.string[off] == 45) {
            ++off;
            sign = -1;
        } else if (this.string[off] == 43) {
            ++off;
            --length;
            sign = 1;
        } else {
            sign = 1;
        }
        int pos = 1;
        while (true) {
            int n = --length;
            --length;
            if (n <= 0) break;
            val += (this.string[off + length] - 48) * pos;
            pos *= 10;
        }
        return val * sign;
    }

    public long getClassicLongValue() {
        long sign;
        if (this.length == 0) {
            return 0L;
        }
        int off = this.off;
        int length = this.length;
        long val = 0L;
        if (this.string[off] == 45) {
            ++off;
            sign = -1L;
        } else if (this.string[off] == 43) {
            ++off;
            --length;
            sign = 1L;
        } else {
            sign = 1L;
        }
        long pos = 1L;
        while (true) {
            int n = --length;
            --length;
            if (n <= 0) break;
            val += (long)(this.string[off + length] - 48) * pos;
            pos *= 10L;
        }
        return val * sign;
    }

    public int getIntValue() {
        if (this.length == 0) {
            return 0;
        }
        int val = 0;
        int pos = 0;
        byte[] string = this.string;
        int off = this.off;
        while (true) {
            val += digits[string[off++]];
            if (++pos == this.length) break;
            val <<= 4;
        }
        return val;
    }

    public long getLongValue() {
        if (this.length == 0) {
            return 0L;
        }
        long val = 0L;
        int pos = 0;
        byte[] string = this.string;
        int off = this.off;
        while (true) {
            val += (long)digits[string[off++]];
            if (++pos == this.length) break;
            val <<= 4;
        }
        return val;
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.getASCIIStringValue());
    }

    public String toString() {
        return "{" + this.getUTF8StringValue() + " @:" + String.valueOf(this.off) + " l:" + String.valueOf(this.length) + "}";
    }
}

