/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

public class PhpDebuggerPHP {
    private static final String data = "<?php /*-*- mode: php; tab-width:4 -*-*/\n\n  /**\n   *  PHPDebugger.php -- The PHP debugger (JavaScript GUI)\n   * \n   * Copyright (C) 2009 Jost Boekemeier\n   * \n   * The PHPDebugger (\"the library\") is free software; you can\n   * redistribute it and/or modify it under the terms of the GNU General\n   * Public License as published by the Free Software Foundation; either\n   * version 2, or (at your option) any later version.\n   * \n   * The library is distributed in the hope that it will be useful, but\n   * WITHOUT ANY WARRANTY; without even the implied warranty of\n   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n   * General Public License for more details.\n   * \n   * You should have received a copy of the GNU General Public License\n   * along with the PHPDebugger; see the file COPYING. If not, write to the\n   * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n   * 02111-1307 USA.\n   * \n   * Linking this file statically or dynamically with other modules is\n   * making a combined work based on this library. Thus, the terms and\n   * conditions of the GNU General Public License cover the whole\n   * combination.\n   * \n   * As a special exception, the copyright holders of this library give you\n   * permission to link this library with independent modules to produce an\n   * executable, regardless of the license terms of these independent\n   * modules, and to copy and distribute the resulting executable under\n   * terms of your choice, provided that you also meet, for each linked\n   * independent module, the terms and conditions of the license of that\n   * module. An independent module is a module which is not derived from\n   * or based on this library. If you modify this library, you may extend\n   * this exception to your version of the library, but you are not\n   * obligated to do so. If you do not wish to do so, delete this\n   * exception statement from your version. \n   *\n   * Usage:\n   * \n   * - include() this file at the beginning of your script\n   *\n   * - browse to your script using firefox \n   *\n   * - set breakpoints using the JavaScript GUI, click on any variable or included file to visit that variable or file\n   * \n   * - click on the stop button to terminate the debug session\n   *\n   * @category   java\n   * @package    pdb\n   * @author     Jost Boekemeier\n   * @license    GPL\n   * @version    1.0\n   * @link       http://php-java-bridge.sf.net/phpdebugger\n   * @see        PHPDebugger.inc\n   */\n\n/** @access private */\ndefine (\"PDB_DEBUG\", 0);\nset_time_limit (0);\n\n$pdb_version = phpversion();\nif ((version_compare(\"5.3.0\", $pdb_version, \">\")))\n  trigger_error(\"<br><strong>PHP ${pdb_version} too old.</strong><br>\\nPlease set the path to a PHP >= 5.3 executable, see php_exec in the WEB-INF/web.xml\", E_USER_ERROR);\n\n \n/**\n * a simple logger\n * @access private\n */\nclass pdb_Logger {\n  const FATAL = 1;\n  const INFO = 2;\n  const VERBOSE = 3;\n  const DEBUG = 4;\n\n  private static $logLevel = 0;\n  private static $logFileName;\n  private static function println($msg, $level) {\n\tif (!self::$logLevel) self::$logLevel=PDB_DEBUG?self::DEBUG:self::INFO;\n\tif ($level <= self::$logLevel) {\n\t  static $file = null;\n\t  if(!isset(self::$logFileName)) {\n\t\tself::$logFileName = $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.\"pdb_PHPDebugger.log\";\n\t  }\n\t  if (!$file) $file = fopen(self::$logFileName, \"ab\") or die(\"fopen\");\n\t  fwrite($file, time().\": \");\n\t  fwrite($file, $msg.\"\\n\");\n\t  fflush($file);\n\t}\n  }\n\n  public static function logFatal($msg) {\n\tself::println($msg, self::FATAL);\n  }\n  public static function logInfo($msg) {\n\tself::println($msg, self::INFO);\n  }\n  public static function logMessage($msg) {\n\tself::println($msg, self::VERBOSE);\n  }\n  public static function logDebug($msg) {\n\tself::println($msg, self::DEBUG);\n  }\n  public static function debug($msg) {\n\tself::logDebug($msg);\n  }\n  public static function log($msg) {\n\tself::logMessage($msg);\n  }\n  public static function setLogLevel($level) {\n\tself::$logLevel=$level;\n  }\n  public static function setLogFileName($name) {\n\tself::$logFileName = $name;\n  }\n}\n\n/**\n * @access private\n */\ninterface pdb_Queue {\n\n  /** \n   * Read a string from the queue\n   * @return string a json encoded string of values\n   * @access private\n   */\n  public function read();\n\n  /**\n   * Write a string to the queue\n   * @param string a json encoded string of values or TRUE\n   * @access private\n   */\n  public function write($val);\n\n  /**\n   * Set the script output before server shutdown\n   * @access private\n   */\n  public function setOutput($output);\n\n  /**\n   * Get the script output\n   * @access private\n   */\n  public function getOutput();\n\n  /**\n   * Mark the channel as dead. If marked, read will return boolean\n   * TRUE, write will do nothing.\n   * @access private\n   */\n  public function shutdown();\n}\n\n/**\n * This class represents the debugger back end connection. It\n * communicates with the debugger front end using a shared-memory queue.\n * It is slow, but it does not require any special library.\n * @access private\n */\nclass pdb_PollingServerConnection implements pdb_Queue {\n  protected $id;\n  protected $role, $to;\n  protected $chanTrm; // \"back end terminated\" flag\n  protected $output;\n  const TIMER_DURATION = 200000; // every 200ms\n\n  /**\n   * Create a new communication using a unique id\n   * @access private\n   */\n  public function pdb_PollingServerConnection($id) {\n\t$this->id = $id;\n\t$this->chanTrm = \"pdb_trmserver{$this->id}\";\n\t$this->output = \"<missing>\";\n\n\t$this->prepareCookies();\n\t$this->init();\n  }\n\n  protected function checkTrm() {\n\treturn false!==$_SESSION[$this->chanTrm];\n  }\n\n  protected function prepareCookies() {\n\tini_set(\"session.use_cookies\", true);\n\tsession_start();\n\tsession_write_close();\n\n\t/* avoid PHP bug, which repeats set-cookie header for each\n\t   iteration of session_start/session_write_close */\n\tini_set(\"session.use_cookies\", false);\n  }\n\n  protected function init() {\n\tsession_start();\n\n\t$this->role = \"client\";\n\t$this->to  = \"server\";\n\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tunset ($_SESSION[$chan]);\n\tunset ($_SESSION[$chanCtr]);\n\n\t$this->role = \"server\";\n\t$this->to  = \"client\";\n\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tunset ($_SESSION[$chan]);\n\tunset ($_SESSION[$chanCtr]);\n\n\tif (isset($_SESSION[$this->chanTrm]) && !$this->checkTrm()) {\n\t  $_SESSION[$this->chanTrm] = true;\n\t  session_write_close();\n\t  sleep(1);\n\t  session_start();\n\t}\n\t$_SESSION[$this->chanTrm] = false;\n\tsession_write_close();\n  }\n\n  protected function poll() {\n\t$val = \"\";\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tsession_start();\n\tif (!($val = $this->checkTrm())) {\n\t  if(!isset($_SESSION[$chanCtr])) { \n\t\t$_SESSION[$chan] = array(); \n\t\t$_SESSION[$chanCtr]=0; \n\t  }\n\t  $seq = $_SESSION[$chanCtr];\n\t  $seqNext = count($_SESSION[$chan]);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} poll next # ${seqNext} (${seq}) ...\");\n\t  if ($seqNext > $seq) {\n\t\t$val = json_decode($_SESSION[$chan][$seq]);\n\t\t$_SESSION[$chan][$seq]=null;\n\t\t$_SESSION[$chanCtr]++;\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} polled next # ${seqNext} (${seq}), got: {$val->seq}\");\n\t  }\n\t}\n\tsession_write_close();\n\treturn $val;\n  }\n  protected function send($val) {\n\t\n\t$seq = $val->seq;\n\t$chan = \"pdb_{$this->to}{$this->id}\";\n\tsession_start();\n\tif (!$this->checkTrm()) $_SESSION[$chan][$seq]=json_encode($val);\n\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} send: ${seq} ...\");\n\tsession_write_close();\n  }\n\n  /**\n   * read a new value from the read queue\n   * @access private\n   */\n  public function read() {\n\t$val = null;\n\t$cntr = 0;\n\twhile(!($val=$this->poll())) {\n\t  if ($cntr<=20) {\n\t\t$cntr++;\n\t\tusleep(self::TIMER_DURATION);\n\t  } else {\n\t\tusleep(self::TIMER_DURATION*5);\n\t  }\n\t}\n\treturn $val === true ? null : $val;\n  }\n\n  /**\n   * write a new value to the write queue\n   * @access private\n   */\n  public function write($val) {\n\t$this->send((object)$val);\n  }\n\n  /**\n   * Set the script output\n   * @access private\n   */\n  public function setOutput($output) {\n\t$this->output = $output;\n  }\n  /**\n   * Get the script output\n   * @access private\n   */\n  public function getOutput() {\n\treturn $_SESSION[$this->chanTrm];\n  }\n\n  /**\n   * shut down the communication channel\n   */\n  public function shutdown() {\n\tif (PDB_DEBUG) pdb_Logger::debug(\"session terminated: {$this->chanTrm}\");\n\tsession_start();\n\t$_SESSION[$this->chanTrm] = $this->output;\n\tsession_write_close();\n  }\n}  \n\n/**\n * This class represents the debugger front end connection. It\n * communicates with the debugger back end using a shared-memory queue.\n * It is slow, but it does not require any special library.\n * @access private\n */\nclass pdb_PollingClientConnection extends pdb_PollingServerConnection {\n  private $seq;\n\n  protected function init() {\n\t$this->role = \"client\";\n\t$this->to  = \"server\";\n  }\n\n  protected function poll() {\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tsession_start();\n\tif (!($val = $this->checkTrm())) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} poll for {$this->seq} ...\");\n\t  if (isset($_SESSION[$chan][$this->seq])) {\n\t\t$val = json_decode($_SESSION[$chan][$this->seq]);\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} polled for {$this->seq}, got: {$val->seq}\");\n\t\tunset($_SESSION[$chan][$this->seq]);\n\t  }\n\t}\n\tsession_write_close();\n\treturn $val;\n  }\n\n  /**\n   * write a new value to the write queue\n   * @access private\n   */\n  public function write($val) {\n\t$this->seq = $val->seq;\n\n\tparent::write($val);\n  }\n\n  /**\n   * shut down the communication channel\n   * @access private\n   */\n  public function shutdown() {}\n}\n\nif (!class_exists(\"pdb_Parser\")) {\n  /**\n   * The PHP parser\n   * @access private\n   */\n  class pdb_Parser {\n\tconst BLOCK = 1;\n\tconst STATEMENT = 2;\n\tconst EXPRESSION = 3;\n\tconst FUNCTION_BLOCK = 4; // BLOCK w/ STEP() as last statement\n\n\tprivate $scriptName, $content;\n\tprivate $code;\n\tprivate $output;\n\tprivate $line, $currentLine;\n\tprivate $beginStatement, $inPhp, $inDQuote;\n \n\t/**\n\t * Create a new PHP parser\n\t * @param string the script name\n\t * @param string the script content\n\t * @access private\n\t */\n\tpublic function pdb_Parser($scriptName, $content) {\n\t  $this->scriptName = $scriptName;\n\t  $this->content = $content;\n\t  $this->code = token_get_all($content);\n\t  $this->output = \"\";\n\t  $this->line = $this->currentLine = 0;\n\t  $this->beginStatement = $this->inPhp = $this->inDQuote = false;\n\t}\n\n\tprivate function toggleDQuote($chr) {\n\t  if ($chr == '\"') $this->inDQuote = !$this->inDQuote;\n\t}\n\n\tprivate function each() {\n\t  $next = each ($this->code);\n\t  if ($next) {\n\t\t$cur = current($this->code);\n\t\tif (is_array($cur)) {\n\t\t  $this->currentLine = $cur[2] + ($cur[1][0] == \"\\n\" ? substr_count($cur[1], \"\\n\") : 0);\n\t\t  if ($this->isWhitespace($cur)) {\n\t\t\t$this->write($cur[1]);\n\t\t\treturn $this->each();\n\t\t  }\n\t\t}\n\t\telse \n\t\t  $this->toggleDQuote($cur);\n\t  }\n\t  return $next;\n\t}\n\n\tprivate function write($code) {\n\t  //echo \"write:::\".$code.\"\\n\";\n\t  $this->output.=$code;\n\t}\n\n\tprivate function writeInclude($once) {\n\t  $name = \"\";\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $name.=$val[1];\n\t\t} else {\n\t\t  if ($val==';') break;\n\t\t  $name.=$val;\n\t\t}\n\t  }\n\t  if (PDB_DEBUG == 2) \n\t\t$this->write(\"EVAL($name);\");\n\t  else\n\t\t$this->write(\"eval('?>'.pdb_startInclude($name, $once)); pdb_endInclude();\");\n\t}\n\n\tprivate function writeCall() {\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $this->write($val[1]);\n\t\t} else {\n\t\t  $this->write($val);\n\t\t  if ($val=='{') break;\n\t\t}\n\t  }\n\t  $scriptName = addslashes($this->scriptName);\n\t  $this->write(\"\\$__pdb_CurrentFrame=pdb_startCall(\\\"$scriptName\\\", {$this->currentLine});\");\n\t}\n\n\tprivate function writeStep($pLevel) {\n\t  $token = current($this->code);\n\t  if ($this->inPhp && !$pLevel && !$this->inDQuote && $this->beginStatement && !$this->isWhitespace($token) && ($this->line != $this->currentLine)) {\n\t\t$line = $this->line = $this->currentLine;\n\t\t$scriptName = addslashes($this->scriptName);\n\t\tif (PDB_DEBUG == 2)\n\t\t  $this->write(\";STEP($line);\");\n\t\telse\n\t\t  $this->write(\";pdb_step(\\\"$scriptName\\\", $line, pdb_getDefinedVars(get_defined_vars(), (isset(\\$this) ? \\$this : NULL)));\");\n\t  }\n\t}\n\n\tprivate function writeNext() {\n\t  $this->next();\n\t  $token = current($this->code);\n\t  if (is_array($token)) $token = $token[1];\n\t  $this->write($token);\n\t}\n\n\tprivate function nextIs($chr) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn false;\t/* not found */\n\t\t  }\n\t\t} else {\n\t\t  while($i--) prev($this->code);\n\t\t  return $cur == $chr;\t/* found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function nextTokenIs($ar) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn (in_array($cur[0], $ar));\n\t\t  }\n\t\t} else {\n\t\t  break; /* not found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function isWhitespace($token) {\n\t  $isWhitespace = false;\n\t  switch($token[0]) {\n\t  case T_COMMENT:\n\t  case T_DOC_COMMENT:\n\t  case T_WHITESPACE:\n\t\t$isWhitespace = true;\n\t\tbreak;\n\t  }\n\t  return $isWhitespace;\n\t}\n\tprivate function next() {\n\t  if (!$this->each()) trigger_error(\"parse error\", E_USER_ERROR);\n\t}\n\n\tprivate function parseBlock () {\n\t  $this->parse(self::BLOCK);\n\t}\n\tprivate function parseFunction () {\n\t  $this->parse(self::FUNCTION_BLOCK);\n\t}\n\tprivate function parseStatement () {\n\t  $this->parse(self::STATEMENT);\n\t}\n\tprivate function parseExpression () {\n\t  $this->parse(self::EXPRESSION);\n\t}\n\n\tprivate function parse ($type) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"parse:::$type\");\n\n\t  $this->beginStatement = true;\n\t  $pLevel = 0;\n\n\t  do {\n\t\t$token = current($this->code);\n\t\tif (!is_array($token)) {\n\t\t  if (PDB_DEBUG) pdb_Logger::debug(\":::\".$token);\n\t\t  if (!$pLevel && $type==self::FUNCTION_BLOCK && $token=='}') $this->writeStep($pLevel);\n\t\t  $this->write($token);\n\t\t  if ($this->inPhp && !$this->inDQuote) {\n\t\t\t$this->beginStatement = false; \n\t\t\tswitch($token) {\n\t\t\tcase '(': \n\t\t\t  $pLevel++;\n\t\t\t  break;\n\t\t\tcase ')':\n\t\t\t  if (!--$pLevel && $type==self::EXPRESSION) return;\n\t\t\t  break;\n\t\t\tcase '{': \n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  break;\n\t\t\tcase '}': \n\t\t\t  if (!$pLevel) return;\n\t\t\t  break;\n\t\t\tcase ';':\n\t\t\t  if (!$pLevel) {\n\t\t\t\tif ($type==self::STATEMENT) return;\n\t\t\t\t$this->beginStatement = true; \n\t\t\t  }\n\t\t\t  break;\n\t\t\t}\n\t\t  }\n\t\t} else {\n\t\t  if (PDB_DEBUG) pdb_Logger::debug(\":::\".$token[1].\":(\".token_name($token[0]).')');\n\n\t\t  if ($this->inDQuote) {\n\t\t\t$this->write($token[1]);\n\t\t\tcontinue;\n\t\t  }\n\n\t\t  switch($token[0]) {\n\n\t\t  case T_OPEN_TAG: \n\t\t  case T_START_HEREDOC:\n\t\t  case T_OPEN_TAG_WITH_ECHO: \n\t\t\t$this->beginStatement = $this->inPhp = true;\n\t\t\t$this->write($token[1]);\n\t\t\tbreak;\n\n\t\t  case T_END_HEREDOC:\n\t\t  case T_CLOSE_TAG: \n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = $this->inPhp = false; \n\t\t\tbreak;\n\n\t\t  case T_FUNCTION:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeCall();\n\t\t\t$this->next();\n\t\t\t$this->parseFunction();\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_ELSE:\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\n\t\t\t}\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_DO:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t  $this->next();\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->next();\n\t\t\t  $this->write('}');\n\t\t\t}\n\t\t\t$token = current($this->code);\n\t\t\t$this->write($token[1]);\n\n\t\t\tif ($token[0]!=T_WHILE) trigger_error(\"parse error\", E_USER_ERROR);\n\t\t\t$this->next();\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CATCH:\n\t\t  case T_IF:\n\t\t  case T_ELSEIF:\n\t\t  case T_FOR:\n\t\t  case T_FOREACH:\n\t\t  case T_WHILE:\n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->next();\n\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\t\t\t}\n\n\t\t\tif ($this->nextTokenIs(array(T_ELSE, T_ELSEIF, T_CATCH))) {\n\t\t\t  $this->beginStatement = false;\n\t\t\t} else {\n\t\t\t  if ($type==self::STATEMENT) return;\n\t\t\t  $this->beginStatement = true;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_REQUIRE_ONCE:\n\t\t  case T_INCLUDE_ONCE: \n\t\t  case T_INCLUDE: \n\t\t  case T_REQUIRE: \n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->writeInclude((($token[0]==T_REQUIRE_ONCE) || ($token[0]==T_INCLUDE_ONCE)) ? 1 : 0);\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CLASS:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeNext();\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  $this->beginStatement = true;\n\t\t\t} else {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->beginStatement = false;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_CASE:\n\t\t  case T_DEFAULT:\n\t\t  case T_PUBLIC:\n\t\t  case T_PRIVATE:\n\t\t  case T_PROTECTED:\n\t\t  case T_STATIC:\n\t\t  case T_CONST:\n\t\t  case T_GLOBAL:\n\t\t  case T_ABSTRACT:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\n\t\t  default:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\t\n\t\t  }\n\t\t}\n\t  } while($this->each());\n\t}\n\n\t/**\n\t * parse the given PHP script\n\t * @return the parsed PHP script\n\t * @access private\n\t */\n\tpublic function parseScript() {\n\t  do {\n\t\t$this->parseBlock();\n\t  } while($this->each());\n\n\t  return $this->output;\n\t}\n  }\n}\n\n\n/**\n * This structure represents the debugger front-end. It is used by the\n * JavaScript code to communicate with the debugger back end.\n * @access private\n */\nclass pdb_JSDebuggerClient {\n  private static function getDebuggerFilename() {\n\t$script = __FILE__;\n\t$scriptName = basename($script);\n\treturn realpath($scriptName == \"PHPDebugger.php\" ? $script :\"java/PHPDebugger.php\");\n  }\n\t\n  private static function getCurrentRootDir() {\n\t$scriptName = $_SERVER['SCRIPT_NAME'];\n\t$scriptFilename = $_SERVER['SCRIPT_FILENAME'];\n \n\t$scriptDirName = dirname($scriptName);\n\t$scriptDir   = dirname($scriptFilename);\n \n\tif ((strlen($scriptDirName)>1) && ($scriptDirName[1]=='~')) {\n\t  $scriptDirName = ltrim($scriptDirName, \"/\");\n\t  $idx = strpos($scriptDirName, '/');\n\t  $scriptDirName = $idx===false ? '' : substr($scriptDirName, $idx);\n\t} elseif ((strlen($scriptDirName)==1) && (($scriptDirName[0]=='/') || ($scriptDirName[0]=='\\\\'))) {\n\t  $scriptDirName = '';\n\t}\n\tif (PDB_DEBUG) pdb_Logger::debug(\"scriptDir: $scriptDir, scriptDirName: $scriptDirName\");\n\n\tif ((strlen($scriptDir) < strlen($scriptDirName)) || ($scriptDirName &&\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  (substr($scriptDir, -strlen($scriptDirName)) != $scriptDirName)))\n\t  return null;\n\telse\n\t  return substr($scriptDir, 0, strlen($scriptDir)-strlen($scriptDirName));\n  }\n  /*\n   * Return the script name\n   * Example: %2Fopt%2Fappserv%2Fapache-tomcat-6.0.14%2Fwebapps%2FJavaBridge%2Ftest.php\"\n   *\n   * @return An urlencoded file name.\n   */\n  public static function getDebugScriptName() {\n\treturn urlencode($_SERVER['SCRIPT_FILENAME']);\n  }\n  /**\n   * Return the debugger URL. \n   * Example: \"/JavaBridge/java/PHPDebugger.php?source=settings.php\"\n   *\n   * @return The debugger URL.\n   * @access private\n   */\n  public static function getDebuggerURL() {\n\t$path = self::getDebuggerFilename();\n\tif (!$path) \n\t  trigger_error(\"java/PHPDebugger.php not found in document root\", E_USER_ERROR);\n\n\t$root = self::getCurrentRootDir();\n\n\t$scriptName = $_SERVER['SCRIPT_NAME'];\n\n\t$scriptDirName = dirname($scriptName);\n\t$prefix = '';\n\tif ((strlen($scriptDirName)>1) && ($scriptDirName[1]=='~')) {\n\t  $scriptDirName = ltrim($scriptDirName, \"/\");\n\t  $idx = strpos($scriptDirName, '/');\n\t  $prefix = '/' . ($idx ? substr($scriptDirName, 0, $idx): $scriptDirName);\n\t}\n  \n\tif (PDB_DEBUG) pdb_Logger::debug(\"serverRoot: $root - path: $path\");\n\tif ($root && (strlen($root) < strlen($path)) && (!strncmp($path, $root, strlen($root))))\n\t  $path = \"${prefix}\" . str_replace('\\\\', '/', substr($path, strlen($root)));\n\telse // could not calculate debugger path\n\t  $path = dirname($_SERVER['SCRIPT_NAME']) . \"/java/PHPDebugger.php\";\n\n\t$pathInfo = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : \"\";\n\t$query = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : \"\";\n\n\t$url = \"${path}${pathInfo}\";\n\tif ($query) $url .= \"?${query}\";\n\treturn $url;\n  }\n\n  public static function getPostData() {\n\t$str = '';\n\tforeach ($_POST as $key => $value) {\n\t  if ($str) $str .= '&';\n\t  $str .= $key . '=' . urlencode($value);\n\t}\n\treturn $str;\n  }\n\n  /**\n   * Get the server's uniqe session ID\n   * @return a uniqe session ID\n   * @access private\n   */ \n  public static function getServerID() {\n\t// TODO: allow more than one debug session\n\treturn 1;\n  }\n \n  private static function getConnection($id) {\n\treturn new pdb_PollingClientConnection($id);\n  }\n  private static function stripslashes($value) {\n\t $value = is_array($value) ?\n\t   array_map(\"self::stripslashes\", $value) :\n\t   stripslashes($value);\n\t \n\t return $value;\n   }\n\n  /**\n   * Pass the command and arguments to the debug back end and\n   * output the response to JavaScript.\n   *\n   * @arg array The command arguments\n   * @access private\n   */\n  public static function handleRequest($vars) {\n\t\tif (get_magic_quotes_gpc()) $vars = self::stripslashes($vars);\n\t$msg = (object)$vars;\n\t\n\tif ($msg->cmd == \"begin\") sleep(1); // wait for the server to settle\n\tif (PDB_DEBUG) pdb_Logger::debug(\"beginHandleRequest: \".$msg->cmd);\n\t$conn = self::getConnection($msg->serverID);\n\t$conn->write($msg);\n\n\tif (!($response = $conn->read())) \n\t  $output = json_encode(array(\"cmd\"=>\"term\", \"output\"=>$conn->getOutput()));\n\telse\n\t  $output = json_encode($response);\n\t\n\techo \"($output)\";\n\tif (PDB_DEBUG) pdb_Logger::debug(\"endHandleRequest\");\n  }\n}\n\n/**\n * The current view frame. Contains the current script name. May be\n * selected by clicking on a include() hyperlink Allows users to set\n * breakpoints for this file.\n *\n * View will be discarded when go, step, end is invoked.\n * @access private\n */\nclass pdb_View {\n  /** The current script name */\n  public $scriptName;\n  /** Back-link to the parent or null */\n  public $parent;\n\n  protected $bpCounter, $lineCounter, $code;\n  /**\n   * Create a new view frame\n   * @param object the parent frame\n   * @param string the script name\n   */\n  public function pdb_View($parent, $scriptName) {\n\t$this->parent = $parent;\n\t$this->scriptName = $scriptName;\n\n\t$this->bpCounter = $this->lineCounter = 1;\n\t$this->code = null;\n  }\n\n  private function lineCB ($val) {\n\treturn $val.(string)$this->lineCounter++;\n  }\n  private function breakpointCB ($val) {\n\treturn \t$val.'id=\"bp_'.(string)$this->bpCounter++.'\"';\n  }\n  function replaceCallback($code, $split, $cb) {\n\t$ar = explode($split, $code);\n\t$last = array_pop($ar);\n\t$ar = array_map($cb, $ar);\n\tarray_push($ar, $last);\n\treturn implode($ar);\n  }\n\n\n  /**\n   * Return a HTML representation of the current script\n   * @return string the clickable HTML representation of the current script\n   */\n  public function getHtmlScriptSource() {\n\tif (!$this->code) {\n\t  $c=\n\t\t'<span class=\"breakpoint\" id=\"bp_\" onmousedown=\"return toggleBreakpoint(this, event);\">'.\n\t\t'<span class=\"currentlineIndicator normal\"></span>'.\n\t\t'<span class=\"linenumber\">line#</span>'.\n\t\t'<span class=\"breakpointIndicator normal\"></span>'.\n\t\t'</span><br />';\n\n\t  $code=show_source($this->scriptName, true);\n\n\t  // br => span id=pb_ ...\n\t  $code = str_replace('<br />', $c, $code);\n\t  // handle incomplete last line, identical to preg: '|(?<!<br >)</span>\\n</span>\\n</code>$|'\n\t  $code = ereg_replace('\"(([^>])|([^/]>)|([^ ]/>)|([^r] />)|([^b]r />)|([^<]br />))(</span>\\n</span>\\n</code>)\"', '\\1 $c \\8', $code);\n\n\t  $code = $this->replaceCallback($code, 'id=\"bp_\"', array($this, \"breakpointCB\"));\n\t  $code = $this->replaceCallback($code, 'line#', array($this, \"lineCB\"));\n\n\t  $this->code = $code;\n\t}\n\n\treturn $this->code;\n  }\n}\n/**\n * The current view. Used to show the contents of a variable\n * @access private\n */\nclass pdb_VariableView extends pdb_View {\n  /**\n   * Create a new variable view\n   * @param object the parent frame\n   * @param string the variable name\n   * @param string the variable value\n   */\n  public function pdb_VariableView($parent, $name, $value) {\n\tparent::pdb_View($parent, $name);\n\t$this->value = $value;\n  }\n  /**\n   * {@inheritDoc}\n   */\n  public function getHtmlScriptSource() {\n\treturn (highlight_string(print_r($this->value, true), true));\n  }\n}\n/**\n * The current execution frame. Contains the current run-time script\n * name along with its state\n * @access private\n */\nclass pdb_Environment extends pdb_View {\n  /** bool true if a dynamic breakpoint should be inserted at the next line, false otherwise */\n  public $stepNext;\n  /** The execution vars */\n  public $vars;\n  /** The current line */\n  public $line;\n\n  /**\n   * Create a new execution frame\n   * @param string the script name\n   * @param bool true if a dynamic breakpoint should be inserted at the next line, false otherwise\n   */\n  public function pdb_Environment($parent, $scriptName, $stepNext) {\n\tparent::pdb_View($parent, $scriptName);\n\t$this->stepNext = $stepNext;\n\t$this->line = -1;\n  }\n  /**\n   * Update the execution frame with the current state\n   * @param string the current script name\n   * @param int the current execution line\n   * @param mixed the current variables\n   */\n  public function update ($line, &$vars) {\n\t$this->line = $line;\n\t$this->vars = $vars;\n  }\n\n  public function __toString() {\n\treturn \"pdb_Environment: {$this->scriptName}, {$this->line}\";\n  }\n}\n/**\n * Represents a breakpoint\n * @access private\n */\nclass pdb_Breakpoint {\n  /** The script name */\n  public $scriptName;\n  /** The current line */\n  public $line;\n  /** The breakpointName as seen by JavaScript */\n  public $breakpoint;\n  /* The breakpoint type (not used yet) */\n  public $type;\n\n  /**\n   * Create a new breakpoint\n   * @param string the breakpoint name\n   * @param string the script name\n   * @param int the line\n   */\n  public function pdb_Breakpoint($breakpointName, $scriptName, $line) {\n\t$this->breakpoint = $breakpointName;\n\t$this->scriptName = $scriptName;\n\t$this->line = $line;\n\n\t$this->type = 1;\n  }\n  /**\n   * @return the string representation of the breakpoint\n   */\n  public function __toString() {\n\treturn \"{$this->line}@{$this->scriptName}, js name: ({$this->breakpoint}, type: {$this->type})\";\n  }\n}\n/**\n * The current debug session. Contains the current environment stack,\n * script output and all breakpoints set by the client. An optional\n * view is set by the switchView command.\n * @access private\n */\nfinal class pdb_Session {\n  /** The collection of breakpoints */\n  public $breakpoints;\n\n  /** List of all frames */\n  public $allFrames;\n  /** The current top level frame */\n  public $currentTopLevelFrame;\n  /** The current execution frame */\n  public $currentFrame;\n  /** The current view */\n  public $currentView;\n  /** The script output */\n  public $output;\n\n  /**\n   * Create a new debug session for a given script\n   * @param string the script name\n   */\n  public function pdb_Session($scriptName) {\n\t$this->breakpoints = $this->lines = array();\n\t$this->currentTopLevelFrame = $this->currentFrame = new pdb_Environment(null, $scriptName, true);\n\t$this->allFrames[] = $this->currentFrame;\n\n\t$this->currentView = null;\n  }\n  /**\n   * Return the clickable HTML script source, either from the cusom view or from the current frame\n   * @return string the HTML script source\n   */\n  public function getCurrentViewHtmlScriptSource () {\n\treturn $this->currentView ? $this->currentView->getHtmlScriptSource() : $this->currentFrame->getHtmlScriptSource();\n  }   \n  /**\n   * Return the current frame script name\n   * @return string the script name of the current frame\n   */\n  public function getScriptName () {\n\treturn $this->currentFrame->scriptName;\n  }\n  /**\n   * Return the current script name, either from the view or from the current frame\n   * @return string the current script name\n   */\n  public function getCurrentViewScriptName () {\n\treturn $this->currentView ? $this->currentView->scriptName : $this->getScriptName();\n  }   \n  /**\n   * Return the breakpoints for the current script\n   * @return object the breakpoints\n   */\n  public function getBreakpoints () {\n\t$bp = array();\n\tforeach ($this->breakpoints as $breakpoint) {\n\t  if ($this->getCurrentViewScriptName() != $breakpoint->scriptName) continue;\n\t  array_push($bp, $breakpoint->breakpoint);\n\t}\n\treturn $bp;\n  }\n  /**\n   * toggle and write breakpoint reply\n   * @param object the current comm. channel\n   * @param object the breakpoint\n   */\n  public function toggleBreakpoint($breakpoint) {\n\t$id = $breakpoint.\"@\".$this->getCurrentViewScriptName();\n\tif (!isset($this->breakpoints[$id])) {\n\t  $this->breakpoints[$id] = new pdb_Breakpoint($breakpoint, $this->getCurrentViewScriptName(), substr($breakpoint, 3));\n\t  return false;\n\t} else {\n\t  $bp = $this->breakpoints[$id];\n\t  unset ($this->breakpoints[$id]);\n\t  return $bp;\n\t}\n  }\n  /**\n   * check if there's a breakpoint\n   * @param string the script name\n   * @param int the line within the script \n   * @return true if a breakpoint exists at line, false otherwise\n   */\n  public function hasBreakpoint($scriptName, $line) {\n\tif ($this->currentFrame->stepNext) return true;\n  \n\tforeach ($this->breakpoints as $breakpoint) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"process breakpoint::: $scriptName, $line:: $breakpoint\");\n\t  if($breakpoint->type==1) {\n\t\tif ($breakpoint->scriptName==$scriptName&&$breakpoint->line==$line) return true;\n\t  }\n\t}\n\treturn false;\n  }\n  /**\n   * parse code\n   * @param string the script name\n   * @param string the content\n   * @return the parsed script\n   */\n  public function parseCode($scriptName, $content) {\n\t$parser = new pdb_Parser($scriptName, $content);\n\treturn $parser->parseScript();\n  }\n  private static function doEval($__pdb_Code) {\n\treturn eval (\"?>\".$__pdb_Code);\n  }\n  /**\n   * parse and execute script\n   * @return the script output\n   */\n  public function evalScript() {\n\t$code = $this->parseCode($this->getScriptName(), file_get_contents($this->getScriptName()));\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"eval:::$code,\".$this->getScriptName().\"\\n\");\n\tob_start();\n\tself::doEval ($code);\n\t$this->output = ob_get_contents();\n\tob_end_clean();\n\n\treturn $this->output;\n  }\n}\n\n/**\n * The java script debugger server daemon. Contains a debug session\n * and handles debug requests from the client.\n * @access private\n */\nclass pdb_JSDebugger {\n  /** The pdb_Session */\n  public $session;\n  private $id;\n \n  public $end;\n  private $includedScripts;\n  private $conn;\n  private $ignoreInterrupt;\n\n  const STEP_INTO = 1;\n  const STEP_OVER = 2;\n  const STEP_OUT = 3;\n  const GO    = 4;\n\n\n  private function getConnection($id) {\n\treturn new pdb_PollingServerConnection($id);\n  }\n\n  /**\n   * Create new PHP debugger using a given comm. ID\n   * @param int the communication address\n   */\n  public function pdb_JSDebugger($id) {\n\n\t$this->id = $id;\n\t$this->conn = $this->getConnection($id);\n\n\t$this->end = false;\n\t$this->session = null;\n\n\t$this->includedScripts = array();\n\n\t$this->ignoreInterrupt = false;\n\tset_error_handler(\"pdb_error_handler\");\n\tregister_shutdown_function(\"pdb_shutdown\");\n  }\n  public function setError($errno, $errfile, $errline, $errstr) {\n\thighlight_string(\"PHP error $errno: $errstr in $errfile line $errline\");\n  }\n  /**\n   * Return the current comm. ID\n   * @return int the communication address\n   */\n  public function getServerID() {\n\treturn $this->id;\n  }\n  /**\n   * Read data from the front end\n   * @return object the data \n   */\n  public function read() {\n\treturn $this->conn->read();\n  }\n  /**\n   * Write data to the front end\n   * @param object the data\n   */\n  public function write($data) {\n\t$data[\"serverID\"] = $this->getServerID();\n\tif (PDB_DEBUG) pdb_Logger::debug(\"->\".print_r($data, true));\n\treturn $this->conn->write($data);\n  }\n  private function ack() {\n\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t   \"seq\"=>$this->packet->seq));\n  }\n\n  private function getOutput() {\n\tif (!$this->session) return \"\";\n\n\tif (!$this->end) $output = $this->session->output = ob_get_contents();\n\treturn $this->session->output;\n  }\n\n  /**\n   * Handle requests from the front end\n   */\n  public function handleRequests() {\n\t$this->ignoreInterrupt = false;\n\n\twhile(!$this->end) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"handleRequests: accept\");\n   \n\t  if (!($this->packet = $this->read())) break; // ignore __destructors after shutdown\n\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"handleRequests: done accept \".$this->packet->cmd);\n\n\t  switch($this->packet->cmd) {\n\t  case \"status\":\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"line\"=>$this->session->currentFrame->line, \n\t\t\t\t\t\t   \"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t   \"breakpoints\"=>$this->session->getBreakpoints()));\n\t\tbreak;\n\t  case \"extendedStatus\":\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"line\"=>$this->session->currentFrame->line, \n\t\t\t\t\t\t   \"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t   \"script\"=>$this->session->getCurrentViewHtmlScriptSource(),\n\t\t\t\t\t\t   \"breakpoints\"=>$this->session->getBreakpoints()));\n\t\tbreak;\n\t  case \"begin\":\n\t\tchdir (urldecode($this->packet->cwd));\n\t\t$this->session = new pdb_Session(urldecode($this->packet->scriptName));\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"scriptName\"=>$this->packet->scriptName, \n\t\t\t\t\t\t   \"script\"=>$this->session->getCurrentViewHtmlScriptSource()));\n\n\t\t$this->session->evalScript();\n\t\t$this->end = true;\n\t\tbreak;\n\t  case \"stepNext\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_INTO;\n\t  case \"stepOver\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_OVER;\n\t  case \"go\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::GO;\n\t  case \"stepOut\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_OUT;\n\t  case \"toggleBreakpoint\":\n\t\t$bp = $this->session->toggleBreakpoint($this->packet->breakpoint);\n\t\t$this->write($bp ? \n\t\t\t\t\t (array(\"cmd\"=>\"unsetBreakpoint\", \n\t\t\t\t\t\t\t\"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t\t\"scriptName\"=>$bp->scriptName, \n\t\t\t\t\t\t\t\"breakpoint\"=>$bp->breakpoint)) :\n\t\t\t\t\t (array(\"cmd\"=>\"setBreakpoint\", \n\t\t\t\t\t\t\t\"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t\t\"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t\t\"breakpoint\"=>$this->packet->breakpoint)));\n\t\tbreak;\n\t  case \"toolTip\":\n\t\t$name = urldecode($this->packet->item);\n\t\t$value = \"\";\n\t\tif ($name[0]=='$') {\n\t\t  $idx = substr($name, 1);\n\t\t  $env = (object) $this->session->currentFrame->vars;\n\t\t  $code = \"return \\$env->$idx;\";\n\t\t  $value = eval($code);\n\t\t  if (is_object($value)) {\n\t\t\t$value = get_class($value) . \" object\";\n\t\t  } elseif (is_array($value)) {\n\t\t\t$value = \"array[\".count($value).\"]\";\n\t\t  } elseif (!isset($value)) {\n\t\t\t$value = \"<undefined>\";\n\t\t  } else {\n\t\t\t$value = print_r($value, true);\n\t\t  }\n\t\t} else {\n\t\t  $value = $this->packet->item;\n\t\t}\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t   \"item\"=>$this->packet->item,\n\t\t\t\t\t\t   \"value\"=>$value));\n\t\tbreak;\n\t  case \"switchView\":\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"switchView here\");\n\t\t$name = urldecode($this->packet->scriptName);\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"switchView $name\");\n\t\tif ($name[0]=='$') {\n\t\t  $idx = substr($name, 1);\n\t\t  $env = (object) $this->session->currentFrame->vars;\n\t\t  $code = \"return \\$env->$idx;\";\n\n\t\t  $pdb_dbg->end = true;\n\t\t  $value = eval($code);\n\t\t  $pdb_dbg->end = false;\n\n\t\t  $this->session->currentView = new pdb_VariableView($this->session->currentView, $name, $value);\n\t\t} else {\n\t\t  $this->end = true;\n\t\t  $value = self::resolveIncludePath(eval(\"return ${name};\"));\n\t\t  $this->end = false;\n\n\t\t  $this->session->currentView = new pdb_View($this->session->currentView, realpath($value));\n\t\t}\n\t\t$this->ack();\n\t\tbreak;\n\t  case \"backView\":\n\t\tif ($this->session->currentView)\n\t\t  $this->session->currentView = $this->session->currentView->parent;\n\t\t$this->ack();\n\t\tbreak;\n\t  case \"output\":\n\t\tif ($this->session) {\n\t\t  $this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t\t \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t\t \"output\"=>$this->getOutput()));\n\t\t} else {\n\t\t  $this->ack();\n\t\t}\n\t\tbreak;\n\t  case \"end\":\n\t\t$this->end();\n\t\tbreak;\n\t  default:\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"illegal packet: \" . print_r($this->packet, true));\n\t\texit(1);\n\t  }\n\t}\n\treturn self::GO;\n  }\n  public function end() {\n\t$this->session->currentView = null;\n\t$this->write(array(\"cmd\"=>\"end\",\n\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t   \"output\"=>$this->getOutput()));\n\t$this->end = true;\n  }\n  /**\n   * shut down the current comm. channel\n   */\n  public function shutdown() {\n\t$this->conn->setOutput($this->getOutput());\n\t$this->conn->shutdown();\n  }\n\n  /**\n   * called at run-time for each frame\n   * @return the current frame\n   */\n  public function startCall($scriptName) {\n\t/* check for stepOver and stepOut */\n\t$stepNext = $this->session->currentFrame->stepNext == pdb_JSDebugger::STEP_INTO ? pdb_JSDebugger::STEP_INTO : false;\n\t\n\tif (PDB_DEBUG) pdb_Logger::debug(\"startCall::$scriptName, $stepNext\");\n\t$env = new pdb_Environment($this->session->currentFrame, $scriptName, $stepNext);\n\t$this->session->allFrames[] = $env;\n\treturn $env;\n  }\n\n  /**\n   * @access private\n   */\n  protected function resolveIncludePath($scriptName) {\n\tif (file_exists($scriptName)) return realpath($scriptName);\n\n\t$paths = explode(PATH_SEPARATOR, get_include_path());\n\t$name = $scriptName;\n\tforeach ($paths as $path) {\n\t  $x = substr($path, -1);\n\t  if ($x != \"/\" && $x != DIRECTORY_SEPARATOR) $path.=DIRECTORY_SEPARATOR;\n\t  $scriptName = realpath(\"${path}${name}\");\n\t  if ($scriptName) return $scriptName;\n\t}\n\ttrigger_error(\"file $scriptName not found\", E_USER_ERROR);\n  }\n  /**\n   * called at run-time for each included file\n   * @param string the script name\n   * @return string the code\n   */\n  public function startInclude($scriptName, $once) {\n\t$isDebugger = (basename($scriptName) == \"PHPDebugger.php\");\n\tif (!$isDebugger)\n\t  $scriptName = $this->resolveIncludePath($scriptName);\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"scriptName::$scriptName, $isDebugger\");\n\n\tif ($once && isset($this->includedScripts[$scriptName]))\n\t  $isDebugger = true;\n\n\t// include only from a top-level environment\n\t// initial line# and vars may be wrong due to a side-effect in step\n\t$this->session->currentFrame = $this->session->currentTopLevelFrame;\n\n\t$stepNext = $this->session->currentFrame->stepNext == pdb_JSDebugger::STEP_INTO ? pdb_JSDebugger::STEP_INTO : false;\n\t$this->session->currentFrame = new pdb_Environment($this->session->currentFrame, $scriptName, $stepNext);\n\t$this->session->allFrames[] = $this->session->currentFrame;\n\n\tif ($isDebugger) // do not debug self\n\t  $code = \"<?php ?>\";\n\telse\n\t  $code = $this->session->parseCode(realpath($scriptName), file_get_contents($scriptName));\n\n\t$this->session->currentTopLevelFrame = $this->session->currentFrame;\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"startInclude:::\".$this->session->currentTopLevelFrame . \" parent: \" . $this->session->currentTopLevelFrame->parent . \" code: \".$code);\n\n\tif ($once) $this->includedScripts[$scriptName] = true;\n\treturn $code;\n  }\n\n  /**\n   * called at run-time after the script has been included\n   */\n  public function endInclude() {\n\tif (PDB_DEBUG) pdb_Logger::debug(\"endInclude:::\".$this->session->currentTopLevelFrame . \"parent: \".$this->session->currentTopLevelFrame->parent);\n\n\t$this->session->currentFrame = $this->session->currentTopLevelFrame = \n\t  $this->session->currentTopLevelFrame->parent;\n  }\n\n  /**\n   * called at run-time for each line\n   * @param string the script name\n   * @param int the current line\n   * @param mixed the execution variables\n   */\n  public function step($scriptName, $line, $vars) {\n\tif ($this->ignoreInterrupt) return; // avoid spurious step calls from __destruct() method\n\t$this->ignoreInterrupt = true;\n\n\tif (PDB_DEBUG) pdb_Logger::logDebug(\"step: $scriptName @ $line\");\n\t// pull the current frame from the stack or the top-level environment\n\t$this->session->currentFrame = (isset($vars['__pdb_CurrentFrame'])) ? $vars['__pdb_CurrentFrame'] : $this->session->currentTopLevelFrame;\n\tunset($vars['__pdb_CurrentFrame']);\n\n\t$this->session->currentFrame->update($line, $vars);\n\n\tif ($this->session->hasBreakpoint($scriptName, $line)) {\n\t  $stepNext = $this->handleRequests();\n\t  if (PDB_DEBUG) pdb_Logger::logDebug(\"continue\");\n\n\t  /* clear all dynamic breakpoints */\n\t  foreach ($this->session->allFrames as $currentFrame)\n\t\t$currentFrame->stepNext = false;\n\n\t  /* set new dynamic breakpoint */\n\t  if ($stepNext != pdb_JSDebugger::GO) {\n\t\t$currentFrame = $this->session->currentFrame;\n\n\t\t/* break in current frame or frame below */\n\t\tif ($stepNext != pdb_JSDebugger::STEP_OUT)\n\t\t  $currentFrame->stepNext = $stepNext;\n\n\t\t/* or break in any parent */\n\t\twhile ($currentFrame = $currentFrame->parent) {\n\t\t  $currentFrame->stepNext = $stepNext;\n\t\t}\n\t  }\n\t}\n\n\t$this->ignoreInterrupt = false;\n\tif (PDB_DEBUG) pdb_Logger::logDebug(\"endStep: $scriptName @ $line\");\n  }\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_getDefinedVars($vars1, $vars2) {\n  if(isset($vars2)) $vars1['pbd_This'] = $vars2;\n\n  unset($vars1['__pdb_Code']);\t   // see pdb_Message::doEval()\n\n  return $vars1;  \n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_startCall($scriptName, $line) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) return $pdb_dbg->startCall($scriptName);\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_startInclude($scriptName, $once) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) return $pdb_dbg->startInclude($scriptName, $once);\n  else return \"\";\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_endInclude() {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) $pdb_dbg->endInclude();\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_step($scriptName, $line, $vars) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) $pdb_dbg->step($scriptName, $line, $vars);\n}\n\n/**\n * @access private\n */\nfunction pdb_error_handler($errno, $errstr, $errfile, $errline) {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error $errno: $errstr in $errfile line $errline\");\n  if ($pdb_dbg->end) return true;\n \n if (strncmp(basename($errfile),\"PHPDebugger\", 11)) \n   $pdb_dbg->setError($errno, $errfile, $errline, $errstr);\n\n  return true;\n}\n\n/**\n * @access private\n */\nfunction pdb_shutdown() {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error: \".print_r(error_get_last(), true));\n  if ($pdb_dbg->end) return;\n\n  $error = error_get_last();\n  if ($error) {\n\t$pdb_dbg->setError($error['type'], $error['file'], $error['line'], $error['message']);\n\t$pdb_dbg->end();\n\t$pdb_dbg->shutdown();\n  }\n}\n\nif (PDB_DEBUG==2) {\n  $parser = new pdb_Parser($argv[1], file_get_contents($argv[1]));\n echo $parser->parseScript();\n exit (2);\n}\n\n/* * The JavaScript part, invoked after the debugger has been included() * */\nif (!isset($_SERVER['HTTP_XPDB_DEBUGGER'])) {\n\n  session_start();\n  header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n  header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n  header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  header(\"Pragma: no-cache\");\n  header(\"Content-Type: text/html\");\n?>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>\nPHPDebugger version 1.0\n</title>\n<style type=\"text/css\">\n#tooltip {\n  background:#EFEFEF none repeat scroll 0 0;\n  height:auto;\n  width:auto;\n  min-width: 1px;\n  min-height: 1.5ex;\n  display: block;\n  border:1px solid black;\n  background-color:gray; color:white;\n  position:absolute;\n  text-align: center;\n  z-index:75;\n}\n.tt {\n  visibility: hidden;\n}\n.ttHover {\n  visibility: visible;\n}\n\n#run {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background:green url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwcXGXdF1DwAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABEUlEQVQoz62SoWvDUBDGfx0Rry6VzzUyg4lEVgYmRulfMVUKVWOqTFVWDULVbNxsTSETg8jOzm+QwcSL28ECmwhJGpqwwnrmfXfv7nvf3b2e+TQ//NMsgPRlQfoeQ14E9TBAe0uC9QyAeBoeQfK6IZjuqmC89tHeEoDFxP+TzKqQJK0JksPNlQ/QSWYBiJQVKShd+4DJa+f68hyA0f0M7fR5nKyaSiQTlHwgatB4JXkzB+q8C12RJfNwr522Vr4hy7PjtgOgbAWZKs6SRASt+gfZ8bPBcQck83B/Jl/Fre3S8AGlarx5Kuazu33o2I4atUq1LYi27cUNEj0cE925VdBxxxWOttJZXFrvFN/+jBPYL4uJYFb2zCiIAAAAAElFTkSuQmCC') no-repeat;\n}\n#terminate {\n  height: 13px;\n  width: 13px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background:red url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYrNECrm4EAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAwUlEQVQoz52SLQ7CQBCFvyaI4nYlciWSI3CEFkVQGAyOcBU0ClCARCKRHGFlN0HsuK4D0RRasWnKJOPel/fmJ/Ev/6ZnDQD89YzcL51iNc3R2ayC5HZkslx3Qs/97gcBEEBOh7jLfNGOh5RY8egQd7HiQcoG9HULPRZRwthagvdR4chapBUPQELVsZKAL8HUkBZApVVHN5FWuhoKzlEYg06HUaYwhuBcO55RGjbxWynANWdSWc5jte3+iCwHIPnn9z7J30SR7ayFNQAAAABJRU5ErkJggg==') no-repeat;\n}\n#stepInto {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYtD6f61SMAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAA6ElEQVQoz2N8//r9fwYKAQuMcWy6JlYFmq4lDIIqyYQNOTZdk8Gr8jpWBdvaNRkUPz9nkDSswWkII8w72Fyi6JjMoGmRw7Ct3ZDBKvM6Ye9gU3RsuiaDpkkywTBhIqjizwfiAxbdBQhDfqCIYXMxVkN+fGdgCCqaCzXkPYNXJoS9ri+ZeO84FV1nWNYUDfEKFC9rimZwKrpOWph41d1nWNaWzcDw5zvDsrZsBq+6+/ijOHn+MQbBzxBF73kVGeYmWiHSSZMiigHY1LIwMDAw/Di/lOHaC4giQYljDAxIhqC7AJtaRmrkHQBYX2Q4HZvQSwAAAABJRU5ErkJggg==') no-repeat;\n}\n#stepOver {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYsOAZcQW0AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABSklEQVQoz62TP0jDQBTGv5QMdSgYcEjGgEvHdsyYsW6Kg27SKeJki1PpEAShqJPYKTilHUS3dOyYbu1mhpZmERqIcIEOyRA4h9qaeCcK+uA43uPj9/7cO4GEhOKPJmYdMrMQTJ5A3nxGKO2okCsHkHbr30PIzII/slA9vMO2XGWEUTDG+PEMyXIBpdJiIWuAbjiIXkcYXJUZiHZ0A91wMOzuoVhS8hWRkFDHlCmN55RMbeqYMiUhYY5jypRMbUrjOaMpbGhpBLffgGZ43OFphge33wDSiD+TJAaQJqubY243016a5GKa4UFYP/HAVFFr+1zI8LaM/dNLoKh8BpMFnu9b0M8zkJ9sYKo4vrgGxC0gjdHrNDdJC79dqFrbR6/TZAAA+JXUH1xIy5WIlFRYJ1quoq9ti7ysycTGS/CxqbILZCC8uQn/8XfeAUbdtbmYIYl8AAAAAElFTkSuQmCC') no-repeat;\n}\n#stepOut {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYsF62NfDQAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABAUlEQVQoz62Tv2vCQBTHP5GsDoJDV8f8C44ZM+Y/EOnSgoOCQ4YOxVE6BH9MoZMdM3TI6CLcJNzmLULGCg4p6HBgoB0SFH9gKvYtj7v3fR/ufe/OSNbJD3dG6RaxGFuIsXUfhB04j0OEfwwyi/q+ZI94NjlsVG2cpyGRb1FvKQCMa54kywAZ9XE9eV78FoSjZ+yWun4S+dnH9aao+QAVBQC43hS2ktDvYLfVXz3RqCjYN5wCiiEpkOos5+vw7RhQbGyqIU2yDNhddfs70TlIFwxsAjTfBZVNnN1IuUbQqJ+i9nFJawJoOWGxykSVBwE5xPFiPl5rOC/xAXlBa/zH3/kFlslu4rTXaTUAAAAASUVORK5CYII=') no-repeat;\n}\n#output {\n  height: 13px;\n  width: 13px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  visibility: visible;\n  background: blue url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLCQYlB4EnoCoAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABCklEQVQoz42Rv0oDQRCHv4MJbCCFgoUHvkBKXyGPEDufwUokhdFGokWwt7IRbISkTHmvcIUPcUKK3eJgp1g4i92Ld4gxWw2z329+8ye7vF81pcs59J0fVUjpcsZaHCwq3QQBD8Ddcv6vYDF7BDxCACMGgPFov8iIgQACChKTVw9rvCrqPK52+FopPjodCBA0Og1H0el5Nv1VXcNPPDQGHAhBMcnpZrlOJFi1aK1orXhVNm/zxGnbXnRaXE//nEchcm17ZpB+ggImIaaDx9gMaBfhQeD95bVfWiLQi4W48vzkmM1ndfBx89OczG5t001ePBVUX1UPWt1OesLMbm2zA4Puhk3n7LucxQLfZ4Norb3ftQMAAAAASUVORK5CYII=') no-repeat;\n}\n#backView {\n  height: 13px;\n  width: 16px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  visibility: visible;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAANCAYAAACgu+4kAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwc3GnvIoSQAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABH0lEQVQoz5WToU4DQRCGvzZLspUn+wpIJLLyJDiQEBLMJZDAA1QgTlRUU1tXCY+A5BGoPHFiKkhukm4yiD3CNr3S9k8mu/l3Z+af2dme1GJ04HM6hBPP2f2S/9DvIj/KjNG4gUbZh36Xc15GURr2B3Abzi8Z+cQABTyqkdu8BTjP+WMV91KLSS22eMDMGjOrzNZfZuvKzCSxJlnN3p4wqcVclD3kYlJBWEJQCACrJLNvVwXnwWVoSErQbwUEwgq0+ZMa2JYfBuAV1aSJo7EwvzsFmpj515y2/WjNKbim5SN66Ry8P2dcTRexDGBWXDNwHSoc5GPZfoW8FGZFxs30FYCBi9xRc3BZCrPiNoZ2/rg5SIPMi+GO0030dv2FQ/EDM7CYPt7DsBMAAAAASUVORK5CYII=') no-repeat;\n}\n \n.normal {\n  background: transparent;\n}\n.selected {\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYQB8PJFa8AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABNElEQVQoz4WPsUsCYRjGf8YNNzTo7vJBDgUNHTSc4KBbro6ORy5KU5tN0VhjS+FfEDXaEFxbY9cQuQSfQ3BCwyck3At9YIOieZo98MAL7/vjed6MMWYMcH6aQxUqePsBaqvKOm0A6PcQpaDoh4QPdcL7E8xQr4EsmC9BLKg8NA8hm72kc+Xx9Hi2GhIryMgAIHZibw9aDZDRBZ3rIs9RZ7neTDK3C1RKUC336L0cc3tTR/fDFGTByLLdTagegMp36d7VAHAWQuSPzy0Mh5BM987vxSoojiGKQBUCgkYzBQGSzOdkBNEr4Pj45QBvtza7XkhCILGg+6A1FEttPL+F67oL6RPIcZFveJse72wHBEdtctncyhcz5tOM40GM1iHxR4jnN1F5L1U8DRkzFhGwTGo4/KsfXjWDCQ6TmRMAAAAASUVORK5CYII=') no-repeat;\n}\n.breakpointSet {\n  background: red url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYOGJqAJ4UAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAA+0lEQVQoz5XSMUvDUBSG4bcXhyM4pFsudBE6GEfB5UKGZLOjq5uCIE7iPyjdxEXQoZC/4OgipIOQbqZDMW6OcbsZBO8Q0MEWkWJJ3vl7lsPpWGu/WOQqy8s44X2S8ukcmyL4Uczu6QnidZczOktUPqY8HB/Bh2OlLWEwTtAHg19kXwvuQwM1/7cBh08Z3Z0ABZCena8HAPViB6hymlHNcppUzXLKaYaq5gVtquYFitq1QtQO5fWDVsbrBygdGqTnNwLS89GhQSFCfJc0QvHNLYj8nFyHBjMcrQVmOEJH8d+PALD5M/nVNW+TFJwDEbajmODiEr2/t/pGbfoGcP1aToLr9OAAAAAASUVORK5CYII=') no-repeat;\n}\n\n#navigationBar {\n  display: block;\n  position: fixed;\n  top: 0px;\n  left: 0px;\n  height: 20px;\n  width: 100%;\n  z-index: 100;\n  background: #efefef;\n}\n#code {\n  display: block;\n  position: absolute;\n  left: 92px;\n  top: 22px;\n  z-index: 50;\n}\n\n.breakpoint {\n  display: inline;\n  position: absolute;\n  left: -92px;\n  width: 90px;\n  height: 13px;\n  background: #efefef;\n  overflow: hidden;\n}\n\n.linenumber {\n  display: inline-block;\n  position: relative;\n  width: 59px;\n  height: 13px;\n  text-align: right;\n  margin-right: 5px;\n  float: right;\n  color: black;\n  \n}\n.currentlineIndicator {\n  display: inline-block;\n  position: relative;\n  width: 13px;\n  height: 13px;\n  float: left;\n}\n.breakpointIndicator {\n  display: inline-block;\n  position: relative;\n  width: 13px;\n  height: 13px;\n  float: left;\n}\n</style>\n\n<script type=\"text/javascript\">\nvar http = createRequestObject();\nvar httpCtrl = createRequestObject();\nvar serverID = <?php echo pdb_JSDebuggerClient::getServerID(); ?>;\nvar scriptName = \"<?php echo pdb_JSDebuggerClient::getDebugScriptName(); ?>\";\nvar currentScriptName = \"\";\nvar cwd = \"<?php echo urlencode(getcwd()); ?>\";\nvar debuggerURL = \"<?php echo pdb_JSDebuggerClient::getDebuggerURL(); ?>\";\nvar date = \"<?php echo gmdate( 'D, d M Y H:i:s').' GMT'; ?>\";\nvar seq = 1;\n\nfunction getSeq() {\n return seq++;\n}\nfunction getServerID() {\n  return serverID;\n}\nfunction createRequestObject() {\n  var req;\n  var browser = navigator.appName;\n  if (browser == \"Microsoft Internet Explorer\") {\n\treq = new ActiveXObject(\"Microsoft.XMLHTTP\");\n  } else {\n\treq = new XMLHttpRequest();\n  }\n  return req;\n}\nfunction doCmd(text) {\n  switch(text.cmd) {\n  case 'stepNext': \n  case 'stepOver': \n  case 'go':\n  case 'switchView':\n  case 'backView':\n  case 'begin':\n  case 'stepOut':\tgetStatusCB(text); break;\n\n  case 'output':\tshowOutputCB(text); break;\n\n  case 'status':\tshowStatusCB(text); break;\n\n  case 'extendedStatus': showExtendedStatusCB(text); break;\n\n  case 'setBreakpoint':\tsetBreakpointCB(text); break;\n\n  case 'unsetBreakpoint':\tunsetBreakpointCB(text); break;\n\n  case 'term':\n  case 'end':\t\tendCB(text); break;\n  case 'toolTip':   showToolTipCB(text); break;\n\n  default: alert(\"illegal cmd: \" + text.cmd); break;\n  }\n}\nfunction hasClassName(element, className) {\n  var elementClassName = element.className;\n  if (elementClassName.length == 0) return false;\n  if (elementClassName == className ||\n    elementClassName.match(new RegExp(\"(^|\\\\s)\" + className + \"(\\\\s|$)\")))\n   return true;\n  return false;\n}\nif (document.getElementsByClassName == undefined) {\n document.getElementsByClassName = function(className) {\n\tvar children = document.body.getElementsByTagName('*');\n\tvar elements = [], child;\n\tfor (var i = 0, length = children.length; i < length; i++) {\n\t child = children[i];\n\t \n\t if (hasClassName(child, className)) {\n\telements.push(child);\n\t }\n\t}\n\treturn elements;\n }\n}\nfunction sendCmd(cmd) {\n  var url = debuggerURL;\n  data = cmd+\"&serverID=\"+getServerID()+\"&seq=\"+getSeq();\n\n  /* use synchronous requests to avoid out of order execution of \n\t step -> status -> extended status sequences */\n  http.open(\"POST\", url, false);\n  http.setRequestHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  http.setRequestHeader(\"Last-Modified\", date);\n  http.setRequestHeader(\"Pragma\", \"no-cache\");\n  http.setRequestHeader(\"Expires\", \"Sat, 1 Jan 2005 00:00:00 GMT\");\n  http.setRequestHeader(\"Content-Type\", \"application/x-www-form-urlencoded\");\n  http.setRequestHeader(\"Content-Length\", data.length);\n  http.setRequestHeader(\"XPDB-DEBUGGER\", 0);\n  /*\n  http.onreadystatechange = function() {\n\t if(http.readyState == 4 && http.status == 200) {\n\t   doCmd(eval(http.responseText));\n\t }\n  }\n  */\n\n  http.send(data);\n\n  doCmd(eval(http.responseText));\n}\nfunction startServer() { \n  var url = debuggerURL;\n\tdata = \"<?php echo pdb_JSDebuggerClient::getPostData(); ?>\";\n\tmethod = \"<?php echo $_SERVER['REQUEST_METHOD']; ?>\";\n  httpCtrl.open(method, url, true);\n  httpCtrl.setRequestHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  httpCtrl.setRequestHeader(\"Last-Modified\", date);\n  httpCtrl.setRequestHeader(\"Pragma\", \"no-cache\");\n  httpCtrl.setRequestHeader(\"Expires\", \"Sat, 1 Jan 2005 00:00:00 GMT\");\n  httpCtrl.setRequestHeader(\"Content-Length\", data.length);\n  httpCtrl.setRequestHeader(\"Content-Type\", \"application/x-www-form-urlencoded\");\n  httpCtrl.setRequestHeader(\"XPDB-DEBUGGER\", getServerID());\n  httpCtrl.onreadystatechange = function() {\n\t if(httpCtrl.readyState == 4 && httpCtrl.status == 200) {\n\t  //alert(\"debugger exited. Debugger debug output: \" +httpCtrl.responseText);\n\t }\n  }\n  httpCtrl.send(data);\n}\nfunction stepNext() {\n  sendCmd(\"cmd=stepNext\");\n}\nfunction stepOver() {\n  sendCmd(\"cmd=stepOver\");\n}\nfunction stepOut() {\n  sendCmd(\"cmd=stepOut\");\n}\nfunction getStatusCB(cmd) {\n\tsendCmd(\"cmd=status\");\n}\n\nfunction loaded() {\n  startServer();\n  sendCmd(\"cmd=begin&scriptName=\"+encodeURI(scriptName)+\"&cwd=\"+encodeURI(cwd));\n}\nfunction toggleBreakpoint(el, event) {\n  sendCmd(\"cmd=toggleBreakpoint&breakpoint=\"+encodeURI(el.id));\n  return false;\n}\nfunction setBreakpointCB(cmd) {\n  document.getElementById(cmd.breakpoint).lastChild.className=\"breakpointIndicator breakpointSet\";\n}\nfunction unsetBreakpointCB(cmd) {\n  document.getElementById(cmd.breakpoint).lastChild.className=\"breakpointIndicator normal\";\n}\nfunction showOutputCB(cmd) {\n  currentScriptName = \"\";\n  document.getElementById(\"code\").innerHTML = cmd.output;\n  window.scrollTo(0, 0);\n}\n\nfunction doShowStatusCB(cmd) {\n  lines = document.getElementsByClassName(\"currentlineIndicator\");\n   if (lines.length == 0) {\n     window.scrollTo (0, 0);\n     return; // no lines to mark\n   }\n\n  lines = document.getElementsByClassName(\"currentlineIndicator selected\");\n  for (i=0; i<lines.length; i++) {\n\tline = lines[i];\n\tline.className = \"currentlineIndicator normal\";\n  }\n  for (i=0; i<cmd.breakpoints.length; i++) {\n\tbreakpoint = cmd.breakpoints[i];\n\tdocument.getElementById(breakpoint).lastChild.className=\"breakpointIndicator breakpointSet\";\n  }\n  currentLine = document.getElementById(\"bp_\"+(cmd.line)).firstChild;\n\n\tcurrentLine.className=\"currentlineIndicator selected\";\n\n\tcodeDiv = document.getElementById(\"code\");\n\tcodeLine = currentLine.parentNode;\n\ttoolsHeight = 30;\n\tif (codeLine.offsetTop < window.pageYOffset || codeLine.offsetTop + codeLine.clientHeight +toolsHeight > window.pageYOffset+window.innerHeight) {\n\t  window.scrollTo(0, codeLine.offsetTop + toolsHeight - window.innerHeight/2);\n\t}\n}\nfunction showStatusCB(cmd) {\n\tif (currentScriptName == cmd.scriptName)\n\t doShowStatusCB(cmd);\n\telse\n\t sendCmd(\"cmd=extendedStatus\"); // another round-trip \n}\nfunction showExtendedStatusCB(cmd) {\n\tcurrentScriptName = cmd.scriptName;\n\tdocument.getElementById(\"code\").innerHTML = cmd.script;\n\tdocument.title = cmd.scriptName;\n\n\tdoShowStatusCB(cmd);\n}\n\nfunction stepInto(el, event) {\n  sendCmd(\"cmd=stepNext\");\n  return false;\n}\nfunction stepOver(el, event) {\n  sendCmd(\"cmd=stepOver\");\n  return false;\n}\nfunction stepOut(el, event) {\n  sendCmd(\"cmd=stepOut\");\n  return false;\n}\nfunction end(el, event) {\n  sendCmd(\"cmd=end\");\n  return false;\n}\nfunction endCB(cmd) {\n  document.body.innerHTML = cmd.output;\n}\nfunction go(el, event) {\n  sendCmd(\"cmd=go\");\n  return false;\n}\nfunction switchView(data) {\n  data = encodeURI(data);\n  sendCmd(\"cmd=switchView&scriptName=\"+data);\n  return false;\n}\nfunction backView(el, event) {\n  sendCmd(\"cmd=backView\");\n  return false;\n}\nfunction output(el, event) {\n  sendCmd(\"cmd=output\");\n  return false;\n}\n\nvar currentEl, tooltipItem;\nvar currentX, currentY;\nvar timer;\nvar tt;\nfunction getToolTip() {\n  if(tt) return tt;\n  return tt = document.getElementById(\"tooltip\");\n}\nfunction mouseout(el, event) {\n  getToolTip().className = \"tt\";\n  if (timer) {\n\twindow.clearTimeout(timer);\n\ttimer = null;\n  }\n  return true;\n}\nfunction mousemove(el, event) {\n  if (timer) {\n\twindow.clearTimeout(timer);\n\tgetToolTip().className = \"tt\";\n\ttimer = null;\n  }\n  if (getEventSource(event).parentNode.className==\"breakpoint\") return true;\n  el = getEventSource(event);\n  if (el.nodeName !=\"SPAN\") return true;\n\n  currentEl = el;\n  currentX = getEventX(event) + window.pageXOffset;\n  currentY = getEventY(event) + window.pageYOffset;\n  timer = window.setTimeout(\"showToolTip()\", 600);\n  return false;\n}\nfunction toolTipCmd(el) {\n  el=encodeURI(el);\n  sendCmd(\"cmd=toolTip&item=\"+el);\n  return false;\n}\nfunction showToolTip() {\n  el = currentEl;\n  if (el && el.firstChild && el.firstChild.data) {\n\tdata = trim(el.firstChild.data);\n\twhile (el && el.previousSibling && el.previousSibling.firstChild && el.previousSibling.firstChild.data && trim(el.previousSibling.firstChild.data)=='->') {\n\t  el = el.previousSibling.previousSibling;\n\t  if (el && el.firstChild && el.firstChild.data) data = trim(el.firstChild.data)+\"->\"+data;\n\t}\n  }\n    toolTipCmd(data);\n}\nfunction showToolTipCB(cmd) {\n  tt = getToolTip();\n  if(tooltipItem) tt.removeChild(tooltipItem);\n  tooltipItem = (document.createTextNode(cmd.value));\n  tt.appendChild(tooltipItem);\n  tt.style.top=(currentY+10) + \"px\";\n  tt.style.left=(currentX+10) + \"px\";\n  tt.className = \"ttHover\";\n\n}\nfunction trim(str) {\n  nbspChar = String.fromCharCode(160);\n  return str.replace(/^\\s*/, \"\").replace(/\\s*$/, \"\").replace(nbspChar,\"\");\n}\nfunction getEventSource(event) {\n if (event.target != undefined) return event.target;\n return event.srcElement;\n}\nfunction getEventX(event) {\n  if (event.clientX != undefined) return event.clientX;\n  return event.offsetX;\n}\nfunction getEventY(event) {\n  if (event.clientY != undefined) return event.clientY;\n  return event.offsetY;\n}\nfunction mousedown(el, event) {\n  getToolTip().className = \"tt\";\n\n  if (getEventSource(event).parentNode.className==\"breakpoint\") return true;\n  el = getEventSource(event);\n  if (el && el.firstChild && el.firstChild.data) {\n\tdata = trim(el.firstChild.data);\n\twhile (el && el.previousSibling && el.previousSibling.firstChild && el.previousSibling.firstChild.data && trim(el.previousSibling.firstChild.data)=='->') {\n\t  el = el.previousSibling.previousSibling;\n\t  if (el && el.firstChild && el.firstChild.data) data = trim(el.firstChild.data)+\"->\"+data;\n\t}\n\tswitchView(data);\n  }\n  return false;\n}\n</script>\n\n</head>\n<body>\n\n<div id=\"navigationBar\">\n<a id=\"run\" onmousedown=\"return go(this, event);\"></a>\n<a id=\"terminate\" onmousedown=\"return end(this, event);\"></a>\n<a id=\"stepInto\" onmousedown=\"return stepInto(this, event);\"></a>\n<a id=\"stepOver\" onmousedown=\"return stepOver(this, event);\"></a>\n<a id=\"stepOut\" onmousedown=\"return stepOut(this, event);\"></a>\n<a id=\"output\" onmousedown=\"return output(this, event);\"></a>\n<a id=\"backView\" onmousedown=\"return backView(this, event);\"></a>\n</div>\n <div onmouseout=\"return mouseout(this, event);\" onmousemove=\"return mousemove(this, event);\" onmousedown=\"return mousedown(this, event);\">\n <div id=\"code\">\n<span>loading...\n<noscript>failed! Please enable JavaScript and try again.</noscript>\n</span>\n</div>\n<div id=\"tooltip\" class=\"tt\" />\n</div>\n<script type=\"text/javascript\">\n loaded();\n</script>\n</body>\n</html>\n<?php\n exit (0);\n} elseif (($serverID = $_SERVER['HTTP_XPDB_DEBUGGER']) != \"0\") {\n/* * The back end part, invoked from JavaScript using a json call. $serverID is a uniq ID generated from JavaScript * */\n header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n header(\"Pragma: no-cache\");\n header(\"Content-Encoding: identity\");\n $pdb_dbg = new pdb_JSDebugger((int)$serverID);\n $pdb_dbg->handleRequests();\n $pdb_dbg->shutdown();\n if (PDB_DEBUG) pdb_Logger::debug(\"SERVER TERMINATED!\");\n exit(0);\n} else {\n/* * The front end part, invoked from JavaScript using json calls * */\n header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n header(\"Pragma: no-cache\");\n header(\"Content-Encoding: identity\");\n pdb_JSDebuggerClient::handleRequest ($_POST);\n exit(0);\n}\n?>\n";
    public static final byte[] bytes = "<?php /*-*- mode: php; tab-width:4 -*-*/\n\n  /**\n   *  PHPDebugger.php -- The PHP debugger (JavaScript GUI)\n   * \n   * Copyright (C) 2009 Jost Boekemeier\n   * \n   * The PHPDebugger (\"the library\") is free software; you can\n   * redistribute it and/or modify it under the terms of the GNU General\n   * Public License as published by the Free Software Foundation; either\n   * version 2, or (at your option) any later version.\n   * \n   * The library is distributed in the hope that it will be useful, but\n   * WITHOUT ANY WARRANTY; without even the implied warranty of\n   * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n   * General Public License for more details.\n   * \n   * You should have received a copy of the GNU General Public License\n   * along with the PHPDebugger; see the file COPYING. If not, write to the\n   * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n   * 02111-1307 USA.\n   * \n   * Linking this file statically or dynamically with other modules is\n   * making a combined work based on this library. Thus, the terms and\n   * conditions of the GNU General Public License cover the whole\n   * combination.\n   * \n   * As a special exception, the copyright holders of this library give you\n   * permission to link this library with independent modules to produce an\n   * executable, regardless of the license terms of these independent\n   * modules, and to copy and distribute the resulting executable under\n   * terms of your choice, provided that you also meet, for each linked\n   * independent module, the terms and conditions of the license of that\n   * module. An independent module is a module which is not derived from\n   * or based on this library. If you modify this library, you may extend\n   * this exception to your version of the library, but you are not\n   * obligated to do so. If you do not wish to do so, delete this\n   * exception statement from your version. \n   *\n   * Usage:\n   * \n   * - include() this file at the beginning of your script\n   *\n   * - browse to your script using firefox \n   *\n   * - set breakpoints using the JavaScript GUI, click on any variable or included file to visit that variable or file\n   * \n   * - click on the stop button to terminate the debug session\n   *\n   * @category   java\n   * @package    pdb\n   * @author     Jost Boekemeier\n   * @license    GPL\n   * @version    1.0\n   * @link       http://php-java-bridge.sf.net/phpdebugger\n   * @see        PHPDebugger.inc\n   */\n\n/** @access private */\ndefine (\"PDB_DEBUG\", 0);\nset_time_limit (0);\n\n$pdb_version = phpversion();\nif ((version_compare(\"5.3.0\", $pdb_version, \">\")))\n  trigger_error(\"<br><strong>PHP ${pdb_version} too old.</strong><br>\\nPlease set the path to a PHP >= 5.3 executable, see php_exec in the WEB-INF/web.xml\", E_USER_ERROR);\n\n \n/**\n * a simple logger\n * @access private\n */\nclass pdb_Logger {\n  const FATAL = 1;\n  const INFO = 2;\n  const VERBOSE = 3;\n  const DEBUG = 4;\n\n  private static $logLevel = 0;\n  private static $logFileName;\n  private static function println($msg, $level) {\n\tif (!self::$logLevel) self::$logLevel=PDB_DEBUG?self::DEBUG:self::INFO;\n\tif ($level <= self::$logLevel) {\n\t  static $file = null;\n\t  if(!isset(self::$logFileName)) {\n\t\tself::$logFileName = $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.\"pdb_PHPDebugger.log\";\n\t  }\n\t  if (!$file) $file = fopen(self::$logFileName, \"ab\") or die(\"fopen\");\n\t  fwrite($file, time().\": \");\n\t  fwrite($file, $msg.\"\\n\");\n\t  fflush($file);\n\t}\n  }\n\n  public static function logFatal($msg) {\n\tself::println($msg, self::FATAL);\n  }\n  public static function logInfo($msg) {\n\tself::println($msg, self::INFO);\n  }\n  public static function logMessage($msg) {\n\tself::println($msg, self::VERBOSE);\n  }\n  public static function logDebug($msg) {\n\tself::println($msg, self::DEBUG);\n  }\n  public static function debug($msg) {\n\tself::logDebug($msg);\n  }\n  public static function log($msg) {\n\tself::logMessage($msg);\n  }\n  public static function setLogLevel($level) {\n\tself::$logLevel=$level;\n  }\n  public static function setLogFileName($name) {\n\tself::$logFileName = $name;\n  }\n}\n\n/**\n * @access private\n */\ninterface pdb_Queue {\n\n  /** \n   * Read a string from the queue\n   * @return string a json encoded string of values\n   * @access private\n   */\n  public function read();\n\n  /**\n   * Write a string to the queue\n   * @param string a json encoded string of values or TRUE\n   * @access private\n   */\n  public function write($val);\n\n  /**\n   * Set the script output before server shutdown\n   * @access private\n   */\n  public function setOutput($output);\n\n  /**\n   * Get the script output\n   * @access private\n   */\n  public function getOutput();\n\n  /**\n   * Mark the channel as dead. If marked, read will return boolean\n   * TRUE, write will do nothing.\n   * @access private\n   */\n  public function shutdown();\n}\n\n/**\n * This class represents the debugger back end connection. It\n * communicates with the debugger front end using a shared-memory queue.\n * It is slow, but it does not require any special library.\n * @access private\n */\nclass pdb_PollingServerConnection implements pdb_Queue {\n  protected $id;\n  protected $role, $to;\n  protected $chanTrm; // \"back end terminated\" flag\n  protected $output;\n  const TIMER_DURATION = 200000; // every 200ms\n\n  /**\n   * Create a new communication using a unique id\n   * @access private\n   */\n  public function pdb_PollingServerConnection($id) {\n\t$this->id = $id;\n\t$this->chanTrm = \"pdb_trmserver{$this->id}\";\n\t$this->output = \"<missing>\";\n\n\t$this->prepareCookies();\n\t$this->init();\n  }\n\n  protected function checkTrm() {\n\treturn false!==$_SESSION[$this->chanTrm];\n  }\n\n  protected function prepareCookies() {\n\tini_set(\"session.use_cookies\", true);\n\tsession_start();\n\tsession_write_close();\n\n\t/* avoid PHP bug, which repeats set-cookie header for each\n\t   iteration of session_start/session_write_close */\n\tini_set(\"session.use_cookies\", false);\n  }\n\n  protected function init() {\n\tsession_start();\n\n\t$this->role = \"client\";\n\t$this->to  = \"server\";\n\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tunset ($_SESSION[$chan]);\n\tunset ($_SESSION[$chanCtr]);\n\n\t$this->role = \"server\";\n\t$this->to  = \"client\";\n\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tunset ($_SESSION[$chan]);\n\tunset ($_SESSION[$chanCtr]);\n\n\tif (isset($_SESSION[$this->chanTrm]) && !$this->checkTrm()) {\n\t  $_SESSION[$this->chanTrm] = true;\n\t  session_write_close();\n\t  sleep(1);\n\t  session_start();\n\t}\n\t$_SESSION[$this->chanTrm] = false;\n\tsession_write_close();\n  }\n\n  protected function poll() {\n\t$val = \"\";\n\t$chanCtr = \"pdb_ctr{$this->role}{$this->id}\";\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tsession_start();\n\tif (!($val = $this->checkTrm())) {\n\t  if(!isset($_SESSION[$chanCtr])) { \n\t\t$_SESSION[$chan] = array(); \n\t\t$_SESSION[$chanCtr]=0; \n\t  }\n\t  $seq = $_SESSION[$chanCtr];\n\t  $seqNext = count($_SESSION[$chan]);\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} poll next # ${seqNext} (${seq}) ...\");\n\t  if ($seqNext > $seq) {\n\t\t$val = json_decode($_SESSION[$chan][$seq]);\n\t\t$_SESSION[$chan][$seq]=null;\n\t\t$_SESSION[$chanCtr]++;\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} polled next # ${seqNext} (${seq}), got: {$val->seq}\");\n\t  }\n\t}\n\tsession_write_close();\n\treturn $val;\n  }\n  protected function send($val) {\n\t\n\t$seq = $val->seq;\n\t$chan = \"pdb_{$this->to}{$this->id}\";\n\tsession_start();\n\tif (!$this->checkTrm()) $_SESSION[$chan][$seq]=json_encode($val);\n\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} send: ${seq} ...\");\n\tsession_write_close();\n  }\n\n  /**\n   * read a new value from the read queue\n   * @access private\n   */\n  public function read() {\n\t$val = null;\n\t$cntr = 0;\n\twhile(!($val=$this->poll())) {\n\t  if ($cntr<=20) {\n\t\t$cntr++;\n\t\tusleep(self::TIMER_DURATION);\n\t  } else {\n\t\tusleep(self::TIMER_DURATION*5);\n\t  }\n\t}\n\treturn $val === true ? null : $val;\n  }\n\n  /**\n   * write a new value to the write queue\n   * @access private\n   */\n  public function write($val) {\n\t$this->send((object)$val);\n  }\n\n  /**\n   * Set the script output\n   * @access private\n   */\n  public function setOutput($output) {\n\t$this->output = $output;\n  }\n  /**\n   * Get the script output\n   * @access private\n   */\n  public function getOutput() {\n\treturn $_SESSION[$this->chanTrm];\n  }\n\n  /**\n   * shut down the communication channel\n   */\n  public function shutdown() {\n\tif (PDB_DEBUG) pdb_Logger::debug(\"session terminated: {$this->chanTrm}\");\n\tsession_start();\n\t$_SESSION[$this->chanTrm] = $this->output;\n\tsession_write_close();\n  }\n}  \n\n/**\n * This class represents the debugger front end connection. It\n * communicates with the debugger back end using a shared-memory queue.\n * It is slow, but it does not require any special library.\n * @access private\n */\nclass pdb_PollingClientConnection extends pdb_PollingServerConnection {\n  private $seq;\n\n  protected function init() {\n\t$this->role = \"client\";\n\t$this->to  = \"server\";\n  }\n\n  protected function poll() {\n\t$chan = \"pdb_{$this->role}{$this->id}\";\n\tsession_start();\n\tif (!($val = $this->checkTrm())) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} poll for {$this->seq} ...\");\n\t  if (isset($_SESSION[$chan][$this->seq])) {\n\t\t$val = json_decode($_SESSION[$chan][$this->seq]);\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"...{$this->role}, {$this->id} polled for {$this->seq}, got: {$val->seq}\");\n\t\tunset($_SESSION[$chan][$this->seq]);\n\t  }\n\t}\n\tsession_write_close();\n\treturn $val;\n  }\n\n  /**\n   * write a new value to the write queue\n   * @access private\n   */\n  public function write($val) {\n\t$this->seq = $val->seq;\n\n\tparent::write($val);\n  }\n\n  /**\n   * shut down the communication channel\n   * @access private\n   */\n  public function shutdown() {}\n}\n\nif (!class_exists(\"pdb_Parser\")) {\n  /**\n   * The PHP parser\n   * @access private\n   */\n  class pdb_Parser {\n\tconst BLOCK = 1;\n\tconst STATEMENT = 2;\n\tconst EXPRESSION = 3;\n\tconst FUNCTION_BLOCK = 4; // BLOCK w/ STEP() as last statement\n\n\tprivate $scriptName, $content;\n\tprivate $code;\n\tprivate $output;\n\tprivate $line, $currentLine;\n\tprivate $beginStatement, $inPhp, $inDQuote;\n \n\t/**\n\t * Create a new PHP parser\n\t * @param string the script name\n\t * @param string the script content\n\t * @access private\n\t */\n\tpublic function pdb_Parser($scriptName, $content) {\n\t  $this->scriptName = $scriptName;\n\t  $this->content = $content;\n\t  $this->code = token_get_all($content);\n\t  $this->output = \"\";\n\t  $this->line = $this->currentLine = 0;\n\t  $this->beginStatement = $this->inPhp = $this->inDQuote = false;\n\t}\n\n\tprivate function toggleDQuote($chr) {\n\t  if ($chr == '\"') $this->inDQuote = !$this->inDQuote;\n\t}\n\n\tprivate function each() {\n\t  $next = each ($this->code);\n\t  if ($next) {\n\t\t$cur = current($this->code);\n\t\tif (is_array($cur)) {\n\t\t  $this->currentLine = $cur[2] + ($cur[1][0] == \"\\n\" ? substr_count($cur[1], \"\\n\") : 0);\n\t\t  if ($this->isWhitespace($cur)) {\n\t\t\t$this->write($cur[1]);\n\t\t\treturn $this->each();\n\t\t  }\n\t\t}\n\t\telse \n\t\t  $this->toggleDQuote($cur);\n\t  }\n\t  return $next;\n\t}\n\n\tprivate function write($code) {\n\t  //echo \"write:::\".$code.\"\\n\";\n\t  $this->output.=$code;\n\t}\n\n\tprivate function writeInclude($once) {\n\t  $name = \"\";\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $name.=$val[1];\n\t\t} else {\n\t\t  if ($val==';') break;\n\t\t  $name.=$val;\n\t\t}\n\t  }\n\t  if (PDB_DEBUG == 2) \n\t\t$this->write(\"EVAL($name);\");\n\t  else\n\t\t$this->write(\"eval('?>'.pdb_startInclude($name, $once)); pdb_endInclude();\");\n\t}\n\n\tprivate function writeCall() {\n\t  while(1) {\n\t\tif (!$this->each()) die(\"parse error\");\n\t\t$val = current($this->code);\n\t\tif (is_array($val)) {\n\t\t  $this->write($val[1]);\n\t\t} else {\n\t\t  $this->write($val);\n\t\t  if ($val=='{') break;\n\t\t}\n\t  }\n\t  $scriptName = addslashes($this->scriptName);\n\t  $this->write(\"\\$__pdb_CurrentFrame=pdb_startCall(\\\"$scriptName\\\", {$this->currentLine});\");\n\t}\n\n\tprivate function writeStep($pLevel) {\n\t  $token = current($this->code);\n\t  if ($this->inPhp && !$pLevel && !$this->inDQuote && $this->beginStatement && !$this->isWhitespace($token) && ($this->line != $this->currentLine)) {\n\t\t$line = $this->line = $this->currentLine;\n\t\t$scriptName = addslashes($this->scriptName);\n\t\tif (PDB_DEBUG == 2)\n\t\t  $this->write(\";STEP($line);\");\n\t\telse\n\t\t  $this->write(\";pdb_step(\\\"$scriptName\\\", $line, pdb_getDefinedVars(get_defined_vars(), (isset(\\$this) ? \\$this : NULL)));\");\n\t  }\n\t}\n\n\tprivate function writeNext() {\n\t  $this->next();\n\t  $token = current($this->code);\n\t  if (is_array($token)) $token = $token[1];\n\t  $this->write($token);\n\t}\n\n\tprivate function nextIs($chr) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn false;\t/* not found */\n\t\t  }\n\t\t} else {\n\t\t  while($i--) prev($this->code);\n\t\t  return $cur == $chr;\t/* found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function nextTokenIs($ar) {\n\t  $i = 0;\n\t  while(each($this->code)) {\n\t\t$cur = current($this->code);\n\t\t$i++;\n\t\tif (is_array($cur)) {\n\t\t  switch ($cur[0]) {\n\t\t  case T_COMMENT:\n\t\t  case T_DOC_COMMENT:\n\t\t  case T_WHITESPACE:\n\t\t\tbreak;\t/* skip */\n\t\t  default: \n\t\t\twhile($i--) prev($this->code);\n\t\t\treturn (in_array($cur[0], $ar));\n\t\t  }\n\t\t} else {\n\t\t  break; /* not found */\n\t\t}\n\t  }\n\t  while($i--) prev($this->code);\n\t  return false;\t/* not found */\n\t}\n\n\tprivate function isWhitespace($token) {\n\t  $isWhitespace = false;\n\t  switch($token[0]) {\n\t  case T_COMMENT:\n\t  case T_DOC_COMMENT:\n\t  case T_WHITESPACE:\n\t\t$isWhitespace = true;\n\t\tbreak;\n\t  }\n\t  return $isWhitespace;\n\t}\n\tprivate function next() {\n\t  if (!$this->each()) trigger_error(\"parse error\", E_USER_ERROR);\n\t}\n\n\tprivate function parseBlock () {\n\t  $this->parse(self::BLOCK);\n\t}\n\tprivate function parseFunction () {\n\t  $this->parse(self::FUNCTION_BLOCK);\n\t}\n\tprivate function parseStatement () {\n\t  $this->parse(self::STATEMENT);\n\t}\n\tprivate function parseExpression () {\n\t  $this->parse(self::EXPRESSION);\n\t}\n\n\tprivate function parse ($type) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"parse:::$type\");\n\n\t  $this->beginStatement = true;\n\t  $pLevel = 0;\n\n\t  do {\n\t\t$token = current($this->code);\n\t\tif (!is_array($token)) {\n\t\t  if (PDB_DEBUG) pdb_Logger::debug(\":::\".$token);\n\t\t  if (!$pLevel && $type==self::FUNCTION_BLOCK && $token=='}') $this->writeStep($pLevel);\n\t\t  $this->write($token);\n\t\t  if ($this->inPhp && !$this->inDQuote) {\n\t\t\t$this->beginStatement = false; \n\t\t\tswitch($token) {\n\t\t\tcase '(': \n\t\t\t  $pLevel++;\n\t\t\t  break;\n\t\t\tcase ')':\n\t\t\t  if (!--$pLevel && $type==self::EXPRESSION) return;\n\t\t\t  break;\n\t\t\tcase '{': \n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  break;\n\t\t\tcase '}': \n\t\t\t  if (!$pLevel) return;\n\t\t\t  break;\n\t\t\tcase ';':\n\t\t\t  if (!$pLevel) {\n\t\t\t\tif ($type==self::STATEMENT) return;\n\t\t\t\t$this->beginStatement = true; \n\t\t\t  }\n\t\t\t  break;\n\t\t\t}\n\t\t  }\n\t\t} else {\n\t\t  if (PDB_DEBUG) pdb_Logger::debug(\":::\".$token[1].\":(\".token_name($token[0]).')');\n\n\t\t  if ($this->inDQuote) {\n\t\t\t$this->write($token[1]);\n\t\t\tcontinue;\n\t\t  }\n\n\t\t  switch($token[0]) {\n\n\t\t  case T_OPEN_TAG: \n\t\t  case T_START_HEREDOC:\n\t\t  case T_OPEN_TAG_WITH_ECHO: \n\t\t\t$this->beginStatement = $this->inPhp = true;\n\t\t\t$this->write($token[1]);\n\t\t\tbreak;\n\n\t\t  case T_END_HEREDOC:\n\t\t  case T_CLOSE_TAG: \n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = $this->inPhp = false; \n\t\t\tbreak;\n\n\t\t  case T_FUNCTION:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeCall();\n\t\t\t$this->next();\n\t\t\t$this->parseFunction();\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_ELSE:\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\n\t\t\t}\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_DO:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\t\t\t  $this->next();\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->next();\n\t\t\t  $this->write('}');\n\t\t\t}\n\t\t\t$token = current($this->code);\n\t\t\t$this->write($token[1]);\n\n\t\t\tif ($token[0]!=T_WHILE) trigger_error(\"parse error\", E_USER_ERROR);\n\t\t\t$this->next();\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CATCH:\n\t\t  case T_IF:\n\t\t  case T_ELSEIF:\n\t\t  case T_FOR:\n\t\t  case T_FOREACH:\n\t\t  case T_WHILE:\n\t\t\t$this->writeStep($pLevel);\n\n\t\t\t$this->write($token[1]);\n\t\t\t$this->next();\n\n\t\t\t$this->parseExpression();\n\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\n\t\t\t  $this->parseBlock();\n\n\n\t\t\t} else {\n\t\t\t  $this->next();\n\t\t\t  /* create an artificial block */\n\t\t\t  $this->write('{');\n\t\t\t  $this->beginStatement = true;\n\t\t\t  $this->writeStep($pLevel);\n\t\t\t  $this->parseStatement();\n\t\t\t  $this->write('}');\n\t\t\t}\n\n\t\t\tif ($this->nextTokenIs(array(T_ELSE, T_ELSEIF, T_CATCH))) {\n\t\t\t  $this->beginStatement = false;\n\t\t\t} else {\n\t\t\t  if ($type==self::STATEMENT) return;\n\t\t\t  $this->beginStatement = true;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_REQUIRE_ONCE:\n\t\t  case T_INCLUDE_ONCE: \n\t\t  case T_INCLUDE: \n\t\t  case T_REQUIRE: \n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->writeInclude((($token[0]==T_REQUIRE_ONCE) || ($token[0]==T_INCLUDE_ONCE)) ? 1 : 0);\n\n\t\t\tif ($type==self::STATEMENT) return;\n\n\t\t\t$this->beginStatement = true;\n\t\t\tbreak;\n\n\t\t  case T_CLASS:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->writeNext();\n\t\t\tif ($this->nextIs('{')) {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->next();\n\t\t\t  $this->parseBlock(); \n\t\t\t  $this->beginStatement = true;\n\t\t\t} else {\n\t\t\t  $this->writeNext();\n\t\t\t  $this->beginStatement = false;\n\t\t\t}\n\t\t\tbreak;\n\n\t\t  case T_CASE:\n\t\t  case T_DEFAULT:\n\t\t  case T_PUBLIC:\n\t\t  case T_PRIVATE:\n\t\t  case T_PROTECTED:\n\t\t  case T_STATIC:\n\t\t  case T_CONST:\n\t\t  case T_GLOBAL:\n\t\t  case T_ABSTRACT:\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\n\t\t  default:\n\t\t\t$this->writeStep($pLevel);\n\t\t\t$this->write($token[1]);\n\t\t\t$this->beginStatement = false;\n\t\t\tbreak;\n\t\n\t\t  }\n\t\t}\n\t  } while($this->each());\n\t}\n\n\t/**\n\t * parse the given PHP script\n\t * @return the parsed PHP script\n\t * @access private\n\t */\n\tpublic function parseScript() {\n\t  do {\n\t\t$this->parseBlock();\n\t  } while($this->each());\n\n\t  return $this->output;\n\t}\n  }\n}\n\n\n/**\n * This structure represents the debugger front-end. It is used by the\n * JavaScript code to communicate with the debugger back end.\n * @access private\n */\nclass pdb_JSDebuggerClient {\n  private static function getDebuggerFilename() {\n\t$script = __FILE__;\n\t$scriptName = basename($script);\n\treturn realpath($scriptName == \"PHPDebugger.php\" ? $script :\"java/PHPDebugger.php\");\n  }\n\t\n  private static function getCurrentRootDir() {\n\t$scriptName = $_SERVER['SCRIPT_NAME'];\n\t$scriptFilename = $_SERVER['SCRIPT_FILENAME'];\n \n\t$scriptDirName = dirname($scriptName);\n\t$scriptDir   = dirname($scriptFilename);\n \n\tif ((strlen($scriptDirName)>1) && ($scriptDirName[1]=='~')) {\n\t  $scriptDirName = ltrim($scriptDirName, \"/\");\n\t  $idx = strpos($scriptDirName, '/');\n\t  $scriptDirName = $idx===false ? '' : substr($scriptDirName, $idx);\n\t} elseif ((strlen($scriptDirName)==1) && (($scriptDirName[0]=='/') || ($scriptDirName[0]=='\\\\'))) {\n\t  $scriptDirName = '';\n\t}\n\tif (PDB_DEBUG) pdb_Logger::debug(\"scriptDir: $scriptDir, scriptDirName: $scriptDirName\");\n\n\tif ((strlen($scriptDir) < strlen($scriptDirName)) || ($scriptDirName &&\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  (substr($scriptDir, -strlen($scriptDirName)) != $scriptDirName)))\n\t  return null;\n\telse\n\t  return substr($scriptDir, 0, strlen($scriptDir)-strlen($scriptDirName));\n  }\n  /*\n   * Return the script name\n   * Example: %2Fopt%2Fappserv%2Fapache-tomcat-6.0.14%2Fwebapps%2FJavaBridge%2Ftest.php\"\n   *\n   * @return An urlencoded file name.\n   */\n  public static function getDebugScriptName() {\n\treturn urlencode($_SERVER['SCRIPT_FILENAME']);\n  }\n  /**\n   * Return the debugger URL. \n   * Example: \"/JavaBridge/java/PHPDebugger.php?source=settings.php\"\n   *\n   * @return The debugger URL.\n   * @access private\n   */\n  public static function getDebuggerURL() {\n\t$path = self::getDebuggerFilename();\n\tif (!$path) \n\t  trigger_error(\"java/PHPDebugger.php not found in document root\", E_USER_ERROR);\n\n\t$root = self::getCurrentRootDir();\n\n\t$scriptName = $_SERVER['SCRIPT_NAME'];\n\n\t$scriptDirName = dirname($scriptName);\n\t$prefix = '';\n\tif ((strlen($scriptDirName)>1) && ($scriptDirName[1]=='~')) {\n\t  $scriptDirName = ltrim($scriptDirName, \"/\");\n\t  $idx = strpos($scriptDirName, '/');\n\t  $prefix = '/' . ($idx ? substr($scriptDirName, 0, $idx): $scriptDirName);\n\t}\n  \n\tif (PDB_DEBUG) pdb_Logger::debug(\"serverRoot: $root - path: $path\");\n\tif ($root && (strlen($root) < strlen($path)) && (!strncmp($path, $root, strlen($root))))\n\t  $path = \"${prefix}\" . str_replace('\\\\', '/', substr($path, strlen($root)));\n\telse // could not calculate debugger path\n\t  $path = dirname($_SERVER['SCRIPT_NAME']) . \"/java/PHPDebugger.php\";\n\n\t$pathInfo = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : \"\";\n\t$query = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : \"\";\n\n\t$url = \"${path}${pathInfo}\";\n\tif ($query) $url .= \"?${query}\";\n\treturn $url;\n  }\n\n  public static function getPostData() {\n\t$str = '';\n\tforeach ($_POST as $key => $value) {\n\t  if ($str) $str .= '&';\n\t  $str .= $key . '=' . urlencode($value);\n\t}\n\treturn $str;\n  }\n\n  /**\n   * Get the server's uniqe session ID\n   * @return a uniqe session ID\n   * @access private\n   */ \n  public static function getServerID() {\n\t// TODO: allow more than one debug session\n\treturn 1;\n  }\n \n  private static function getConnection($id) {\n\treturn new pdb_PollingClientConnection($id);\n  }\n  private static function stripslashes($value) {\n\t $value = is_array($value) ?\n\t   array_map(\"self::stripslashes\", $value) :\n\t   stripslashes($value);\n\t \n\t return $value;\n   }\n\n  /**\n   * Pass the command and arguments to the debug back end and\n   * output the response to JavaScript.\n   *\n   * @arg array The command arguments\n   * @access private\n   */\n  public static function handleRequest($vars) {\n\t\tif (get_magic_quotes_gpc()) $vars = self::stripslashes($vars);\n\t$msg = (object)$vars;\n\t\n\tif ($msg->cmd == \"begin\") sleep(1); // wait for the server to settle\n\tif (PDB_DEBUG) pdb_Logger::debug(\"beginHandleRequest: \".$msg->cmd);\n\t$conn = self::getConnection($msg->serverID);\n\t$conn->write($msg);\n\n\tif (!($response = $conn->read())) \n\t  $output = json_encode(array(\"cmd\"=>\"term\", \"output\"=>$conn->getOutput()));\n\telse\n\t  $output = json_encode($response);\n\t\n\techo \"($output)\";\n\tif (PDB_DEBUG) pdb_Logger::debug(\"endHandleRequest\");\n  }\n}\n\n/**\n * The current view frame. Contains the current script name. May be\n * selected by clicking on a include() hyperlink Allows users to set\n * breakpoints for this file.\n *\n * View will be discarded when go, step, end is invoked.\n * @access private\n */\nclass pdb_View {\n  /** The current script name */\n  public $scriptName;\n  /** Back-link to the parent or null */\n  public $parent;\n\n  protected $bpCounter, $lineCounter, $code;\n  /**\n   * Create a new view frame\n   * @param object the parent frame\n   * @param string the script name\n   */\n  public function pdb_View($parent, $scriptName) {\n\t$this->parent = $parent;\n\t$this->scriptName = $scriptName;\n\n\t$this->bpCounter = $this->lineCounter = 1;\n\t$this->code = null;\n  }\n\n  private function lineCB ($val) {\n\treturn $val.(string)$this->lineCounter++;\n  }\n  private function breakpointCB ($val) {\n\treturn \t$val.'id=\"bp_'.(string)$this->bpCounter++.'\"';\n  }\n  function replaceCallback($code, $split, $cb) {\n\t$ar = explode($split, $code);\n\t$last = array_pop($ar);\n\t$ar = array_map($cb, $ar);\n\tarray_push($ar, $last);\n\treturn implode($ar);\n  }\n\n\n  /**\n   * Return a HTML representation of the current script\n   * @return string the clickable HTML representation of the current script\n   */\n  public function getHtmlScriptSource() {\n\tif (!$this->code) {\n\t  $c=\n\t\t'<span class=\"breakpoint\" id=\"bp_\" onmousedown=\"return toggleBreakpoint(this, event);\">'.\n\t\t'<span class=\"currentlineIndicator normal\"></span>'.\n\t\t'<span class=\"linenumber\">line#</span>'.\n\t\t'<span class=\"breakpointIndicator normal\"></span>'.\n\t\t'</span><br />';\n\n\t  $code=show_source($this->scriptName, true);\n\n\t  // br => span id=pb_ ...\n\t  $code = str_replace('<br />', $c, $code);\n\t  // handle incomplete last line, identical to preg: '|(?<!<br >)</span>\\n</span>\\n</code>$|'\n\t  $code = ereg_replace('\"(([^>])|([^/]>)|([^ ]/>)|([^r] />)|([^b]r />)|([^<]br />))(</span>\\n</span>\\n</code>)\"', '\\1 $c \\8', $code);\n\n\t  $code = $this->replaceCallback($code, 'id=\"bp_\"', array($this, \"breakpointCB\"));\n\t  $code = $this->replaceCallback($code, 'line#', array($this, \"lineCB\"));\n\n\t  $this->code = $code;\n\t}\n\n\treturn $this->code;\n  }\n}\n/**\n * The current view. Used to show the contents of a variable\n * @access private\n */\nclass pdb_VariableView extends pdb_View {\n  /**\n   * Create a new variable view\n   * @param object the parent frame\n   * @param string the variable name\n   * @param string the variable value\n   */\n  public function pdb_VariableView($parent, $name, $value) {\n\tparent::pdb_View($parent, $name);\n\t$this->value = $value;\n  }\n  /**\n   * {@inheritDoc}\n   */\n  public function getHtmlScriptSource() {\n\treturn (highlight_string(print_r($this->value, true), true));\n  }\n}\n/**\n * The current execution frame. Contains the current run-time script\n * name along with its state\n * @access private\n */\nclass pdb_Environment extends pdb_View {\n  /** bool true if a dynamic breakpoint should be inserted at the next line, false otherwise */\n  public $stepNext;\n  /** The execution vars */\n  public $vars;\n  /** The current line */\n  public $line;\n\n  /**\n   * Create a new execution frame\n   * @param string the script name\n   * @param bool true if a dynamic breakpoint should be inserted at the next line, false otherwise\n   */\n  public function pdb_Environment($parent, $scriptName, $stepNext) {\n\tparent::pdb_View($parent, $scriptName);\n\t$this->stepNext = $stepNext;\n\t$this->line = -1;\n  }\n  /**\n   * Update the execution frame with the current state\n   * @param string the current script name\n   * @param int the current execution line\n   * @param mixed the current variables\n   */\n  public function update ($line, &$vars) {\n\t$this->line = $line;\n\t$this->vars = $vars;\n  }\n\n  public function __toString() {\n\treturn \"pdb_Environment: {$this->scriptName}, {$this->line}\";\n  }\n}\n/**\n * Represents a breakpoint\n * @access private\n */\nclass pdb_Breakpoint {\n  /** The script name */\n  public $scriptName;\n  /** The current line */\n  public $line;\n  /** The breakpointName as seen by JavaScript */\n  public $breakpoint;\n  /* The breakpoint type (not used yet) */\n  public $type;\n\n  /**\n   * Create a new breakpoint\n   * @param string the breakpoint name\n   * @param string the script name\n   * @param int the line\n   */\n  public function pdb_Breakpoint($breakpointName, $scriptName, $line) {\n\t$this->breakpoint = $breakpointName;\n\t$this->scriptName = $scriptName;\n\t$this->line = $line;\n\n\t$this->type = 1;\n  }\n  /**\n   * @return the string representation of the breakpoint\n   */\n  public function __toString() {\n\treturn \"{$this->line}@{$this->scriptName}, js name: ({$this->breakpoint}, type: {$this->type})\";\n  }\n}\n/**\n * The current debug session. Contains the current environment stack,\n * script output and all breakpoints set by the client. An optional\n * view is set by the switchView command.\n * @access private\n */\nfinal class pdb_Session {\n  /** The collection of breakpoints */\n  public $breakpoints;\n\n  /** List of all frames */\n  public $allFrames;\n  /** The current top level frame */\n  public $currentTopLevelFrame;\n  /** The current execution frame */\n  public $currentFrame;\n  /** The current view */\n  public $currentView;\n  /** The script output */\n  public $output;\n\n  /**\n   * Create a new debug session for a given script\n   * @param string the script name\n   */\n  public function pdb_Session($scriptName) {\n\t$this->breakpoints = $this->lines = array();\n\t$this->currentTopLevelFrame = $this->currentFrame = new pdb_Environment(null, $scriptName, true);\n\t$this->allFrames[] = $this->currentFrame;\n\n\t$this->currentView = null;\n  }\n  /**\n   * Return the clickable HTML script source, either from the cusom view or from the current frame\n   * @return string the HTML script source\n   */\n  public function getCurrentViewHtmlScriptSource () {\n\treturn $this->currentView ? $this->currentView->getHtmlScriptSource() : $this->currentFrame->getHtmlScriptSource();\n  }   \n  /**\n   * Return the current frame script name\n   * @return string the script name of the current frame\n   */\n  public function getScriptName () {\n\treturn $this->currentFrame->scriptName;\n  }\n  /**\n   * Return the current script name, either from the view or from the current frame\n   * @return string the current script name\n   */\n  public function getCurrentViewScriptName () {\n\treturn $this->currentView ? $this->currentView->scriptName : $this->getScriptName();\n  }   \n  /**\n   * Return the breakpoints for the current script\n   * @return object the breakpoints\n   */\n  public function getBreakpoints () {\n\t$bp = array();\n\tforeach ($this->breakpoints as $breakpoint) {\n\t  if ($this->getCurrentViewScriptName() != $breakpoint->scriptName) continue;\n\t  array_push($bp, $breakpoint->breakpoint);\n\t}\n\treturn $bp;\n  }\n  /**\n   * toggle and write breakpoint reply\n   * @param object the current comm. channel\n   * @param object the breakpoint\n   */\n  public function toggleBreakpoint($breakpoint) {\n\t$id = $breakpoint.\"@\".$this->getCurrentViewScriptName();\n\tif (!isset($this->breakpoints[$id])) {\n\t  $this->breakpoints[$id] = new pdb_Breakpoint($breakpoint, $this->getCurrentViewScriptName(), substr($breakpoint, 3));\n\t  return false;\n\t} else {\n\t  $bp = $this->breakpoints[$id];\n\t  unset ($this->breakpoints[$id]);\n\t  return $bp;\n\t}\n  }\n  /**\n   * check if there's a breakpoint\n   * @param string the script name\n   * @param int the line within the script \n   * @return true if a breakpoint exists at line, false otherwise\n   */\n  public function hasBreakpoint($scriptName, $line) {\n\tif ($this->currentFrame->stepNext) return true;\n  \n\tforeach ($this->breakpoints as $breakpoint) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"process breakpoint::: $scriptName, $line:: $breakpoint\");\n\t  if($breakpoint->type==1) {\n\t\tif ($breakpoint->scriptName==$scriptName&&$breakpoint->line==$line) return true;\n\t  }\n\t}\n\treturn false;\n  }\n  /**\n   * parse code\n   * @param string the script name\n   * @param string the content\n   * @return the parsed script\n   */\n  public function parseCode($scriptName, $content) {\n\t$parser = new pdb_Parser($scriptName, $content);\n\treturn $parser->parseScript();\n  }\n  private static function doEval($__pdb_Code) {\n\treturn eval (\"?>\".$__pdb_Code);\n  }\n  /**\n   * parse and execute script\n   * @return the script output\n   */\n  public function evalScript() {\n\t$code = $this->parseCode($this->getScriptName(), file_get_contents($this->getScriptName()));\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"eval:::$code,\".$this->getScriptName().\"\\n\");\n\tob_start();\n\tself::doEval ($code);\n\t$this->output = ob_get_contents();\n\tob_end_clean();\n\n\treturn $this->output;\n  }\n}\n\n/**\n * The java script debugger server daemon. Contains a debug session\n * and handles debug requests from the client.\n * @access private\n */\nclass pdb_JSDebugger {\n  /** The pdb_Session */\n  public $session;\n  private $id;\n \n  public $end;\n  private $includedScripts;\n  private $conn;\n  private $ignoreInterrupt;\n\n  const STEP_INTO = 1;\n  const STEP_OVER = 2;\n  const STEP_OUT = 3;\n  const GO    = 4;\n\n\n  private function getConnection($id) {\n\treturn new pdb_PollingServerConnection($id);\n  }\n\n  /**\n   * Create new PHP debugger using a given comm. ID\n   * @param int the communication address\n   */\n  public function pdb_JSDebugger($id) {\n\n\t$this->id = $id;\n\t$this->conn = $this->getConnection($id);\n\n\t$this->end = false;\n\t$this->session = null;\n\n\t$this->includedScripts = array();\n\n\t$this->ignoreInterrupt = false;\n\tset_error_handler(\"pdb_error_handler\");\n\tregister_shutdown_function(\"pdb_shutdown\");\n  }\n  public function setError($errno, $errfile, $errline, $errstr) {\n\thighlight_string(\"PHP error $errno: $errstr in $errfile line $errline\");\n  }\n  /**\n   * Return the current comm. ID\n   * @return int the communication address\n   */\n  public function getServerID() {\n\treturn $this->id;\n  }\n  /**\n   * Read data from the front end\n   * @return object the data \n   */\n  public function read() {\n\treturn $this->conn->read();\n  }\n  /**\n   * Write data to the front end\n   * @param object the data\n   */\n  public function write($data) {\n\t$data[\"serverID\"] = $this->getServerID();\n\tif (PDB_DEBUG) pdb_Logger::debug(\"->\".print_r($data, true));\n\treturn $this->conn->write($data);\n  }\n  private function ack() {\n\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t   \"seq\"=>$this->packet->seq));\n  }\n\n  private function getOutput() {\n\tif (!$this->session) return \"\";\n\n\tif (!$this->end) $output = $this->session->output = ob_get_contents();\n\treturn $this->session->output;\n  }\n\n  /**\n   * Handle requests from the front end\n   */\n  public function handleRequests() {\n\t$this->ignoreInterrupt = false;\n\n\twhile(!$this->end) {\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"handleRequests: accept\");\n   \n\t  if (!($this->packet = $this->read())) break; // ignore __destructors after shutdown\n\n\t  if (PDB_DEBUG) pdb_Logger::debug(\"handleRequests: done accept \".$this->packet->cmd);\n\n\t  switch($this->packet->cmd) {\n\t  case \"status\":\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"line\"=>$this->session->currentFrame->line, \n\t\t\t\t\t\t   \"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t   \"breakpoints\"=>$this->session->getBreakpoints()));\n\t\tbreak;\n\t  case \"extendedStatus\":\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"line\"=>$this->session->currentFrame->line, \n\t\t\t\t\t\t   \"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t   \"script\"=>$this->session->getCurrentViewHtmlScriptSource(),\n\t\t\t\t\t\t   \"breakpoints\"=>$this->session->getBreakpoints()));\n\t\tbreak;\n\t  case \"begin\":\n\t\tchdir (urldecode($this->packet->cwd));\n\t\t$this->session = new pdb_Session(urldecode($this->packet->scriptName));\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t   \"scriptName\"=>$this->packet->scriptName, \n\t\t\t\t\t\t   \"script\"=>$this->session->getCurrentViewHtmlScriptSource()));\n\n\t\t$this->session->evalScript();\n\t\t$this->end = true;\n\t\tbreak;\n\t  case \"stepNext\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_INTO;\n\t  case \"stepOver\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_OVER;\n\t  case \"go\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::GO;\n\t  case \"stepOut\":\n\t\tif ($this->end) break;\n\t\t$this->session->currentView = null;\n\t\t$this->ack();\n\t\treturn self::STEP_OUT;\n\t  case \"toggleBreakpoint\":\n\t\t$bp = $this->session->toggleBreakpoint($this->packet->breakpoint);\n\t\t$this->write($bp ? \n\t\t\t\t\t (array(\"cmd\"=>\"unsetBreakpoint\", \n\t\t\t\t\t\t\t\"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t\t\"scriptName\"=>$bp->scriptName, \n\t\t\t\t\t\t\t\"breakpoint\"=>$bp->breakpoint)) :\n\t\t\t\t\t (array(\"cmd\"=>\"setBreakpoint\", \n\t\t\t\t\t\t\t\"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t\t\"scriptName\"=>$this->session->getCurrentViewScriptName(), \n\t\t\t\t\t\t\t\"breakpoint\"=>$this->packet->breakpoint)));\n\t\tbreak;\n\t  case \"toolTip\":\n\t\t$name = urldecode($this->packet->item);\n\t\t$value = \"\";\n\t\tif ($name[0]=='$') {\n\t\t  $idx = substr($name, 1);\n\t\t  $env = (object) $this->session->currentFrame->vars;\n\t\t  $code = \"return \\$env->$idx;\";\n\t\t  $value = eval($code);\n\t\t  if (is_object($value)) {\n\t\t\t$value = get_class($value) . \" object\";\n\t\t  } elseif (is_array($value)) {\n\t\t\t$value = \"array[\".count($value).\"]\";\n\t\t  } elseif (!isset($value)) {\n\t\t\t$value = \"<undefined>\";\n\t\t  } else {\n\t\t\t$value = print_r($value, true);\n\t\t  }\n\t\t} else {\n\t\t  $value = $this->packet->item;\n\t\t}\n\t\t$this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t   \"seq\"=>$this->packet->seq,\n\t\t\t\t\t\t   \"item\"=>$this->packet->item,\n\t\t\t\t\t\t   \"value\"=>$value));\n\t\tbreak;\n\t  case \"switchView\":\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"switchView here\");\n\t\t$name = urldecode($this->packet->scriptName);\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"switchView $name\");\n\t\tif ($name[0]=='$') {\n\t\t  $idx = substr($name, 1);\n\t\t  $env = (object) $this->session->currentFrame->vars;\n\t\t  $code = \"return \\$env->$idx;\";\n\n\t\t  $pdb_dbg->end = true;\n\t\t  $value = eval($code);\n\t\t  $pdb_dbg->end = false;\n\n\t\t  $this->session->currentView = new pdb_VariableView($this->session->currentView, $name, $value);\n\t\t} else {\n\t\t  $this->end = true;\n\t\t  $value = self::resolveIncludePath(eval(\"return ${name};\"));\n\t\t  $this->end = false;\n\n\t\t  $this->session->currentView = new pdb_View($this->session->currentView, realpath($value));\n\t\t}\n\t\t$this->ack();\n\t\tbreak;\n\t  case \"backView\":\n\t\tif ($this->session->currentView)\n\t\t  $this->session->currentView = $this->session->currentView->parent;\n\t\t$this->ack();\n\t\tbreak;\n\t  case \"output\":\n\t\tif ($this->session) {\n\t\t  $this->write(array(\"cmd\"=>$this->packet->cmd,\n\t\t\t\t\t\t\t \"seq\"=>$this->packet->seq, \n\t\t\t\t\t\t\t \"output\"=>$this->getOutput()));\n\t\t} else {\n\t\t  $this->ack();\n\t\t}\n\t\tbreak;\n\t  case \"end\":\n\t\t$this->end();\n\t\tbreak;\n\t  default:\n\t\tif (PDB_DEBUG) pdb_Logger::debug(\"illegal packet: \" . print_r($this->packet, true));\n\t\texit(1);\n\t  }\n\t}\n\treturn self::GO;\n  }\n  public function end() {\n\t$this->session->currentView = null;\n\t$this->write(array(\"cmd\"=>\"end\",\n\t\t\t\t\t   \"seq\"=>$this->packet->seq, \n\t\t\t\t\t   \"output\"=>$this->getOutput()));\n\t$this->end = true;\n  }\n  /**\n   * shut down the current comm. channel\n   */\n  public function shutdown() {\n\t$this->conn->setOutput($this->getOutput());\n\t$this->conn->shutdown();\n  }\n\n  /**\n   * called at run-time for each frame\n   * @return the current frame\n   */\n  public function startCall($scriptName) {\n\t/* check for stepOver and stepOut */\n\t$stepNext = $this->session->currentFrame->stepNext == pdb_JSDebugger::STEP_INTO ? pdb_JSDebugger::STEP_INTO : false;\n\t\n\tif (PDB_DEBUG) pdb_Logger::debug(\"startCall::$scriptName, $stepNext\");\n\t$env = new pdb_Environment($this->session->currentFrame, $scriptName, $stepNext);\n\t$this->session->allFrames[] = $env;\n\treturn $env;\n  }\n\n  /**\n   * @access private\n   */\n  protected function resolveIncludePath($scriptName) {\n\tif (file_exists($scriptName)) return realpath($scriptName);\n\n\t$paths = explode(PATH_SEPARATOR, get_include_path());\n\t$name = $scriptName;\n\tforeach ($paths as $path) {\n\t  $x = substr($path, -1);\n\t  if ($x != \"/\" && $x != DIRECTORY_SEPARATOR) $path.=DIRECTORY_SEPARATOR;\n\t  $scriptName = realpath(\"${path}${name}\");\n\t  if ($scriptName) return $scriptName;\n\t}\n\ttrigger_error(\"file $scriptName not found\", E_USER_ERROR);\n  }\n  /**\n   * called at run-time for each included file\n   * @param string the script name\n   * @return string the code\n   */\n  public function startInclude($scriptName, $once) {\n\t$isDebugger = (basename($scriptName) == \"PHPDebugger.php\");\n\tif (!$isDebugger)\n\t  $scriptName = $this->resolveIncludePath($scriptName);\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"scriptName::$scriptName, $isDebugger\");\n\n\tif ($once && isset($this->includedScripts[$scriptName]))\n\t  $isDebugger = true;\n\n\t// include only from a top-level environment\n\t// initial line# and vars may be wrong due to a side-effect in step\n\t$this->session->currentFrame = $this->session->currentTopLevelFrame;\n\n\t$stepNext = $this->session->currentFrame->stepNext == pdb_JSDebugger::STEP_INTO ? pdb_JSDebugger::STEP_INTO : false;\n\t$this->session->currentFrame = new pdb_Environment($this->session->currentFrame, $scriptName, $stepNext);\n\t$this->session->allFrames[] = $this->session->currentFrame;\n\n\tif ($isDebugger) // do not debug self\n\t  $code = \"<?php ?>\";\n\telse\n\t  $code = $this->session->parseCode(realpath($scriptName), file_get_contents($scriptName));\n\n\t$this->session->currentTopLevelFrame = $this->session->currentFrame;\n\n\tif (PDB_DEBUG) pdb_Logger::debug(\"startInclude:::\".$this->session->currentTopLevelFrame . \" parent: \" . $this->session->currentTopLevelFrame->parent . \" code: \".$code);\n\n\tif ($once) $this->includedScripts[$scriptName] = true;\n\treturn $code;\n  }\n\n  /**\n   * called at run-time after the script has been included\n   */\n  public function endInclude() {\n\tif (PDB_DEBUG) pdb_Logger::debug(\"endInclude:::\".$this->session->currentTopLevelFrame . \"parent: \".$this->session->currentTopLevelFrame->parent);\n\n\t$this->session->currentFrame = $this->session->currentTopLevelFrame = \n\t  $this->session->currentTopLevelFrame->parent;\n  }\n\n  /**\n   * called at run-time for each line\n   * @param string the script name\n   * @param int the current line\n   * @param mixed the execution variables\n   */\n  public function step($scriptName, $line, $vars) {\n\tif ($this->ignoreInterrupt) return; // avoid spurious step calls from __destruct() method\n\t$this->ignoreInterrupt = true;\n\n\tif (PDB_DEBUG) pdb_Logger::logDebug(\"step: $scriptName @ $line\");\n\t// pull the current frame from the stack or the top-level environment\n\t$this->session->currentFrame = (isset($vars['__pdb_CurrentFrame'])) ? $vars['__pdb_CurrentFrame'] : $this->session->currentTopLevelFrame;\n\tunset($vars['__pdb_CurrentFrame']);\n\n\t$this->session->currentFrame->update($line, $vars);\n\n\tif ($this->session->hasBreakpoint($scriptName, $line)) {\n\t  $stepNext = $this->handleRequests();\n\t  if (PDB_DEBUG) pdb_Logger::logDebug(\"continue\");\n\n\t  /* clear all dynamic breakpoints */\n\t  foreach ($this->session->allFrames as $currentFrame)\n\t\t$currentFrame->stepNext = false;\n\n\t  /* set new dynamic breakpoint */\n\t  if ($stepNext != pdb_JSDebugger::GO) {\n\t\t$currentFrame = $this->session->currentFrame;\n\n\t\t/* break in current frame or frame below */\n\t\tif ($stepNext != pdb_JSDebugger::STEP_OUT)\n\t\t  $currentFrame->stepNext = $stepNext;\n\n\t\t/* or break in any parent */\n\t\twhile ($currentFrame = $currentFrame->parent) {\n\t\t  $currentFrame->stepNext = $stepNext;\n\t\t}\n\t  }\n\t}\n\n\t$this->ignoreInterrupt = false;\n\tif (PDB_DEBUG) pdb_Logger::logDebug(\"endStep: $scriptName @ $line\");\n  }\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_getDefinedVars($vars1, $vars2) {\n  if(isset($vars2)) $vars1['pbd_This'] = $vars2;\n\n  unset($vars1['__pdb_Code']);\t   // see pdb_Message::doEval()\n\n  return $vars1;  \n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_startCall($scriptName, $line) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) return $pdb_dbg->startCall($scriptName);\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_startInclude($scriptName, $once) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) return $pdb_dbg->startInclude($scriptName, $once);\n  else return \"\";\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_endInclude() {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) $pdb_dbg->endInclude();\n}\n\n/**\n * Convenience function called by the executor\n * @access private\n */\nfunction pdb_step($scriptName, $line, $vars) {\n  global $pdb_dbg;\n  if (isset($pdb_dbg)) $pdb_dbg->step($scriptName, $line, $vars);\n}\n\n/**\n * @access private\n */\nfunction pdb_error_handler($errno, $errstr, $errfile, $errline) {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error $errno: $errstr in $errfile line $errline\");\n  if ($pdb_dbg->end) return true;\n \n if (strncmp(basename($errfile),\"PHPDebugger\", 11)) \n   $pdb_dbg->setError($errno, $errfile, $errline, $errstr);\n\n  return true;\n}\n\n/**\n * @access private\n */\nfunction pdb_shutdown() {\n  global $pdb_dbg;\n  if (PDB_DEBUG) pdb_Logger::debug(\"PHP error: \".print_r(error_get_last(), true));\n  if ($pdb_dbg->end) return;\n\n  $error = error_get_last();\n  if ($error) {\n\t$pdb_dbg->setError($error['type'], $error['file'], $error['line'], $error['message']);\n\t$pdb_dbg->end();\n\t$pdb_dbg->shutdown();\n  }\n}\n\nif (PDB_DEBUG==2) {\n  $parser = new pdb_Parser($argv[1], file_get_contents($argv[1]));\n echo $parser->parseScript();\n exit (2);\n}\n\n/* * The JavaScript part, invoked after the debugger has been included() * */\nif (!isset($_SERVER['HTTP_XPDB_DEBUGGER'])) {\n\n  session_start();\n  header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n  header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n  header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  header(\"Pragma: no-cache\");\n  header(\"Content-Type: text/html\");\n?>\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>\nPHPDebugger version 1.0\n</title>\n<style type=\"text/css\">\n#tooltip {\n  background:#EFEFEF none repeat scroll 0 0;\n  height:auto;\n  width:auto;\n  min-width: 1px;\n  min-height: 1.5ex;\n  display: block;\n  border:1px solid black;\n  background-color:gray; color:white;\n  position:absolute;\n  text-align: center;\n  z-index:75;\n}\n.tt {\n  visibility: hidden;\n}\n.ttHover {\n  visibility: visible;\n}\n\n#run {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background:green url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwcXGXdF1DwAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABEUlEQVQoz62SoWvDUBDGfx0Rry6VzzUyg4lEVgYmRulfMVUKVWOqTFVWDULVbNxsTSETg8jOzm+QwcSL28ECmwhJGpqwwnrmfXfv7nvf3b2e+TQ//NMsgPRlQfoeQ14E9TBAe0uC9QyAeBoeQfK6IZjuqmC89tHeEoDFxP+TzKqQJK0JksPNlQ/QSWYBiJQVKShd+4DJa+f68hyA0f0M7fR5nKyaSiQTlHwgatB4JXkzB+q8C12RJfNwr522Vr4hy7PjtgOgbAWZKs6SRASt+gfZ8bPBcQck83B/Jl/Fre3S8AGlarx5Kuazu33o2I4atUq1LYi27cUNEj0cE925VdBxxxWOttJZXFrvFN/+jBPYL4uJYFb2zCiIAAAAAElFTkSuQmCC') no-repeat;\n}\n#terminate {\n  height: 13px;\n  width: 13px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background:red url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYrNECrm4EAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAwUlEQVQoz52SLQ7CQBCFvyaI4nYlciWSI3CEFkVQGAyOcBU0ClCARCKRHGFlN0HsuK4D0RRasWnKJOPel/fmJ/Ev/6ZnDQD89YzcL51iNc3R2ayC5HZkslx3Qs/97gcBEEBOh7jLfNGOh5RY8egQd7HiQcoG9HULPRZRwthagvdR4chapBUPQELVsZKAL8HUkBZApVVHN5FWuhoKzlEYg06HUaYwhuBcO55RGjbxWynANWdSWc5jte3+iCwHIPnn9z7J30SR7ayFNQAAAABJRU5ErkJggg==') no-repeat;\n}\n#stepInto {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYtD6f61SMAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAA6ElEQVQoz2N8//r9fwYKAQuMcWy6JlYFmq4lDIIqyYQNOTZdk8Gr8jpWBdvaNRkUPz9nkDSswWkII8w72Fyi6JjMoGmRw7Ct3ZDBKvM6Ye9gU3RsuiaDpkkywTBhIqjizwfiAxbdBQhDfqCIYXMxVkN+fGdgCCqaCzXkPYNXJoS9ri+ZeO84FV1nWNYUDfEKFC9rimZwKrpOWph41d1nWNaWzcDw5zvDsrZsBq+6+/ijOHn+MQbBzxBF73kVGeYmWiHSSZMiigHY1LIwMDAw/Di/lOHaC4giQYljDAxIhqC7AJtaRmrkHQBYX2Q4HZvQSwAAAABJRU5ErkJggg==') no-repeat;\n}\n#stepOver {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYsOAZcQW0AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABSklEQVQoz62TP0jDQBTGv5QMdSgYcEjGgEvHdsyYsW6Kg27SKeJki1PpEAShqJPYKTilHUS3dOyYbu1mhpZmERqIcIEOyRA4h9qaeCcK+uA43uPj9/7cO4GEhOKPJmYdMrMQTJ5A3nxGKO2okCsHkHbr30PIzII/slA9vMO2XGWEUTDG+PEMyXIBpdJiIWuAbjiIXkcYXJUZiHZ0A91wMOzuoVhS8hWRkFDHlCmN55RMbeqYMiUhYY5jypRMbUrjOaMpbGhpBLffgGZ43OFphge33wDSiD+TJAaQJqubY243016a5GKa4UFYP/HAVFFr+1zI8LaM/dNLoKh8BpMFnu9b0M8zkJ9sYKo4vrgGxC0gjdHrNDdJC79dqFrbR6/TZAAA+JXUH1xIy5WIlFRYJ1quoq9ti7ysycTGS/CxqbILZCC8uQn/8XfeAUbdtbmYIYl8AAAAAElFTkSuQmCC') no-repeat;\n}\n#stepOut {\n  height: 13px;\n  width: 17px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAANCAYAAABPeYUaAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYsF62NfDQAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABAUlEQVQoz62Tv2vCQBTHP5GsDoJDV8f8C44ZM+Y/EOnSgoOCQ4YOxVE6BH9MoZMdM3TI6CLcJNzmLULGCg4p6HBgoB0SFH9gKvYtj7v3fR/ufe/OSNbJD3dG6RaxGFuIsXUfhB04j0OEfwwyi/q+ZI94NjlsVG2cpyGRb1FvKQCMa54kywAZ9XE9eV78FoSjZ+yWun4S+dnH9aao+QAVBQC43hS2ktDvYLfVXz3RqCjYN5wCiiEpkOos5+vw7RhQbGyqIU2yDNhddfs70TlIFwxsAjTfBZVNnN1IuUbQqJ+i9nFJawJoOWGxykSVBwE5xPFiPl5rOC/xAXlBa/zH3/kFlslu4rTXaTUAAAAASUVORK5CYII=') no-repeat;\n}\n#output {\n  height: 13px;\n  width: 13px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  visibility: visible;\n  background: blue url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLCQYlB4EnoCoAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABCklEQVQoz42Rv0oDQRCHv4MJbCCFgoUHvkBKXyGPEDufwUokhdFGokWwt7IRbISkTHmvcIUPcUKK3eJgp1g4i92Ld4gxWw2z329+8ye7vF81pcs59J0fVUjpcsZaHCwq3QQBD8Ddcv6vYDF7BDxCACMGgPFov8iIgQACChKTVw9rvCrqPK52+FopPjodCBA0Og1H0el5Nv1VXcNPPDQGHAhBMcnpZrlOJFi1aK1orXhVNm/zxGnbXnRaXE//nEchcm17ZpB+ggImIaaDx9gMaBfhQeD95bVfWiLQi4W48vzkmM1ndfBx89OczG5t001ePBVUX1UPWt1OesLMbm2zA4Puhk3n7LucxQLfZ4Norb3ftQMAAAAASUVORK5CYII=') no-repeat;\n}\n#backView {\n  height: 13px;\n  width: 16px;\n  display: inline-block;\n  position: relative;\n  margin: 1px 10px 1px 10px;\n  visibility: visible;\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAANCAYAAACgu+4kAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwc3GnvIoSQAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABH0lEQVQoz5WToU4DQRCGvzZLspUn+wpIJLLyJDiQEBLMJZDAA1QgTlRUU1tXCY+A5BGoPHFiKkhukm4yiD3CNr3S9k8mu/l3Z+af2dme1GJ04HM6hBPP2f2S/9DvIj/KjNG4gUbZh36Xc15GURr2B3Abzi8Z+cQABTyqkdu8BTjP+WMV91KLSS22eMDMGjOrzNZfZuvKzCSxJlnN3p4wqcVclD3kYlJBWEJQCACrJLNvVwXnwWVoSErQbwUEwgq0+ZMa2JYfBuAV1aSJo7EwvzsFmpj515y2/WjNKbim5SN66Ry8P2dcTRexDGBWXDNwHSoc5GPZfoW8FGZFxs30FYCBi9xRc3BZCrPiNoZ2/rg5SIPMi+GO0030dv2FQ/EDM7CYPt7DsBMAAAAASUVORK5CYII=') no-repeat;\n}\n \n.normal {\n  background: transparent;\n}\n.selected {\n  background: yellow url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYQB8PJFa8AAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAABNElEQVQoz4WPsUsCYRjGf8YNNzTo7vJBDgUNHTSc4KBbro6ORy5KU5tN0VhjS+FfEDXaEFxbY9cQuQSfQ3BCwyck3At9YIOieZo98MAL7/vjed6MMWYMcH6aQxUqePsBaqvKOm0A6PcQpaDoh4QPdcL7E8xQr4EsmC9BLKg8NA8hm72kc+Xx9Hi2GhIryMgAIHZibw9aDZDRBZ3rIs9RZ7neTDK3C1RKUC336L0cc3tTR/fDFGTByLLdTagegMp36d7VAHAWQuSPzy0Mh5BM987vxSoojiGKQBUCgkYzBQGSzOdkBNEr4Pj45QBvtza7XkhCILGg+6A1FEttPL+F67oL6RPIcZFveJse72wHBEdtctncyhcz5tOM40GM1iHxR4jnN1F5L1U8DRkzFhGwTGo4/KsfXjWDCQ6TmRMAAAAASUVORK5CYII=') no-repeat;\n}\n.breakpointSet {\n  background: red url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9kLBwYOGJqAJ4UAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAA+0lEQVQoz5XSMUvDUBSG4bcXhyM4pFsudBE6GEfB5UKGZLOjq5uCIE7iPyjdxEXQoZC/4OgipIOQbqZDMW6OcbsZBO8Q0MEWkWJJ3vl7lsPpWGu/WOQqy8s44X2S8ukcmyL4Uczu6QnidZczOktUPqY8HB/Bh2OlLWEwTtAHg19kXwvuQwM1/7cBh08Z3Z0ABZCena8HAPViB6hymlHNcppUzXLKaYaq5gVtquYFitq1QtQO5fWDVsbrBygdGqTnNwLS89GhQSFCfJc0QvHNLYj8nFyHBjMcrQVmOEJH8d+PALD5M/nVNW+TFJwDEbajmODiEr2/t/pGbfoGcP1aToLr9OAAAAAASUVORK5CYII=') no-repeat;\n}\n\n#navigationBar {\n  display: block;\n  position: fixed;\n  top: 0px;\n  left: 0px;\n  height: 20px;\n  width: 100%;\n  z-index: 100;\n  background: #efefef;\n}\n#code {\n  display: block;\n  position: absolute;\n  left: 92px;\n  top: 22px;\n  z-index: 50;\n}\n\n.breakpoint {\n  display: inline;\n  position: absolute;\n  left: -92px;\n  width: 90px;\n  height: 13px;\n  background: #efefef;\n  overflow: hidden;\n}\n\n.linenumber {\n  display: inline-block;\n  position: relative;\n  width: 59px;\n  height: 13px;\n  text-align: right;\n  margin-right: 5px;\n  float: right;\n  color: black;\n  \n}\n.currentlineIndicator {\n  display: inline-block;\n  position: relative;\n  width: 13px;\n  height: 13px;\n  float: left;\n}\n.breakpointIndicator {\n  display: inline-block;\n  position: relative;\n  width: 13px;\n  height: 13px;\n  float: left;\n}\n</style>\n\n<script type=\"text/javascript\">\nvar http = createRequestObject();\nvar httpCtrl = createRequestObject();\nvar serverID = <?php echo pdb_JSDebuggerClient::getServerID(); ?>;\nvar scriptName = \"<?php echo pdb_JSDebuggerClient::getDebugScriptName(); ?>\";\nvar currentScriptName = \"\";\nvar cwd = \"<?php echo urlencode(getcwd()); ?>\";\nvar debuggerURL = \"<?php echo pdb_JSDebuggerClient::getDebuggerURL(); ?>\";\nvar date = \"<?php echo gmdate( 'D, d M Y H:i:s').' GMT'; ?>\";\nvar seq = 1;\n\nfunction getSeq() {\n return seq++;\n}\nfunction getServerID() {\n  return serverID;\n}\nfunction createRequestObject() {\n  var req;\n  var browser = navigator.appName;\n  if (browser == \"Microsoft Internet Explorer\") {\n\treq = new ActiveXObject(\"Microsoft.XMLHTTP\");\n  } else {\n\treq = new XMLHttpRequest();\n  }\n  return req;\n}\nfunction doCmd(text) {\n  switch(text.cmd) {\n  case 'stepNext': \n  case 'stepOver': \n  case 'go':\n  case 'switchView':\n  case 'backView':\n  case 'begin':\n  case 'stepOut':\tgetStatusCB(text); break;\n\n  case 'output':\tshowOutputCB(text); break;\n\n  case 'status':\tshowStatusCB(text); break;\n\n  case 'extendedStatus': showExtendedStatusCB(text); break;\n\n  case 'setBreakpoint':\tsetBreakpointCB(text); break;\n\n  case 'unsetBreakpoint':\tunsetBreakpointCB(text); break;\n\n  case 'term':\n  case 'end':\t\tendCB(text); break;\n  case 'toolTip':   showToolTipCB(text); break;\n\n  default: alert(\"illegal cmd: \" + text.cmd); break;\n  }\n}\nfunction hasClassName(element, className) {\n  var elementClassName = element.className;\n  if (elementClassName.length == 0) return false;\n  if (elementClassName == className ||\n    elementClassName.match(new RegExp(\"(^|\\\\s)\" + className + \"(\\\\s|$)\")))\n   return true;\n  return false;\n}\nif (document.getElementsByClassName == undefined) {\n document.getElementsByClassName = function(className) {\n\tvar children = document.body.getElementsByTagName('*');\n\tvar elements = [], child;\n\tfor (var i = 0, length = children.length; i < length; i++) {\n\t child = children[i];\n\t \n\t if (hasClassName(child, className)) {\n\telements.push(child);\n\t }\n\t}\n\treturn elements;\n }\n}\nfunction sendCmd(cmd) {\n  var url = debuggerURL;\n  data = cmd+\"&serverID=\"+getServerID()+\"&seq=\"+getSeq();\n\n  /* use synchronous requests to avoid out of order execution of \n\t step -> status -> extended status sequences */\n  http.open(\"POST\", url, false);\n  http.setRequestHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  http.setRequestHeader(\"Last-Modified\", date);\n  http.setRequestHeader(\"Pragma\", \"no-cache\");\n  http.setRequestHeader(\"Expires\", \"Sat, 1 Jan 2005 00:00:00 GMT\");\n  http.setRequestHeader(\"Content-Type\", \"application/x-www-form-urlencoded\");\n  http.setRequestHeader(\"Content-Length\", data.length);\n  http.setRequestHeader(\"XPDB-DEBUGGER\", 0);\n  /*\n  http.onreadystatechange = function() {\n\t if(http.readyState == 4 && http.status == 200) {\n\t   doCmd(eval(http.responseText));\n\t }\n  }\n  */\n\n  http.send(data);\n\n  doCmd(eval(http.responseText));\n}\nfunction startServer() { \n  var url = debuggerURL;\n\tdata = \"<?php echo pdb_JSDebuggerClient::getPostData(); ?>\";\n\tmethod = \"<?php echo $_SERVER['REQUEST_METHOD']; ?>\";\n  httpCtrl.open(method, url, true);\n  httpCtrl.setRequestHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n  httpCtrl.setRequestHeader(\"Last-Modified\", date);\n  httpCtrl.setRequestHeader(\"Pragma\", \"no-cache\");\n  httpCtrl.setRequestHeader(\"Expires\", \"Sat, 1 Jan 2005 00:00:00 GMT\");\n  httpCtrl.setRequestHeader(\"Content-Length\", data.length);\n  httpCtrl.setRequestHeader(\"Content-Type\", \"application/x-www-form-urlencoded\");\n  httpCtrl.setRequestHeader(\"XPDB-DEBUGGER\", getServerID());\n  httpCtrl.onreadystatechange = function() {\n\t if(httpCtrl.readyState == 4 && httpCtrl.status == 200) {\n\t  //alert(\"debugger exited. Debugger debug output: \" +httpCtrl.responseText);\n\t }\n  }\n  httpCtrl.send(data);\n}\nfunction stepNext() {\n  sendCmd(\"cmd=stepNext\");\n}\nfunction stepOver() {\n  sendCmd(\"cmd=stepOver\");\n}\nfunction stepOut() {\n  sendCmd(\"cmd=stepOut\");\n}\nfunction getStatusCB(cmd) {\n\tsendCmd(\"cmd=status\");\n}\n\nfunction loaded() {\n  startServer();\n  sendCmd(\"cmd=begin&scriptName=\"+encodeURI(scriptName)+\"&cwd=\"+encodeURI(cwd));\n}\nfunction toggleBreakpoint(el, event) {\n  sendCmd(\"cmd=toggleBreakpoint&breakpoint=\"+encodeURI(el.id));\n  return false;\n}\nfunction setBreakpointCB(cmd) {\n  document.getElementById(cmd.breakpoint).lastChild.className=\"breakpointIndicator breakpointSet\";\n}\nfunction unsetBreakpointCB(cmd) {\n  document.getElementById(cmd.breakpoint).lastChild.className=\"breakpointIndicator normal\";\n}\nfunction showOutputCB(cmd) {\n  currentScriptName = \"\";\n  document.getElementById(\"code\").innerHTML = cmd.output;\n  window.scrollTo(0, 0);\n}\n\nfunction doShowStatusCB(cmd) {\n  lines = document.getElementsByClassName(\"currentlineIndicator\");\n   if (lines.length == 0) {\n     window.scrollTo (0, 0);\n     return; // no lines to mark\n   }\n\n  lines = document.getElementsByClassName(\"currentlineIndicator selected\");\n  for (i=0; i<lines.length; i++) {\n\tline = lines[i];\n\tline.className = \"currentlineIndicator normal\";\n  }\n  for (i=0; i<cmd.breakpoints.length; i++) {\n\tbreakpoint = cmd.breakpoints[i];\n\tdocument.getElementById(breakpoint).lastChild.className=\"breakpointIndicator breakpointSet\";\n  }\n  currentLine = document.getElementById(\"bp_\"+(cmd.line)).firstChild;\n\n\tcurrentLine.className=\"currentlineIndicator selected\";\n\n\tcodeDiv = document.getElementById(\"code\");\n\tcodeLine = currentLine.parentNode;\n\ttoolsHeight = 30;\n\tif (codeLine.offsetTop < window.pageYOffset || codeLine.offsetTop + codeLine.clientHeight +toolsHeight > window.pageYOffset+window.innerHeight) {\n\t  window.scrollTo(0, codeLine.offsetTop + toolsHeight - window.innerHeight/2);\n\t}\n}\nfunction showStatusCB(cmd) {\n\tif (currentScriptName == cmd.scriptName)\n\t doShowStatusCB(cmd);\n\telse\n\t sendCmd(\"cmd=extendedStatus\"); // another round-trip \n}\nfunction showExtendedStatusCB(cmd) {\n\tcurrentScriptName = cmd.scriptName;\n\tdocument.getElementById(\"code\").innerHTML = cmd.script;\n\tdocument.title = cmd.scriptName;\n\n\tdoShowStatusCB(cmd);\n}\n\nfunction stepInto(el, event) {\n  sendCmd(\"cmd=stepNext\");\n  return false;\n}\nfunction stepOver(el, event) {\n  sendCmd(\"cmd=stepOver\");\n  return false;\n}\nfunction stepOut(el, event) {\n  sendCmd(\"cmd=stepOut\");\n  return false;\n}\nfunction end(el, event) {\n  sendCmd(\"cmd=end\");\n  return false;\n}\nfunction endCB(cmd) {\n  document.body.innerHTML = cmd.output;\n}\nfunction go(el, event) {\n  sendCmd(\"cmd=go\");\n  return false;\n}\nfunction switchView(data) {\n  data = encodeURI(data);\n  sendCmd(\"cmd=switchView&scriptName=\"+data);\n  return false;\n}\nfunction backView(el, event) {\n  sendCmd(\"cmd=backView\");\n  return false;\n}\nfunction output(el, event) {\n  sendCmd(\"cmd=output\");\n  return false;\n}\n\nvar currentEl, tooltipItem;\nvar currentX, currentY;\nvar timer;\nvar tt;\nfunction getToolTip() {\n  if(tt) return tt;\n  return tt = document.getElementById(\"tooltip\");\n}\nfunction mouseout(el, event) {\n  getToolTip().className = \"tt\";\n  if (timer) {\n\twindow.clearTimeout(timer);\n\ttimer = null;\n  }\n  return true;\n}\nfunction mousemove(el, event) {\n  if (timer) {\n\twindow.clearTimeout(timer);\n\tgetToolTip().className = \"tt\";\n\ttimer = null;\n  }\n  if (getEventSource(event).parentNode.className==\"breakpoint\") return true;\n  el = getEventSource(event);\n  if (el.nodeName !=\"SPAN\") return true;\n\n  currentEl = el;\n  currentX = getEventX(event) + window.pageXOffset;\n  currentY = getEventY(event) + window.pageYOffset;\n  timer = window.setTimeout(\"showToolTip()\", 600);\n  return false;\n}\nfunction toolTipCmd(el) {\n  el=encodeURI(el);\n  sendCmd(\"cmd=toolTip&item=\"+el);\n  return false;\n}\nfunction showToolTip() {\n  el = currentEl;\n  if (el && el.firstChild && el.firstChild.data) {\n\tdata = trim(el.firstChild.data);\n\twhile (el && el.previousSibling && el.previousSibling.firstChild && el.previousSibling.firstChild.data && trim(el.previousSibling.firstChild.data)=='->') {\n\t  el = el.previousSibling.previousSibling;\n\t  if (el && el.firstChild && el.firstChild.data) data = trim(el.firstChild.data)+\"->\"+data;\n\t}\n  }\n    toolTipCmd(data);\n}\nfunction showToolTipCB(cmd) {\n  tt = getToolTip();\n  if(tooltipItem) tt.removeChild(tooltipItem);\n  tooltipItem = (document.createTextNode(cmd.value));\n  tt.appendChild(tooltipItem);\n  tt.style.top=(currentY+10) + \"px\";\n  tt.style.left=(currentX+10) + \"px\";\n  tt.className = \"ttHover\";\n\n}\nfunction trim(str) {\n  nbspChar = String.fromCharCode(160);\n  return str.replace(/^\\s*/, \"\").replace(/\\s*$/, \"\").replace(nbspChar,\"\");\n}\nfunction getEventSource(event) {\n if (event.target != undefined) return event.target;\n return event.srcElement;\n}\nfunction getEventX(event) {\n  if (event.clientX != undefined) return event.clientX;\n  return event.offsetX;\n}\nfunction getEventY(event) {\n  if (event.clientY != undefined) return event.clientY;\n  return event.offsetY;\n}\nfunction mousedown(el, event) {\n  getToolTip().className = \"tt\";\n\n  if (getEventSource(event).parentNode.className==\"breakpoint\") return true;\n  el = getEventSource(event);\n  if (el && el.firstChild && el.firstChild.data) {\n\tdata = trim(el.firstChild.data);\n\twhile (el && el.previousSibling && el.previousSibling.firstChild && el.previousSibling.firstChild.data && trim(el.previousSibling.firstChild.data)=='->') {\n\t  el = el.previousSibling.previousSibling;\n\t  if (el && el.firstChild && el.firstChild.data) data = trim(el.firstChild.data)+\"->\"+data;\n\t}\n\tswitchView(data);\n  }\n  return false;\n}\n</script>\n\n</head>\n<body>\n\n<div id=\"navigationBar\">\n<a id=\"run\" onmousedown=\"return go(this, event);\"></a>\n<a id=\"terminate\" onmousedown=\"return end(this, event);\"></a>\n<a id=\"stepInto\" onmousedown=\"return stepInto(this, event);\"></a>\n<a id=\"stepOver\" onmousedown=\"return stepOver(this, event);\"></a>\n<a id=\"stepOut\" onmousedown=\"return stepOut(this, event);\"></a>\n<a id=\"output\" onmousedown=\"return output(this, event);\"></a>\n<a id=\"backView\" onmousedown=\"return backView(this, event);\"></a>\n</div>\n <div onmouseout=\"return mouseout(this, event);\" onmousemove=\"return mousemove(this, event);\" onmousedown=\"return mousedown(this, event);\">\n <div id=\"code\">\n<span>loading...\n<noscript>failed! Please enable JavaScript and try again.</noscript>\n</span>\n</div>\n<div id=\"tooltip\" class=\"tt\" />\n</div>\n<script type=\"text/javascript\">\n loaded();\n</script>\n</body>\n</html>\n<?php\n exit (0);\n} elseif (($serverID = $_SERVER['HTTP_XPDB_DEBUGGER']) != \"0\") {\n/* * The back end part, invoked from JavaScript using a json call. $serverID is a uniq ID generated from JavaScript * */\n header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n header(\"Pragma: no-cache\");\n header(\"Content-Encoding: identity\");\n $pdb_dbg = new pdb_JSDebugger((int)$serverID);\n $pdb_dbg->handleRequests();\n $pdb_dbg->shutdown();\n if (PDB_DEBUG) pdb_Logger::debug(\"SERVER TERMINATED!\");\n exit(0);\n} else {\n/* * The front end part, invoked from JavaScript using json calls * */\n header(\"Expires: Sat, 1 Jan 2005 00:00:00 GMT\");\n header(\"Last-Modified: \".gmdate( \"D, d M Y H:i:s\").\" GMT\");\n header(\"Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\");\n header(\"Pragma: no-cache\");\n header(\"Content-Encoding: identity\");\n pdb_JSDebuggerClient::handleRequest ($_POST);\n exit(0);\n}\n?>\n".getBytes();
}

