/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

class Session
implements ISession {
    protected Map map;
    protected String name;
    private static int sessionCount = 0;
    boolean isNew = true;
    protected long creationTime;
    protected long lastAccessedTime;
    protected long timeout;

    public Object get(Object ob) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.get(ob);
    }

    public void put(Object ob1, Object ob2) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.put(ob1, ob2);
    }

    public Object remove(Object ob) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.remove(ob);
    }

    Session(String name) {
        this.name = name;
        ++sessionCount;
        this.map = Collections.synchronizedMap(new HashMap());
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
        this.timeout = 1440000L;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout * 1000;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public int getSessionCount() {
        return sessionCount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        --sessionCount;
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            if (JavaBridge.sessionHash != null) {
                JavaBridge.sessionHash.remove(this.name);
            }
        }
    }

    public void invalidate() {
        this.destroy();
    }

    public void putAll(Map vars) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.putAll(vars);
    }

    public Map getAll() {
        this.lastAccessedTime = System.currentTimeMillis();
        return new HashMap(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void expire() {
        if (JavaBridge.sessionHash == null) {
            return;
        }
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Iterator e = JavaBridge.sessionHash.values().iterator();
            while (e.hasNext()) {
                Session ref = (Session)e.next();
                if (ref.timeout <= 0L || ref.lastAccessedTime + ref.timeout > System.currentTimeMillis()) continue;
                --sessionCount;
                e.remove();
                if (Util.logLevel <= 3) continue;
                Util.logDebug("Session " + ref.name + " expired.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        if (JavaBridge.sessionHash == null) {
            return;
        }
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Iterator e = JavaBridge.sessionHash.values().iterator();
            while (e.hasNext()) {
                Session ref = (Session)e.next();
                --sessionCount;
                e.remove();
                if (Util.logLevel <= 3) continue;
                Util.logDebug("Session " + ref.name + " destroyed.");
            }
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }
}

