/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContextFactory;

public class ContextRunner
implements Runnable {
    protected IContextFactory ctx;
    protected Request request;
    protected InputStream in;
    protected OutputStream out;
    protected AbstractChannel channel;
    protected ILogger logger;
    protected byte shortPathHeader;

    public ContextRunner(AbstractChannel channel, ILogger logger) {
        this.channel = channel;
        this.logger = logger;
    }

    protected int readLength() throws IOException {
        byte[] buf = new byte[1];
        this.in.read(buf);
        this.shortPathHeader = (byte)(0xFF & buf[0]);
        buf = new byte[2];
        this.in.read(buf);
        return 0xFF & buf[0] | 0xFF00 & buf[1] << 8;
    }

    protected String readString(int length) throws IOException {
        byte[] buf = new byte[length];
        this.in.read(buf);
        return new String(buf, "ASCII");
    }

    protected String readName() throws IOException {
        return this.readString(this.readLength());
    }

    protected void setIO(JavaBridge bridge, InputStream in, OutputStream out) {
        bridge.request.reset();
        bridge.in = in;
        bridge.out = out;
    }

    protected boolean init() throws IOException {
        if (Util.logLevel > 4) {
            Util.logDebug("starting a new ContextRunner " + this);
        }
        this.out = this.channel.getOuptutStream();
        this.in = this.channel.getInputStream();
        int c = this.in.read();
        if (c != 127) {
            if (c == -1) {
                return false;
            }
            try {
                this.out.write(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Protocol violation");
        }
        this.out.write(0);
        this.out.flush();
        String name = this.readName();
        this.ctx = ContextFactory.get(name);
        if (this.ctx == null) {
            throw new IOException("No context available for: " + name + ". Please make sure that your script does not exceed php.java.bridge.max_wait, currently set to: " + Util.MAX_WAIT);
        }
        JavaBridge bridge = this.ctx.getBridge();
        if (Util.logLevel > 4) {
            Util.logDebug(this.ctx + " created new thread");
        }
        if (this.shortPathHeader != -1) {
            bridge.request = new Request(bridge);
            bridge.request.init(this.shortPathHeader);
        }
        this.setIO(bridge, this.in, this.out);
        this.request = bridge.request;
        this.ctx.initialize();
        return true;
    }

    public void run() {
        try {
            if (this.init()) {
                this.request.handleRequests();
            } else {
                Util.warn("context runner init failed");
            }
        }
        catch (IOException e) {
            if (Util.logLevel > 4) {
                Util.printStackTrace(e);
            }
        }
        catch (Exception e) {
            Util.printStackTrace(e);
        }
        finally {
            if (this.ctx != null) {
                this.ctx.destroy();
            }
            this.channel.shutdown();
        }
    }
}

