/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectionException;
import php.java.bridge.http.FCGIConnectionInputStream;
import php.java.bridge.http.IFCGIProcessFactory;

public class FCGIInputStream
extends FCGIConnectionInputStream {
    private final IFCGIProcessFactory processFactory;
    private StringBuffer error;
    private byte[] header = new byte[8];

    public FCGIInputStream(IFCGIProcessFactory processFactory) {
        this.processFactory = processFactory;
    }

    public StringBuffer getError() {
        return this.error;
    }

    public String checkError() {
        return this.error == null ? null : Util.checkError(this.error.toString());
    }

    public int read(byte[] buf) throws FCGIConnectionException {
        try {
            return this.doRead(buf);
        }
        catch (FCGIConnectionException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw new FCGIConnectionException(this.connection, e);
        }
    }

    public int doRead(byte[] buf) throws IOException {
        int i;
        int n = 0;
        while ((i = this.read(this.header, n, 8 - n)) > 0) {
            n += i;
        }
        if (8 != n) {
            throw new IOException("Protocol error");
        }
        int type = this.header[1] & 0xFF;
        int contentLength = (this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF;
        int paddingLength = this.header[6] & 0xFF;
        switch (type) {
            case 6: 
            case 7: {
                n = 0;
                while ((i = this.read(buf, n, contentLength - n)) > 0) {
                    n += i;
                }
                if (n != contentLength) {
                    throw new IOException("Protocol error while reading FCGI data");
                }
                if (type == 7) {
                    String s = new String(buf, 0, n, "ASCII");
                    this.processFactory.log(s);
                    contentLength = 0;
                    if (this.error == null) {
                        this.error = new StringBuffer(s);
                    } else {
                        this.error.append(s);
                    }
                }
                if (paddingLength > 0) {
                    byte[] b = new byte[paddingLength];
                    n = 0;
                    while ((i = this.read(b, n, b.length - n)) > 0) {
                        n += i;
                    }
                    if (n != paddingLength) {
                        throw new IOException("Protocol error while reading FCGI padding");
                    }
                }
                return contentLength;
            }
            case 3: {
                n = 0;
                while ((i = this.read(buf, n, contentLength - n)) > 0) {
                    n += i;
                }
                if (n != contentLength) {
                    throw new IOException("Protocol error while reading EOF data");
                }
                if (paddingLength > 0 && (n = super.read(buf, 0, paddingLength)) != paddingLength) {
                    throw new IOException("Protocol error while reading EOF padding");
                }
                return -1;
            }
        }
        throw new IOException("Received unknown type");
    }
}

