/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import php.java.bridge.NotImplementedException;
import php.java.bridge.http.FCGIConnectionException;
import php.java.bridge.http.FCGIConnectionOutputStream;
import php.java.bridge.http.FCGIUtil;

public class FCGIOutputStream
extends FCGIConnectionOutputStream {
    public void write(int type, byte[] buf) throws FCGIConnectionException {
        this.write(type, buf, buf.length);
    }

    public void write(int type, byte[] buf, int length) throws FCGIConnectionException {
        int requestId = 1;
        byte[] header = new byte[]{1, (byte)type, (byte)(requestId >> 8 & 0xFF), (byte)(requestId & 0xFF), -1, -1, 0, 0};
        int contentLength = length;
        int pos = 0;
        while (pos + 65535 <= contentLength) {
            this.write(header);
            this.write(buf, pos, 65535);
            pos += 65535;
        }
        contentLength = length % 65535;
        header[4] = (byte)(contentLength >> 8 & 0xFF);
        header[5] = (byte)(contentLength & 0xFF);
        this.write(header);
        this.write(buf, pos, contentLength);
    }

    public void writeBegin() throws FCGIConnectionException {
        int role = 1;
        byte[] body = new byte[]{(byte)(role >> 8 & 0xFF), (byte)(role & 0xFF), 1, 0, 0, 0, 0, 0};
        this.write(1, body);
    }

    private void writeLength(ByteArrayOutputStream out, int keyLen) throws IOException {
        if (keyLen < 128) {
            out.write((byte)keyLen);
        } else {
            byte[] b = new byte[]{(byte)((keyLen >> 24 | 0x80) & 0xFF), (byte)(keyLen >> 16 & 0xFF), (byte)(keyLen >> 8 & 0xFF), (byte)keyLen};
            out.write(b);
        }
    }

    public void writeParams(Map props) throws FCGIConnectionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Iterator ii = props.keySet().iterator();
        while (ii.hasNext()) {
            Object k = ii.next();
            Object v = props.get(k);
            String key = String.valueOf(k);
            String val = String.valueOf(v);
            int keyLen = key.length();
            int valLen = val.length();
            if (keyLen == 0 || valLen == 0) continue;
            try {
                this.writeLength(out, keyLen);
                this.writeLength(out, valLen);
                out.write(key.getBytes("ASCII"));
                out.write(val.getBytes("ASCII"));
            }
            catch (IOException e) {
                throw new FCGIConnectionException(this.connection, e);
            }
        }
        this.write(4, out.toByteArray());
        this.write(4, FCGIUtil.FCGI_EMPTY_RECORD);
    }

    public void write(int b) {
        throw new NotImplementedException();
    }
}

