/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.HeaderParser;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.WriterOutputStream;
import php.java.script.CloneableScript;
import php.java.script.CompiledPhpScript;
import php.java.script.Continuation;
import php.java.script.IPhpScriptContext;
import php.java.script.IPhpScriptEngine;
import php.java.script.PhpScriptContext;
import php.java.script.PhpScriptContextFactory;
import php.java.script.PhpScriptEngineFactory;
import php.java.script.PhpScriptWriter;
import php.java.script.ResultProxy;

abstract class AbstractPhpScriptEngine
extends AbstractScriptEngine
implements IPhpScriptEngine,
Compilable,
FileFilter,
CloneableScript {
    protected Object script = null;
    protected Object scriptClosure = null;
    protected Continuation continuation = null;
    protected Map env = null;
    protected IContextFactory ctx = null;
    private ScriptEngineFactory factory = null;
    protected ResultProxy resultProxy;
    protected File compilerOutputFile;
    private boolean isCompiled;
    static final Reader DUMMY_READER = new Reader(){

        public void close() throws IOException {
            AbstractPhpScriptEngine.throwNoOutputFile();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            AbstractPhpScriptEngine.throwNoOutputFile();
            return 0;
        }
    };
    private static final String STANDARD_HEADER = new String("<?php require_once(\"/java/Java.inc\");$java_bindings = java_context()->getBindings(100);$java_scriptname = @java_values($java_bindings['javax.script.filename']);if(!isset($argv)) $argv = @java_values($java_bindings['javax.script.argv']);if(!isset($argv)) $argv=array();\n$_SERVER['SCRIPT_FILENAME'] =  isset($java_scriptname) ? $java_scriptname : '';array_unshift($argv, $_SERVER['SCRIPT_FILENAME']);if (!isset($argc)) $argc = count($argv);$_SERVER['argv'] = $argv;?>");
    private static final String STANDARD_HEADER_EMBEDDED = new String("<?php $java_bindings = java_context()->getBindings(100);$java_scriptname = @java_values($java_bindings['javax.script.filename']);if(!isset($argv)) $argv = @java_values($java_bindings['javax.script.argv']);if(!isset($argv)) $argv=array();\n$_SERVER['SCRIPT_FILENAME'] =  isset($java_scriptname) ? $java_scriptname : '';array_unshift($argv, $_SERVER['SCRIPT_FILENAME']);if (!isset($argc)) $argc = count($argv);$_SERVER['argv'] = $argv;?>");
    private String cachedSimpleStandardHeader;
    private ScriptContext ctxCache;
    private String cachedEmbeddedStandardHeader;

    static HashMap getProcessEnvironment() {
        return Util.COMMON_ENVIRONMENT;
    }

    public AbstractPhpScriptEngine(PhpScriptEngineFactory factory) {
        this.factory = factory;
        this.getContext();
    }

    protected void setStandardEnvironmentValues(Map env) {
        env.put("X_JAVABRIDGE_CONTEXT", this.ctx.getId());
    }

    protected void addNewContextFactory() {
        this.ctx = PhpScriptContextFactory.addNew((IContext)this.getContext());
    }

    protected ContextServer getContextServer() {
        return ((IPhpScriptContext)this.getContext()).getContextServer();
    }

    protected void setNewContextFactory() {
        this.env = (Map)AbstractPhpScriptEngine.getProcessEnvironment().clone();
        this.addNewContextFactory();
        ContextServer contextServer = this.getContextServer();
        AbstractChannelName channelName = contextServer.getChannelName(this.ctx);
        if (channelName != null) {
            this.env.put("X_JAVABRIDGE_REDIRECT", channelName.getName());
            this.ctx.getBridge();
            contextServer.start(channelName, Util.getLogger());
        }
        this.setStandardEnvironmentValues(this.env);
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.evalPhp(reader, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evalPhp(Reader reader, ScriptContext context) throws ScriptException {
        if (this.isCompiled) {
            throw new IllegalStateException("already compiled");
        }
        ScriptContext current = this.getContext();
        if (current != context) {
            try {
                this.setContext(context);
                Object object = this.doEvalPhp(reader, context);
                return object;
            }
            finally {
                this.setContext(current);
            }
        }
        return this.doEvalPhp(reader, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evalCompiledPhp(Reader reader, ScriptContext context) throws ScriptException {
        ScriptContext current = this.getContext();
        if (current != context) {
            try {
                this.setContext(context);
                Object object = this.doEvalCompiledPhp(reader, context);
                return object;
            }
            finally {
                this.setContext(current);
            }
        }
        return this.doEvalCompiledPhp(reader, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compilePhp(Reader reader) throws IOException {
        this.isCompiled = true;
        if (this.compilerOutputFile == null) {
            this.compilerOutputFile = File.createTempFile("compiled-", ".php", null);
        }
        FileWriter writer = new FileWriter(this.compilerOutputFile);
        char[] buf = new char[8192];
        Reader localReader = this.getLocalReader(reader, true);
        try {
            int c;
            while ((c = localReader.read(buf)) > 0) {
                writer.write(buf, 0, c);
            }
            writer.close();
        }
        finally {
            localReader.close();
        }
    }

    private void updateGlobalEnvironment(ScriptContext context) throws IOException {
        if (this.isCompiled) {
            if (this.compilerOutputFile == null) {
                throw new NullPointerException("SCRIPT_FILENAME");
            }
            this.env.put("SCRIPT_FILENAME", this.compilerOutputFile.getCanonicalPath());
        }
    }

    protected Continuation getContinuation(Reader reader, ScriptContext context) throws IOException {
        HeaderParser headerParser = HeaderParser.DEFAULT_HEADER_PARSER;
        IPhpScriptContext phpScriptContext = (IPhpScriptContext)context;
        this.updateGlobalEnvironment(context);
        OutputStream out = ((PhpScriptWriter)context.getWriter()).getOutputStream();
        OutputStream err = ((PhpScriptWriter)context.getErrorWriter()).getOutputStream();
        if (out instanceof WriterOutputStream) {
            headerParser = new SimpleHeaderParser((WriterOutputStream)out);
        }
        this.resultProxy = new ResultProxy(this);
        Continuation kont = phpScriptContext.createContinuation(reader, this.env, out, err, headerParser, this.resultProxy, Util.getLogger(), this.isCompiled);
        phpScriptContext.setContinuation(kont);
        phpScriptContext.startContinuation();
        return kont;
    }

    protected abstract Object doEvalPhp(Reader var1, ScriptContext var2) throws ScriptException;

    protected abstract Object doEvalCompiledPhp(Reader var1, ScriptContext var2) throws ScriptException;

    protected abstract Reader getLocalReader(Reader var1, boolean var2) throws IOException;

    protected final Object doEval(Reader reader, ScriptContext context) throws Exception {
        this.continuation = this.getContinuation(reader, context);
        return this.continuation.getPhpScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null) {
            return this.evalPhp(null, context);
        }
        script = script.trim();
        StringReader localReader = new StringReader(script);
        try {
            Object object = this.eval((Reader)localReader, context);
            return object;
        }
        finally {
            try {
                ((Reader)localReader).close();
            }
            catch (IOException iOException) {}
        }
    }

    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public void release() {
        if (this.continuation != null) {
            try {
                this.continuation.release();
                this.ctx.releaseManaged();
            }
            catch (InterruptedException e) {
                return;
            }
            this.ctx = null;
            this.continuation = null;
            this.script = null;
            this.scriptClosure = null;
            try {
                this.getContext().getWriter().flush();
            }
            catch (Exception e) {
                Util.printStackTrace((Throwable)e);
            }
            try {
                this.getContext().getErrorWriter().flush();
            }
            catch (Exception e) {
                Util.printStackTrace((Throwable)e);
            }
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public void close() throws IOException {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript compile(String script) throws ScriptException {
        StringReader reader = new StringReader(script);
        try {
            CompiledScript compiledScript = this.compile(reader);
            return compiledScript;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Util.printStackTrace((Throwable)e);
            }
        }
    }

    static final void throwNoOutputFile() {
        throw new IllegalStateException("No compilation output file has been set!");
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            this.compilePhp(reader);
            return new CompiledPhpScript(this);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        return new PhpScriptContext(super.getScriptContext(bindings));
    }

    public ScriptContext getContext() {
        if (this.ctxCache == null) {
            this.ctxCache = super.getContext();
            if (!(this.ctxCache instanceof IPhpScriptContext)) {
                if (this.ctxCache == null) {
                    this.ctxCache = new SimpleScriptContext();
                }
                this.ctxCache = new PhpScriptContext(this.ctxCache);
                super.setContext(this.ctxCache);
            }
        }
        return this.ctxCache;
    }

    public void setContext(ScriptContext context) {
        super.setContext(context);
        this.ctxCache = null;
        this.getContext();
    }

    private String getSimpleStandardHeader(String filePath) {
        if (this.cachedSimpleStandardHeader != null) {
            return this.cachedSimpleStandardHeader;
        }
        StringBuffer buf = new StringBuffer(STANDARD_HEADER);
        buf.insert(20, filePath);
        this.cachedSimpleStandardHeader = buf.toString();
        return this.cachedSimpleStandardHeader;
    }

    public boolean accept(File outputFile) {
        this.compilerOutputFile = outputFile;
        return true;
    }

    private String getEmbeddedStandardHeader(String filePath) throws IOException {
        if (this.cachedEmbeddedStandardHeader != null) {
            return this.cachedEmbeddedStandardHeader;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Field f = Util.JAVA_INC.getField("bytes");
            byte[] buf = (byte[])f.get(Util.JAVA_INC);
            out.write(buf);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(STANDARD_HEADER_EMBEDDED);
            writer.close();
            this.cachedEmbeddedStandardHeader = out.toString("ASCII");
            return this.cachedEmbeddedStandardHeader;
        }
        catch (Exception e) {
            IOException ex = new IOException("Cannot create standard header");
            ex.initCause(e);
            throw ex;
        }
    }

    protected String getStandardHeader(String filePath) throws IOException {
        return filePath == null ? this.getEmbeddedStandardHeader(filePath) : this.getSimpleStandardHeader(filePath);
    }

    public Object clone() {
        AbstractPhpScriptEngine other = (AbstractPhpScriptEngine)this.getFactory().getScriptEngine();
        other.isCompiled = this.isCompiled;
        other.compilerOutputFile = this.compilerOutputFile;
        return other;
    }

    private final class SimpleHeaderParser
    extends HeaderParser {
        private WriterOutputStream writer;

        public SimpleHeaderParser(WriterOutputStream writer) {
            this.writer = writer;
        }

        public void parseHeader(String header) {
            if (header == null) {
                return;
            }
            int idx = header.indexOf(58);
            if (idx == -1) {
                return;
            }
            String key = header.substring(0, idx).trim().toLowerCase();
            String val = header.substring(idx + 1).trim();
            this.addHeader(key, val);
        }

        public void addHeader(String key, String val) {
            if (val != null && key.equals("content-type")) {
                int idx = val.indexOf(59);
                if (idx == -1) {
                    return;
                }
                String enc = val.substring(idx + 1).trim();
                if ((idx = enc.indexOf(61)) == -1) {
                    return;
                }
                enc = enc.substring(idx + 1);
                this.writer.setEncoding(enc);
            }
        }
    }
}

