/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import php.java.bridge.Util;
import php.java.bridge.http.HeaderParser;
import php.java.script.IScriptReader;

public class URLReader
extends Reader
implements IScriptReader {
    private URL url;
    private HttpURLConnection conn;
    private HostnameVerifier hostNameVerifier;
    private SSLSocketFactory sslSocketFactory;

    private HostnameVerifier getHostNameVerifier() {
        if (this.hostNameVerifier != null) {
            return this.hostNameVerifier;
        }
        this.hostNameVerifier = new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        return this.hostNameVerifier;
    }

    private SSLSocketFactory getSslSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        X509TrustManager tm = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        KeyManager[] km = null;
        TrustManager[] tma = new X509TrustManager[]{tm};
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(km, tma, new SecureRandom());
        this.sslSocketFactory = sslContext.getSocketFactory();
        return this.sslSocketFactory;
    }

    public URLReader(URL url) throws UnknownHostException, IOException {
        this.url = url;
        this.conn = (HttpURLConnection)url.openConnection();
        if (this.conn instanceof HttpsURLConnection) {
            this.allowSelfSignedCertificates();
        }
        this.conn.setDoInput(true);
        this.conn.setRequestMethod("GET");
    }

    public URLReader(HttpURLConnection conn) {
        this.conn = conn;
    }

    private void allowSelfSignedCertificates() {
        HttpsURLConnection xcon = (HttpsURLConnection)this.conn;
        try {
            xcon.setSSLSocketFactory(this.getSslSocketFactory());
        }
        catch (KeyManagementException e) {
            Util.printStackTrace((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Util.printStackTrace((Throwable)e);
        }
        xcon.setHostnameVerifier(this.getHostNameVerifier());
    }

    public URL getURL() {
        return this.url;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IllegalStateException("Use urlReader.read(Hashtable, OutputStream) or use a FileReader() instead.");
    }

    private void appendListValues(StringBuffer buf, List list) {
        Iterator ii = list.iterator();
        while (ii.hasNext()) {
            buf.append(ii.next());
            if (!ii.hasNext()) continue;
            buf.append("; ");
        }
    }

    public void read(Map env, OutputStream out, HeaderParser headerParser) throws IOException {
        InputStream natIn = null;
        try {
            int count;
            byte[] buf = new byte[8192];
            for (int i = 0; i < IScriptReader.HEADER.length; ++i) {
                String key = IScriptReader.HEADER[i];
                String val = (String)env.get(key);
                if (val == null) continue;
                this.conn.setRequestProperty(key, val);
            }
            String overrideHosts = (String)env.get("X_JAVABRIDGE_OVERRIDE_HOSTS");
            if (overrideHosts != null) {
                this.conn.setRequestProperty("X_JAVABRIDGE_OVERRIDE_HOSTS", overrideHosts);
                this.conn.setRequestProperty("X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT", overrideHosts);
            }
            natIn = this.conn.getInputStream();
            if (headerParser != HeaderParser.DEFAULT_HEADER_PARSER) {
                StringBuffer sbuf = new StringBuffer();
                Iterator<Map.Entry<String, List<String>>> ii = this.conn.getHeaderFields().entrySet().iterator();
                while (ii.hasNext()) {
                    Map.Entry<String, List<String>> e = ii.next();
                    List<String> list = e.getValue();
                    if (list.size() == 1) {
                        headerParser.addHeader(String.valueOf(e.getKey()), String.valueOf(list.get(0)));
                        continue;
                    }
                    this.appendListValues(sbuf, list);
                    headerParser.addHeader(String.valueOf(e.getKey()), sbuf.toString());
                    sbuf.setLength(0);
                }
            }
            while ((count = natIn.read(buf)) > 0) {
                out.write(buf, 0, count);
            }
        }
        catch (IOException x) {
            Util.printStackTrace((Throwable)x);
            throw x;
        }
        finally {
            if (natIn != null) {
                try {
                    natIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() throws IOException {
    }

    public String toString() {
        return String.valueOf(this.url);
    }
}

