/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.script.ScriptContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.ILogger;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Util;
import php.java.bridge.http.Context;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.HeaderParser;
import php.java.bridge.http.WriterOutputStream;
import php.java.script.Continuation;
import php.java.script.IPhpScriptContext;
import php.java.script.PhpScriptContextDecorator;
import php.java.script.PhpScriptWriter;
import php.java.script.ResultProxy;
import php.java.script.servlet.HttpFastCGIProxy;
import php.java.script.servlet.PhpScriptLogWriter;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.HttpContext;
import php.java.servlet.Logger;
import php.java.servlet.ServletUtil;

public class PhpHttpScriptContext
extends PhpScriptContextDecorator {
    public static final int REQUEST_SCOPE = 0;
    public static final int SESSION_SCOPE = 150;
    public static final int APPLICATION_SCOPE = 175;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected ServletContext context;
    protected Servlet servlet;
    protected Writer writer;
    protected Writer errorWriter;
    protected Reader reader;

    public PhpHttpScriptContext(ScriptContext ctx, Servlet servlet, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super((IPhpScriptContext)ctx);
        this.request = request;
        this.response = response;
        this.context = context;
        this.servlet = servlet;
    }

    public Continuation createContinuation(Reader reader, Map env, OutputStream out, OutputStream err, HeaderParser headerParser, ResultProxy result, ILogger logger, boolean isCompiled) {
        Continuation cont;
        if (isCompiled) {
            ContextLoaderListener listener = ContextLoaderListener.getContextLoaderListener((ServletContext)this.getServletContext());
            cont = new HttpFastCGIProxy(env, out, err, headerParser, result, listener.getConnectionPool());
        } else {
            cont = super.createContinuation(reader, env, out, err, headerParser, result, logger, isCompiled);
        }
        return cont;
    }

    public void startContinuation() {
        ContextLoaderListener listener = ContextLoaderListener.getContextLoaderListener((ServletContext)this.getServletContext());
        listener.getThreadPool().start((Runnable)this.getContinuation());
    }

    public Object getAttribute(String key, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(key);
        }
        if (scope == 150) {
            return this.request.getSession().getAttribute(key);
        }
        if (scope == 175) {
            return this.context.getAttribute(key);
        }
        return super.getAttribute(key, scope);
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Object result = super.getAttribute(name);
        if (result != null) {
            return result;
        }
        result = this.request.getAttribute(name);
        if (result != null) {
            return result;
        }
        result = this.request.getSession().getAttribute(name);
        if (result != null) {
            return result;
        }
        result = this.context.getAttribute(name);
        if (result != null) {
            return result;
        }
        return null;
    }

    public void setAttribute(String key, Object value, int scope) throws IllegalArgumentException {
        if (scope == 0) {
            this.request.setAttribute(key, value);
        } else if (scope == 150) {
            this.request.getSession().setAttribute(key, value);
        } else if (scope == 175) {
            this.context.setAttribute(key, value);
        } else {
            super.setAttribute(key, value, scope);
        }
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public Writer getWriter() {
        if (this.writer == null) {
            try {
                this.setWriter(this.response.getWriter());
            }
            catch (IOException e) {
                Util.printStackTrace((Throwable)e);
            }
        }
        return this.writer;
    }

    public void setWriter(Writer writer) {
        if (!(writer instanceof PhpScriptWriter)) {
            writer = new PhpScriptWriter((OutputStream)new WriterOutputStream(writer));
        }
        this.writer = writer;
        super.setWriter(this.writer);
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.setErrorWriter((Writer)((Object)PhpScriptLogWriter.getWriter(new Logger())));
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer errorWriter) {
        if (!(errorWriter instanceof PhpScriptWriter)) {
            errorWriter = new PhpScriptWriter((OutputStream)new WriterOutputStream(errorWriter));
        }
        this.errorWriter = errorWriter;
        super.setErrorWriter(this.errorWriter);
    }

    public Reader getReader() {
        if (this.reader == null) {
            try {
                this.reader = this.request.getReader();
            }
            catch (IOException e) {
                Util.printStackTrace((Throwable)e);
            }
        }
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
        super.setReader(this.reader);
    }

    public Object init(Object callable) throws Exception {
        return Context.getManageable((Object)callable);
    }

    public void onShutdown(Object closeable) {
        HttpContext.handleManaged(closeable, this.context);
    }

    public Object getHttpServletResponse() {
        return this.response;
    }

    public Object getHttpServletRequest() {
        return this.request;
    }

    public Object getServlet() {
        return this.servlet;
    }

    public Object getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public Object getServletContext() {
        return this.context;
    }

    public String getRealPath(String path) {
        return ServletUtil.getRealPath(this.context, path);
    }

    public String getRedirectString(String webPath) {
        throw new NotImplementedException();
    }

    public String getRedirectString() {
        throw new NotImplementedException();
    }

    public String getRedirectURL(String webPath) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSocketName());
        buf.append("/");
        buf.append(webPath);
        try {
            URI uri = new URI(this.request.isSecure() ? "https:127.0.0.1" : "http:127.0.0.1", buf.toString(), null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            Util.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getSocketName() {
        return String.valueOf(ServletUtil.getLocalPort((ServletRequest)this.request));
    }

    public ContextServer getContextServer() {
        return ContextLoaderListener.getContextLoaderListener(this.context).getContextServer();
    }
}

