/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnectionException;
import php.java.bridge.http.FCGIConnectionPool;
import php.java.bridge.http.FCGIInputStream;
import php.java.bridge.http.FCGIOutputStream;
import php.java.bridge.http.FCGIUtil;
import php.java.bridge.http.IContextFactory;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.PhpJavaServlet;
import php.java.servlet.ServletContextFactory;
import php.java.servlet.ServletUtil;

public class FastCGIServlet
extends HttpServlet {
    protected static final String _80 = "80";
    protected static final String _443 = "443";
    private static final long serialVersionUID = 3545800996174312757L;
    protected String documentRoot;
    protected String serverSignature;
    protected ServletContext context;
    protected ContextLoaderListener contextLoaderListener;
    protected String serverInfo;
    protected FCGIConnectionPool connectionPool;
    protected boolean phpRequestURIisUnique;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        String value = config.getInitParameter("php_request_uri_is_unique");
        if ("on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            this.phpRequestURIisUnique = true;
        }
        this.contextLoaderListener = (ContextLoaderListener)this.context.getAttribute(ContextLoaderListener.CONTEXT_LOADER_LISTENER);
        this.serverInfo = config.getServletName();
        if (this.serverInfo == null) {
            this.serverInfo = "FastCGIServlet";
        }
        this.documentRoot = ServletUtil.getRealPath(this.context, "");
        this.serverSignature = this.context.getServerInfo();
        this.connectionPool = this.contextLoaderListener.getConnectionPool();
        if (this.connectionPool == null) {
            try {
                this.contextLoaderListener.getChannelName().test();
            }
            catch (FCGIConnectException e) {
                throw new ServletException((Throwable)e);
            }
            throw new ServletException("No connection pool");
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected void setupRequestVariables(HttpServletRequest req, Environment env) {
        env.allHeaders = new ArrayList();
        env.includedJava = this.contextLoaderListener.getPhpIncludeJava() && PhpJavaServlet.getHeader("X_JAVABRIDGE_INCLUDE", req) == null;
        env.contextPath = (String)req.getAttribute("javax.servlet.include.context_path");
        if (env.contextPath == null) {
            env.contextPath = req.getContextPath();
        }
        env.pathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
        if (env.pathInfo == null) {
            env.pathInfo = req.getPathInfo();
        }
        env.servletPath = (String)req.getAttribute("javax.servlet.include.servlet_path");
        if (env.servletPath == null) {
            env.servletPath = req.getServletPath();
        }
        env.queryString = (String)req.getAttribute("javax.servlet.include.query_string");
        if (env.queryString == null) {
            env.queryString = req.getQueryString();
        }
        env.requestUri = this.phpRequestURIisUnique ? (String)req.getAttribute("javax.servlet.include.request_uri") : (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (env.requestUri == null) {
            env.requestUri = req.getRequestURI();
        }
    }

    protected void setPathInfo(HttpServletRequest req, HashMap envp, Environment env) {
        String pathInfo = env.pathInfo;
        if (pathInfo != null) {
            envp.put("PATH_INFO", pathInfo);
            envp.put("PATH_TRANSLATED", this.documentRoot + pathInfo);
        }
        if (env.includedJava) {
            envp.put("SCRIPT_FILENAME", ServletUtil.getRealPath(this.context, "java/JavaProxy.php"));
        } else {
            envp.put("SCRIPT_FILENAME", ServletUtil.getRealPath(this.context, env.servletPath));
        }
    }

    protected void setupCGIEnvironment(HttpServletRequest req, HttpServletResponse res, Environment env) throws ServletException {
        String id;
        HashMap envp = (HashMap)this.contextLoaderListener.getEnvironment().clone();
        envp.put("SERVER_SOFTWARE", this.serverInfo);
        envp.put("SERVER_NAME", ServletUtil.nullsToBlanks(req.getServerName()));
        envp.put("GATEWAY_INTERFACE", "CGI/1.1");
        envp.put("SERVER_PROTOCOL", ServletUtil.nullsToBlanks(req.getProtocol()));
        int port = ServletUtil.getLocalPort((ServletRequest)req);
        Integer iPort = port == 0 ? new Integer(-1) : new Integer(port);
        envp.put("SERVER_PORT", iPort.toString());
        envp.put("REQUEST_METHOD", ServletUtil.nullsToBlanks(req.getMethod()));
        envp.put("SCRIPT_NAME", env.contextPath + env.servletPath);
        envp.put("QUERY_STRING", ServletUtil.nullsToBlanks(env.queryString));
        envp.put("REMOTE_HOST", ServletUtil.nullsToBlanks(req.getRemoteHost()));
        envp.put("REMOTE_ADDR", ServletUtil.nullsToBlanks(req.getRemoteAddr()));
        envp.put("AUTH_TYPE", ServletUtil.nullsToBlanks(req.getAuthType()));
        envp.put("REMOTE_USER", ServletUtil.nullsToBlanks(req.getRemoteUser()));
        envp.put("REMOTE_IDENT", "");
        envp.put("CONTENT_TYPE", ServletUtil.nullsToBlanks(req.getContentType()));
        this.setPathInfo(req, envp, env);
        int contentLength = req.getContentLength();
        String sContentLength = contentLength <= 0 ? "" : new Integer(contentLength).toString();
        envp.put("CONTENT_LENGTH", sContentLength);
        Enumeration headers = req.getHeaderNames();
        String header = null;
        StringBuffer buffer = new StringBuffer();
        while (headers.hasMoreElements()) {
            header = ((String)headers.nextElement()).toUpperCase();
            if ("AUTHORIZATION".equalsIgnoreCase(header) || "PROXY_AUTHORIZATION".equalsIgnoreCase(header)) continue;
            if ("HOST".equalsIgnoreCase(header)) {
                String host = req.getHeader(header);
                int idx = host.indexOf(":");
                if (idx < 0) {
                    idx = host.length();
                }
                envp.put("HTTP_" + header.replace('-', '_'), host.substring(0, idx));
                continue;
            }
            if (header.startsWith("X_")) {
                envp.put(header, req.getHeader(header));
                continue;
            }
            envp.put("HTTP_" + header.replace('-', '_'), ServletUtil.getHeaders(buffer, req.getHeaders(header)));
        }
        env.environment = envp;
        if (env.includedJava) {
            env.environment.put("X_JAVABRIDGE_INCLUDE_ONLY", "1");
            env.environment.put("X_JAVABRIDGE_INCLUDE", ServletUtil.getRealPath(this.getServletContext(), env.servletPath));
        }
        env.environment.put("REDIRECT_STATUS", "200");
        env.environment.put("SERVER_SOFTWARE", Util.EXTENSION_NAME);
        String sPort = (String)env.environment.get("SERVER_PORT");
        String standardPort = req.isSecure() ? _443 : _80;
        StringBuffer httpHost = new StringBuffer((String)env.environment.get("SERVER_NAME"));
        if (!standardPort.equals(sPort)) {
            httpHost.append(":");
            httpHost.append(sPort);
        }
        env.environment.put("HTTP_HOST", httpHost.toString());
        String remotePort = null;
        try {
            remotePort = String.valueOf(req.getRemotePort());
        }
        catch (Throwable t) {
            remotePort = String.valueOf(t);
        }
        env.environment.put("REMOTE_PORT", remotePort);
        String query = env.queryString;
        if (query != null) {
            env.environment.put("REQUEST_URI", ServletUtil.nullsToBlanks(env.requestUri + "?" + query));
        } else {
            env.environment.put("REQUEST_URI", ServletUtil.nullsToBlanks(env.requestUri));
        }
        env.environment.put("SERVER_ADDR", req.getServerName());
        env.environment.put("SERVER_SIGNATURE", this.serverSignature);
        env.environment.put("DOCUMENT_ROOT", this.documentRoot);
        if (req.isSecure()) {
            env.environment.put("HTTPS", "On");
        }
        if ((id = PhpJavaServlet.getHeader("X_JAVABRIDGE_CONTEXT", req)) == null) {
            env.ctx = ServletContextFactory.addNew(this.contextLoaderListener.getContextServer(), (Servlet)this, this.getServletContext(), req, req, res);
            id = env.ctx.getId();
            AbstractChannelName channelName = this.contextLoaderListener.getContextServer().getChannelName(env.ctx);
            if (channelName != null) {
                env.environment.put("X_JAVABRIDGE_REDIRECT", channelName.getName());
                env.ctx.getBridge();
                this.contextLoaderListener.getContextServer().start(channelName, this.contextLoaderListener.getLogger());
            }
        }
        env.environment.put("X_JAVABRIDGE_CONTEXT", id);
    }

    protected void parseBody(HttpServletRequest req, HttpServletResponse res, Environment env) throws FCGIConnectionException, FCGIConnectException, IOException, ServletException {
        byte[] buf = new byte[65535];
        ServletInputStream in = null;
        OutputStream out = null;
        FCGIInputStream natIn = null;
        FCGIOutputStream natOut = null;
        FCGIConnectionPool.Connection connection = null;
        try {
            int n;
            connection = this.connectionPool.openConnection();
            natOut = (FCGIOutputStream)connection.getOutputStream();
            natIn = (FCGIInputStream)connection.getInputStream();
            in = req.getInputStream();
            out = ServletUtil.getServletOutputStream(res);
            natOut.writeBegin();
            natOut.writeParams((Map)env.environment);
            String line = null;
            int i = 0;
            int s = 0;
            boolean eoh = false;
            boolean rn = false;
            if ("chunked".equalsIgnoreCase(PhpJavaServlet.getHeader("Transfer-Encoding", req)) || "upgrade".equalsIgnoreCase(PhpJavaServlet.getHeader("Connection", req))) {
                ServletInputStream inputStream = in;
                in = null;
                FCGIOutputStream natOutputStream = natOut;
                natOut = null;
                new Thread((InputStream)inputStream, buf, natOutputStream){
                    private final /* synthetic */ InputStream val$inputStream;
                    private final /* synthetic */ byte[] val$buf;
                    private final /* synthetic */ FCGIOutputStream val$natOutputStream;
                    {
                        this.val$inputStream = inputStream;
                        this.val$buf = byArray;
                        this.val$natOutputStream = fCGIOutputStream;
                    }

                    public void run() {
                        try {
                            int n;
                            while ((n = this.val$inputStream.read(this.val$buf)) != -1) {
                                this.val$natOutputStream.write(5, this.val$buf, n);
                            }
                            this.val$natOutputStream.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                this.val$natOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }.start();
            } else {
                while ((n = in.read(buf)) != -1) {
                    natOut.write(5, buf, n);
                }
                natOut.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
                natOut.close();
                natOut = null;
            }
            String remain = null;
            while ((n = natIn.read(buf)) != -1) {
                int N = i + n;
                block19: while (!eoh && i < N) {
                    switch (buf[i++]) {
                        case 10: {
                            if (rn) {
                                eoh = true;
                            } else {
                                if (remain != null) {
                                    line = remain + new String(buf, s, i - s, "ASCII");
                                    line = line.substring(0, line.length() - 2);
                                    remain = null;
                                } else {
                                    line = new String(buf, s, i - s - 2, "ASCII");
                                }
                                this.addHeader(res, line, env);
                                s = i;
                            }
                            rn = true;
                            continue block19;
                        }
                        case 13: {
                            continue block19;
                        }
                    }
                    rn = false;
                }
                if (eoh) {
                    if (i < N) {
                        out.write(buf, i, N - i);
                    }
                } else {
                    remain = remain != null ? remain + new String(buf, s, i - s, "ASCII") : new String(buf, s, i - s, "ASCII");
                }
                i = 0;
                s = 0;
            }
            natIn.close();
            String phpFatalError = natIn.checkError();
            StringBuffer phpError = natIn.getError();
            if (phpError != null && Util.logLevel > 4) {
                Util.logDebug((String)phpError.toString());
            }
            natIn = null;
            connection = null;
            if (phpFatalError != null) {
                throw new RuntimeException(phpFatalError);
            }
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.setIsClosed();
            }
            if (natIn != null) {
                try {
                    natIn.close();
                }
                catch (IOException iOException) {}
            }
            if (natOut != null) {
                try {
                    natOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Environment getEnvironment() {
        return new Environment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, InterruptedException {
        Environment env = this.getEnvironment();
        this.setupRequestVariables(req, env);
        this.setupCGIEnvironment(req, res, env);
        try {
            this.parseBody(req, res, env);
        }
        catch (FCGIConnectException ex) {
            if (Util.logLevel > 1) {
                Util.logDebug((String)("PHP FastCGI server failed: " + (Object)((Object)ex)));
                Util.printStackTrace((Throwable)ex);
            }
            IOException ex2 = new IOException("PHP FastCGI server failed: ");
            ex2.initCause(ex);
            throw ex2;
        }
        catch (FCGIConnectionException x) {
            Util.logError((String)("PHP application terminated unexpectedly, have you started php-cgi with the environment setting PHP_FCGI_MAX_REQUESTS=" + this.contextLoaderListener.getPhpMaxRequests() + "?  Error: " + (Object)((Object)x)));
            if (Util.logLevel > 1) {
                Util.logDebug((String)("PHP FastCGI instance failed: " + (Object)((Object)x)));
                Util.printStackTrace((Throwable)x);
            }
            throw new ServletException("PHP FastCGI instance failed.", (Throwable)x);
        }
        catch (IOException e) {
            if (Util.logLevel > 4) {
                Util.printStackTrace((Throwable)e);
            }
        }
        finally {
            if (env.ctx != null) {
                env.ctx.releaseManaged();
            }
            env.ctx = null;
        }
    }

    protected void addHeader(HttpServletResponse response, String line, Environment env) {
        try {
            if (line.startsWith("Status")) {
                int i = (line = line.substring(line.indexOf(":") + 1).trim()).indexOf(32);
                if (i > 0) {
                    line = line.substring(0, i);
                }
                response.setStatus(Integer.parseInt(line));
            } else if (!env.allHeaders.contains(line)) {
                response.addHeader(line.substring(0, line.indexOf(":")).trim(), line.substring(line.indexOf(":") + 1).trim());
                env.allHeaders.add(line);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.execute(req, res);
        }
        catch (IOException e) {
            try {
                res.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer buf = new StringBuffer("PHP FastCGI server not running. Please see server log for details.");
            if (this.contextLoaderListener.getChannelName() != null && this.context != null) {
                buf.append(" Or start a PHP FastCGI server using the command:\n");
                buf.append(this.contextLoaderListener.getChannelName().getFcgiStartCommand(ServletUtil.getRealPath(this.context, "/WEB-INF/cgi"), this.contextLoaderListener.getPhpMaxRequests()));
            }
            IOException ex = new IOException(buf.toString());
            ex.initCause(e);
            throw ex;
        }
        catch (ServletException e) {
            try {
                res.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                res.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Util.logLevel > 4) {
                Util.printStackTrace((Throwable)t);
            }
            throw new ServletException(t);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handle(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handle(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handle(req, res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Util.logLevel > 4) {
            if (req.getAttribute("javax.servlet.include.request_uri") != null) {
                this.log("doGet (included):" + req.getAttribute("javax.servlet.include.request_uri"));
            }
            this.log("doGet:" + req.getRequestURI());
        }
        this.handle(req, res);
    }

    protected static class Environment {
        public IContextFactory ctx;
        public String contextPath;
        public String pathInfo;
        public String servletPath;
        public String queryString;
        public String requestUri;
        public HashMap environment;
        public boolean includedJava;
        public ArrayList allHeaders;

        protected Environment() {
        }
    }
}

