/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import php.java.bridge.Util;
import php.java.bridge.classloader.DynamicClassLoader;
import php.java.bridge.classloader.JarLibraryPath;
import php.java.bridge.util.Logger;

class DynamicJavaBridgeClassLoader
extends DynamicClassLoader {
    private static final URL[] EMPTY_URL = new URL[0];
    private static final JarLibraryPath EMPTY_PATH = new JarLibraryPath(){

        @Override
        public URL[] getURLs() {
            return EMPTY_URL;
        }
    };
    static final String LD_LIBRARY_PATH = DynamicJavaBridgeClassLoader.getLD_LIBRARY_PATH();
    static final String CLASSPATH = DynamicJavaBridgeClassLoader.getCLASSPATH();

    protected DynamicJavaBridgeClassLoader(DynamicJavaBridgeClassLoader other) {
        super(other);
    }

    protected DynamicJavaBridgeClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected DynamicJavaBridgeClassLoader() {
    }

    public static JarLibraryPath checkJarLibraryPath(String rawPath, String rawContextDir, String cwd, String searchpath) throws IOException {
        if (rawPath == null || rawPath.length() < 1) {
            return EMPTY_PATH;
        }
        return new JarLibraryPath(rawPath, rawContextDir, cwd, searchpath);
    }

    public void updateJarLibraryPath(String rawPath, String rawContextDir, String cwd, String searchpath) throws IOException {
        this.updateJarLibraryPath(DynamicJavaBridgeClassLoader.checkJarLibraryPath(rawPath, rawContextDir, cwd, searchpath));
    }

    public void updateJarLibraryPath(JarLibraryPath path) {
        String key = path.getPath();
        URL[] urls = path.getURLs();
        if (urls.length > 0) {
            this.addURLs(key, urls, false);
        }
        path.addToCache();
    }

    static URL checkUrl(URL url) throws IOException {
        url.getProtocol();
        return url;
    }

    static void checkJarFile(File f) throws IOException {
        try {
            DynamicJavaBridgeClassLoader.doCheckJarFile(f);
        }
        catch (IOException e) {
            IOException ex = new IOException("Could not open jar file " + f + ", reason: " + String.valueOf(e.getMessage()));
            ex.initCause(e);
            throw ex;
        }
    }

    private static void doCheckJarFile(File f) throws IOException {
        JarFile jar = new JarFile(f);
        try {
            Manifest mf = jar.getManifest();
            if (Logger.getLogLevel() > 4 && mf != null) {
                Set<Map.Entry<Object, Object>> main = mf.getMainAttributes().entrySet();
                if (Logger.getLogLevel() > 5) {
                    Logger.logDebug("ClassLoader: loaded file: " + f + ", main attributes: " + main);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                jar.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            jar.close();
        }
        catch (Exception exception) {}
    }

    static void addJars(List list, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.getName().endsWith(".jar")) {
                try {
                    list.add(new URL("file", null, f.getAbsolutePath()));
                }
                catch (MalformedURLException e) {
                    Logger.printStackTrace(e);
                }
            }
            ++i;
        }
    }

    public DynamicJavaBridgeClassLoader clearVMLoader() {
        DynamicJavaBridgeClassLoader that = new DynamicJavaBridgeClassLoader(this);
        this.copyInto(that);
        return that;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.clearLoader();
            DynamicJavaBridgeClassLoader.clearCache();
        }
    }

    public void clear() {
        this.clearLoader();
    }

    private static final String getLD_LIBRARY_PATH() {
        try {
            return System.getProperty("java.library.path");
        }
        catch (Throwable throwable) {
            return "[error: no java.library.path set]";
        }
    }

    private static final String getCLASSPATH() {
        try {
            return System.getProperty("java.ext.dirs");
        }
        catch (Throwable throwable) {
            return "[error: no java.ext.dirs set]";
        }
    }

    protected String resolveLibraryName(String name) {
        URL url = this.findResource("lib" + name + ".so");
        if (url == null) {
            url = this.findResource(String.valueOf(name) + ".dll");
        }
        if (url != null) {
            return new File(url.getPath()).getAbsolutePath();
        }
        throw new UnsatisfiedLinkError("Native library " + name + " could not be found in java_require() path.");
    }

    protected DynamicClassLoader.URLClassLoaderFactory getUrlClassLoaderFactory() {
        return new DynamicClassLoader.URLClassLoaderFactory(){

            @Override
            public URLClassLoader createUrlClassLoader(String classPath, URL[] urls, ClassLoader parent) {
                URLClassLoader loader = new URLClassLoader(urls, parent){
                    private Map cache;
                    {
                        this.cache = new HashMap();
                    }

                    public String toString() {
                        return String.valueOf(DynamicJavaBridgeClassLoader.this.arrayToString(this.getURLs()));
                    }

                    public Class loadClass(String name) throws ClassNotFoundException {
                        Class result = null;
                        Object c = null;
                        if (Logger.getLogLevel() > 4) {
                            Logger.logDebug("trying to load class: " + name + " from: " + "LOADER-ID" + System.identityHashCode(this));
                        }
                        if ((c = this.cache.get(name)) != "not found") {
                            if (c != null) {
                                return c;
                            }
                            try {
                                result = this.doLoadClass(name);
                                this.cache.put(name, result);
                                return result;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                this.cache.put(name, "not found");
                            }
                        }
                        throw new ClassNotFoundException(name);
                    }

                    private Class doLoadClass(String name) throws ClassNotFoundException {
                        try {
                            Class<?> c = super.loadClass(name);
                            if (c != null) {
                                return c;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            throw e;
                        }
                        catch (Exception ex) {
                            throw new ClassNotFoundException("Class " + name + " not found due to exception: " + ex + ".", ex);
                        }
                        throw new ClassNotFoundException(name);
                    }

                    @Override
                    public URL findResource(String name) {
                        return super.findResource(name);
                    }

                    @Override
                    protected String findLibrary(String name) {
                        if (Logger.getLogLevel() > 4) {
                            Logger.logDebug("trying to load library: " + name + " from: " + "LOADER-ID" + System.identityHashCode(this));
                        }
                        if (!Util.IS_GNU_JAVA) {
                            throw new UnsatisfiedLinkError("This java VM can only load pure java libraries. Either use GNU java instead or move the java library to " + CLASSPATH + " and the shared library " + name + " to " + LD_LIBRARY_PATH);
                        }
                        String s = super.findLibrary(name);
                        if (s != null) {
                            return s;
                        }
                        return DynamicJavaBridgeClassLoader.this.resolveLibraryName(name);
                    }
                };
                if (Logger.getLogLevel() > 4) {
                    Logger.logDebug("Added LOADER-ID" + System.identityHashCode(loader) + "\nOrigPath: " + classPath + "\nTranslated: " + DynamicJavaBridgeClassLoader.this.arrayToString(urls));
                }
                return loader;
            }
        };
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.classPaths.iterator();
        DynamicClassLoader.URLClassLoaderEntry e = null;
        while (iter.hasNext()) {
            e = (DynamicClassLoader.URLClassLoaderEntry)this.classLoaders.get(iter.next());
            buf.append(e.toString());
            buf.append(";");
        }
        ClassLoader parent = this.getParent();
        if (parent != null && parent instanceof URLClassLoader) {
            buf.append(String.valueOf(this.arrayToString(((URLClassLoader)parent).getURLs())));
            buf.append(";");
        }
        return buf.toString();
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Could not find " + name + " in java_require() path. Please check the path and the SEL and File permissions.", e);
        }
    }

    public static synchronized DynamicJavaBridgeClassLoader newInstance(ClassLoader parent) {
        try {
            DynamicJavaBridgeClassLoader cl = new DynamicJavaBridgeClassLoader(parent);
            cl.setUrlClassLoaderFactory(cl.getUrlClassLoaderFactory());
            return cl;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }
}

