/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.parser.IDocHandler;
import php.java.bridge.parser.IntegerComparator;
import php.java.bridge.parser.Parser;
import php.java.bridge.parser.ParserString;
import php.java.bridge.parser.ParserTag;
import php.java.bridge.parser.PhpArray;
import php.java.bridge.parser.PhpExactNumber;
import php.java.bridge.parser.PhpParserString;
import php.java.bridge.parser.Response;
import php.java.bridge.util.AppThreadPool;
import php.java.bridge.util.Logger;

public final class Request
implements IDocHandler {
    private Parser parser;
    private JavaBridge defaultBridge;
    private JavaBridge bridge;
    protected static final IntegerComparator PHP_ARRAY_KEY_COMPARATOR = new IntegerComparator();
    public static final PhpNull PHPNULL = new PhpNull();
    static final Object[] ZERO_ARGS = new Object[0];
    private SimpleContext contextCache;
    private Arg arg;
    public Response response = null;
    static final byte[] ZERO = new byte[1];
    static final Object ZERO_OBJECT = new Object();
    private static final String SUB_FAILED = "PHP callback execution failed.";

    protected Object getGlobalRef(int i) {
        Object ref = this.bridge.getGlobalRef().get(i);
        if (ref == PHPNULL) {
            return null;
        }
        return ref;
    }

    SimpleContext getContext() {
        if (this.contextCache != null) {
            return this.contextCache;
        }
        if (this.bridge.getOptions().passContext()) {
            this.contextCache = new Context();
            return this.contextCache;
        }
        this.contextCache = new SimpleContext(null, null);
        return this.contextCache;
    }

    public Request(JavaBridge bridge) {
        this.bridge = bridge;
        this.parser = new Parser(bridge, this);
    }

    public void init(byte ch) {
        this.parser.initOptions(ch);
    }

    public boolean init(InputStream in, OutputStream out) throws IOException {
        switch (this.parser.initOptions(in, out)) {
            case 1: {
                this.bridge.logDebug("PING - PONG - Closing Request");
                out.write(ZERO, 0, 1);
                return false;
            }
            case 3: {
                this.bridge.logDebug("IO_ERROR - Closing Request");
                return false;
            }
            case 2: {
                this.bridge.logDebug("EOF - Closing Request");
                return false;
            }
        }
        return true;
    }

    private long getClassicPhpLong(ParserString[] st) {
        return st[0].getClassicLongValue();
    }

    private Object createClassicExact(ParserString[] st) {
        return new Integer(st[0].getClassicIntValue());
    }

    private long getPhpLong(ParserString[] st) {
        long val = st[0].getLongValue();
        if (st[1].string[st[1].off] != 79) {
            val *= -1L;
        }
        return val;
    }

    private Object createExact(ParserString[] st) {
        int val = st[0].getIntValue();
        if (st[1].string[st[1].off] != 79) {
            val *= -1;
        }
        return new Integer(val);
    }

    @Override
    public boolean begin(ParserTag[] tag) {
        boolean reply = true;
        ParserString[] st = tag[2].strings;
        byte ch = tag[0].strings[0].string[0];
        switch (ch) {
            case 71: 
            case 89: {
                this.arg.type = ch;
                this.arg.predicate = st[0].string[st[0].off];
                int i = st[1].getIntValue();
                this.arg.callObject = i == 0 ? this.bridge : this.getGlobalRef(i);
                this.arg.method = st[2].getCachedStringValue();
                this.arg.id.parseID(st[3]);
                break;
            }
            case 73: {
                this.arg.type = ch;
                int i = st[0].getIntValue();
                this.arg.callObject = i == 0 ? this.bridge : this.getGlobalRef(i);
                this.arg.method = st[1].getCachedStringValue();
                this.arg.predicate = st[2].string[st[2].off];
                this.arg.id.parseID(st[3]);
                break;
            }
            case 72: 
            case 75: {
                this.arg.type = ch;
                this.arg.predicate = st[0].string[st[0].off];
                this.arg.callObject = st[1].getCachedStringValue();
                this.arg.id.parseID(st[2]);
                break;
            }
            case 67: {
                this.arg.type = ch;
                this.arg.callObject = st[0].getCachedStringValue();
                this.arg.predicate = st[1].string[st[1].off];
                this.arg.id.parseID(st[2]);
                break;
            }
            case 70: {
                this.arg.type = ch;
                this.arg.predicate = st[0].string[st[0].off];
                break;
            }
            case 82: {
                this.arg.type = ch;
                this.arg.id.parseID(st[0]);
                break;
            }
            case 90: {
                this.arg.type = ch;
                this.bridge.getContext().setExitCode(st[0].getIntValue());
                break;
            }
            case 88: {
                this.arg = new CompositeArg(this.arg);
                this.arg.composite = st[0].string[st[0].off];
                break;
            }
            case 80: {
                if (this.arg.composite == 72) {
                    if (st[0].string[st[0].off] == 83) {
                        this.arg.key = st[1].getCachedStringValue();
                        break;
                    }
                    this.arg.key = new Integer(st[1].getIntValue());
                    break;
                }
                this.arg.key = null;
                break;
            }
            case 85: {
                Object obj;
                int i = st[0].getIntValue();
                if (Logger.getLogLevel() > 4 && !((obj = this.bridge.getGlobalRef().get(i)) instanceof Proxy)) {
                    Logger.logDebug("unref: " + obj);
                }
                this.bridge.getGlobalRef().remove(i);
                reply = false;
                break;
            }
            case 83: {
                if (tag[2].n <= 0) break;
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpParserString(this.bridge, st[0]));
                    break;
                }
                this.arg.add(st[0].getStringValue());
                break;
            }
            case 66: {
                this.arg.add(new Boolean(st[0].string[st[0].off] == 84));
                break;
            }
            case 84: {
                this.arg.add(new Boolean(st[0].string[st[0].off] == 49));
                break;
            }
            case 76: {
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpExactNumber(this.getPhpLong(st)));
                    break;
                }
                this.arg.add(this.createExact(st));
                break;
            }
            case 74: {
                if (this.arg.composite != 72) {
                    this.arg.add(new PhpExactNumber(this.getClassicPhpLong(st)));
                    break;
                }
                this.arg.add(this.createClassicExact(st));
                break;
            }
            case 68: {
                this.arg.add(new Double(st[0].getDoubleValue()));
                break;
            }
            case 69: {
                if (st[0].length == 0) {
                    this.arg.callObject = new Exception(st[1].getStringValue());
                    break;
                }
                int i = st[0].getIntValue();
                if (i == 0) {
                    this.arg.callObject = new Exception(st[1].getStringValue());
                    break;
                }
                this.arg.callObject = this.getGlobalRef(i);
                break;
            }
            case 79: {
                if (st[0].length == 0) {
                    this.arg.add(null);
                    break;
                }
                int i = st[0].getIntValue();
                if (i == 0) {
                    this.arg.add(null);
                    break;
                }
                this.arg.add(this.getGlobalRef(i));
            }
        }
        return reply;
    }

    @Override
    public void end(ParserString[] string) {
        switch (string[0].string[0]) {
            case 88: {
                this.arg = ((CompositeArg)this.arg).pop();
            }
        }
    }

    private void setIllegalStateException(String s) {
        IllegalStateException ex = new IllegalStateException(s);
        this.bridge.lastException = ex;
        this.response.setResultException(this.bridge.lastException, true);
    }

    private int handleRequest() throws IOException {
        int retval = this.parser.parse(this.bridge.in);
        if (retval == 0) {
            this.arg.id.setID(this.response);
            switch (this.arg.type) {
                case 73: {
                    try {
                        switch (this.arg.predicate) {
                            case 80: {
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 73: {
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 71: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncVoidWriter();
                                this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 89: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncVoidWriter();
                                this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 67: {
                    try {
                        switch (this.arg.predicate) {
                            case 67: {
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 73: {
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 72: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncVoidWriter();
                                this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 75: {
                    try {
                        switch (this.arg.predicate) {
                            case 50: {
                                this.response.setAsyncWriter();
                            }
                            case 49: {
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            case 51: {
                                this.response.setAsyncVoidWriter();
                                this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                                break;
                            }
                            default: {
                                throw new IOException("Protocol error");
                            }
                        }
                        this.response.flush();
                    }
                    catch (AbortException sub) {
                        Logger.printStackTrace(sub);
                        retval = 2;
                    }
                    break;
                }
                case 70: {
                    IJavaBridgeFactory factory = this.bridge.getFactory();
                    if (this.arg.predicate == 65) {
                        this.bridge.recycle();
                        try {
                            ((AppThreadPool.Delegate)Thread.currentThread()).setPersistent();
                        }
                        catch (ClassCastException classCastException) {}
                        this.response.setFinish(true);
                    } else {
                        this.response.setFinish(false);
                        retval = 2;
                    }
                    this.response.flush();
                    factory.invalidate();
                    break;
                }
                case 82: {
                    this.setIllegalStateException(SUB_FAILED);
                    this.response.flush();
                }
            }
            this.arg.reset();
        }
        return retval;
    }

    public void handleRequests() throws IOException {
        if (this.response == null) {
            this.response = this.bridge.createResponse();
        }
        this.arg = new SimpleArg();
        while (this.handleRequest() == 0) {
        }
    }

    public boolean handleOneRequest() throws IOException {
        if (this.response == null) {
            this.response = this.bridge.createResponse();
        }
        this.arg = new SimpleArg();
        return this.handleRequest() == 0;
    }

    private short parseSubRequestUntilEof() {
        try {
            return this.parser.parse(this.bridge.in);
        }
        catch (IOException e) {
            this.bridge.printStackTrace(e);
            return 2;
        }
    }

    protected Object[] handleSubRequests() throws AbortException, Throwable {
        Response currentResponse = this.response;
        Arg current = this.arg;
        this.response = this.response.copyResponse();
        this.arg = new SimpleArg();
        while (this.parseSubRequestUntilEof() == 0) {
            this.arg.id.setID(this.response);
            switch (this.arg.type) {
                case 73: {
                    switch (this.arg.predicate) {
                        case 80: {
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 73: {
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 71: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncVoidWriter();
                            this.bridge.GetSetProp(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 89: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncVoidWriter();
                            this.bridge.Invoke(this.arg.callObject, this.arg.method, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 67: {
                    switch (this.arg.predicate) {
                        case 67: {
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 73: {
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 72: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncVoidWriter();
                            this.bridge.CreateObject((String)this.arg.callObject, false, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 75: {
                    switch (this.arg.predicate) {
                        case 50: {
                            this.response.setAsyncWriter();
                        }
                        case 49: {
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        case 51: {
                            this.response.setAsyncVoidWriter();
                            this.bridge.CreateObject((String)this.arg.callObject, true, this.arg.getArgs(), this.response);
                            break;
                        }
                        default: {
                            throw new IOException("Protocol error");
                        }
                    }
                    this.response.flush();
                    break;
                }
                case 70: {
                    this.response.setFinish(false);
                    this.response.flush();
                    this.response = currentResponse;
                    this.arg = current;
                    throw new AbortException();
                }
                case 82: {
                    Arg ret = this.arg;
                    this.arg = current;
                    this.response.reset();
                    this.response = currentResponse;
                    if (ret.callObject != null) {
                        throw (Throwable)ret.callObject;
                    }
                    return ret.getArgs();
                }
            }
            this.arg.reset();
        }
        this.response.setFinish(false);
        this.response.flush();
        this.arg = current;
        this.response = currentResponse;
        throw new AbortException();
    }

    public void reset() {
        this.parser.reset();
    }

    public void setBridge(JavaBridge bridge) {
        this.defaultBridge = this.bridge;
        bridge.in = this.bridge.in;
        bridge.out = this.bridge.out;
        this.bridge = bridge;
        this.bridge.request = this;
        this.response.setBridge(bridge);
        this.parser.setBridge(bridge);
    }

    private void resetBridge() {
        if (this.defaultBridge != null) {
            this.bridge = this.defaultBridge;
            this.response.setBridge(this.bridge);
            this.parser.setBridge(this.bridge);
            this.defaultBridge = null;
        }
    }

    public void recycle() {
        this.reset();
        if (this.arg != null) {
            this.arg.reset();
        }
        if (this.response != null) {
            this.response.recycle();
        }
        this.resetBridge();
    }

    @Override
    public void parseHeader(InputStream in) throws IOException {
        this.bridge.getFactory().parseHeader(this, in);
    }

    public static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 7778150395848350732L;
    }

    private abstract class Arg {
        protected byte type;
        protected Object callObject;
        protected String method;
        protected SimpleContext id;
        protected byte predicate;
        protected Object key;
        protected byte composite;

        private Arg() {
            this.id = Request.this.getContext();
        }

        public abstract void add(Object var1);

        public abstract Object[] getArgs();

        public abstract void reset();
    }

    private final class CompositeArg
    extends Arg {
        private PhpArray ht = null;
        private int count = 0;
        private Arg parent;

        public CompositeArg(Arg parent) {
            this.parent = parent;
        }

        @Override
        public void add(Object val) {
            if (this.ht == null) {
                this.ht = new PhpArray();
            }
            if (this.key != null) {
                this.ht.put(this.key, val);
            } else {
                this.ht.put(new Integer(this.count++), val);
            }
        }

        protected Arg pop() {
            if (this.ht == null) {
                this.ht = new PhpArray();
            }
            this.parent.add(this.ht);
            return this.parent;
        }

        @Override
        public Object[] getArgs() {
            Request.this.bridge.logError("Protocol error: getArgs");
            return ZERO_ARGS;
        }

        @Override
        public void reset() {
            Request.this.bridge.logError("Protocol error: reset");
        }
    }

    private class Context
    extends SimpleContext {
        protected long id;

        private Context() {
        }

        @Override
        public void parseID(ParserString string) {
            this.id = string.getLongValue();
        }

        @Override
        public void setID(Response response) {
            response.setID(this.id);
        }
    }

    protected static final class PhpNull {
        protected PhpNull() {
        }

        public String toString() {
            return "";
        }
    }

    private final class SimpleArg
    extends Arg {
        private LinkedList list;

        private SimpleArg() {
        }

        @Override
        public void add(Object val) {
            if (this.list == null) {
                this.list = new LinkedList();
            }
            this.list.add(val);
        }

        @Override
        public Object[] getArgs() {
            return this.list == null ? ZERO_ARGS : this.list.toArray();
        }

        @Override
        public void reset() {
            this.list = null;
            this.composite = 0;
            this.type = 0;
            this.callObject = null;
            this.method = null;
            this.key = null;
        }
    }

    private class SimpleContext {
        private SimpleContext() {
        }

        public void parseID(ParserString string) {
        }

        public void setID(Response response) {
        }

        /* synthetic */ SimpleContext(SimpleContext simpleContext, SimpleContext simpleContext2) {
            this();
        }
    }
}

