/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import php.java.bridge.Util;
import php.java.bridge.util.Logger;
import php.java.fastcgi.FCGIHelper;
import php.java.fastcgi.PhpException;

public class FCGIProcess
extends Process {
    protected Process proc;
    private String[] args;
    private File homeDir;
    private Map env;
    private boolean tryOtherLocations;
    private boolean preferSystemPhp;
    private boolean isOldPhpVersion = false;
    private boolean includeJava;
    private boolean includeDebugger;
    private String cgiDir;
    private String pearDir;
    private String webInfDir;

    private FCGIProcess(Builder builder) {
        this.args = builder.args;
        this.homeDir = builder.homeDir;
        this.env = builder.env;
        this.tryOtherLocations = builder.tryOtherLocations;
        this.preferSystemPhp = builder.preferSystemPhp;
        this.isOldPhpVersion = builder.isOldPhpVersion;
        this.includeJava = builder.includeJava;
        this.includeDebugger = builder.includeDebugger;
        this.cgiDir = builder.cgiDir;
        this.pearDir = builder.pearDir;
        this.webInfDir = builder.webInfDir;
    }

    private String getQuoted(String key, String val) {
        if (this.isOldPhpVersion) {
            return String.valueOf(key) + val;
        }
        StringBuffer buf = new StringBuffer(key);
        buf.append("'");
        buf.append(val);
        buf.append("'");
        return buf.toString();
    }

    private String[] getPhpArgs(String[] args, boolean includeJava, boolean includeDebugger, String cgiDir, String pearDir, String webInfDir) {
        String[] allArgs = new String[args.length + Util.PHP_ARGS.length + (Util.sessionSavePath != null ? 2 : 0) + (includeJava ? 1 : 0) + (includeDebugger ? 1 : 0) + (cgiDir != null ? 2 : 0) + (pearDir != null ? 2 : 0) + (webInfDir != null ? 2 : 0)];
        int i = 0;
        i = 0;
        while (i < args.length) {
            allArgs[i] = args[i];
            ++i;
        }
        if (Util.sessionSavePath != null) {
            allArgs[i++] = "-d";
            allArgs[i++] = this.getQuoted("session.save_path=", Util.sessionSavePath);
        }
        if (cgiDir != null) {
            File extDir = new File(cgiDir, String.valueOf(Util.osArch) + "-" + Util.osName);
            try {
                cgiDir = extDir.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
                cgiDir = extDir.getAbsolutePath();
            }
            allArgs[i++] = "-d";
            allArgs[i++] = this.getQuoted("java.os_arch_dir=", cgiDir);
        }
        if (pearDir != null) {
            allArgs[i++] = "-d";
            allArgs[i++] = this.getQuoted("java.pear_dir=", pearDir);
        }
        if (webInfDir != null) {
            allArgs[i++] = "-d";
            allArgs[i++] = this.getQuoted("java.web_inf_dir=", webInfDir);
        }
        if (includeJava || includeDebugger) {
            allArgs[i++] = "-C";
        }
        int j = 0;
        while (j < Util.PHP_ARGS.length) {
            allArgs[i++] = Util.PHP_ARGS[j];
            ++j;
        }
        return allArgs;
    }

    protected String[] quoteArgs(String[] s) {
        if (!Util.USE_SH_WRAPPER) {
            int j = 0;
            while (j < s.length) {
                if (s[j] != null) {
                    s[j] = "\"" + s[j] + "\"";
                }
                ++j;
            }
        }
        return s;
    }

    protected boolean testPhp(String[] php, String[] args) {
        InputStream err;
        OutputStream out;
        InputStream in;
        block50: {
            Runtime rt = Runtime.getRuntime();
            String[] s = this.quoteArgs(this.getTestArgumentArray(php, args));
            byte[] buf = new byte[8192];
            in = null;
            out = null;
            err = null;
            try {
                int c;
                this.proc = rt.exec(s, FCGIProcess.hashToStringArray(this.env), this.homeDir);
                in = this.proc.getInputStream();
                err = this.proc.getErrorStream();
                out = this.proc.getOutputStream();
                out.close();
                out = null;
                while ((c = err.read(buf)) > 0) {
                    Logger.logError(new String(buf, 0, c, "ASCII"));
                }
                err.close();
                err = null;
                ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
                while ((c = in.read(buf)) > 0) {
                    outBuf.write(buf, 0, c);
                }
                in.close();
                in = null;
                int errCode = this.proc.waitFor();
                int result = this.proc.exitValue();
                if (errCode != 0 || result != 0) {
                    throw new IOException("php could not be run, returned error code: " + errCode + ", result: " + result);
                }
                try {
                    try {
                        this.checkOldPhpVersion(outBuf);
                    }
                    catch (Throwable t) {
                        Logger.printStackTrace(t);
                        outBuf.close();
                        break block50;
                    }
                }
                catch (Throwable throwable) {
                    outBuf.close();
                    throw throwable;
                }
                outBuf.close();
            }
            catch (IOException e) {
                Logger.logFatal("Fatal Error: Failed to start PHP " + Arrays.asList(s) + ", reason: " + e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (err != null) {
                        err.close();
                    }
                }
                catch (Exception exception) {}
                return false;
            }
            catch (InterruptedException interruptedException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (err != null) {
                            err.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (err != null) {
                        err.close();
                    }
                }
                catch (Exception exception) {}
                return false;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (err != null) {
                err.close();
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private void checkOldPhpVersion(ByteArrayOutputStream outBuf) {
        String ver = outBuf.toString();
        StringTokenizer tok = new StringTokenizer(ver);
        int n = tok.countTokens();
        if (n < 2) {
            return;
        }
        String[] str = new String[n];
        int i = 0;
        while (tok.hasMoreTokens()) {
            str[i] = tok.nextToken();
            ++i;
        }
        tok = new StringTokenizer(str[1], ".");
        n = tok.countTokens();
        if (n < 1) {
            return;
        }
        str = new String[n];
        i = 0;
        while (tok.hasMoreTokens()) {
            str[i] = tok.nextToken();
            ++i;
        }
        int major = Integer.parseInt(str[0]);
        if (major > 5) {
            return;
        }
        if (major == 5) {
            if (n < 2) {
                return;
            }
            int minor = Integer.parseInt(str[1]);
            if (minor > 2) {
                return;
            }
        }
        this.isOldPhpVersion = true;
    }

    protected void runPhp(String[] php, String[] args) throws IOException {
        Runtime rt = Runtime.getRuntime();
        String[] s = this.quoteArgs(this.getArgumentArray(php, args));
        this.proc = rt.exec(s, FCGIProcess.hashToStringArray(this.env), this.homeDir);
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug("Started " + Arrays.asList(s));
        }
    }

    protected String[] getTestArgumentArray(String[] php, String[] args) {
        LinkedList<String> buf = new LinkedList<String>();
        buf.addAll(Arrays.asList(php));
        buf.add("-v");
        return buf.toArray(new String[buf.size()]);
    }

    protected String[] getArgumentArray(String[] php, String[] args) {
        String realPath = new File(args[0]).getParent();
        if (realPath == null) {
            realPath = Util.TMPDIR.getAbsolutePath();
        }
        LinkedList<String> buf = new LinkedList<String>();
        if (Util.USE_SH_WRAPPER) {
            buf.add("/bin/sh");
            buf.add(String.valueOf(realPath) + File.separator + "launcher.sh");
            buf.addAll(Arrays.asList(php));
            int i = 1;
            while (i < args.length) {
                buf.add(args[i]);
                ++i;
            }
            buf.addAll(Arrays.asList(Util.ALLOW_URL_INCLUDE));
        } else {
            buf.add(String.valueOf(realPath) + File.separator + "launcher.exe");
            buf.add(Util.LAUNCHER_FLAGS);
            buf.addAll(Arrays.asList(php));
            int i = 1;
            while (i < args.length) {
                buf.add(args[i]);
                ++i;
            }
            buf.addAll(Arrays.asList(Util.ALLOW_URL_INCLUDE));
        }
        return buf.toArray(new String[buf.size()]);
    }

    protected void start() throws NullPointerException, IOException {
        String workspace;
        String[] php = new String[1];
        if (this.args == null) {
            this.args = new String[1];
        }
        String phpExec = this.args[0];
        String[] cgiBinary = null;
        if (Util.PHP_EXEC == null) {
            int i;
            if (!this.preferSystemPhp) {
                if (phpExec != null && (cgiBinary = Util.checkCgiBinary(phpExec)) != null) {
                    php = cgiBinary;
                }
                if (this.tryOtherLocations && php[0] == null) {
                    i = 0;
                    while (i < Util.DEFAULT_CGI_LOCATIONS.length) {
                        File location = new File(Util.DEFAULT_CGI_LOCATIONS[i]);
                        if (location.exists()) {
                            php[0] = location.getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                if (this.tryOtherLocations && php[0] == null) {
                    i = 0;
                    while (i < Util.DEFAULT_CGI_LOCATIONS.length) {
                        File location = new File(Util.DEFAULT_CGI_LOCATIONS[i]);
                        if (location.exists()) {
                            php[0] = location.getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (phpExec != null && php[0] == null && (cgiBinary = Util.checkCgiBinary(phpExec)) != null) {
                    php = cgiBinary;
                }
            }
        }
        if (php[0] == null && this.tryOtherLocations) {
            php[0] = Util.PHP_EXEC;
        }
        if (php[0] == null && phpExec != null && new File(phpExec).exists()) {
            php[0] = phpExec;
        }
        if (php[0] == null && (workspace = Util.canonicalPath(new File("WebContent/WEB-INF/cgi").getAbsolutePath(), "php-cgi").toString()) != null && (new File(workspace).exists() || new File(String.valueOf(workspace) + ".exe").exists())) {
            php[0] = workspace;
        }
        if (php[0] == null) {
            php[0] = "php-cgi";
        }
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug("Using php binary: " + Arrays.asList(php));
        }
        if (this.homeDir != null && cgiBinary == null) {
            this.homeDir = Util.HOME_DIR;
        }
        if (this.homeDir != null && !this.homeDir.exists()) {
            this.homeDir = null;
        }
        if (!this.testPhp(php, this.args)) {
            throw new IOException("PHP not found. Please install php-cgi. PHP test command was: " + Arrays.asList(this.getTestArgumentArray(php, this.args)) + " ");
        }
        this.runPhp(php, this.getPhpArgs(this.args, this.includeJava, this.includeDebugger, this.cgiDir, this.pearDir, this.webInfDir));
    }

    public void checkError() throws PhpException {
    }

    @Override
    public OutputStream getOutputStream() {
        return this.proc.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.proc.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.proc.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.proc.waitFor();
    }

    @Override
    public int exitValue() {
        return this.proc.exitValue();
    }

    @Override
    public void destroy() {
        this.proc.destroy();
    }

    public static String[] hashToStringArray(Map h) {
        Vector<String> v = new Vector<String>();
        Iterator e = h.keySet().iterator();
        while (e.hasNext()) {
            String k = e.next().toString();
            v.add(String.valueOf(k) + "=" + h.get(k));
        }
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ FCGIProcess(Builder builder, FCGIProcess fCGIProcess) {
        this(builder);
    }

    public static final class Builder {
        private String[] args = Util.PHP_ARGS;
        private File homeDir = new File(Util.JAVABRIDGE_BASE).getAbsoluteFile();
        private Map env = new HashMap(Util.COMMON_ENVIRONMENT);
        private boolean tryOtherLocations = true;
        private boolean preferSystemPhp = true;
        private boolean isOldPhpVersion = false;
        private boolean includeJava = false;
        private boolean includeDebugger = false;
        private String cgiDir = Util.DEFAULT_CGI_LOCATIONS[0];
        private String pearDir = null;
        private String webInfDir = null;

        public Builder withArgs(String[] args) {
            this.args = args;
            return this;
        }

        public Builder withHomeDir(File homeDir) {
            this.homeDir = homeDir;
            return this;
        }

        public Builder withEnv(Map env) {
            this.env = env;
            return this;
        }

        public Builder withTryOtherLocations(boolean tryOtherLocations) {
            this.tryOtherLocations = tryOtherLocations;
            return this;
        }

        public Builder withPreferSystemPhp(boolean preferSystemPhp) {
            this.preferSystemPhp = preferSystemPhp;
            return this;
        }

        public Builder withIsOldPhpVersion(boolean isOldPhpVersion) {
            this.isOldPhpVersion = isOldPhpVersion;
            return this;
        }

        public Builder withIncludeJava(boolean includeJava) {
            this.includeJava = includeJava;
            return this;
        }

        public Builder withIncludeDebugger(boolean includeDebugger) {
            this.includeDebugger = includeDebugger;
            return this;
        }

        public Builder withCgiDir(String cgiDir) {
            this.cgiDir = cgiDir;
            return this;
        }

        public Builder withPearDir(String pearDir) {
            this.pearDir = pearDir;
            return this;
        }

        public Builder withWebInfDir(String webInfDir) {
            this.webInfDir = webInfDir;
            return this;
        }

        public Builder withHelper(FCGIHelper helper) {
            this.tryOtherLocations = helper.isPhpTryOtherLocations();
            this.preferSystemPhp = helper.isPreferSystemPhp();
            this.isOldPhpVersion = false;
            this.includeJava = helper.isPhpIncludeJava();
            this.includeDebugger = helper.isPhpIncludeDebugger();
            this.cgiDir = helper.getCgiDir();
            this.pearDir = helper.getPearDir();
            this.webInfDir = helper.getWebInfDir();
            return this;
        }

        public FCGIProcess build() {
            return new FCGIProcess(this, null);
        }
    }
}

