/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import php.java.bridge.Util;
import php.java.script.CompiledPhpScriptEngine;

public class PhpScriptEngineFactory
implements ScriptEngineFactory {
    protected Factory factory = new Factory();
    private static final String ENGINE_NAME = String.valueOf(Util.EXTENSION_NAME) + " php script engine for Java";
    List names;

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return Util.VERSION;
    }

    @Override
    public String getLanguageName() {
        return "php";
    }

    @Override
    public String getLanguageVersion() {
        return "6";
    }

    public List getExtensions() {
        return this.getNames();
    }

    public List getMimeTypes() {
        return Arrays.asList(new String[0]);
    }

    public List getNames() {
        if (this.names == null) {
            this.names = Arrays.asList(this.getLanguageName(), "phtml", "php4", "php5", "php6");
        }
        return this.names;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.factory.create();
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "STATELESS";
        }
        throw new IllegalArgumentException("key");
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuffer b = new StringBuffer();
        b.append("$");
        b.append(obj);
        b.append("->");
        b.append(m);
        b.append("(");
        int i = 0;
        while (i < args.length - 1) {
            b.append(args[i]);
            b.append(",");
            ++i;
        }
        b.append(args[i]);
        b.append(")");
        return b.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "echo(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        int i = 0;
        StringBuffer b = new StringBuffer("<?php ");
        i = 0;
        while (i < statements.length) {
            b.append(statements[i]);
            b.append(";");
            ++i;
        }
        b.append("?>");
        return b.toString();
    }

    protected class Factory {
        public ScriptEngine create() {
            return new CompiledPhpScriptEngine(PhpScriptEngineFactory.this);
        }
    }
}

