/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.ISession;
import php.java.servlet.HttpContext;

final class HttpSessionFacade
implements ISession {
    private HttpSession session;
    private int timeout;
    private HttpSession sessionCache = null;
    private boolean isNew;
    private IContextFactory ctxFactory;

    HttpSession getCachedSession() {
        if (this.sessionCache != null) {
            return this.sessionCache;
        }
        this.sessionCache = this.session;
        this.sessionCache.setMaxInactiveInterval(this.timeout);
        return this.sessionCache;
    }

    private HttpSessionFacade(IContextFactory ctxFactory, ServletContext ctx, HttpServletRequest req, HttpServletResponse res, short clientIsNew, int timeout) {
        this.ctxFactory = ctxFactory;
        switch (clientIsNew) {
            case 1: {
                this.session = req.getSession(true);
                break;
            }
            case 0: {
                this.session = req.getSession();
                break;
            }
            case 2: {
                this.session = req.getSession(false);
                break;
            }
            default: {
                throw new IllegalStateException("clientIsNew:" + clientIsNew);
            }
        }
        this.timeout = timeout;
        this.isNew = this.session.isNew();
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)((HttpContext)this.ctxFactory.getContext()).getHttpServletRequest();
    }

    public ServletContext getServletContext() {
        return (ServletContext)((HttpContext)this.ctxFactory.getContext()).getServletContext();
    }

    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)((HttpContext)this.ctxFactory.getContext()).getHttpServletResponse();
    }

    public Object get(Object ob) {
        return this.getCachedSession().getAttribute(String.valueOf(ob));
    }

    public void put(Object ob1, Object ob2) {
        this.getCachedSession().setAttribute(String.valueOf(ob1), ob2);
    }

    public Object remove(Object ob) {
        String key = String.valueOf(ob);
        Object o = this.getCachedSession().getAttribute(key);
        if (o != null) {
            this.getCachedSession().removeAttribute(key);
        }
        return o;
    }

    public void setTimeout(int timeout) {
        this.getCachedSession().setMaxInactiveInterval(timeout);
    }

    public int getTimeout() {
        return this.getCachedSession().getMaxInactiveInterval();
    }

    public int getSessionCount() {
        return -1;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void destroy() {
        this.getCachedSession().invalidate();
    }

    public void putAll(Map vars) {
        for (Object key : vars.keySet()) {
            Object val = vars.get(key);
            this.put(key, val);
        }
    }

    public Map getAll() {
        HttpSession session = this.getCachedSession();
        HashMap map = new HashMap();
        Enumeration ee = session.getAttributeNames();
        while (ee.hasMoreElements()) {
            Object key = ee.nextElement();
            Object val = this.get(key);
            map.put(key, val);
        }
        return map;
    }

    public long getCreationTime() {
        return this.getCachedSession().getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getCachedSession().getLastAccessedTime();
    }

    public static ISession getFacade(IContextFactory factory, ServletContext kontext, HttpServletRequest req, HttpServletResponse res, short clientIsNew, int timeout) {
        if (clientIsNew != 2 || clientIsNew == 2 && req.getSession(false) != null) {
            return new HttpSessionFacade(factory, kontext, req, res, clientIsNew, timeout);
        }
        return null;
    }
}

