/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FilterInputStream {
    public static final int[] ASCII_HEX = ChunkedInputStream.getAscii();
    private boolean eof = false;
    private byte[] rn = new byte[2];
    private byte[] remaining;
    private int remainPos;
    private int remainLen;
    private byte[] buf = new byte[8192];

    private static int[] getAscii() {
        int[] ascii = new int[103];
        int i = 48;
        while (i < 58) {
            ascii[i] = i - 48;
            ++i;
        }
        i = 65;
        while (i < 71) {
            ascii[i] = i - 55;
            ++i;
        }
        i = 97;
        while (i < 103) {
            ascii[i] = i - 87;
            ++i;
        }
        return ascii;
    }

    public ChunkedInputStream(InputStream in) {
        super(new BufferedInputStream(in));
    }

    @Override
    public int read(byte[] buf, int pos, int len) throws IOException {
        int count;
        int i;
        if (len <= 0) {
            return len;
        }
        if (this.eof) {
            return -1;
        }
        if (this.remaining != null) {
            if (len < this.remainLen) {
                System.arraycopy(this.remaining, this.remainPos, buf, pos, len);
                this.remainPos += len;
                this.remainLen -= len;
                return len;
            }
            System.arraycopy(this.remaining, this.remainPos, buf, pos, this.remainLen);
            this.remaining = null;
            return this.remainLen;
        }
        int packetLen = this.readPacketLength();
        if (packetLen == 0) {
            this.eof = true;
        }
        this.remaining = new byte[packetLen];
        this.remainLen = 0;
        int c = 0;
        while ((i = this.in.read(this.remaining, c, packetLen - c)) > 0) {
            c += i;
        }
        if (c != packetLen) {
            throw new IOException("read chunked");
        }
        c = 0;
        while ((i = this.in.read(this.rn, c, 2 - c)) > 0) {
            c += i;
        }
        if (c != 2) {
            throw new IOException("read \r\n");
        }
        if (len >= packetLen) {
            count = packetLen;
            System.arraycopy(this.remaining, 0, buf, pos, packetLen);
            this.remaining = null;
        } else {
            count = len;
            System.arraycopy(this.remaining, 0, buf, pos, len);
            this.remainPos = len;
            this.remainLen = packetLen - len;
        }
        return count;
    }

    private int readPacketLength() throws IOException {
        int c;
        int n = 0;
        while ((c = this.in.read()) != 13) {
            if (c == -1) {
                throw new IllegalStateException("read chunked packet length");
            }
            if (c == 32) continue;
            n <<= 4;
            n += ASCII_HEX[c];
        }
        if (this.in.read() == -1) {
            throw new IOException("read chunked packet length");
        }
        return n;
    }

    public void eof() throws IOException {
        this.read(this.buf, 0, this.buf.length);
    }
}

