/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.SessionFactory;
import php.java.bridge.http.SocketContextServer;
import php.java.bridge.util.AppThreadPool;

public final class ContextServer {
    private String contextName;
    private boolean promiscuous;
    public static final String ROOT_CONTEXT_SERVER_ATTRIBUTE = String.valueOf(ContextServer.class.getName()) + ".ROOT";
    private static SocketContextServer sock = null;
    private static AppThreadPool pool;

    private static synchronized AppThreadPool getAppThreadPool() {
        if (pool != null) {
            return pool;
        }
        pool = new AppThreadPool("JavaBridgeContextRunner", Integer.parseInt(Util.THREAD_POOL_MAX_SIZE));
        return pool;
    }

    public ContextServer(String contextName, boolean promiscuous) {
        this.contextName = contextName;
        this.promiscuous = promiscuous;
    }

    public boolean isPromiscuous() {
        return this.promiscuous;
    }

    private static final synchronized void destroyContextServer() {
        if (sock != null) {
            sock.destroy();
        }
        sock = null;
        ContextFactory.destroyAll();
        SessionFactory.destroyTimer();
        if (pool != null) {
            pool.destroy();
        }
        pool = null;
    }

    public void destroy() {
        ContextServer.destroyContextServer();
    }

    public boolean isAvailable(String channelName) {
        if (!SocketContextServer.SOCKET_SERVER_AVAIL) {
            return false;
        }
        SocketContextServer sock = ContextServer.getSocketContextServer(this, ContextServer.getAppThreadPool(), this.contextName);
        return sock != null && sock.isAvailable();
    }

    private static synchronized SocketContextServer getSocketContextServer(ContextServer server, AppThreadPool pool, String contextName) {
        if (sock != null) {
            return sock;
        }
        sock = new SocketContextServer(pool, server.isPromiscuous(), contextName);
        return sock;
    }

    public void start(AbstractChannelName channelName) {
        boolean started = channelName.start();
        if (!started) {
            throw new IllegalStateException("SocketContextServer not available");
        }
    }

    public AbstractChannelName getChannelName(IContextFactory currentCtx) {
        SocketContextServer sock = ContextServer.getSocketContextServer(this, ContextServer.getAppThreadPool(), this.contextName);
        return sock.isAvailable() ? new SocketChannelName(sock.getChannelName(), currentCtx) : null;
    }

    public String toString() {
        return "ContextServer: " + this.contextName;
    }

    private class SocketChannelName
    extends AbstractChannelName {
        public SocketChannelName(String name, IContextFactory ctx) {
            super(name, ctx);
        }

        @Override
        public boolean startChannel() {
            return sock.start(this);
        }

        public String toString() {
            return "Socket:" + this.getName();
        }
    }
}

