/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.util;

import php.java.bridge.Util;
import php.java.bridge.util.Logger;
import php.java.bridge.util.ThreadPool;

public final class AppThreadPool
extends ThreadPool {
    @Override
    protected Delegate createDelegate(String name) {
        return new Delegate(name);
    }

    public AppThreadPool(String name, int poolMaxSize) {
        super(name, poolMaxSize);
    }

    public static AppThreadPool createThreadPool(String name) {
        AppThreadPool pool = null;
        int maxSize = 20;
        try {
            maxSize = Integer.parseInt(Util.THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable t) {
            Logger.printStackTrace(t);
        }
        if (maxSize > 0) {
            pool = new AppThreadPool(name, maxSize);
        }
        return pool;
    }

    static final class AppGroup
    extends ThreadGroup {
        private void init() {
            this.setDaemon(true);
        }

        public AppGroup(String name) {
            super(name);
            this.init();
        }

        public AppGroup(ThreadGroup group, String name) {
            super(group, name);
            this.init();
        }
    }

    public final class Delegate
    extends ThreadPool.Delegate {
        protected ThreadGroup appGroup;

        protected Delegate(String name) {
            super(AppThreadPool.this, new Group(name), name);
            this.appGroup = null;
            ((Group)this.getThreadGroup()).lock();
        }

        public ThreadGroup getAppGroup() {
            if (this.appGroup != null) {
                return this.appGroup;
            }
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            this.appGroup = new AppGroup("JavaBridgeThreadPoolAppGroup");
            group.lock();
            return this.appGroup;
        }

        public void setPersistent() {
            if (!AppThreadPool.this.checkReserve() && !this.terminate) {
                this.terminate = true;
                String name = this.getName();
                this.setName(String.valueOf(name) + ",isDaemon=true");
                if (Logger.getLogLevel() > 5) {
                    name = String.valueOf(name) + "+";
                }
                this.createThread(name);
            }
            this.end();
        }

        @Override
        protected void createThread(String name) {
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            super.createThread(name);
            group.lock();
        }

        /*
         * Loose catch block
         */
        @Override
        protected void terminate() {
            block13: {
                ThreadGroup group;
                if (Logger.getLogLevel() > 4) {
                    Logger.logDebug("term (thread removed from pool): " + this);
                }
                if ((group = this.appGroup) != null) {
                    try {
                        group.interrupt();
                    }
                    catch (SecurityException securityException) {
                        return;
                    }
                    try {
                        try {
                            group.destroy();
                        }
                        catch (SecurityException securityException) {
                            this.appGroup = null;
                        }
                        catch (IllegalThreadStateException e1) {
                            Logger.printStackTrace(e1);
                            this.appGroup = null;
                        }
                        catch (Exception e2) {
                            Logger.printStackTrace(e2);
                            this.appGroup = null;
                            break block13;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                    }
                    finally {
                        this.appGroup = null;
                    }
                }
            }
        }

        @Override
        protected void end() {
            ThreadGroup group;
            super.end();
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("end (thread returned to pool): " + this);
            }
            if ((group = this.appGroup) != null) {
                try {
                    try {
                        group.interrupt();
                    }
                    catch (SecurityException securityException) {
                        this.appGroup = null;
                    }
                    catch (Exception e2) {
                        Logger.printStackTrace(e2);
                        this.appGroup = null;
                    }
                }
                finally {
                    this.appGroup = null;
                }
            }
        }
    }

    static final class Group
    extends ThreadGroup {
        boolean isLocked = false;

        void lock() {
            this.isLocked = true;
        }

        void unlock() {
            this.isLocked = false;
        }

        private void init() {
            this.setDaemon(true);
        }

        public Group(String name) {
            super(name);
            this.init();
        }

        public Group(ThreadGroup group, String name) {
            super(group, name);
            this.init();
        }
    }
}

