/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

public final class PhpProcedure
implements InvocationHandler {
    private static final Constructor<MethodHandles.Lookup> LOOKUP_CONSTRUCTOR;
    private IJavaBridgeFactory bridge;
    private long object;
    private Map names;
    protected String name;

    protected PhpProcedure(IJavaBridgeFactory bridge, long object, String name, Map names) {
        this.bridge = bridge;
        this.object = object;
        this.names = names;
        this.name = name;
    }

    public static Object createProxy(IJavaBridgeFactory bridge, String name, Map names, Class[] interfaces, long object) {
        PhpProcedure handler = new PhpProcedure(bridge, object, name, names);
        ClassLoader loader = Util.getContextClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        return proxy;
    }

    public static Object createProxy(Class[] interfaces, PhpProcedure proc) {
        return PhpProcedure.createProxy(proc.bridge, proc.name, proc.names, interfaces, proc.object);
    }

    private Object invoke(Object proxy, String method, Class returnType, Object[] args) throws Throwable {
        String cname;
        JavaBridge bridge = this.bridge.getBridge();
        if (bridge.logLevel > 3) {
            bridge.logDebug("invoking callback: " + method);
        }
        if (this.name != null) {
            cname = this.name;
        } else {
            cname = (String)this.names.get(method);
            if (cname == null) {
                cname = method;
            }
        }
        bridge.request.response.setResultProcedure(this.object, cname, method, args);
        Object[] result = bridge.request.handleSubRequests();
        if (bridge.logLevel > 3) {
            bridge.logDebug("result from cb: " + Arrays.asList(result));
        }
        return bridge.coerce(returnType, result[0], bridge.request.response);
    }

    private void checkPhpContinuation() throws IllegalStateException {
        if (this.bridge.isNew()) {
            throw new IllegalStateException("Cannot call closure anymore: the closed-over PHP script continuation has been terminated.");
        }
    }

    public Object invoke(Object proxy, String method, Object[] args) throws Throwable {
        this.checkPhpContinuation();
        return this.invoke(proxy, method, Object.class, args);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkPhpContinuation();
        return method.isDefault() ? this.invokeDefaultMethod(proxy, method, args) : this.invoke(proxy, method.getName(), method.getReturnType(), args);
    }

    private Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        return LOOKUP_CONSTRUCTOR.newInstance(declaringClass, 2).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    public static long unwrap(Object ob) {
        InvocationHandler handler = Proxy.getInvocationHandler(ob);
        PhpProcedure proc = (PhpProcedure)handler;
        return proc.object;
    }

    static {
        try {
            LOOKUP_CONSTRUCTOR = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            if (!LOOKUP_CONSTRUCTOR.isAccessible()) {
                LOOKUP_CONSTRUCTOR.setAccessible(true);
            }
        }
        catch (NoSuchMethodException exp) {
            throw new IllegalStateException(exp);
        }
    }
}

