/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.bridge.http.WriterOutputStream;
import php.java.bridge.util.Logger;

public class ServletUtil {
    private static final Map<String, String> pathInfoToRealPathCache = new HashMap<String, String>();

    private ServletUtil() {
    }

    public static String getRealPath(ServletContext ctx, String pathInfoCGI) {
        String ret = pathInfoToRealPathCache.get(pathInfoCGI);
        if (ret != null) {
            return ret;
        }
        ret = ctx.getRealPath(pathInfoCGI);
        if (ret != null) {
            pathInfoToRealPathCache.put(pathInfoCGI, ret);
            return ret;
        }
        URL url = null;
        try {
            StringBuilder b = new StringBuilder();
            url = ctx.getResource("/");
            if (url != null) {
                String path = url.getPath();
                b.append(path);
                if (!path.endsWith("/")) {
                    b.append("/");
                }
                b.append(pathInfoCGI.startsWith("/") ? pathInfoCGI.substring(1) : pathInfoCGI);
                ret = b.toString().replace('/', File.separatorChar);
            }
        }
        catch (MalformedURLException e) {
            Logger.printStackTrace((Throwable)e);
        }
        if (url == null || !"file".equals(url.getProtocol())) {
            throw new IllegalStateException("Cannot access " + pathInfoCGI + " within the current web application. Please explode it: Unzip the application .war file into a directory and deploy the directory instead.");
        }
        pathInfoToRealPathCache.put(pathInfoCGI, ret);
        return ret;
    }

    public static int getLocalPort(ServletRequest req) {
        int port = -1;
        try {
            port = req.getLocalPort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port <= 0) {
            port = req.getServerPort();
        }
        return port;
    }

    public static boolean isJavaBridgeWc(String contextPath) {
        return contextPath != null && contextPath.endsWith("JavaBridge");
    }

    public static String nullsToBlanks(String s) {
        return ServletUtil.nullsToString(s, "");
    }

    public static String nullsToString(String couldBeNull, String subForNulls) {
        return couldBeNull == null ? subForNulls : couldBeNull;
    }

    public static String getHeaders(StringBuffer buf, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            buf.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            buf.append("; ");
        }
        String result = buf.toString();
        buf.setLength(0);
        return result;
    }

    public static OutputStream getServletOutputStream(HttpServletResponse response) throws IOException {
        try {
            return response.getOutputStream();
        }
        catch (IllegalStateException e) {
            WriterOutputStream out = new WriterOutputStream((Writer)response.getWriter());
            out.setEncoding(response.getCharacterEncoding());
            return out;
        }
    }

    public static int getMBeanProperty(String pattern, String property) {
        block3: {
            try {
                Class<?> objectNameClazz = Class.forName("javax.management.ObjectName");
                Constructor<?> constructor = objectNameClazz.getConstructor(String.class);
                Object objectName = constructor.newInstance(pattern);
                Class<?> clazz = Class.forName("javax.management.MBeanServerFactory");
                Method method = clazz.getMethod("findMBeanServer", String.class);
                ArrayList servers = (ArrayList)method.invoke(clazz, new Object[]{null});
                Object server = servers.get(0);
                Class<?> mBeanServerClazz = Class.forName("javax.management.MBeanServer");
                clazz = Class.forName("javax.management.QueryExp");
                method = mBeanServerClazz.getMethod("queryMBeans", objectNameClazz, clazz);
                Set s = (Set)method.invoke(server, objectName, null);
                Iterator ii = s.iterator();
                if (ii.hasNext()) {
                    clazz = Class.forName("javax.management.ObjectInstance");
                    method = clazz.getMethod("getObjectName", Util.ZERO_PARAM);
                    objectName = method.invoke(ii.next(), Util.ZERO_ARG);
                    method = mBeanServerClazz.getMethod("getAttribute", objectNameClazz, String.class);
                    Object result = method.invoke(server, objectName, property);
                    return Integer.parseInt(String.valueOf(result));
                }
            }
            catch (Exception t) {
                if (Logger.getLogLevel() <= 5) break block3;
                Logger.printStackTrace((Throwable)t);
            }
        }
        return 0;
    }
}

