/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import php.java.bridge.util.Logger;

public final class Util {
    public static int MAX_WAIT;
    public static String LAUNCHER_FLAGS;
    public static Class JAVA_INC;
    public static Class PHPDEBUGGER_PHP;
    public static Class LAUNCHER_UNIX;
    public static Class LAUNCHER_WINDOWS;
    public static Class LAUNCHER_WINDOWS2;
    public static Class LAUNCHER_WINDOWS3;
    public static Class LAUNCHER_WINDOWS4;
    public static Class LAUNCHER_WINDOWS5;
    public static Class LAUNCHER_WINDOWS6;
    public static Class LAUNCHER_WINDOWS7;
    public static final byte[] HEX_DIGITS;
    public static final boolean USE_SH_WRAPPER;
    public static final String[] ALLOW_URL_INCLUDE;
    public static final String X_JAVABRIDGE_OVERRIDE_HOSTS = "X_JAVABRIDGE_OVERRIDE_HOSTS";
    public static final String X_JAVABRIDGE_CONTEXT = "X_JAVABRIDGE_CONTEXT";
    public static final String X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT = "X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT";
    public static final String X_JAVABRIDGE_REDIRECT = "X_JAVABRIDGE_REDIRECT";
    public static final String X_JAVABRIDGE_INCLUDE = "X_JAVABRIDGE_INCLUDE";
    public static final String X_JAVABRIDGE_INCLUDE_ONLY = "X_JAVABRIDGE_INCLUDE_ONLY";
    private static DateFormat formatter;
    public static String[] PHP_ARGS;
    private static String DEFAULT_PHP_ARGS;
    public static String[] DEFAULT_CGI_LOCATIONS;
    public static final String ASCII = "ASCII";
    public static final String UTF8 = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BUF_SIZE = 8192;
    public static List ENVIRONMENT_BLACKLIST;
    public static HashMap COMMON_ENVIRONMENT;
    public static final String[] DEFAULT_EXT_DIRS;
    public static final boolean IS_GNU_JAVA;
    public static String EXTENSION_NAME;
    public static String THREAD_POOL_MAX_SIZE;
    public static int DEFAULT_LOG_LEVEL;
    public static final int BACKLOG = 20;
    public static final Object[] ZERO_ARG;
    public static final Class[] ZERO_PARAM;
    public static final byte[] RN;
    public static File TMPDIR;
    public static String VM_NAME;
    public static boolean JAVABRIDGE_PROMISCUOUS;
    public static String DEFAULT_LOG_FILE;
    static boolean DEFAULT_LOG_FILE_SET;
    public static String JAVABRIDGE_BASE;
    public static String JAVABRIDGE_LIB;
    public static String VERSION;
    public static String osArch;
    public static String osName;
    public static String PHP_EXEC;
    public static File HOME_DIR;
    public static String sessionSavePath;

    private Util() {
    }

    private static String getProperty(Properties p, String key, String defaultValue) {
        String s = null;
        if (p != null) {
            s = p.getProperty(key);
        }
        if (s == null) {
            s = System.getProperty("php.java.bridge." + String.valueOf(key).toLowerCase());
        }
        if (s == null) {
            s = defaultValue;
        }
        return s;
    }

    private static void initGlobals() {
        String val2;
        Properties p;
        block55: {
            formatter = SimpleDateFormat.getDateTimeInstance(0, 1, Locale.ENGLISH);
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                JAVA_INC = Class.forName("php.java.bridge.generated.JavaInc");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                PHPDEBUGGER_PHP = Class.forName("php.java.bridge.generated.PhpDebuggerPHP");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LAUNCHER_UNIX = Class.forName("php.java.bridge.generated.LauncherUnix");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LAUNCHER_WINDOWS = Class.forName("php.java.bridge.generated.LauncherWindows");
                LAUNCHER_WINDOWS2 = Class.forName("php.java.bridge.generated.LauncherWindows2");
                LAUNCHER_WINDOWS3 = Class.forName("php.java.bridge.generated.LauncherWindows3");
                LAUNCHER_WINDOWS4 = Class.forName("php.java.bridge.generated.LauncherWindows4");
                LAUNCHER_WINDOWS5 = Class.forName("php.java.bridge.generated.LauncherWindows5");
                LAUNCHER_WINDOWS6 = Class.forName("php.java.bridge.generated.LauncherWindows6");
                LAUNCHER_WINDOWS7 = Class.forName("php.java.bridge.generated.LauncherWindows7");
            }
            catch (Exception exception) {
                // empty catch block
            }
            p = new Properties();
            try {
                InputStream in = Util.class.getResourceAsStream("global.properties");
                p.load(in);
                VERSION = p.getProperty("BACKEND_VERSION");
            }
            catch (Throwable t) {
                VERSION = "unknown";
            }
            ENVIRONMENT_BLACKLIST = Util.getEnvironmentBlacklist(p);
            COMMON_ENVIRONMENT = Util.getCommonEnvironment(ENVIRONMENT_BLACKLIST);
            DEFAULT_CGI_LOCATIONS = new String[]{"/usr/bin/php-cgi", "c:/Program Files/PHP/php-cgi.exe"};
            try {
                if (new File(DEFAULT_CGI_LOCATIONS[0]).exists() || new File(DEFAULT_CGI_LOCATIONS[1]).exists()) break block55;
                try {
                    String programFiles;
                    File filePath = null;
                    boolean found = false;
                    String path = (String)COMMON_ENVIRONMENT.get("PATH");
                    StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                    while (tok.hasMoreTokens()) {
                        String s = tok.nextToken();
                        filePath = new File(s, "php-cgi.exe");
                        if (filePath.exists()) {
                            found = true;
                            break;
                        }
                        filePath = new File(s, "php-cgi");
                        if (!filePath.exists()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        filePath = new File("/usr/php/bin/php-cgi");
                        found = filePath.exists();
                    }
                    if (!found && (programFiles = (String)COMMON_ENVIRONMENT.get("ProgramFiles")) != null) {
                        filePath = new File(programFiles + "\\PHP\\php-cgi.exe");
                        found = filePath.exists();
                    }
                    if (found) {
                        DEFAULT_CGI_LOCATIONS = new String[]{filePath.getCanonicalPath(), DEFAULT_CGI_LOCATIONS[0], DEFAULT_CGI_LOCATIONS[1]};
                    }
                }
                catch (Exception filePath) {}
            }
            catch (Throwable filePath) {
                // empty catch block
            }
        }
        LAUNCHER_FLAGS = Util.getProperty(p, "php.java.bridge.launcher_flags", "16777216");
        try {
            MAX_WAIT = Integer.parseInt(Util.getProperty(p, "php.java.bridge.max_wait", "15000"));
        }
        catch (Exception e) {
            MAX_WAIT = 15000;
        }
        try {
            HOME_DIR = new File(System.getProperty("user.home"));
        }
        catch (Exception e) {
            HOME_DIR = null;
        }
        try {
            JAVABRIDGE_BASE = Util.getProperty(p, "php.java.bridge.base", System.getProperty("user.home"));
            JAVABRIDGE_LIB = JAVABRIDGE_BASE + File.separator + "lib";
        }
        catch (Exception e) {
            JAVABRIDGE_BASE = ".";
            JAVABRIDGE_LIB = ".";
        }
        try {
            VM_NAME = "unknown";
            VM_NAME = System.getProperty("java.version") + "@" + System.getProperty("java.vendor.url");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            JAVABRIDGE_PROMISCUOUS = false;
            JAVABRIDGE_PROMISCUOUS = Util.getProperty(p, "php.java.bridge.promiscuous", "false").toLowerCase().equals("true");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            THREAD_POOL_MAX_SIZE = "20";
            THREAD_POOL_MAX_SIZE = Util.getProperty(p, "THREADS", "20");
        }
        catch (Throwable e) {
            // empty catch block
        }
        TMPDIR = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        if (!TMPDIR.exists() || !TMPDIR.isDirectory()) {
            TMPDIR = null;
        }
        sessionSavePath = null;
        if (TMPDIR != null) {
            try {
                TMPDIR = TMPDIR.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (TMPDIR != null) {
            sessionSavePath = TMPDIR.getPath();
        }
        DEFAULT_PHP_ARGS = "-d java.session=On -d display_errors=Off -d log_errors=On -d java.persistent_servlet_connections=On";
        try {
            String str = Util.getProperty(p, "PHP_EXEC_ARGS", DEFAULT_PHP_ARGS);
            String[] args = str.split(" ");
            for (int i = 0; i < args.length; ++i) {
                try {
                    args[i] = URLDecoder.decode(args[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            PHP_ARGS = args;
        }
        catch (Throwable str) {
            // empty catch block
        }
        try {
            EXTENSION_NAME = "JavaBridge";
            EXTENSION_NAME = Util.getProperty(p, "EXTENSION_DISPLAY_NAME", "JavaBridge");
        }
        catch (Throwable str) {
            // empty catch block
        }
        try {
            PHP_EXEC = Util.getProperty(p, "PHP_EXEC", null);
        }
        catch (Throwable str) {
            // empty catch block
        }
        try {
            String s = Util.getProperty(p, "DEFAULT_LOG_LEVEL", "3");
            DEFAULT_LOG_LEVEL = Integer.parseInt(s);
            Logger.setLogLevel(DEFAULT_LOG_LEVEL);
        }
        catch (Throwable s) {
            // empty catch block
        }
        try {
            DEFAULT_LOG_FILE_SET = false;
            DEFAULT_LOG_FILE = Util.getProperty(p, "DEFAULT_LOG_FILE", EXTENSION_NAME + ".log");
            DEFAULT_LOG_FILE_SET = System.getProperty("php.java.bridge.default_log_file") != null;
        }
        catch (Throwable s) {
            // empty catch block
        }
        String separator = "/-+.,;: ";
        try {
            val2 = System.getProperty("os.arch").toLowerCase();
            StringTokenizer t = new StringTokenizer(val2, separator);
            osArch = t.nextToken();
        }
        catch (Throwable val2) {
            // empty catch block
        }
        if (osArch == null) {
            osArch = "unknown";
        }
        try {
            val2 = System.getProperty("os.name").toLowerCase();
            StringTokenizer t = new StringTokenizer(val2, separator);
            osName = t.nextToken();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (osName == null) {
            osName = "unknown";
        }
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class c = Util.getClass(obj);
        String name = c.getName();
        if (name.startsWith("[")) {
            name = "array_of_" + name.substring(1);
        }
        return name;
    }

    public static String getShortClassName(Object obj) {
        String name = Util.getClassName(obj);
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static String getShortName(Class clazz) {
        int idx;
        String name = clazz.getName();
        if (name.startsWith("[")) {
            name = "array_of_" + name.substring(1);
        }
        if ((idx = name.lastIndexOf(46)) != -1) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static Class getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    public static void appendObject(Object obj, StringBuffer buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Class) {
            if (((Class)obj).isInterface()) {
                buf.append("[i:");
            } else {
                buf.append("[c:");
            }
        } else {
            buf.append("[o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append("]:");
        buf.append("\"");
        buf.append(Util.stringValueOf(obj));
        buf.append("\"");
    }

    public static void appendTrace(Throwable throwable, String trace, StringBuffer buf) {
        buf.append(" at:\n");
        StackTraceElement[] stack = throwable.getStackTrace();
        int top = stack.length;
        for (int i = 0; i < top; ++i) {
            buf.append("#-");
            buf.append(top - i);
            buf.append(" ");
            buf.append(stack[i].toString());
            buf.append("\n");
        }
        buf.append(trace);
    }

    public static void appendShortObject(Object obj, StringBuffer buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Class) {
            if (((Class)obj).isInterface()) {
                buf.append("[i:");
            } else {
                buf.append("[c:");
            }
        } else {
            buf.append("[o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append("]");
    }

    public static void appendParam(Class c, StringBuffer buf) {
        if (c.isInterface()) {
            buf.append("(i:");
        } else if (c == Class.class) {
            buf.append("(c:");
        } else {
            buf.append("(o:");
        }
        buf.append(Util.getShortClassName(c));
        buf.append(")");
    }

    public static void appendParam(Object obj, StringBuffer buf) {
        if (obj instanceof Class) {
            Class c = (Class)obj;
            if (c.isInterface()) {
                buf.append("(i:");
            } else {
                buf.append("(c:");
            }
        } else {
            buf.append("(o:");
        }
        buf.append(Util.getShortClassName(obj));
        buf.append(")");
    }

    public static String argsToString(Object[] args, Class[] params) {
        StringBuffer buffer = new StringBuffer("");
        Util.appendArgs(args, params, buffer);
        return buffer.toString();
    }

    public static void appendArgs(Object[] args, Class[] params, StringBuffer buf) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (params != null) {
                    Util.appendParam(params[i], buf);
                }
                Util.appendShortObject(args[i], buf);
                if (i + 1 >= args.length) continue;
                buf.append(", ");
            }
        }
    }

    public static byte[] toBytes(String s) {
        try {
            return s.getBytes(ASCII);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s.getBytes();
        }
    }

    public static String[] hashToStringArray(Map h) {
        Vector<String> v = new Vector<String>();
        Iterator e = h.keySet().iterator();
        while (e.hasNext()) {
            String k = e.next().toString();
            v.add(k + "=" + h.get(k));
        }
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }

    public static String getHostAddress(boolean promiscuous) {
        String addr = "127.0.0.1";
        try {
            if (JAVABRIDGE_PROMISCUOUS || promiscuous) {
                addr = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }

    public static String[] checkCgiBinary(String php) {
        File location;
        File phpFile = new File(php);
        String path = phpFile.getParent();
        String file = phpFile.getName();
        StringBuffer buf = Util.canonicalPath(path, file);
        if (USE_SH_WRAPPER) {
            location = new File(buf.toString() + ".sh");
            if (Logger.getLogLevel() > 3) {
                Logger.logDebug("trying: " + location);
            }
            if (location.exists()) {
                return new String[]{"/bin/sh", location.getAbsolutePath()};
            }
        } else {
            location = new File(buf.toString() + ".exe");
            if (Logger.getLogLevel() > 3) {
                Logger.logDebug("trying: " + location);
            }
            if (location.exists()) {
                return new String[]{location.getAbsolutePath()};
            }
        }
        location = new File(buf.toString());
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug("trying: " + location);
        }
        if (location.exists()) {
            return new String[]{location.getAbsolutePath()};
        }
        return null;
    }

    public static StringBuffer canonicalPath(String path, String file) {
        StringBuffer buf = new StringBuffer();
        if (path != null) {
            buf.append(path);
            buf.append(File.separatorChar);
        }
        buf.append(osArch);
        buf.append("-");
        buf.append(osName);
        buf.append(File.separatorChar);
        buf.append(file);
        return buf;
    }

    public static String checkError(String s) {
        return s.startsWith("PHP") && s.indexOf("error:") > -1 ? s : null;
    }

    private static List getEnvironmentBlacklist(Properties p) {
        LinkedList<String> l = new LinkedList<String>();
        try {
            String s = Util.getProperty(p, "PHP_ENV_BLACKLIST", "PHPRC");
            StringTokenizer t = new StringTokenizer(s, " ");
            while (t.hasMoreTokens()) {
                l.add(t.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            l = new LinkedList();
            l.add("PHPRC");
        }
        return l;
    }

    private static HashMap getCommonEnvironment(List blacklist) {
        String s2;
        String val;
        String[] entries = new String[]{"PATH", "PATH", "LD_LIBRARY_PATH", "LD_ASSUME_KERNEL", "USER", "TMP", "TEMP", "HOME", "HOMEPATH", "LANG", "TZ", "OS"};
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        Method m = null;
        try {
            m = System.class.getMethod("getenv", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < entries.length; ++i) {
            val = null;
            if (m != null) {
                try {
                    val = (String)m.invoke(System.class, (Object[])new String[]{entries[i]});
                }
                catch (Exception e) {
                    m = null;
                }
            }
            if (val == null) {
                try {
                    val = System.getProperty(entries[i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (val == null || blacklist.contains(entries[i])) continue;
            defaultEnv.put(entries[i], val);
        }
        val = null;
        String key = null;
        if (new File("c:/winnt").isDirectory()) {
            val = "c:\\winnt";
        } else if (new File("c:/windows").isDirectory()) {
            val = "c:\\windows";
        }
        try {
            key = "SystemRoot";
            s2 = System.getenv("SystemRoot");
            if (s2 != null) {
                val = s2;
            }
        }
        catch (Throwable s2) {
            // empty catch block
        }
        try {
            key = "Windows.SystemRoot";
            s2 = System.getProperty("Windows.SystemRoot");
            if (s2 != null) {
                val = s2;
            }
        }
        catch (Throwable s3) {
            // empty catch block
        }
        if (val != null && !blacklist.contains(key)) {
            defaultEnv.put("SystemRoot", val);
        }
        try {
            m = System.class.getMethod("getenv", ZERO_PARAM);
            Map map = (Map)m.invoke(System.class, ZERO_ARG);
            for (Map.Entry entry : map.entrySet()) {
                key = (String)entry.getKey();
                val = (String)entry.getValue();
                if (blacklist.contains(key)) continue;
                defaultEnv.put(key, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultEnv;
    }

    public static String stringValueOf(Object object) {
        String s = String.valueOf(object);
        if (s == null) {
            s = String.valueOf(s);
        }
        return s;
    }

    public static String formatDateTime(long ms) {
        return formatter.format(new Date(ms));
    }

    static final boolean checkVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (loader == null) {
            loader = Util.class.getClassLoader();
        }
        return loader;
    }

    public static final Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Util.getContextClassLoader());
    }

    public static String getSimpleRedirectString(String webPath, String socketName, boolean isSecure) {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(socketName);
            buf.append("/");
            buf.append(webPath);
            URI uri = new URI(isSecure ? "s:127.0.0.1" : "h:127.0.0.1", buf.toString(), null);
            return uri.toASCIIString() + ".phpjavabridge";
        }
        catch (URISyntaxException e) {
            Logger.printStackTrace(e);
            StringBuffer buf = new StringBuffer(isSecure ? "s:127.0.0.1" : "h:127.0.0.1:");
            buf.append(socketName);
            buf.append('/');
            buf.append(webPath);
            buf.append(".phpjavabridge");
            return buf.toString();
        }
    }

    static {
        Util.initGlobals();
        HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        USE_SH_WRAPPER = new File("/bin/sh").exists();
        ALLOW_URL_INCLUDE = new String[]{"-d", "allow_url_include=On"};
        DEFAULT_EXT_DIRS = new String[]{"/usr/share/java/ext", "/usr/java/packages/lib/ext"};
        IS_GNU_JAVA = Util.checkVM();
        ZERO_ARG = new Object[0];
        ZERO_PARAM = new Class[0];
        RN = Util.toBytes("\r\n");
    }
}

