/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import php.java.bridge.Util;
import php.java.bridge.util.Logger;
import php.java.fastcgi.CloseableConnection;
import php.java.fastcgi.Connection;
import php.java.fastcgi.ConnectionException;
import php.java.fastcgi.FCGIHelper;
import php.java.fastcgi.FCGIProcess;
import php.java.fastcgi.FCGIProcessException;
import php.java.fastcgi.SocketFactory;

public abstract class FCGIFactory {
    private static final int THREAD_POOL_MAX_SIZE = Integer.parseInt(Util.THREAD_POOL_MAX_SIZE);
    protected boolean promiscuous;
    protected CloseableConnection fcgiConnectionPool;
    protected FCGIProcess proc = null;
    private boolean fcgiStarted = false;
    private final Object fcgiStartLock = new Object();
    protected Exception fcgiProcessStartException;
    protected Map env;
    protected String[] args;
    protected FCGIHelper helper;

    public FCGIFactory(String[] args, Map env, CloseableConnection fcgiConnectionPool, FCGIHelper helper) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = args;
        if (env == null) {
            throw new NullPointerException("env");
        }
        this.env = env;
        this.fcgiConnectionPool = fcgiConnectionPool;
        this.helper = helper;
    }

    public void startFCGIServer() throws FCGIProcessException, ConnectionException {
        this.findFreePort(!this.helper.isInternalDefaultPort());
        this.initialize(this.helper.isExternalFCGIPool());
        File cgiOsDir = Util.TMPDIR;
        this.helper.createLauncher(cgiOsDir);
        if (!this.helper.isExternalFCGIPool()) {
            this.startServer();
        }
        this.test("Could not connect to server. Please start it with: " + this.getFcgiStartCommand(this.helper.getCgiDir(), this.helper.getPhpFcgiMaxRequests()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean startServer() {
        Object object = this.fcgiStartLock;
        synchronized (object) {
            if (!this.fcgiStarted) {
                if (this.canStartFCGI()) {
                    try {
                        this.bind();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.fcgiStarted = true;
            }
        }
        return this.fcgiStarted;
    }

    public abstract void test(String var1) throws FCGIProcessException, ConnectionException;

    protected abstract void waitForDaemon() throws UnknownHostException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runFcgi() {
        byte[] buf = new byte[8192];
        try {
            FCGIProcess proc = this.doBind();
            if (proc == null || proc.getInputStream() == null) {
                return;
            }
            proc.getInputStream().close();
            InputStream in = proc.getErrorStream();
            try {
                int c;
                while ((c = in.read(buf)) != -1) {
                    Logger.logError(new String(buf, 0, c));
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            this.fcgiProcessStartException = e;
            Logger.logError("Could not start FCGI server: " + e);
        }
    }

    protected abstract FCGIProcess doBind() throws IOException;

    protected void bind() throws InterruptedException, IOException {
        Thread t = new Thread("JavaBridgeFastCGIRunner"){

            @Override
            public void run() {
                FCGIFactory.this.runFcgi();
            }
        };
        t.start();
        this.waitForDaemon();
    }

    private boolean canStartFCGI() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.fcgiStartLock;
        synchronized (object) {
            this.fcgiStarted = false;
            if (this.proc == null) {
                return;
            }
            try {
                OutputStream out = this.proc.getOutputStream();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
            }
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.proc.waitFor(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.proc.destroy();
            }
            catch (Exception e) {
                Logger.printStackTrace(e);
            }
            this.proc = null;
        }
    }

    public abstract Connection connect() throws FCGIProcessException;

    public void initialize(boolean externalPool) {
        if (externalPool) {
            this.setDefaultPort();
        } else {
            this.setDynamicPort();
        }
    }

    protected abstract void setDynamicPort();

    protected abstract void setDefaultPort();

    public abstract String getFcgiStartCommand(String var1, int var2);

    public abstract void findFreePort(boolean var1);

    public static FCGIFactory createConnectionFactory(String[] args, Map env, CloseableConnection fcgiConnectionPool, FCGIHelper helper) {
        return new SocketFactory(args, env, fcgiConnectionPool, helper);
    }

    protected FCGIProcess createFCGIProcess(String[] args, Map env) throws IOException {
        env = new HashMap<String, String>(env);
        env.put("PHP_FCGI_MAX_REQUESTS", String.valueOf(this.helper.getPhpFcgiMaxRequests()));
        Object children = env.get("PHP_FCGI_CHILDREN");
        if (children == null) {
            env.put("PHP_FCGI_CHILDREN", "5");
        } else if (Integer.parseInt(String.valueOf(children)) > THREAD_POOL_MAX_SIZE) {
            env.put("PHP_FCGI_CHILDREN", "5");
        }
        return new FCGIProcess.Builder().withArgs(args).withEnv(env).withHelper(this.helper).build();
    }
}

