/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import php.java.bridge.util.Logger;
import php.java.servlet.ServletUtil;

public class PhpCGIFilter
implements Filter {
    public static final String PHP_SUFFIX = ".php/";
    private String DOCUMENT_ROOT;

    public String getPhpSuffix() {
        return PHP_SUFFIX;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = ((HttpServletRequest)request).getRequestURI();
        String PHP_SUFFIX = this.getPhpSuffix();
        int PHP_SUFFIX_LEN = PHP_SUFFIX.length();
        int idx = uri.indexOf(PHP_SUFFIX);
        if (idx != -1) {
            final String pathInfo = uri.substring(idx + PHP_SUFFIX_LEN - 1);
            final String pathTranslated = this.DOCUMENT_ROOT + pathInfo;
            final String dispatch = uri.substring(0, idx + PHP_SUFFIX_LEN - 1);
            String servletPathOrig = ((HttpServletRequest)request).getServletPath();
            idx = servletPathOrig.indexOf(PHP_SUFFIX);
            if (idx == -1) {
                Logger.warn((String)("INTERNAL ERROR: " + servletPathOrig));
                chain.doFilter(request, response);
                return;
            }
            final String servletPath = servletPathOrig.substring(0, idx + PHP_SUFFIX_LEN - 1);
            HttpServletRequestWrapper req = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getPathInfo() {
                    return pathInfo;
                }

                public String getPathTranslated() {
                    return pathTranslated;
                }

                public String getServletPath() {
                    return servletPath;
                }

                public String getRequestURI() {
                    return dispatch;
                }

                public StringBuffer getRequestURL() {
                    try {
                        return new StringBuffer(new URI(this.getScheme(), null, this.getServerName(), this.getServerPort(), this.getRequestURI(), null, null).toURL().toExternalForm());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            request.getRequestDispatcher(dispatch).forward((ServletRequest)req, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.DOCUMENT_ROOT = ServletUtil.getRealPath(config.getServletContext(), "");
    }

    public void destroy() {
    }
}

