/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.util;

import java.util.LinkedList;
import php.java.bridge.util.Logger;
import php.java.bridge.util.Thread;

public class ThreadPool {
    private String name;
    private int threads = 0;
    private int idles = 0;
    private int poolMaxSize;
    private int poolReserve;
    private LinkedList runnables = new LinkedList();
    private LinkedList threadList = new LinkedList();

    protected Delegate createDelegate(String name) {
        return new Delegate(name);
    }

    protected void startNewThread(String name) {
        Delegate d = this.createDelegate(name);
        this.threadList.add(d);
        d.start();
    }

    protected synchronized boolean checkReserve() {
        return this.threads - this.idles < this.poolReserve;
    }

    private synchronized Runnable getNextRunnable() throws InterruptedException {
        while (this.runnables.isEmpty()) {
            ++this.idles;
            this.wait();
            --this.idles;
        }
        return (Runnable)this.runnables.removeFirst();
    }

    public synchronized void start(Runnable r) {
        this.runnables.add(r);
        if (this.idles == 0 && this.threads < this.poolMaxSize) {
            ++this.threads;
            this.startNewThread(this.name + "#" + String.valueOf(this.threads));
        } else {
            this.notify();
        }
    }

    protected void init(String name, int poolMaxSize) {
        this.name = name;
        this.poolMaxSize = poolMaxSize;
        this.poolReserve = (poolMaxSize >>> 2) * 3;
    }

    public void destroy() {
        for (Delegate d : this.threadList) {
            d.terminate = true;
            d.interrupt();
        }
    }

    public ThreadPool(String name, int poolMaxSize) {
        if (poolMaxSize < 1) {
            throw new IllegalArgumentException("poolMaxSize must be >0");
        }
        this.init(name, poolMaxSize);
    }

    protected class Delegate
    extends Thread {
        protected boolean terminate;

        public Delegate(String name) {
            super(name);
            this.terminate = false;
        }

        public Delegate(ThreadGroup group, String name) {
            super(group, name);
            this.terminate = false;
        }

        protected void terminate() {
        }

        protected void end() {
        }

        protected void createThread(String name) {
            ThreadPool.this.startNewThread(name);
        }

        @Override
        public void run() {
            try {
                while (!this.terminate) {
                    ThreadPool.this.getNextRunnable().run();
                    this.end();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                Logger.printStackTrace(t);
                this.createThread(this.getName());
            }
            finally {
                this.terminate();
            }
        }
    }
}

