/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.IOException;
import java.io.InputStream;
import php.java.bridge.util.NotImplementedException;
import php.java.fastcgi.ConnectionException;
import php.java.fastcgi.FCGIProcessException;

public class FCGIInputStream
extends InputStream {
    private InputStream in;
    private byte[] header = new byte[8];

    public FCGIInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws ConnectionException {
        throw new NotImplementedException();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read(byte[] buf) throws ConnectionException {
        try {
            return this.doRead(buf);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex);
        }
    }

    @Override
    public int read(byte[] buf, int off, int buflength) throws ConnectionException {
        try {
            return this.in.read(buf, off, buflength);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex);
        }
    }

    @Override
    public void close() throws ConnectionException, FCGIProcessException {
    }

    private int doRead(byte[] buf) throws IOException {
        int i;
        int n = 0;
        while ((i = this.read(this.header, n, 8 - n)) > 0) {
            n += i;
        }
        if (8 != n) {
            throw new IOException("Protocol error");
        }
        int type = this.header[1] & 0xFF;
        int contentLength = (this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF;
        int paddingLength = this.header[6] & 0xFF;
        switch (type) {
            case 6: 
            case 7: {
                n = 0;
                while ((i = this.read(buf, n, contentLength - n)) > 0) {
                    n += i;
                }
                if (n != contentLength) {
                    throw new IOException("Protocol error while reading FCGI data");
                }
                if (paddingLength > 0) {
                    byte[] b = new byte[paddingLength];
                    n = 0;
                    while ((i = this.read(b, n, b.length - n)) > 0) {
                        n += i;
                    }
                    if (n != paddingLength) {
                        throw new IOException("Protocol error while reading FCGI padding");
                    }
                }
                if (type == 7) {
                    return contentLength * -1 - 1;
                }
                return contentLength;
            }
            case 3: {
                n = 0;
                while ((i = this.read(buf, n, contentLength - n)) > 0) {
                    n += i;
                }
                if (n != contentLength) {
                    throw new IOException("Protocol error while reading EOF data");
                }
                if (paddingLength > 0) {
                    n = 0;
                    while ((i = this.read(buf, n, buf.length - n)) > 0) {
                        n += i;
                    }
                    if (n != paddingLength) {
                        throw new IOException("Protocol error while reading EOF padding");
                    }
                }
                return -1;
            }
        }
        throw new IOException("Received unknown type");
    }
}

