/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;
import gnu.lists.VoidConsumer;
import java.io.PrintWriter;

public class TreeList
extends AbstractSequence
implements Consumer,
Consumable {
    public Object[] objects;
    static final Object availObject = new String("(AVAIL");
    public char[] data;
    public int gapStart;
    public int gapEnd;
    static final int MAX_CHAR_SHORT = 40959;
    static final int MIN_INT_SHORT = -4096;
    static final int MAX_INT_SHORT = 8191;
    static final int INT_SHORT_ZERO = 49152;
    static final int OBJECT_REF_SHORT = 57344;
    static final int OBJECT_REF_SHORT_INDEX_MAX = 4095;
    static final char OBJECT_REF_FOLLOWS = '\uf10d';
    static final int BYTE_PREFIX = 61440;
    static final char BOOL_FALSE = '\uf100';
    static final char BOOL_TRUE = '\uf101';
    static final int INT_FOLLOWS = 61698;
    static final int LONG_FOLLOWS = 61699;
    static final int FLOAT_FOLLOWS = 61700;
    static final int DOUBLE_FOLLOWS = 61701;
    static final int CHAR_FOLLOWS = 61702;
    static final int CHAR_PAIR_FOLLOWS = 61703;
    static final int BEGIN_ATTRIBUTE_LONG = 61705;
    static final int END_ATTRIBUTES = 61706;
    static final int BEGIN_GROUP_SHORT = 40960;
    static final int BEGIN_GROUP_SHORT_INDEX_MAX = 4095;
    static final int END_GROUP_SHORT = 61707;
    static final int BEGIN_GROUP_LONG = 61704;
    static final int END_GROUP_LONG = 61708;
    int currentBeginGroup = 0;
    int attributeStart;

    public TreeList() {
        this.resizeObjects();
        this.gapEnd = 200;
        this.data = new char[this.gapEnd];
    }

    public void clear() {
        this.gapStart = 0;
        this.gapEnd = this.data.length;
        if (this.gapEnd > 1500) {
            this.gapEnd = 200;
            this.data = new char[this.gapEnd];
        }
        this.objects = null;
        this.resizeObjects();
    }

    public void ensureSpace(int n) {
        int n2 = this.gapEnd - this.gapStart;
        if (n > n2) {
            int n3;
            int n4 = this.data.length;
            int n5 = 2 * n4;
            int n6 = n4 - n2 + n;
            if (n5 < n6) {
                n5 = n6;
            }
            char[] cArray = new char[n5];
            if (this.gapStart > 0) {
                System.arraycopy(this.data, 0, cArray, 0, this.gapStart);
            }
            if ((n3 = n4 - this.gapEnd) > 0) {
                System.arraycopy(this.data, this.gapEnd, cArray, n5 - n3, n3);
            }
            this.gapEnd = n5 - n3;
            this.data = cArray;
        }
    }

    public final void resizeObjects() {
        Object[] objectArray;
        int n;
        int n2;
        if (this.objects == null) {
            n2 = 0;
            n = 100;
            objectArray = new Object[n];
        } else {
            n2 = this.objects.length;
            n = 2 * n2;
            objectArray = new Object[n];
            System.arraycopy(this.objects, 0, objectArray, 0, n2);
        }
        Object object2 = availObject;
        int n3 = n2;
        while (n3 < n) {
            objectArray[n3] = object2;
            ++n3;
        }
        this.objects = objectArray;
    }

    protected int find(Object object2) {
        int n = 0;
        int n2 = this.objects.length;
        Object object3 = availObject;
        int n3 = -1;
        while (n < n2) {
            Object object4 = this.objects[n];
            if (object4 == object2) {
                return n;
            }
            if (object4 == object3 && n3 < 0) {
                n3 = n;
            }
            ++n;
        }
        if (n3 >= 0) {
            this.objects[n3] = object2;
            return n3;
        }
        this.resizeObjects();
        this.objects[n2] = object2;
        return n2;
    }

    protected int find(Object object2, Object object3) {
        int n = 0;
        int n2 = this.objects.length;
        Object object4 = availObject;
        int n3 = -1;
        Object[] objectArray = this.objects;
        while (n + 1 < n2) {
            Object object5 = objectArray[n];
            if (object5 == object2 && objectArray[n + 1] == object3) {
                return n;
            }
            if (n3 < 0 && object5 == object4 && objectArray[n + 1] == object4) {
                n3 = n;
            }
            ++n;
        }
        if (n3 >= 0) {
            objectArray[n3] = object2;
            objectArray[n3 + 1] = object3;
            return n3;
        }
        this.resizeObjects();
        objectArray = this.objects;
        objectArray[n2] = object2;
        objectArray[n2 + 1] = object3;
        return n2;
    }

    protected final int getIntN(int n) {
        return this.data[n] << 16 | this.data[n + 1];
    }

    protected final long getLongN(int n) {
        char[] cArray = this.data;
        return cArray[n] << 48 | cArray[n + 1] << 32 | cArray[n + 2] << 16 | cArray[n + 3];
    }

    public final void setIntN(int n, int n2) {
        this.data[n] = (char)(n2 >> 16);
        this.data[n + 1] = (char)n2;
    }

    public void writeObject(Object object2) {
        this.ensureSpace(3);
        int n = this.find(object2);
        if (n < 4096) {
            this.data[this.gapStart++] = (char)(0xE000 | n);
        } else {
            this.data[this.gapStart++] = 61709;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void beginGroup(String string, Object object2) {
        this.beginGroup(this.find(string, object2));
    }

    public void beginGroup(int n) {
        this.ensureSpace(11);
        this.gapEnd -= 7;
        this.data[this.gapStart++] = 61704;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61708;
        this.setIntN(this.gapEnd + 1, n);
        this.setIntN(this.gapEnd + 3, this.gapStart - 3);
        this.setIntN(this.gapEnd + 5, this.currentBeginGroup);
        this.currentBeginGroup = this.gapStart - 3;
        this.data[--this.gapEnd] = 61706;
    }

    public void endGroup(String string) {
        if (this.data[this.gapEnd] != '\uf10c') {
            throw new Error("unexpected endGroup");
        }
        int n = this.getIntN(this.gapEnd + 1);
        int n2 = this.getIntN(this.gapEnd + 3);
        int n3 = this.getIntN(this.gapEnd + 5);
        this.gapEnd += 7;
        int n4 = this.gapStart - n2;
        int n5 = n2 - n3;
        if (n < 4095 && n4 < 65536 && n5 < 65536) {
            this.data[n2] = (char)(0xA000 | n);
            this.data[n2 + 1] = (char)n4;
            this.data[n2 + 2] = (char)n5;
            this.data[this.gapStart] = 61707;
            this.data[this.gapStart + 1] = (char)n4;
            this.gapStart += 2;
        } else {
            this.data[n2] = 61704;
            this.setIntN(n2 + 1, n4);
            this.data[this.gapStart] = 61708;
            this.setIntN(this.gapStart + 1, n);
            this.setIntN(this.gapStart + 3, -n4);
            if (n3 >= this.gapStart || n2 <= this.gapStart) {
                n3 -= this.gapStart;
            }
            this.setIntN(this.gapStart + 5, n3);
            this.gapStart += 7;
        }
        this.currentBeginGroup = n3;
    }

    public void beginAttribute(String string, Object object2) {
        this.beginAttribute(this.find(string, object2));
    }

    public void beginAttribute(int n) {
        if (this.data[this.gapEnd] != '\uf10a') {
            throw new Error("unexpected beginAttribute");
        }
        if (this.attributeStart > 0) {
            this.setIntN(this.attributeStart + 3, this.gapStart - this.attributeStart);
        }
        this.attributeStart = this.gapStart;
        this.ensureSpace(6);
        this.data[this.gapStart++] = 61705;
        this.setIntN(this.gapStart, n);
        this.setIntN(this.gapStart + 2, this.gapEnd - this.data.length);
        this.gapStart += 4;
    }

    public void endAttributes() {
        if (this.attributeStart > 0) {
            this.setIntN(this.attributeStart + 3, this.gapStart - this.attributeStart);
        }
        if (this.data[this.gapEnd] != '\uf10a') {
            throw new Error("unexpected endAttributes");
        }
        ++this.gapEnd;
        this.data[this.gapStart++] = 61706;
        this.attributeStart = 0;
    }

    public void writeChar(int n) {
        this.ensureSpace(3);
        if (n <= 40959) {
            this.data[this.gapStart++] = (char)n;
        } else if (n < 65536) {
            this.data[this.gapStart++] = 61702;
            this.data[this.gapStart++] = (char)n;
        } else {
            this.data[this.gapStart++] = 61703;
        }
    }

    public void writeBoolean(boolean bl) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = bl ? 61697 : 61696;
    }

    public void writeByte(int n) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = (char)(61440 + (n & 0xFF));
    }

    public void writeInt(int n) {
        this.ensureSpace(3);
        if (n >= -4096 && n <= 8191) {
            this.data[this.gapStart++] = (char)(49152 + n);
        } else {
            this.data[this.gapStart++] = 61698;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeLong(long l) {
        this.ensureSpace(5);
        this.data[this.gapStart++] = 61699;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public void writeFloat(float f) {
        this.ensureSpace(3);
        int n = Float.floatToIntBits(f);
        this.data[this.gapStart++] = 61700;
        this.data[this.gapStart++] = (char)(n >>> 16);
        this.data[this.gapStart++] = (char)n;
    }

    public void writeDouble(double d) {
        this.ensureSpace(5);
        long l = Double.doubleToLongBits(d);
        this.data[this.gapStart++] = 61701;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        this.ensureSpace(n2);
        while (n2 > 0) {
            char c = cArray[n++];
            --n2;
            if (c <= '\u9fff') {
                this.data[this.gapStart++] = c;
                continue;
            }
            this.writeChar(c);
            this.ensureSpace(n2);
        }
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        int n3 = this.data.length;
        VoidConsumer voidConsumer = VoidConsumer.getInstance();
        while (true) {
            if (n2 == this.gapStart) {
                n2 = this.gapEnd;
            }
            if (n2 == n3) {
                return n;
            }
            n2 = this.consumeRange(n2, n3, 1, voidConsumer);
            ++n;
        }
    }

    protected void makePosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        int n3 = 0;
        while (--n >= 0) {
            if ((n3 = this.nextDataIndex(n3)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        positionContainer.setPosition(n2, n3 << 1 | (bl ? 1 : 0), null);
        positionContainer.setSequence(n2, this);
    }

    public boolean gotoChildrenStart(TreePosition treePosition) {
        int n = treePosition.ipos >> 1;
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return false;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            n += 3;
        } else {
            return false;
        }
        while (true) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            }
            if ((c = this.data[n]) == '\uf109') {
                int n2;
                n = n2 + ((n2 = this.getIntN(n + 3)) < 0 ? this.data.length : n);
                continue;
            }
            if (c != '\uf10a') break;
            ++n;
        }
        treePosition.push(this, n << 1, null);
        return true;
    }

    public Object get(int n) {
        throw this.unsupported("get");
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        if (!this.hasNext(n, object2)) {
            return false;
        }
        this.consumeRange(n >>> 1, this.data.length, 1, consumer);
        return true;
    }

    public int consumeRange(int n, int n2, int n3, Consumer consumer) {
        int n4;
        block23: {
            char c;
            int n5;
            n4 = n;
            int n6 = n5 = n <= this.gapStart && n2 > this.gapStart ? this.gapStart : n2;
            block15: while (true) {
                int n7;
                if (n4 >= n5) {
                    if (n4 != this.gapStart || n2 <= this.gapEnd) break block23;
                    n4 = this.gapEnd;
                    n5 = n2;
                }
                if (n3 >= 0 && --n3 == 0) break block23;
                if ((c = this.data[n4++]) <= '\u9fff') {
                    int n8;
                    int n9 = n4 - 1;
                    if (n3 < 0 || (n8 = n9 + n3) < n5) {
                        n8 = n5;
                    }
                    while (n4 < n8) {
                        if ((c = this.data[n4++]) <= '\u9fff') continue;
                        --n4;
                        break;
                    }
                    consumer.write(this.data, n9, n4 - n9);
                    continue;
                }
                if (c >= '\ue000' && c <= '\uefff') {
                    consumer.writeObject(this.objects[c - 57344]);
                    continue;
                }
                if (c >= '\ua000' && c <= '\uafff') {
                    n7 = c - 40960;
                    consumer.beginGroup(this.objects[n7].toString(), this.objects[n7 + 1]);
                    n4 += 2;
                    continue;
                }
                if (c >= '\ub000' && c <= '\udfff') {
                    consumer.writeInt(c - 49152);
                    continue;
                }
                switch (c) {
                    case '\uf100': 
                    case '\uf101': {
                        consumer.writeBoolean(c != '\uf100');
                        continue block15;
                    }
                    case '\uf106': {
                        consumer.write(this.data, n4, '\u0001' + c - 61702);
                        ++n4;
                        continue block15;
                    }
                    case '\uf107': {
                        consumer.write(this.data, n4, '\u0001' + c - 61702);
                        n4 += 2;
                        continue block15;
                    }
                    case '\uf10d': {
                        consumer.writeObject(this.objects[this.getIntN(n4)]);
                        n4 += 2;
                        continue block15;
                    }
                    case '\uf10b': {
                        n7 = this.data[n4++];
                        n7 = this.data[n4 - 2 - n7] - 40960;
                        consumer.endGroup(this.objects[n7].toString());
                        continue block15;
                    }
                    case '\uf108': {
                        n7 = this.getIntN(n4);
                        n7 += n7 >= 0 ? (n4 += 2) - 1 : this.data.length;
                        n7 = this.getIntN(n7 + 1);
                        consumer.beginGroup(this.objects[n7].toString(), this.objects[n7 + 1]);
                        continue block15;
                    }
                    case '\uf10c': {
                        n7 = this.getIntN(n4);
                        consumer.endGroup(this.objects[n7].toString());
                        n4 += 6;
                        continue block15;
                    }
                    case '\uf109': {
                        n7 = this.getIntN(n4);
                        consumer.beginAttribute(this.objects[n7].toString(), this.objects[n7 + 1]);
                        n4 += 4;
                        continue block15;
                    }
                    case '\uf10a': {
                        consumer.endAttributes();
                        continue block15;
                    }
                    case '\uf102': {
                        this.writeInt(this.getIntN(n4));
                        n4 += 2;
                        continue block15;
                    }
                    case '\uf104': {
                        this.writeFloat(Float.intBitsToFloat(this.getIntN(n4)));
                        n4 += 2;
                        continue block15;
                    }
                    case '\uf103': {
                        this.writeLong(this.getLongN(n4));
                        n4 += 4;
                        continue block15;
                    }
                    case '\uf105': {
                        this.writeDouble(Double.longBitsToDouble(this.getLongN(n4)));
                        n4 += 4;
                        continue block15;
                    }
                }
                break;
            }
            throw new Error("unknown code:" + c);
        }
        return n4;
    }

    public boolean hasNext(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return false;
        }
        char c = this.data[n2];
        return c != '\uf10a' && c != '\uf10b' && c != '\uf10c';
    }

    protected int getNextKind(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return 29;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return 32;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return 33;
        }
        if ((c & 0xFF00) == 61440) {
            return 28;
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return 22;
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return 27;
            }
            case '\uf102': {
                return 22;
            }
            case '\uf103': {
                return 24;
            }
            case '\uf104': {
                return 25;
            }
            case '\uf105': {
                return 26;
            }
            case '\uf106': 
            case '\uf107': {
                return 29;
            }
            case '\uf108': {
                return 33;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': {
                return 0;
            }
        }
        return 32;
    }

    protected int getNextTypeIndex(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c >= '\ua000' && c <= '\uafff') {
            return c - 40960;
        }
        if (c == '\uf108' || c == '\uf109') {
            return this.getIntN(n2 + 1);
        }
        return -1;
    }

    protected String getNextTypeName(int n, Object object2) {
        int n2 = this.getNextTypeIndex(n, object2);
        return n2 < 0 ? null : (String)this.objects[n2];
    }

    protected Object getNextTypeObject(int n, Object object2) {
        int n2 = this.getNextTypeIndex(n, object2);
        return n2 < 0 ? null : this.objects[n2 + 1];
    }

    public Object getNext(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return Sequence.eofValue;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return Convert.toObject(c);
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return this.objects[c - 57344];
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return Convert.toObject(c - 49152);
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return Convert.toObject(c != '\uf100');
            }
            case '\uf102': {
                return Convert.toObject(this.getIntN(n2 + 1));
            }
            case '\uf103': {
                return Convert.toObject(this.getLongN(n2 + 1));
            }
            case '\uf104': {
                return Convert.toObject(Float.intBitsToFloat(this.getIntN(n2 + 1)));
            }
            case '\uf105': {
                return Convert.toObject(Double.longBitsToDouble(this.getLongN(n2 + 1)));
            }
            case '\uf106': {
                return Convert.toObject(this.data[n2 + 1]);
            }
            case '\uf10d': {
                return this.objects[this.getIntN(n2 + 1)];
            }
        }
        throw this.unsupported("getNext, code=" + Integer.toHexString(c));
    }

    protected void makeRelativePosition(int n, Object object2, int n2, boolean bl, PositionContainer positionContainer, int n3) {
        if (n2 < 0) {
            throw this.unsupported("backwards makeRelativePostion");
        }
        int n4 = n >>> 1;
        while (--n2 >= 0) {
            if ((n4 = this.nextDataIndex(n4)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        positionContainer.setPosition(n3, n4 << 1 | (bl ? 1 : 0), null);
    }

    public int nextDataIndex(int n) {
        char c;
        if (n == this.gapStart) {
            n = this.gapEnd;
        }
        if (n == this.data.length) {
            return -1;
        }
        if ((c = this.data[n++]) <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff') {
            return n;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.data[n] + n + 2;
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return n;
            }
            case '\uf106': {
                return n + 1;
            }
            case '\uf102': 
            case '\uf107': 
            case '\uf10d': {
                return n + 2;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': {
                return -1;
            }
            case '\uf108': {
                int n2 = this.getIntN(n);
                return (n2 += n2 < 0 ? this.data.length : n - 1) + 7;
            }
            case '\uf109': {
                int n3 = this.getIntN(n + 2);
                return n3 += n3 < 0 ? this.data.length : n - 1;
            }
            case '\uf103': 
            case '\uf105': {
                return n + 4;
            }
        }
        throw new Error("unknown code:" + c);
    }

    public void consumeRange(int n, int n2, Consumer consumer) {
        this.consumeRange(n, n2, -1, consumer);
    }

    public void consume(Consumer consumer) {
        this.consumeRange(0, this.data.length, consumer);
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("TreeList @" + System.identityHashCode(this) + " gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + " length:" + this.data.length);
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            if (n2 < this.gapStart || n2 >= this.gapEnd) {
                int n3 = this.data[n2];
                printWriter.print("" + n2 + ": 0x" + Integer.toHexString(n3) + '=' + (short)n3);
                if (--n < 0) {
                    if (n3 <= 40959) {
                        if (n3 >= 32 && n3 < 127) {
                            printWriter.print("='" + (char)n3 + "'");
                        } else if (n3 == 10) {
                            printWriter.print("='\\n'");
                        } else {
                            printWriter.print("='\\u" + Integer.toHexString(n3) + "'");
                        }
                    } else if (n3 >= 57344 && n3 <= 61439) {
                        Object object2 = this.objects[n3 -= 57344];
                        printWriter.print("=Object#" + n3 + '=' + object2 + ':' + object2.getClass().getName());
                    } else if (n3 >= 40960 && n3 <= 45055) {
                        printWriter.print("=BEGIN_GROUP_SHORT index#" + (n3 -= 40960) + "=<" + this.objects[n3] + '>');
                        n = 2;
                    } else if (n3 >= 45056 && n3 <= 57343) {
                        printWriter.print("= INT_SHORT:" + (n3 - 49152));
                    } else {
                        switch (n3) {
                            case 61698: {
                                int n4 = this.getIntN(n2 + 1);
                                printWriter.print("=INT_FOLLOWS value:" + n4);
                                n = 2;
                                break;
                            }
                            case 61699: {
                                long l = this.getLongN(n2 + 1);
                                printWriter.print("=LONG_FOLLOWS value:" + l);
                                n = 4;
                                break;
                            }
                            case 61700: {
                                int n4 = this.getIntN(n2 + 1);
                                printWriter.print("=FLOAT_FOLLOWS value:" + Float.intBitsToFloat(n4));
                                n = 2;
                                break;
                            }
                            case 61701: {
                                long l = this.getLongN(n2 + 1);
                                printWriter.print("=DOUBLE_FOLLOWS value:" + Double.longBitsToDouble(l));
                                n = 4;
                                break;
                            }
                            case 61696: {
                                printWriter.print("= false");
                                break;
                            }
                            case 61697: {
                                printWriter.print("= true");
                                break;
                            }
                            case 61702: {
                                printWriter.print("=CHAR_FOLLOWS");
                                n = 1;
                                break;
                            }
                            case 61703: {
                                printWriter.print("=CHAR_PAIR_FOLLOWS");
                                n = 2;
                                break;
                            }
                            case 61709: {
                                n = 2;
                                break;
                            }
                            case 61707: {
                                printWriter.print("=END_GROUP_SHORT begin:");
                                int n4 = n2 - this.data[n2 + 1];
                                printWriter.print(n4);
                                n4 = this.data[n4] - 40960;
                                printWriter.print(" -> #" + n4 + "=<" + this.objects[n4] + '>');
                                n = 1;
                                break;
                            }
                            case 61704: {
                                int n4 = this.getIntN(n2 + 1);
                                printWriter.print("=BEGIN_GROUP_LONG end:" + (n4 += n4 < 0 ? this.data.length : n2));
                                n4 = this.getIntN(n4 + 1);
                                printWriter.print(" -> #" + n4 + "=<" + this.objects[n4] + '>');
                                n = 2;
                                break;
                            }
                            case 61708: {
                                int n4 = this.getIntN(n2 + 1);
                                printWriter.print("=END_GROUP_LONG name:" + n4 + "=<" + this.objects[n4] + '>');
                                n4 = this.getIntN(n2 + 3);
                                n4 = n4 < 0 ? n2 + n4 : n4;
                                printWriter.print(" begin:" + n4);
                                n4 = this.getIntN(n2 + 5);
                                n4 = n4 < 0 ? n2 + n4 : n4;
                                printWriter.print(" parent:" + n4);
                                n = 6;
                                break;
                            }
                            case 61705: {
                                int n4 = this.getIntN(n2 + 1);
                                printWriter.print("=BEGIN_ATTRIBUTE name:" + n4 + "=" + this.objects[n4]);
                                n4 = this.getIntN(n2 + 3);
                                printWriter.print(" end:" + (n4 += n4 < 0 ? this.data.length : n2));
                                n = 4;
                                break;
                            }
                            case 61706: {
                                printWriter.print("=END_ATTRIBUTES");
                            }
                        }
                    }
                }
                printWriter.println();
            }
            ++n2;
        }
    }
}

