/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Future;
import gnu.mapping.LogWriter;
import gnu.mapping.Printable;
import gnu.mapping.SFormat;
import gnu.text.PrettyWriter;
import gnu.text.WriterManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;

public class OutPort
extends PrintWriter
implements Printable,
Consumer {
    String name;
    private Writer base;
    PrettyWriter bout;
    protected int index;
    public boolean printReadable;
    private static OutPort outInitial;
    private static OutPort out;
    private static OutPort errInitial;
    private static OutPort err;
    static Writer logFile;
    protected static final int WORD = -2;
    protected int prev = 10;
    NumberFormat numberFormat;
    public FormatToConsumer objectFormat;

    OutPort(Writer writer, PrettyWriter prettyWriter, boolean bl) {
        super((Writer)prettyWriter, bl);
        this.bout = prettyWriter;
        this.base = writer;
        this.index = WriterManager.instance.register(prettyWriter);
    }

    public OutPort(Writer writer, boolean bl, boolean bl2) {
        this(writer, new PrettyWriter(writer, bl), bl2);
    }

    public OutPort(Writer writer, boolean bl, boolean bl2, String string) {
        this(writer, new PrettyWriter(writer, bl), bl2);
        this.name = string;
    }

    public OutPort(OutputStream outputStream) {
        this(outputStream, null);
    }

    public OutPort(OutputStream outputStream, String string) {
        this((Writer)new OutputStreamWriter(outputStream), true, string);
    }

    public OutPort(Writer writer) {
        this(writer, false, false);
    }

    public OutPort(Writer writer, String string) {
        this(writer, false, false);
        this.name = string;
    }

    public OutPort(Writer writer, boolean bl, String string) {
        this(writer, false, bl);
        this.name = string;
    }

    public static OutPort outDefault() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).out;
        }
        return out;
    }

    public static void setOutDefault(OutPort outPort) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).out = outPort;
        } else {
            out = outPort;
        }
    }

    public static OutPort errDefault() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).err;
        }
        return err;
    }

    public static void setErrDefault(OutPort outPort) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).err = outPort;
        } else {
            err = outPort;
        }
    }

    public void echo(char[] cArray, int n, int n2) throws IOException {
        if (this.base instanceof LogWriter) {
            ((LogWriter)this.base).echo(cArray, n, n2);
        }
    }

    public static void closeLogFile() throws IOException {
        if (logFile != null) {
            logFile.close();
            logFile = null;
        }
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile((Writer)null);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile((Writer)null);
        }
    }

    public static void setLogFile(String string) throws IOException {
        if (logFile != null) {
            OutPort.closeLogFile();
        }
        logFile = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        if (OutPort.outInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.outInitial.base).setLogFile(logFile);
        }
        if (OutPort.errInitial.base instanceof LogWriter) {
            ((LogWriter)OutPort.errInitial.base).setLogFile(logFile);
        }
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    private void startWord() {
        this.prev = -2;
    }

    public void write(int n) {
        super.write(n);
        this.prev = n;
    }

    public void write(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            super.write(cArray, n, n2);
            this.prev = cArray[n + n2 - 1];
        }
    }

    public void write(String string) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        this.prev = string.charAt(n - 1);
        super.write(string);
    }

    public void writeChar(int n) {
        this.write(n);
    }

    public void writeSchemeObject(Object object2, boolean bl) {
        boolean bl2 = this.printReadable;
        try {
            this.printReadable = bl;
            SFormat.print(object2, this);
            Object var5_4 = null;
            this.printReadable = bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.printReadable = bl2;
            throw throwable;
        }
    }

    public void print(char c) {
        super.print(c);
        this.prev = c;
    }

    public void print(int n) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(n);
        } else {
            this.print(this.numberFormat.format(n));
        }
    }

    public void print(long l) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(l);
        } else {
            this.print(this.numberFormat.format(l));
        }
    }

    public void print(double d) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(d);
        } else {
            this.print(this.numberFormat.format(d));
        }
    }

    public void print(float f) {
        this.startWord();
        if (this.numberFormat == null) {
            super.print(f);
        } else {
            this.print(this.numberFormat.format(f));
        }
    }

    public void print(String string) {
        this.write(string);
    }

    public void print(Object object2) {
        this.startWord();
        if (this.objectFormat != null) {
            this.objectFormat.writeObject(object2, this);
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else {
            super.print(object2);
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<output-port");
        if (this.name != null) {
            printWriter.print(' ');
            printWriter.print(this.name);
        }
        printWriter.print('>');
    }

    public void writeBoolean(boolean bl) {
        this.print(bl);
    }

    public void writeFloat(float f) {
        this.print(f);
    }

    public void writeDouble(double d) {
        this.print(d);
    }

    public void writeInt(int n) {
        this.print(n);
    }

    public void writeLong(long l) {
        this.print(l);
    }

    public void beginGroup(String string, Object object2) {
        this.print('(');
        this.print(string);
    }

    public void endGroup(String string) {
        out.print(')');
        this.prev = 41;
    }

    public void beginAttribute(String string, Object object2) {
        this.print(' ');
        this.print(string);
        this.print(": ");
        this.prev = -2;
    }

    public void endAttributes() {
        this.prev = -2;
        this.print(' ');
    }

    public void writeObject(Object object2) {
        this.print(object2);
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        this.print(string);
    }

    public void freshLine() {
        int n = this.bout.getColumnNumber();
        if (n != 0) {
            this.println();
        }
    }

    public int getColumnNumber() {
        return this.bout.getColumnNumber();
    }

    public void setColumnNumber(int n) {
        this.bout.setColumnNumber(n);
    }

    public void clearBuffer() {
        this.bout.clearBuffer();
    }

    public void close() {
        super.close();
        WriterManager.instance.unregister(this.index);
    }

    public static void runCleanups() {
        WriterManager.instance.run();
    }

    public void startLogicalBlock(String string, boolean bl, String string2) {
        this.bout.startLogicalBlock(string, bl, string2);
    }

    public void startLogicalBlock(String string, String string2, int n) {
        this.bout.startLogicalBlock(string, false, string2);
        this.bout.addIndentation(string == null ? n : n - string.length(), false);
    }

    public void endLogicalBlock(String string) {
        this.bout.endLogicalBlock(string);
    }

    public void writeBreak(int n) {
        this.bout.writeBreak(n);
    }

    public void writeSpaceLinear() {
        this.write(32);
        this.writeBreak(78);
    }

    public void writeBreakLinear() {
        this.writeBreak(78);
    }

    public void writeSpaceFill() {
        this.write(32);
        this.writeBreak(70);
    }

    public void writeBreakFill() {
        this.writeBreak(70);
    }

    public void setIndentation(int n, boolean bl) {
        this.bout.addIndentation(n, bl);
    }

    static {
        out = outInitial = new OutPort(new LogWriter(new BufferedWriter(new OutputStreamWriter(System.out))), true, true, "<stdout>");
        err = errInitial = new OutPort(new LogWriter(new OutputStreamWriter(System.err)), true, true, "<stderr>");
    }
}

