/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.FdfWriter;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TextField;
import com.lowagie.text.pdf.XfdfReader;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private HashMap sigNames;
    private boolean append;
    private static final int DA_FONT = 0;
    private static final int DA_SIZE = 1;
    private static final int DA_COLOR = 2;
    private boolean lastWasString;
    private boolean generateAppearances = true;
    private static final HashMap stdFieldFontNames = new HashMap();
    private int totalRevisions;
    private HashMap fieldCache;

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
    }

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        if (pdfWriter instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)pdfWriter).isAppend();
        }
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        int n = 1;
        while (n <= this.reader.getNumberOfPages()) {
            PdfDictionary pdfDictionary2 = this.reader.getPageN(n);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS), pdfDictionary2);
            if (pdfArray != null) {
                ArrayList arrayList = pdfArray.getArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    PdfDictionary pdfDictionary3;
                    PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n2), pdfArray);
                    if ((!(pdfObject instanceof PdfIndirectReference) || pdfObject.isIndirect()) && PdfName.WIDGET.equals((pdfDictionary3 = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) {
                        Object object;
                        PdfDictionary pdfDictionary4 = pdfDictionary3;
                        PdfDictionary pdfDictionary5 = new PdfDictionary();
                        pdfDictionary5.putAll(pdfDictionary3);
                        String string = "";
                        PdfDictionary pdfDictionary6 = null;
                        PdfObject pdfObject2 = null;
                        while (pdfDictionary3 != null) {
                            pdfDictionary5.mergeDifferent(pdfDictionary3);
                            object = (PdfString)pdfDictionary3.get(PdfName.T);
                            if (object != null) {
                                string = String.valueOf(((PdfString)object).toUnicodeString()) + "." + string;
                            }
                            if (pdfObject2 == null && pdfDictionary3.get(PdfName.V) != null) {
                                pdfObject2 = pdfDictionary3.get(PdfName.V);
                            }
                            if (pdfDictionary6 == null && object != null) {
                                pdfDictionary6 = pdfDictionary3;
                                if (pdfDictionary3.get(PdfName.V) == null && pdfObject2 != null) {
                                    pdfDictionary6.put(PdfName.V, pdfObject2);
                                }
                            }
                            pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT), pdfDictionary3);
                        }
                        if (string.length() > 0) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if ((object = (Item)this.fields.get(string)) == null) {
                            object = new Item();
                            this.fields.put(string, object);
                        }
                        if (pdfDictionary6 == null) {
                            ((Item)object).values.add(pdfDictionary4);
                        } else {
                            ((Item)object).values.add(pdfDictionary6);
                        }
                        ((Item)object).widgets.add(pdfDictionary4);
                        ((Item)object).widget_refs.add(arrayList.get(n2));
                        if (pdfDictionary != null) {
                            pdfDictionary5.mergeDifferent(pdfDictionary);
                        }
                        ((Item)object).merged.add(pdfDictionary5);
                        ((Item)object).page.add(new Integer(n));
                        ((Item)object).tabOrder.add(new Integer(n2));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String[] getAppearanceStates(String string) {
        PdfObject pdfObject;
        int n;
        ArrayList arrayList;
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(0);
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if (pdfObject2 != null) {
            if (pdfObject2.isString()) {
                hashMap.put(((PdfString)pdfObject2).toUnicodeString(), null);
            } else if (pdfObject2.isArray()) {
                arrayList = ((PdfArray)pdfObject2).getArrayList();
                n = 0;
                while (n < arrayList.size()) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                    if (pdfObject != null && pdfObject.isString()) {
                        hashMap.put(((PdfString)pdfObject).toUnicodeString(), null);
                    }
                    ++n;
                }
            }
        }
        arrayList = item.widgets;
        n = 0;
        while (n < arrayList.size()) {
            PdfObject pdfObject3;
            pdfObject = (PdfDictionary)arrayList.get(n);
            if ((pdfObject = (PdfDictionary)((PdfDictionary)pdfObject).get(PdfName.AP)) != null && (pdfObject3 = ((PdfDictionary)pdfObject).get(PdfName.N)) != null && pdfObject3.isDictionary()) {
                pdfObject = (PdfDictionary)pdfObject3;
                Iterator iterator = ((PdfDictionary)pdfObject).getKeys().iterator();
                while (iterator.hasNext()) {
                    String string2 = PdfName.decodeName(((PdfName)iterator.next()).toString());
                    hashMap.put(string2, null);
                }
            }
            ++n;
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    public void exportAsFdf(FdfWriter fdfWriter) {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            String string = (String)entry.getKey();
            PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
            if (pdfObject == null) continue;
            String string2 = this.getField(string);
            if (this.lastWasString) {
                fdfWriter.setFieldAsString(string, string2);
                continue;
            }
            fdfWriter.setFieldAsName(string, string2);
        }
    }

    public boolean renameField(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46) + 1;
        if (n2 != (n = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n2).equals(string2.substring(0, n))) {
            return false;
        }
        if (this.fields.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        int n3 = 0;
        while (n3 < item.merged.size()) {
            PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(n3);
            pdfDictionary.put(PdfName.T, pdfString);
            this.markUsed(pdfDictionary);
            pdfDictionary = (PdfDictionary)item.merged.get(n3);
            pdfDictionary.put(PdfName.T, pdfString);
            ++n3;
        }
        this.fields.remove(string);
        this.fields.put(string2, item);
        return true;
    }

    private static Object[] splitDAelements(String string) {
        try {
            PRTokeniser pRTokeniser = new PRTokeniser(PdfEncodings.convertToBytes(string, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = new Object[3];
            while (pRTokeniser.nextToken()) {
                if (pRTokeniser.getTokenType() == 4) continue;
                if (pRTokeniser.getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    String string2 = pRTokeniser.getStringValue();
                    if (string2.equals("Tf")) {
                        if (arrayList.size() >= 2) {
                            objectArray[0] = arrayList.get(arrayList.size() - 2);
                            objectArray[1] = new Float((String)arrayList.get(arrayList.size() - 1));
                        }
                    } else if (string2.equals("g")) {
                        if (arrayList.size() >= 1 && (f3 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue()) != 0.0f) {
                            objectArray[2] = new GrayColor(f3);
                        }
                    } else if (string2.equals("rg")) {
                        if (arrayList.size() >= 3) {
                            f3 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                            f2 = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                            f = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                            objectArray[2] = new Color(f3, f2, f);
                        }
                    } else if (string2.equals("k") && arrayList.size() >= 4) {
                        f3 = new Float((String)arrayList.get(arrayList.size() - 4)).floatValue();
                        f2 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                        f = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                        float f4 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                        objectArray[2] = new CMYKColor(f3, f2, f, f4);
                    }
                    arrayList.clear();
                    continue;
                }
                arrayList.add(pRTokeniser.getStringValue());
            }
            return objectArray;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string, String string2) throws IOException, DocumentException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PdfObject pdfObject;
        this.topFirst = 0;
        int n = 0;
        TextField textField = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(string2)) {
            Object object6;
            textField = new TextField(this.writer, null, null);
            textField.setBorderWidth(0.0f);
            pdfObject = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
            if (pdfObject != null) {
                object5 = AcroFields.splitDAelements(pdfObject.toUnicodeString());
                if (object5[1] != null) {
                    textField.setFontSize(((Float)object5[1]).floatValue());
                }
                if (object5[2] != null) {
                    textField.setTextColor((Color)object5[2]);
                }
                if (object5[0] != null && (object4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (object4 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FONT))) != null) {
                    object3 = ((PdfDictionary)object4).get(new PdfName((String)object5[0]));
                    if (object3 != null && ((PdfObject)object3).type() == 10) {
                        textField.setFont(new DocumentFont((PRIndirectReference)object3));
                    } else {
                        object2 = (String[])stdFieldFontNames.get(object5[0]);
                        if (object2 != null) {
                            try {
                                object6 = "winansi";
                                if (((String[])object2).length > 1) {
                                    object6 = object2[1];
                                }
                                object = BaseFont.createFont((String)object2[0], (String)object6, false);
                                textField.setFont((BaseFont)object);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            if ((object5 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
                object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BC));
                textField.setBorderColor(this.getMKColor((PdfArray)object4));
                object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BG));
                textField.setBackgroundColor(this.getMKColor((PdfArray)object4));
                object3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.R));
                if (object3 != null) {
                    textField.setRotation(((PdfNumber)object3).intValue());
                }
            }
            if ((object4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF))) != null) {
                n = ((PdfNumber)object4).intValue();
            }
            textField.setOptions(((n & 0x1000) == 0 ? 0 : 4) | ((n & 0x1000000) == 0 ? 0 : 256));
            if ((n & 0x1000000) != 0) {
                object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
                int n2 = 0;
                if (object3 != null) {
                    n2 = ((PdfNumber)object3).intValue();
                }
                textField.setMaxCharacterLength(n2);
            }
            if ((object4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q))) != null) {
                if (((PdfNumber)object4).intValue() == 1) {
                    textField.setAlignment(1);
                } else if (((PdfNumber)object4).intValue() == 2) {
                    textField.setAlignment(2);
                }
            }
            if ((object3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
                object2 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.W));
                if (object2 != null) {
                    textField.setBorderWidth(((PdfNumber)object2).floatValue());
                }
                if (PdfName.D.equals(object6 = (PdfName)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.S)))) {
                    textField.setBorderStyle(1);
                } else if (PdfName.B.equals(object6)) {
                    textField.setBorderStyle(2);
                } else if (PdfName.I.equals(object6)) {
                    textField.setBorderStyle(3);
                } else if (PdfName.U.equals(object6)) {
                    textField.setBorderStyle(4);
                }
            } else {
                object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
                if (object2 != null) {
                    object6 = ((PdfArray)object2).getArrayList();
                    if (((ArrayList)object6).size() >= 3) {
                        textField.setBorderWidth(((PdfNumber)((ArrayList)object6).get(2)).floatValue());
                    }
                    if (((ArrayList)object6).size() >= 4) {
                        textField.setBorderStyle(1);
                    }
                }
            }
            object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
            object6 = PdfReader.getNormalizedRectangle((PdfArray)object2);
            if (textField.getRotation() == 90 || textField.getRotation() == 270) {
                object6 = ((Rectangle)object6).rotate();
            }
            textField.setBox((Rectangle)object6);
            if (this.fieldCache != null) {
                this.fieldCache.put(string2, textField);
            }
        } else {
            textField = (TextField)this.fieldCache.get(string2);
            textField.setWriter(this.writer);
        }
        if (PdfName.TX.equals(pdfObject = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT)))) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfObject)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((n & 0x20000) != 0) {
            textField.setText(string);
            return textField.getAppearance();
        }
        object5 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if (object5 != null) {
            object4 = ((PdfArray)object5).getArrayList();
            object3 = new String[((ArrayList)object4).size()];
            object2 = new String[((ArrayList)object4).size()];
            int n3 = 0;
            while (n3 < ((ArrayList)object4).size()) {
                object = (PdfObject)((ArrayList)object4).get(n3);
                if (((PdfObject)object).isString()) {
                    object2[n3] = ((PdfString)object).toUnicodeString();
                    object3[n3] = object2[n3];
                } else {
                    ArrayList arrayList = ((PdfArray)object).getArrayList();
                    object2[n3] = ((PdfString)arrayList.get(0)).toUnicodeString();
                    object3[n3] = ((PdfString)arrayList.get(1)).toUnicodeString();
                }
                ++n3;
            }
            n3 = 0;
            int n4 = 0;
            while (n4 < ((Object)object3).length) {
                if (string.equals(object3[n4])) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            textField.setChoices((String[])object3);
            textField.setChoiceExports((String[])object2);
            textField.setChoiceSelection(n3);
        }
        object4 = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return object4;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.BTN.equals(pdfName)) {
            PdfObject pdfObject2;
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return "";
            }
            String string2 = "";
            if (pdfObject.isName()) {
                string2 = PdfName.decodeName(pdfObject.toString());
            }
            if ((pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT))) != null && pdfObject2.isArray()) {
                ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                    PdfString pdfString = (PdfString)arrayList.get(n2);
                    string2 = pdfString.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        if (pdfObject.isString()) {
            this.lastWasString = true;
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    public boolean setFieldProperty(String string, String string2, Object object, int[] nArray) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("textcolor")) {
            int n = 0;
            while (n < item.merged.size()) {
                PdfString pdfString;
                if (instHit.isHit(n) && (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DA))) != null) {
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] != null) {
                        ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                        byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                        pdfAppearance.setColorFill((Color)object);
                        PdfString pdfString2 = new PdfString(pdfAppearance.toString());
                        ((PdfDictionary)item.merged.get(n)).put(PdfName.DA, pdfString2);
                        ((PdfDictionary)item.widgets.get(n)).put(PdfName.DA, pdfString2);
                        this.markUsed((PdfDictionary)item.widgets.get(n));
                    }
                }
                ++n;
            }
        } else if (string2.equalsIgnoreCase("textsize")) {
            int n = 0;
            while (n < item.merged.size()) {
                PdfString pdfString;
                if (instHit.isHit(n) && (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DA))) != null) {
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] != null) {
                        ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                        byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)object).floatValue()).append(" Tf ");
                        if (objectArray[2] != null) {
                            pdfAppearance.setColorFill((Color)objectArray[2]);
                        }
                        PdfString pdfString3 = new PdfString(pdfAppearance.toString());
                        ((PdfDictionary)item.merged.get(n)).put(PdfName.DA, pdfString3);
                        ((PdfDictionary)item.widgets.get(n)).put(PdfName.DA, pdfString3);
                        this.markUsed((PdfDictionary)item.widgets.get(n));
                    }
                }
                ++n;
            }
        } else if (string2.equalsIgnoreCase("bgcolor") || string2.equalsIgnoreCase("bordercolor")) {
            PdfName pdfName = string2.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
            int n = 0;
            while (n < item.merged.size()) {
                if (instHit.isHit(n)) {
                    PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.MK));
                    this.markUsed(pdfObject);
                    PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                    if (pdfDictionary == null) {
                        if (object == null) {
                            return true;
                        }
                        pdfDictionary = new PdfDictionary();
                        ((PdfDictionary)item.merged.get(n)).put(PdfName.MK, pdfDictionary);
                        ((PdfDictionary)item.widgets.get(n)).put(PdfName.MK, pdfDictionary);
                        this.markUsed((PdfDictionary)item.widgets.get(n));
                    }
                    if (object == null) {
                        pdfDictionary.remove(pdfName);
                    } else {
                        pdfDictionary.put(pdfName, PdfFormField.getMKColor((Color)object));
                    }
                }
                ++n;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean setFieldProperty(String string, String string2, int n, int[] nArray) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("flags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            int n2 = 0;
            while (n2 < item.merged.size()) {
                if (instHit.isHit(n2)) {
                    ((PdfDictionary)item.merged.get(n2)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n2)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n2));
                }
                ++n2;
            }
        } else if (string2.equalsIgnoreCase("setflags")) {
            int n3 = 0;
            while (n3 < item.merged.size()) {
                if (instHit.isHit(n3)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(n3)).get(PdfName.F));
                    int n4 = 0;
                    if (pdfNumber != null) {
                        n4 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n4 | n);
                    ((PdfDictionary)item.merged.get(n3)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n3)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n3));
                }
                ++n3;
            }
        } else if (string2.equalsIgnoreCase("clrflags")) {
            int n5 = 0;
            while (n5 < item.merged.size()) {
                if (instHit.isHit(n5)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(n5)).get(PdfName.F));
                    int n6 = 0;
                    if (pdfNumber != null) {
                        n6 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n6 & ~n);
                    ((PdfDictionary)item.merged.get(n5)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n5)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n5));
                }
                ++n5;
            }
        } else if (string2.equalsIgnoreCase("fflags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            int n7 = 0;
            while (n7 < item.merged.size()) {
                if (instHit.isHit(n7)) {
                    ((PdfDictionary)item.merged.get(n7)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n7)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n7));
                }
                ++n7;
            }
        } else if (string2.equalsIgnoreCase("setfflags")) {
            int n8 = 0;
            while (n8 < item.merged.size()) {
                if (instHit.isHit(n8)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(n8)).get(PdfName.FF));
                    int n9 = 0;
                    if (pdfNumber != null) {
                        n9 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n9 | n);
                    ((PdfDictionary)item.merged.get(n8)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n8)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n8));
                }
                ++n8;
            }
        } else if (string2.equalsIgnoreCase("clrfflags")) {
            int n10 = 0;
            while (n10 < item.merged.size()) {
                if (instHit.isHit(n10)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(n10)).get(PdfName.FF));
                    int n11 = 0;
                    if (pdfNumber != null) {
                        n11 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n11 & ~n);
                    ((PdfDictionary)item.merged.get(n10)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n10)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n10));
                }
                ++n10;
            }
        } else {
            return false;
        }
        return true;
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        fdfReader.getFields();
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public void setFields(XfdfReader xfdfReader) throws IOException, DocumentException {
        xfdfReader.getFields();
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = xfdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        int n;
        PdfObject pdfObject;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.MAXLEN));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if (n > 0) {
                string2 = string2.substring(0, Math.min(n, string2.length()));
            }
        }
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            pdfObject = new PdfString(string2, "UnicodeBig");
            n = 0;
            while (n < item.values.size()) {
                ((PdfDictionary)item.values.get(n)).put(PdfName.V, pdfObject);
                this.markUsed((PdfDictionary)item.values.get(n));
                PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n);
                pdfDictionary.put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary2 = (PdfDictionary)item.widgets.get(n);
                if (this.generateAppearances) {
                    PdfObject pdfObject2;
                    PdfAppearance pdfAppearance = this.getAppearance(pdfDictionary, string3, string);
                    if (PdfName.CH.equals(pdfName)) {
                        pdfObject2 = new PdfNumber(this.topFirst);
                        pdfDictionary2.put(PdfName.TI, pdfObject2);
                        pdfDictionary.put(PdfName.TI, pdfObject2);
                    }
                    if ((pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.AP))) == null) {
                        pdfObject2 = new PdfDictionary();
                        pdfDictionary2.put(PdfName.AP, pdfObject2);
                        pdfDictionary.put(PdfName.AP, pdfObject2);
                    }
                    ((PdfDictionary)pdfObject2).put(PdfName.N, pdfAppearance.getIndirectReference());
                } else {
                    pdfDictionary2.remove(PdfName.AP);
                    pdfDictionary.remove(PdfName.AP);
                }
                this.markUsed(pdfDictionary2);
                ++n;
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if ((n & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName2 = new PdfName(string2);
            if ((n & 0x8000) == 0) {
                int n2 = 0;
                while (n2 < item.values.size()) {
                    ((PdfDictionary)item.values.get(n2)).put(PdfName.V, pdfName2);
                    this.markUsed((PdfDictionary)item.values.get(n2));
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n2);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(n2);
                    pdfDictionary3.put(PdfName.AS, pdfName2);
                    this.markUsed(pdfDictionary3);
                    ++n2;
                }
            } else {
                PdfObject pdfObject3;
                ArrayList<String> arrayList = new ArrayList<String>();
                PdfObject pdfObject4 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
                if (pdfObject4 != null && pdfObject4.isArray()) {
                    ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                    int n3 = 0;
                    while (n3 < arrayList2.size()) {
                        pdfObject3 = PdfReader.getPdfObject((PdfObject)arrayList2.get(n3));
                        if (pdfObject3 != null && pdfObject3.isString()) {
                            arrayList.add(((PdfString)pdfObject3).toUnicodeString());
                        } else {
                            arrayList.add(null);
                        }
                        ++n3;
                    }
                }
                int n4 = arrayList.indexOf(string2);
                PdfName pdfName3 = null;
                if (n4 >= 0) {
                    pdfName3 = new PdfName(String.valueOf(n4));
                    pdfObject3 = pdfName3;
                } else {
                    pdfObject3 = pdfName2;
                }
                int n5 = 0;
                while (n5 < item.values.size()) {
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(n5);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)item.widgets.get(n5);
                    this.markUsed((PdfDictionary)item.values.get(n5));
                    if (pdfName3 != null) {
                        PdfString pdfString = new PdfString(string2, "UnicodeBig");
                        ((PdfDictionary)item.values.get(n5)).put(PdfName.V, pdfString);
                        pdfDictionary.put(PdfName.V, pdfString);
                    } else {
                        ((PdfDictionary)item.values.get(n5)).put(PdfName.V, pdfName2);
                        pdfDictionary.put(PdfName.V, pdfName2);
                    }
                    this.markUsed(pdfDictionary4);
                    if (this.isInAP(pdfDictionary4, (PdfName)pdfObject3)) {
                        pdfDictionary.put(PdfName.AS, pdfObject3);
                        pdfDictionary4.put(PdfName.AS, pdfObject3);
                    } else {
                        pdfDictionary.put(PdfName.AS, PdfName.OFF);
                        pdfDictionary4.put(PdfName.AS, PdfName.OFF);
                    }
                    ++n5;
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String string) {
        return (Item)this.fields.get(string);
    }

    public float[] getFieldPositions(String string) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.page.size() * 5];
        int n = 0;
        int n2 = 0;
        while (n2 < item.page.size()) {
            try {
                PdfDictionary pdfDictionary = (PdfDictionary)item.widgets.get(n2);
                PdfArray pdfArray = (PdfArray)pdfDictionary.get(PdfName.RECT);
                if (pdfArray != null) {
                    Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                    fArray[n] = ((Integer)item.page.get(n2)).floatValue();
                    int n3 = ++n;
                    fArray[n3] = rectangle.left();
                    int n4 = ++n;
                    fArray[n4] = rectangle.bottom();
                    int n5 = ++n;
                    fArray[n5] = rectangle.right();
                    int n6 = ++n;
                    ++n;
                    fArray[n6] = rectangle.top();
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (n < fArray.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        ArrayList arrayList = pdfArray.getArrayList();
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return arrayList.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        int n = 0;
        while (n < arrayList.size()) {
            PdfObject pdfObject2 = (PdfObject)arrayList.get(n);
            if (pdfObject2.isIndirect() && ((PdfIndirectReference)pdfObject2).getNumber() == pdfIndirectReference.getNumber()) {
                arrayList.remove(n--);
            }
            ++n;
        }
        return arrayList.size();
    }

    public boolean removeFieldsFromPage(int n) {
        if (n < 1) {
            return false;
        }
        String[] stringArray = new String[this.fields.size()];
        this.fields.keySet().toArray(stringArray);
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            boolean bl2 = this.removeField(stringArray[n2], n);
            bl = bl || bl2;
            ++n2;
        }
        return bl;
    }

    public boolean removeField(String string, int n) {
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS), pdfDictionary);
        if (pdfArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < item.widget_refs.size()) {
            int n3 = (Integer)item.page.get(n2);
            if (n == -1 || n == n3) {
                PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)item.widget_refs.get(n2);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
                PdfDictionary pdfDictionary3 = this.reader.getPageN(n3);
                PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS), pdfDictionary3);
                if (pdfArray2 != null) {
                    if (this.removeRefFromArray(pdfArray2, pdfIndirectReference) == 0) {
                        pdfDictionary3.remove(PdfName.ANNOTS);
                        this.markUsed(pdfDictionary3);
                    } else {
                        this.markUsed(pdfArray2);
                    }
                }
                PdfReader.killIndirect(pdfIndirectReference);
                PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
                while ((pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(PdfName.PARENT)) != null) {
                    pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
                    PdfArray pdfArray3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.KIDS));
                    if (this.removeRefFromArray(pdfArray3, pdfIndirectReference2) != 0) break;
                    pdfIndirectReference2 = pdfIndirectReference;
                    PdfReader.killIndirect(pdfIndirectReference);
                }
                if (pdfIndirectReference == null) {
                    this.removeRefFromArray(pdfArray, pdfIndirectReference2);
                    this.markUsed(pdfArray);
                }
                if (n != -1) {
                    item.merged.remove(n2);
                    item.page.remove(n2);
                    item.values.remove(n2);
                    item.widget_refs.remove(n2);
                    item.widgets.remove(n2);
                    --n2;
                }
            }
            ++n2;
        }
        if (n == -1 || item.merged.size() == 0) {
            this.fields.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl) {
        this.generateAppearances = bl;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (bl) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public ArrayList getSignatureNames() {
        Object object;
        Object object2;
        Object[] objectArray;
        if (this.sigNames != null) {
            return new ArrayList(this.sigNames.keySet());
        }
        this.sigNames = new HashMap();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList2;
            PdfObject pdfObject;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            objectArray = iterator.next();
            object2 = (Item)objectArray.getValue();
            object = (PdfDictionary)((Item)object2).merged.get(0);
            if (!PdfName.SIG.equals(((PdfDictionary)object).get(PdfName.FT)) || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.V))) == null || pdfObject3.type() != 6 || (pdfObject2 = (pdfDictionary = (PdfDictionary)pdfObject3).get(PdfName.CONTENTS)) == null || pdfObject2.type() != 3 || (pdfObject = pdfDictionary.get(PdfName.BYTERANGE)) == null || pdfObject.type() != 5 || (arrayList2 = ((PdfArray)pdfObject).getArrayList()).size() < 2) continue;
            int n = ((PdfNumber)arrayList2.get(arrayList2.size() - 1)).intValue() + ((PdfNumber)arrayList2.get(arrayList2.size() - 2)).intValue();
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = objectArray.getKey();
            int[] nArray = new int[2];
            nArray[0] = n;
            objectArray2[1] = nArray;
            arrayList.add(objectArray2);
        }
        Collections.sort(arrayList, new SorterComparator());
        if (arrayList.size() > 0) {
            this.totalRevisions = ((int[])((Object[])arrayList.get(arrayList.size() - 1))[1])[0] == this.reader.getFileLength() ? arrayList.size() : arrayList.size() + 1;
            int n = 0;
            while (n < arrayList.size()) {
                objectArray = (Object[])arrayList.get(n);
                object2 = (String)objectArray[0];
                object = (int[])objectArray[1];
                object[1] = n + 1;
                this.sigNames.put(object2, object);
                ++n;
            }
        }
        return new ArrayList(this.sigNames.keySet());
    }

    public ArrayList getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(pdfDictionary.get(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public PdfDictionary getSignatureDictionary(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        Item item = (Item)this.fields.get(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
        return (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
    }

    public boolean signatureCoversWholeDocument(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return false;
        }
        return ((int[])this.sigNames.get(string))[0] == this.reader.getFileLength();
    }

    public PdfPKCS7 verifySignature(String string) {
        return this.verifySignature(string, null);
    }

    public PdfPKCS7 verifySignature(String string, String string2) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return null;
        }
        try {
            PdfString pdfString;
            PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.SUBFILTER));
            PdfString pdfString2 = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
            PdfPKCS7 pdfPKCS7 = null;
            if (pdfName.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CERT));
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), pdfString.getBytes(), string2);
            } else {
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), string2);
            }
            this.updateByteRange(pdfPKCS7, pdfDictionary);
            pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.M));
            if (pdfString != null) {
                pdfPKCS7.setSignDate(PdfDate.decode(pdfString.toString()));
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAME))) != null) {
                pdfPKCS7.setSignName(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REASON))) != null) {
                pdfPKCS7.setReason(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.LOCATION))) != null) {
                pdfPKCS7.setLocation(pdfString.toUnicodeString());
            }
            return pdfPKCS7;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateByteRange(PdfPKCS7 pdfPKCS7, PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BYTERANGE));
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            try {
                randomAccessFileOrArray.reOpen();
                byte[] byArray = new byte[8192];
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    int n2;
                    int n3 = ((PdfNumber)arrayList.get(n)).intValue();
                    int n4 = ((PdfNumber)arrayList.get(++n)).intValue();
                    randomAccessFileOrArray.seek(n3);
                    while (n4 > 0 && (n2 = randomAccessFileOrArray.read(byArray, 0, Math.min(n4, byArray.length))) > 0) {
                        n4 -= n2;
                        pdfPKCS7.update(byArray, 0, n2);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                randomAccessFileOrArray.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        randomAccessFileOrArray.close();
    }

    private void markUsed(PdfObject pdfObject) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(pdfObject);
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String string) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(string)) {
            return 0;
        }
        return ((int[])this.sigNames.get(string))[1];
    }

    public InputStream extractRevision(String string) throws IOException {
        this.getSignatureNames();
        int n = ((int[])this.sigNames.get(string))[0];
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        randomAccessFileOrArray.reOpen();
        randomAccessFileOrArray.seek(0);
        return new RevisionStream(randomAccessFileOrArray, n);
    }

    public HashMap getFieldCache() {
        return this.fieldCache;
    }

    public void setFieldCache(HashMap hashMap) {
        this.fieldCache = hashMap;
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] nArray) {
            if (nArray == null) {
                return;
            }
            this.hits = new IntHashtable();
            int n = 0;
            while (n < nArray.length) {
                this.hits.put(nArray[n], 1);
                ++n;
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    private static class RevisionStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFileOrArray raf;
        private int length;
        private int rangePosition = 0;
        private boolean closed;

        RevisionStream(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
            this.raf = randomAccessFileOrArray;
            this.length = n;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.rangePosition >= this.length) {
                this.close();
                return -1;
            }
            int n3 = Math.min(n2, this.length - this.rangePosition);
            this.raf.readFully(byArray, n, n3);
            this.rangePosition += n3;
            return n3;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.raf.close();
                this.closed = true;
            }
        }
    }

    private static class SorterComparator
    implements Comparator {
        SorterComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((int[])((Object[])object)[1])[0];
            int n2 = ((int[])((Object[])object2)[1])[0];
            return n - n2;
        }
    }
}

