/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfInfoElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
    }

    public byte[] writeDocument() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(RTF_DOCUMENT);
            byteArrayOutputStream.write(this.documentHeader.write());
            this.data.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void add(RtfBasicElement rtfBasicElement) {
        try {
            if (rtfBasicElement instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)rtfBasicElement);
            } else {
                this.data.write(rtfBasicElement.write());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer n = null;
        while (this.previousRandomInts.contains(n = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(n);
        return n;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public String filterSpecialChar(String string, boolean bl, boolean bl2) {
        int n = string.length();
        char c = 'z';
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == '\\') {
                stringBuffer.append("\\\\");
            } else if (c2 == '\n') {
                if (bl2) {
                    stringBuffer.append("\\line ");
                } else {
                    stringBuffer.append("\\par ");
                }
            } else if (c2 == '\t') {
                stringBuffer.append("\\tab");
            } else if (c2 > c) {
                if (bl) {
                    stringBuffer.append("\\'").append(Long.toHexString(c2));
                } else {
                    stringBuffer.append("\\u").append((long)c2).append('?');
                }
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        if (string2.indexOf("$newpage$") >= 0) {
            String string3 = string2.substring(0, string2.indexOf("$newpage$"));
            String string4 = string2.substring(string2.indexOf("$newpage$") + 9);
            stringBuffer = new StringBuffer(string3);
            stringBuffer.append("\\page\\par ");
            stringBuffer.append(string4);
            return stringBuffer.toString();
        }
        return string2;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.autogenerateTOCEntries = bl;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }
}

